/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.aria;

import com.google.gwt.aria.client.AutocompleteValue;
import com.google.gwt.aria.client.Id;
import com.google.gwt.aria.client.Roles;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.core.shared.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.dom.client.HandlesAllKeyEvents;
import com.google.gwt.event.dom.client.HasAllKeyHandlers;
import com.google.gwt.event.dom.client.HasBlurHandlers;
import com.google.gwt.event.dom.client.HasFocusHandlers;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.logical.shared.HasSelectionHandlers;
import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.event.shared.HasHandlers;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Focusable;
import com.google.gwt.user.client.ui.HasEnabled;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.HasValue;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.MenuItem;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.SuggestOracle;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.ValueBoxBase;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.unitime.timetable.gwt.client.aria.AriaStatus;
import org.unitime.timetable.gwt.client.aria.AriaTextArea;
import org.unitime.timetable.gwt.client.aria.HasAriaLabel;
import org.unitime.timetable.gwt.resources.GwtAriaMessages;

public class AriaSuggestArea
extends Composite
implements HasText,
HasValue<String>,
HasSelectionHandlers<SuggestOracle.Suggestion>,
Focusable,
HasEnabled,
HasAriaLabel {
    private static GwtAriaMessages ARIA = (GwtAriaMessages)GWT.create(GwtAriaMessages.class);
    private AriaTextArea iText;
    private SuggestOracle iOracle;
    private PopupPanel iSuggestionPopup;
    private SuggestionMenu iSuggestionMenu;
    private ScrollPanel iPopupScroll;
    private SuggestionCallback iSuggestionCallback;
    private SuggestOracle.Callback iOracleCallback;
    private String iCurrentText = null;
    private boolean iTabPreventDefault = false;

    public AriaSuggestArea(SuggestOracle oracle) {
        this(new AriaTextArea(), oracle);
    }

    public AriaSuggestArea(AriaTextArea box, List<String> suggestions) {
        this(box, new SimpleOracle(suggestions));
    }

    public AriaSuggestArea(AriaTextArea box, SuggestOracle oracle) {
        this.iOracle = oracle;
        this.iText = box;
        this.iText.setStyleName("unitime-TextArea");
        this.initWidget((Widget)this.iText);
        this.addEventsToTextBox();
        this.iSuggestionMenu = new SuggestionMenu();
        this.iPopupScroll = new ScrollPanel((Widget)this.iSuggestionMenu);
        this.iPopupScroll.addStyleName("scroll");
        this.iSuggestionPopup = new PopupPanel(true, false);
        this.iSuggestionPopup.setPreviewingAllNativeEvents(true);
        this.iSuggestionPopup.setStyleName("unitime-SuggestBoxPopup");
        this.iSuggestionPopup.setWidget((Widget)this.iPopupScroll);
        this.iSuggestionPopup.addAutoHidePartner((Element)this.getElement());
        this.iSuggestionCallback = new SuggestionCallback(){

            @Override
            public void onSuggestionSelected(SuggestOracle.Suggestion suggestion) {
                if (!suggestion.getReplacementString().isEmpty()) {
                    AriaSuggestArea.this.setStatus(ARIA.suggestionSelected(AriaSuggestArea.this.status(suggestion)));
                }
                AriaSuggestArea.this.iCurrentText = suggestion.getReplacementString();
                AriaSuggestArea.this.setText(suggestion.getReplacementString());
                AriaSuggestArea.this.hideSuggestionList();
                AriaSuggestArea.this.fireSuggestionEvent(suggestion);
            }
        };
        this.iOracleCallback = new SuggestOracle.Callback(){

            public void onSuggestionsReady(SuggestOracle.Request request, SuggestOracle.Response response) {
                if (response.getSuggestions() == null || response.getSuggestions().isEmpty()) {
                    if (AriaSuggestArea.this.iSuggestionPopup.isShowing()) {
                        AriaSuggestArea.this.iSuggestionPopup.hide();
                    }
                } else {
                    AriaSuggestArea.this.iSuggestionMenu.clearItems();
                    SuggestOracle.Suggestion first = null;
                    for (SuggestOracle.Suggestion suggestion : response.getSuggestions()) {
                        AriaSuggestArea.this.iSuggestionMenu.addItem(new SuggestionMenuItem(suggestion));
                        if (first != null) continue;
                        first = suggestion;
                    }
                    AriaSuggestArea.this.iSuggestionMenu.selectItem(0);
                    AriaSuggestArea.this.iSuggestionMenu.setWidth(AriaSuggestArea.this.iText.getElement().getClientWidth() - 2 + "px");
                    AriaSuggestArea.this.iSuggestionPopup.showRelativeTo((UIObject)AriaSuggestArea.this.iText);
                    AriaSuggestArea.this.iSuggestionMenu.scrollToView();
                    if (response.getSuggestions().size() == 1) {
                        if (first.getReplacementString().isEmpty()) {
                            AriaSuggestArea.this.setStatus(AriaSuggestArea.this.status(first));
                        } else {
                            AriaSuggestArea.this.setStatus(ARIA.showingOneSuggestion(AriaSuggestArea.this.status(first)));
                        }
                    } else {
                        AriaSuggestArea.this.setStatus(ARIA.showingMultipleSuggestions(response.getSuggestions().size(), request.getQuery(), AriaSuggestArea.this.status(first)));
                    }
                }
            }
        };
        Roles.getTextboxRole().setAriaAutocompleteProperty((Element)this.iText.getElement(), AutocompleteValue.NONE);
        this.iSuggestionPopup.getElement().setAttribute("id", DOM.createUniqueId());
        Roles.getTextboxRole().setAriaOwnsProperty((Element)this.iText.getElement(), new Id[]{Id.of((Element)this.iSuggestionPopup.getElement())});
        this.iText.addFocusHandler(new FocusHandler(){

            public void onFocus(FocusEvent event) {
                AriaSuggestArea.this.showSuggestionList();
            }
        });
    }

    public void setSuggestions(List<String> suggestions) {
        this.iOracle = new SimpleOracle(suggestions);
    }

    private String status(SuggestOracle.Suggestion suggestion) {
        return suggestion instanceof HasStatus ? ((HasStatus)suggestion).getStatusString() : suggestion.getDisplayString();
    }

    public void setStatus(String text) {
        AriaStatus.getInstance().setText(text);
    }

    public void setTabPreventDefault(boolean tabPreventDefault) {
        this.iTabPreventDefault = tabPreventDefault;
    }

    private void addEventsToTextBox() {
        class TextBoxEvents
        extends HandlesAllKeyEvents
        implements ValueChangeHandler<String> {
            TextBoxEvents() {
            }

            public void onKeyDown(KeyDownEvent event) {
                switch (event.getNativeKeyCode()) {
                    case 40: {
                        if (AriaSuggestArea.this.moveSelectionDown()) {
                            event.preventDefault();
                            return;
                        }
                        if (AriaSuggestArea.this.isSuggestionListShowing() || !event.getNativeEvent().getAltKey() && AriaSuggestArea.this.iText.getCursorPos() != AriaSuggestArea.this.iText.getText().length()) break;
                        AriaSuggestArea.this.showSuggestionList();
                        break;
                    }
                    case 38: {
                        if (!AriaSuggestArea.this.moveSelectionUp()) break;
                        event.preventDefault();
                        return;
                    }
                    case 13: {
                        if (!AriaSuggestArea.this.isSuggestionListShowing()) break;
                        AriaSuggestArea.this.iSuggestionMenu.executeSelected();
                        event.preventDefault();
                        return;
                    }
                    case 9: {
                        if (!AriaSuggestArea.this.isSuggestionListShowing()) break;
                        AriaSuggestArea.this.iSuggestionMenu.executeSelected();
                        if (!AriaSuggestArea.this.iTabPreventDefault) break;
                        event.preventDefault();
                        return;
                    }
                    case 27: {
                        if (!AriaSuggestArea.this.isSuggestionListShowing()) break;
                        AriaSuggestArea.this.hideSuggestionList();
                        event.preventDefault();
                        return;
                    }
                }
                AriaSuggestArea.this.delegateEvent((Widget)AriaSuggestArea.this, (GwtEvent)event);
            }

            public void onKeyPress(KeyPressEvent event) {
                AriaSuggestArea.this.delegateEvent((Widget)AriaSuggestArea.this, (GwtEvent)event);
            }

            public void onKeyUp(KeyUpEvent event) {
                AriaSuggestArea.this.refreshSuggestions();
                AriaSuggestArea.this.delegateEvent((Widget)AriaSuggestArea.this, (GwtEvent)event);
            }

            public void onValueChange(ValueChangeEvent<String> event) {
                AriaSuggestArea.this.delegateEvent((Widget)AriaSuggestArea.this, event);
            }
        }
        TextBoxEvents events = new TextBoxEvents();
        events.addKeyHandlersTo((HasAllKeyHandlers)this.iText);
        this.iText.addValueChangeHandler(events);
    }

    private boolean moveSelectionDown() {
        if (!this.isSuggestionListShowing()) {
            return false;
        }
        if (this.iSuggestionMenu.selectItem(this.iSuggestionMenu.getSelectedItemIndex() + 1)) {
            if (this.iSuggestionMenu.getNumItems() > 1) {
                this.setStatus(ARIA.onSuggestion(this.iSuggestionMenu.getSelectedItemIndex() + 1, this.iSuggestionMenu.getNumItems(), this.status(this.iSuggestionMenu.getSelectedSuggestion())));
            }
            return true;
        }
        return false;
    }

    private boolean moveSelectionUp() {
        if (!this.isSuggestionListShowing()) {
            return false;
        }
        boolean selected = false;
        selected = this.iSuggestionMenu.getSelectedItemIndex() == -1 ? this.iSuggestionMenu.selectItem(this.iSuggestionMenu.getNumItems() - 1) : this.iSuggestionMenu.selectItem(this.iSuggestionMenu.getSelectedItemIndex() - 1);
        if (selected) {
            if (this.iSuggestionMenu.getNumItems() > 1) {
                this.setStatus(ARIA.onSuggestion(this.iSuggestionMenu.getSelectedItemIndex() + 1, this.iSuggestionMenu.getNumItems(), this.status(this.iSuggestionMenu.getSelectedSuggestion())));
            }
            return true;
        }
        return false;
    }

    public void showSuggestionList() {
        this.iCurrentText = null;
        this.refreshSuggestions();
    }

    private void refreshSuggestions() {
        String text = this.getText();
        if (text.equals(this.iCurrentText)) {
            return;
        }
        this.iCurrentText = text;
        this.showSuggestions(text);
    }

    public void hideSuggestionList() {
        if (this.iSuggestionPopup.isShowing()) {
            this.iSuggestionPopup.hide();
        }
    }

    public void showSuggestions(String text) {
        this.iOracle.requestSuggestions(new SuggestOracle.Request(text), this.iOracleCallback);
    }

    public boolean isSuggestionListShowing() {
        return this.iSuggestionPopup.isShowing();
    }

    public SuggestionMenu getSuggestionMenu() {
        return this.iSuggestionMenu;
    }

    public HandlerRegistration addValueChangeHandler(ValueChangeHandler<String> handler) {
        return this.addHandler((EventHandler)handler, ValueChangeEvent.getType());
    }

    public String getValue() {
        return this.iText.getValue();
    }

    public void setValue(String value) {
        this.setValue(value, false);
    }

    public void setValue(String value, boolean fireEvents) {
        this.iText.setValue(value);
        if (fireEvents) {
            ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)this.getValue());
        }
    }

    public String getText() {
        return this.iText.getText();
    }

    public void setText(String text) {
        this.iText.setText(text);
    }

    public HandlerRegistration addSelectionHandler(SelectionHandler<SuggestOracle.Suggestion> handler) {
        return this.addHandler((EventHandler)handler, SelectionEvent.getType());
    }

    private void fireSuggestionEvent(SuggestOracle.Suggestion selectedSuggestion) {
        SelectionEvent.fire((HasSelectionHandlers)this, (Object)selectedSuggestion);
    }

    public int getTabIndex() {
        return this.iText.getTabIndex();
    }

    public void setAccessKey(char key) {
        this.iText.setAccessKey(key);
    }

    public void setFocus(boolean focused) {
        this.iText.setFocus(focused);
    }

    public void setTabIndex(int index) {
        this.iText.setTabIndex(index);
    }

    public boolean isEnabled() {
        return this.iText.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.iText.setEnabled(enabled);
    }

    public ValueBoxBase<String> getValueBox() {
        return this.iText;
    }

    @Override
    public String getAriaLabel() {
        return this.iText.getAriaLabel();
    }

    @Override
    public void setAriaLabel(String text) {
        this.iText.setAriaLabel(text);
    }

    public static class SimpleOracle
    extends SuggestOracle {
        List<String> iSuggestions;

        public SimpleOracle(List<String> suggestions) {
            this.iSuggestions = suggestions;
        }

        public void requestSuggestions(SuggestOracle.Request request, SuggestOracle.Callback callback) {
            if (this.iSuggestions == null || this.iSuggestions.isEmpty()) {
                callback.onSuggestionsReady(request, new SuggestOracle.Response(null));
                return;
            }
            ArrayList<SimpleSuggestion> suggestions = new ArrayList<SimpleSuggestion>();
            for (String suggestion : this.iSuggestions) {
                if (suggestion.equalsIgnoreCase(request.getQuery())) continue;
                if (suggestion.toLowerCase().startsWith(request.getQuery().toLowerCase()) || suggestion.toLowerCase().contains(" " + request.getQuery().toLowerCase())) {
                    suggestions.add(new SimpleSuggestion(suggestion));
                }
                if (suggestions.size() < request.getLimit()) continue;
                break;
            }
            callback.onSuggestionsReady(request, new SuggestOracle.Response(suggestions));
        }

        public boolean isDisplayStringHTML() {
            return false;
        }
    }

    private class SuggestionMenu
    extends MenuBar
    implements HasFocusHandlers,
    HasBlurHandlers {
        SuggestionMenu() {
            super(true);
            this.setStyleName("");
            this.setFocusOnHoverEnabled(false);
            this.sinkEvents(4096);
            this.sinkEvents(2048);
        }

        public void onBrowserEvent(Event event) {
            switch (DOM.eventGetType((Event)event)) {
                case 4096: {
                    BlurEvent.fireNativeEvent((NativeEvent)event, (HasHandlers)this);
                    break;
                }
                case 2048: {
                    FocusEvent.fireNativeEvent((NativeEvent)event, (HasHandlers)this);
                }
            }
            super.onBrowserEvent(event);
        }

        public int getNumItems() {
            return this.getItems().size();
        }

        public int getSelectedItemIndex() {
            MenuItem selectedItem = this.getSelectedItem();
            if (selectedItem != null) {
                return this.getItems().indexOf(selectedItem);
            }
            return -1;
        }

        public boolean selectItem(int index) {
            List items = this.getItems();
            if (index > -1 && index < items.size()) {
                this.selectItem((MenuItem)items.get(index));
                AriaSuggestArea.this.iPopupScroll.ensureVisible((UIObject)items.get(index));
                return true;
            }
            return false;
        }

        public void scrollToView() {
            List items = this.getItems();
            int index = this.getSelectedItemIndex();
            if (index > -1 && index < items.size()) {
                AriaSuggestArea.this.iPopupScroll.ensureVisible((UIObject)items.get(index));
            }
        }

        public boolean executeSelected() {
            MenuItem selected = this.getSelectedItem();
            if (selected == null) {
                return false;
            }
            selected.getScheduledCommand().execute();
            return true;
        }

        public SuggestOracle.Suggestion getSelectedSuggestion() {
            MenuItem selectedItem = this.getSelectedItem();
            return selectedItem == null ? null : ((SuggestionMenuItem)selectedItem).getSuggestion();
        }

        public HandlerRegistration addBlurHandler(BlurHandler handler) {
            return this.addHandler((EventHandler)handler, (GwtEvent.Type)BlurEvent.getType());
        }

        public HandlerRegistration addFocusHandler(FocusHandler handler) {
            return this.addHandler((EventHandler)handler, (GwtEvent.Type)FocusEvent.getType());
        }
    }

    public static interface SuggestionCallback {
        public void onSuggestionSelected(SuggestOracle.Suggestion var1);
    }

    public static interface HasStatus {
        public String getStatusString();
    }

    public static class SimpleSuggestion
    implements SuggestOracle.Suggestion {
        private String iSuggestion;

        SimpleSuggestion(String suggestion) {
            this.iSuggestion = suggestion;
        }

        public String getDisplayString() {
            return this.iSuggestion;
        }

        public String getReplacementString() {
            return this.iSuggestion;
        }
    }

    private class SuggestionMenuItem
    extends MenuItem {
        private SuggestOracle.Suggestion iSuggestion;

        private SuggestionMenuItem(final SuggestOracle.Suggestion suggestion) {
            super(suggestion.getDisplayString(), AriaSuggestArea.this.iOracle.isDisplayStringHTML(), new Scheduler.ScheduledCommand(){

                public void execute() {
                    AriaSuggestArea.this.iSuggestionCallback.onSuggestionSelected(suggestion);
                }
            });
            this.iSuggestion = null;
            this.setStyleName("item");
            this.getElement().setAttribute("whiteSpace", "pre-wrap");
            this.iSuggestion = suggestion;
        }

        public SuggestOracle.Suggestion getSuggestion() {
            return this.iSuggestion;
        }
    }
}

