/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.dataexchange;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.dom4j.Element;
import org.unitime.commons.Debug;
import org.unitime.timetable.dataexchange.EventRelatedImports;
import org.unitime.timetable.dataexchange.PointInTimeDataExport;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.AcademicArea;
import org.unitime.timetable.model.AcademicClassification;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.ClassDurationType;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseCreditType;
import org.unitime.timetable.model.CourseCreditUnitType;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CourseType;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalMethod;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.ItypeDesc;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.NonUniversityLocation;
import org.unitime.timetable.model.PitClass;
import org.unitime.timetable.model.PitClassEvent;
import org.unitime.timetable.model.PitClassInstructor;
import org.unitime.timetable.model.PitClassMeeting;
import org.unitime.timetable.model.PitClassMeetingUtilPeriod;
import org.unitime.timetable.model.PitCourseOffering;
import org.unitime.timetable.model.PitDepartmentalInstructor;
import org.unitime.timetable.model.PitInstrOfferingConfig;
import org.unitime.timetable.model.PitInstructionalOffering;
import org.unitime.timetable.model.PitOfferingCoordinator;
import org.unitime.timetable.model.PitSchedulingSubpart;
import org.unitime.timetable.model.PitStudent;
import org.unitime.timetable.model.PitStudentAcadAreaMajorClassification;
import org.unitime.timetable.model.PitStudentAcadAreaMinorClassification;
import org.unitime.timetable.model.PitStudentClassEnrollment;
import org.unitime.timetable.model.PointInTimeData;
import org.unitime.timetable.model.PosMajor;
import org.unitime.timetable.model.PosMajorConcentration;
import org.unitime.timetable.model.PosMinor;
import org.unitime.timetable.model.PositionType;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.RoomDept;
import org.unitime.timetable.model.RoomType;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.TeachingResponsibility;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.TimePatternDays;
import org.unitime.timetable.model.TimePatternTime;
import org.unitime.timetable.model.base.BasePitClassInstructor;
import org.unitime.timetable.util.CalendarUtils;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.ProgressTracker;

public class PointInTimeDataImport
extends EventRelatedImports {
    private PointInTimeData pointInTimeData = null;
    private HashMap<String, SubjectArea> subjectAreas = new HashMap();
    private HashMap<String, ItypeDesc> itypes = new HashMap();
    private HashMap<String, ClassDurationType> classDurationTypes = new HashMap();
    private HashMap<String, InstructionalMethod> instructionalMethods = new HashMap();
    private HashMap<String, Department> departmentsByCode = new HashMap();
    private HashMap<String, CourseType> courseTypesByRef = new HashMap();
    private HashMap<String, TeachingResponsibility> teachingResponsibilitiesByRef = new HashMap();
    private HashMap<String, DatePattern> datePatternsByName = new HashMap();
    private HashMap<String, TimePattern> timePatternsByName = new HashMap();
    private HashMap<String, AcademicClassification> academicClassificationsByCode = new HashMap();
    private HashMap<String, AcademicArea> academicAreasByAbbv = new HashMap();
    private HashMap<String, PosMajor> majorsByCode = new HashMap();
    private HashMap<String, PosMajorConcentration> concentrationsByCode = new HashMap();
    private HashMap<String, PosMinor> minorsByCode = new HashMap();
    private HashMap<String, RoomType> roomTypesByRef = new HashMap();
    private HashMap<String, CourseCreditType> creditTypesByRef = new HashMap();
    private HashMap<String, CourseCreditUnitType> creditUnitTypesByRef = new HashMap();
    private HashMap<String, PositionType> positionTypesByRef = new HashMap();
    private HashMap<String, Building> buildingsByAbbv = new HashMap();
    private HashMap<String, Location> locationsByName = new HashMap();
    private HashMap<String, DepartmentalInstructor> departmentalInstructorsByName = new HashMap();
    private HashMap<Long, TimePattern> timePatterns = new HashMap();
    private HashMap<Long, DatePattern> datePatterns = new HashMap();
    private HashMap<Long, Location> locations = new HashMap();
    private HashMap<Long, Building> buildings = new HashMap();
    private HashMap<Long, InstructionalOffering> instructionalOfferings = new HashMap();
    private HashMap<Long, CourseOffering> courseOfferings = new HashMap();
    private HashMap<Long, PitCourseOffering> pitCourseOfferings = new HashMap();
    private HashMap<Long, InstrOfferingConfig> instrOfferingConfigs = new HashMap();
    private HashMap<Long, SchedulingSubpart> schedulingSubparts = new HashMap();
    private HashMap<Long, Class_> classes = new HashMap();
    private HashMap<Long, PitClass> pitClasses = new HashMap();
    private HashMap<Long, RoomType> roomTypes = new HashMap();
    private HashMap<Long, CourseCreditType> creditTypes = new HashMap();
    private HashMap<Long, CourseCreditUnitType> creditUnitTypes = new HashMap();
    private HashMap<Long, PositionType> positionTypes = new HashMap();
    private HashMap<Long, TeachingResponsibility> teachingResponsibilities = new HashMap();
    private HashMap<Long, Department> departments = new HashMap();
    private HashMap<Long, PitDepartmentalInstructor> pitDepartmentInstructors = new HashMap();
    private HashMap<Long, CourseType> courseTypes = new HashMap();
    private HashMap<Long, AcademicArea> academicAreas = new HashMap();
    private HashMap<Long, AcademicClassification> academicClassifications = new HashMap();
    private HashMap<Long, PosMajor> majors = new HashMap();
    private HashMap<Long, PosMinor> minors = new HashMap();
    private HashMap<Long, Student> students = new HashMap();
    private HashMap<Long, PosMajorConcentration> concentrations = new HashMap();
    protected boolean courseNumbersMustBeUnique;

    @Override
    public void loadXml(Element rootElement) throws Exception {
        this.initializeTrimLeadingZeros();
        try {
            if (!rootElement.getName().equalsIgnoreCase(PointInTimeDataExport.sRootElementName)) {
                throw new Exception("Given XML file is not a Course Offerings load file.");
            }
            this.beginTransaction();
            this.initializeLoad(rootElement);
            this.preLoadAction();
            this.loadOfferings(rootElement);
            this.loadStudents(rootElement);
            this.completeLoad();
        }
        catch (Exception e) {
            this.fatal("Exception: " + e.getMessage(), e);
            this.rollbackTransaction();
            throw e;
        }
        finally {
            this.postLoadAction();
        }
        this.updateChangeList(true);
        this.reportMissingLocations();
        this.mailLoadResults();
    }

    private void completeLoad() {
        this.pointInTimeData.setSavedSuccessfully(true);
        this.getHibSession().merge((Object)this.pointInTimeData);
        this.flush(true);
        this.commitTransaction();
    }

    private void loadStudents(Element rootElement) throws Exception {
        this.loadExistingStudents(this.session.getUniqueId());
        Element studentsElement = rootElement.element(PointInTimeDataExport.sStudentsElementName);
        int numStudents = studentsElement.elements().size();
        this.info("Loading data for " + numStudents + " students.");
        ProgressTracker progressTracker = new ProgressTracker("Students", numStudents, 5, this.getClass());
        String progress = null;
        int count = 0;
        for (Element studentElement : studentsElement.elements()) {
            this.elementStudent(studentElement);
            if (++count % 1 == 0) {
                this.flush(true);
            }
            if ((progress = progressTracker.getProgressStringIfNeeded()) == null) continue;
            this.info(progress);
        }
        this.flush(true);
        this.info("Loading of student data complete.");
    }

    private void elementStudent(Element studentElement) throws Exception {
        Long uid = this.getRequiredLongAttribute(studentElement, PointInTimeDataExport.sUniqueIdAttribute, PointInTimeDataExport.sStudentElementName);
        String externalId = this.getRequiredStringAttribute(studentElement, PointInTimeDataExport.sExternalIdAttribute, PointInTimeDataExport.sStudentElementName);
        PitStudent s = new PitStudent();
        if (this.students.get(uid) != null && this.students.get(uid).getExternalUniqueId().equals(externalId)) {
            s.setStudent(this.students.get(uid));
        }
        s.setExternalUniqueId(externalId);
        s.setFirstName(this.getOptionalStringAttribute(studentElement, PointInTimeDataExport.sFirstNameAttribute));
        s.setMiddleName(this.getOptionalStringAttribute(studentElement, PointInTimeDataExport.sMiddleNameAttribute));
        s.setLastName(this.getRequiredStringAttribute(studentElement, PointInTimeDataExport.sLastNameAttribute, PointInTimeDataExport.sStudentElementName));
        s.setPointInTimeData(this.pointInTimeData);
        this.getHibSession().persist((Object)s);
        for (Element element : studentElement.elements()) {
            if (element.getName().equals(PointInTimeDataExport.sEnrollmentElementName)) {
                this.elementEnrollment(element, s);
                continue;
            }
            if (element.getName().equals(PointInTimeDataExport.sAcadAreaMajorClassificationElementName)) {
                this.elementAcadAreaMajorClassification(element, s);
                continue;
            }
            if (!element.getName().equals(PointInTimeDataExport.sAcadAreaMinorClassificationElementName)) continue;
            this.elementAcadAreaMinorClassification(element, s);
        }
    }

    private void elementAcadAreaMajorClassification(Element element, PitStudent s) throws Exception {
        String weight;
        PitStudentAcadAreaMajorClassification aamc = new PitStudentAcadAreaMajorClassification();
        aamc.setAcademicArea(this.academicAreas.get(this.getRequiredLongAttribute(element, PointInTimeDataExport.sAcademicAreaUniqueIdAttribute, PointInTimeDataExport.sAcadAreaMajorClassificationElementName)));
        aamc.setAcademicClassification(this.academicClassifications.get(this.getRequiredLongAttribute(element, PointInTimeDataExport.sAcademicClassificationUniqueIdAttribute, PointInTimeDataExport.sAcadAreaMajorClassificationElementName)));
        aamc.setMajor(this.majors.get(this.getRequiredLongAttribute(element, PointInTimeDataExport.sMajorUniqueIdAttribute, PointInTimeDataExport.sAcadAreaMajorClassificationElementName)));
        Long concId = this.getOptionalLongAttribute(element, PointInTimeDataExport.sConcentrationUniqueIdAttribute);
        if (concId != null) {
            aamc.setConcentration(this.concentrations.get(concId));
        }
        if ((weight = this.getOptionalStringAttribute(element, PointInTimeDataExport.sAcademicAreaMajorClassificationWeightAttribute)) != null) {
            aamc.setWeight(Double.valueOf(weight));
        } else {
            aamc.setWeight(1.0);
        }
        aamc.setPitStudent(s);
        s.addToPitAcadAreaMajorClassifications(aamc);
        this.getHibSession().persist((Object)aamc);
    }

    private void elementAcadAreaMinorClassification(Element element, PitStudent s) throws Exception {
        PitStudentAcadAreaMinorClassification aamc = new PitStudentAcadAreaMinorClassification();
        aamc.setAcademicArea(this.academicAreas.get(this.getRequiredLongAttribute(element, PointInTimeDataExport.sAcademicAreaUniqueIdAttribute, PointInTimeDataExport.sAcadAreaMinorClassificationElementName)));
        aamc.setAcademicClassification(this.academicClassifications.get(this.getRequiredLongAttribute(element, PointInTimeDataExport.sAcademicClassificationUniqueIdAttribute, PointInTimeDataExport.sAcadAreaMinorClassificationElementName)));
        aamc.setMinor(this.minors.get(this.getRequiredLongAttribute(element, PointInTimeDataExport.sMinorUniqueIdAttribute, PointInTimeDataExport.sAcadAreaMinorClassificationElementName)));
        aamc.setPitStudent(s);
        s.addToPitAcadAreaMinorClassifications(aamc);
        this.getHibSession().persist((Object)aamc);
    }

    private void elementEnrollment(Element element, PitStudent s) throws NumberFormatException, Exception {
        PitStudentClassEnrollment psce = new PitStudentClassEnrollment();
        psce.setPitClass(this.pitClasses.get(this.getRequiredLongAttribute(element, PointInTimeDataExport.sClassUniqueIdAttribute, PointInTimeDataExport.sEnrollmentElementName)));
        PitCourseOffering pco = this.pitCourseOfferings.get(this.getRequiredLongAttribute(element, PointInTimeDataExport.sCourseOfferingUniqueIdAttribute, PointInTimeDataExport.sEnrollmentElementName));
        psce.setPitCourseOffering(pco);
        psce.setTimestamp(CalendarUtils.getDate(this.getRequiredStringAttribute(element, PointInTimeDataExport.sTimestampAttribute, PointInTimeDataExport.sEnrollmentElementName), this.dateFormat + " " + this.timeFormat));
        psce.setChangedBy(this.getOptionalStringAttribute(element, PointInTimeDataExport.sChangedByAttribute));
        psce.setPitStudent(s);
        s.addToPitClassEnrollments(psce);
        this.getHibSession().persist((Object)psce);
    }

    private void preLoadAction() {
    }

    private void postLoadAction() {
    }

    private void loadOfferings(Element rootElement) throws Exception {
        Element offeringsElement = rootElement.element(PointInTimeDataExport.sOfferingsElementName);
        ProgressTracker progressTracker = new ProgressTracker("Instructional Offerings", offeringsElement.elements().size(), 2, this.getClass());
        this.info("Loading data for " + offeringsElement.elements().size() + " offerings.");
        String progress = null;
        int successCount = 0;
        int failCount = 0;
        for (Element offeringElement : offeringsElement.elements()) {
            try {
                this.elementOffering(offeringElement);
                this.flush(true);
                ++successCount;
            }
            catch (Exception e) {
                this.addNote("Not Loading 'offering' Error:  " + e.getMessage());
                e.printStackTrace();
                this.addNote("\t " + offeringElement.asXML());
                ++failCount;
                throw e;
            }
            progress = progressTracker.getProgressStringIfNeeded();
            if (progress == null) continue;
            this.info(progress);
        }
        this.info("Loading of offering data complete.  " + successCount + " successfully loaded.  " + failCount + " failed to load.");
    }

    private void elementOffering(Element instructionalOfferingElement) throws Exception {
        String externalId;
        if (!instructionalOfferingElement.getName().equalsIgnoreCase(PointInTimeDataExport.sOfferingElementName)) {
            throw new Exception("Expecting to find an '" + PointInTimeDataExport.sOfferingElementName + "' at this level, instead found '" + instructionalOfferingElement.getName() + "'.");
        }
        Long uid = this.getRequiredLongAttribute(instructionalOfferingElement, PointInTimeDataExport.sUniqueIdAttribute, PointInTimeDataExport.sOfferingElementName);
        PitInstructionalOffering pio = new PitInstructionalOffering();
        if (this.instructionalOfferings.get(uid) != null) {
            pio.setInstructionalOffering(this.instructionalOfferings.get(uid));
        }
        if ((externalId = this.getOptionalStringAttribute(instructionalOfferingElement, PointInTimeDataExport.sExternalIdAttribute)) != null) {
            pio.setExternalUniqueId(externalId);
        }
        pio.setInstrOfferingPermId(this.getRequiredIntegerAttribute(instructionalOfferingElement, PointInTimeDataExport.sPermanentIdAttribute, PointInTimeDataExport.sOfferingElementName));
        String limitStr = this.getRequiredStringAttribute(instructionalOfferingElement, PointInTimeDataExport.sLimitAttribute, PointInTimeDataExport.sOfferingElementName);
        if (!"inf".equalsIgnoreCase(limitStr)) {
            pio.setLimit(Integer.parseInt(limitStr));
        }
        pio.setDemand(this.getRequiredIntegerAttribute(instructionalOfferingElement, PointInTimeDataExport.sDemandAttribute, PointInTimeDataExport.sOfferingElementName));
        Long uidRollFwdFrm = this.getOptionalLongAttribute(instructionalOfferingElement, PointInTimeDataExport.sUniqueIdRolledForwardFromAttribute);
        if (uidRollFwdFrm != null) {
            pio.setUniqueIdRolledForwardFrom(uidRollFwdFrm);
        }
        pio.setPointInTimeData(this.pointInTimeData);
        this.getHibSession().persist((Object)pio);
        for (Element element : instructionalOfferingElement.elements()) {
            if (PointInTimeDataExport.sCourseElementName.equals(element.getName())) {
                this.elementCourse(element, pio);
                continue;
            }
            if (PointInTimeDataExport.sConfigElementName.equals(element.getName())) {
                this.elementInstrOffrConfig(element, pio);
                continue;
            }
            if (!PointInTimeDataExport.sOfferingCoordinatorElementName.equals(element.getName())) continue;
            this.elementOfferingCoordinator(element, pio);
        }
    }

    private void initializeLoad(Element rootElement) throws Exception {
        this.initializeDateTimeFormats(rootElement);
        this.initializeSessionIndependentData(rootElement);
        this.initializeSessionData(rootElement);
        this.loadSetupData();
        this.logXmlFileCreateInformation(rootElement);
    }

    private void initializeSessionIndependentData(Element rootElement) throws Exception {
        this.initializeRoomTypeData(rootElement);
        this.initializePositionTypeData(rootElement);
        this.initializeTeachingResponsibilityData(rootElement);
        this.initializeCourseTypeData(rootElement);
        this.initializeClassDurationTypeData(rootElement);
        this.initializeCreditTypeData(rootElement);
        this.initializeCreditUnitTypeData(rootElement);
        this.initializeInstructionalMethodData(rootElement);
    }

    private void elementRoomType(Element roomTypeElement) throws Exception {
        Long uid = this.getRequiredLongAttribute(roomTypeElement, PointInTimeDataExport.sUniqueIdAttribute, PointInTimeDataExport.sRoomTypeElementName);
        String reference = this.getRequiredStringAttribute(roomTypeElement, PointInTimeDataExport.sReferenceAttribute, PointInTimeDataExport.sRoomTypeElementName);
        RoomType rt = this.roomTypesByRef.get(reference);
        if (rt == null) {
            String label = this.getRequiredStringAttribute(roomTypeElement, PointInTimeDataExport.sLabelAttribute, PointInTimeDataExport.sRoomTypeElementName);
            Boolean isRoom = this.getRequiredBooleanAttribute(roomTypeElement, PointInTimeDataExport.sIsRoomAttribute, PointInTimeDataExport.sRoomTypeElementName);
            Integer order = this.getRequiredIntegerAttribute(roomTypeElement, PointInTimeDataExport.sOrderAttribute, PointInTimeDataExport.sRoomTypeElementName);
            rt = new RoomType();
            rt.setReference(reference);
            rt.setLabel(label);
            rt.setRoom(isRoom);
            rt.setOrd(order);
            this.getHibSession().persist((Object)rt);
        }
        this.roomTypes.put(uid, rt);
    }

    private void elementPositionType(Element positionTypeElement) throws Exception {
        Long uid = this.getRequiredLongAttribute(positionTypeElement, PointInTimeDataExport.sUniqueIdAttribute, PointInTimeDataExport.sRoomTypeElementName);
        String reference = this.getRequiredStringAttribute(positionTypeElement, PointInTimeDataExport.sReferenceAttribute, PointInTimeDataExport.sRoomTypeElementName);
        PositionType pt = this.positionTypesByRef.get(reference);
        if (pt == null) {
            String label = this.getRequiredStringAttribute(positionTypeElement, PointInTimeDataExport.sLabelAttribute, PointInTimeDataExport.sRoomTypeElementName);
            Integer order = this.getRequiredIntegerAttribute(positionTypeElement, PointInTimeDataExport.sOrderAttribute, PointInTimeDataExport.sRoomTypeElementName);
            pt = new PositionType();
            pt.setReference(reference);
            pt.setLabel(label);
            pt.setSortOrder(order);
            this.getHibSession().persist((Object)pt);
        }
        this.positionTypes.put(uid, pt);
    }

    private void elementTeachingResponsibility(Element teachingResponsibilityElement) throws Exception {
        Long uid = this.getRequiredLongAttribute(teachingResponsibilityElement, PointInTimeDataExport.sUniqueIdAttribute, PointInTimeDataExport.sTeachingResponsibilityElementName);
        String reference = this.getRequiredStringAttribute(teachingResponsibilityElement, PointInTimeDataExport.sReferenceAttribute, PointInTimeDataExport.sTeachingResponsibilityElementName);
        TeachingResponsibility tr = this.teachingResponsibilitiesByRef.get(reference);
        if (tr == null) {
            String label = this.getRequiredStringAttribute(teachingResponsibilityElement, PointInTimeDataExport.sLabelAttribute, PointInTimeDataExport.sTeachingResponsibilityElementName);
            String abbreviation = this.getRequiredStringAttribute(teachingResponsibilityElement, PointInTimeDataExport.sAbbreviationAttribute, PointInTimeDataExport.sTeachingResponsibilityElementName);
            Boolean instructor = this.getRequiredBooleanAttribute(teachingResponsibilityElement, PointInTimeDataExport.sInstructorAttribute, PointInTimeDataExport.sTeachingResponsibilityElementName);
            Boolean coordinator = this.getRequiredBooleanAttribute(teachingResponsibilityElement, PointInTimeDataExport.sCoordinatorAttribute, PointInTimeDataExport.sTeachingResponsibilityElementName);
            Integer options = this.getOptionalIntegerAttribute(teachingResponsibilityElement, PointInTimeDataExport.sOptionsAttribute);
            tr = new TeachingResponsibility();
            tr.setReference(reference);
            tr.setLabel(label);
            tr.setInstructor(instructor);
            tr.setCoordinator(coordinator);
            tr.setAbbreviation(abbreviation);
            tr.setOptions(options == null ? 0 : options);
            this.getHibSession().persist((Object)tr);
        }
        this.teachingResponsibilities.put(uid, tr);
    }

    private void initializeRoomTypeData(Element rootElement) throws Exception {
        for (RoomType roomType : RoomType.findAll()) {
            this.roomTypesByRef.put(roomType.getReference(), roomType);
        }
        Element roomTypesElement = rootElement.element(PointInTimeDataExport.sRoomTypesElementName);
        for (Element roomTypeElement : roomTypesElement.elements()) {
            this.elementRoomType(roomTypeElement);
        }
    }

    private void initializeCreditTypeData(Element rootElement) throws Exception {
        for (CourseCreditType creditType : CourseCreditType.getCourseCreditTypeList()) {
            this.creditTypesByRef.put(creditType.getReference(), creditType);
        }
        Element creditTypesElement = rootElement.element(PointInTimeDataExport.sCreditTypesElementName);
        for (Element creditTypeElement : creditTypesElement.elements()) {
            this.elementCreditType(creditTypeElement);
        }
    }

    private void elementCreditType(Element creditTypeElement) throws Exception {
        Long uid = this.getRequiredLongAttribute(creditTypeElement, PointInTimeDataExport.sUniqueIdAttribute, PointInTimeDataExport.sCreditTypeElementName);
        String reference = this.getRequiredStringAttribute(creditTypeElement, PointInTimeDataExport.sReferenceAttribute, PointInTimeDataExport.sCreditTypeElementName);
        CourseCreditType ct = this.creditTypesByRef.get(reference);
        if (ct == null) {
            String label = this.getRequiredStringAttribute(creditTypeElement, PointInTimeDataExport.sLabelAttribute, PointInTimeDataExport.sCreditTypeElementName);
            String abbreviation = this.getRequiredStringAttribute(creditTypeElement, PointInTimeDataExport.sAbbreviationAttribute, PointInTimeDataExport.sCreditTypeElementName);
            String masterCode = this.getOptionalStringAttribute(creditTypeElement, PointInTimeDataExport.sLegacyCourseMasterCodeAttribute);
            ct = new CourseCreditType();
            ct.setReference(reference);
            ct.setLabel(label);
            ct.setAbbreviation(abbreviation);
            if (masterCode != null) {
                ct.setLegacyCourseMasterCode(masterCode);
            }
            this.getHibSession().persist((Object)ct);
        }
        this.creditTypes.put(uid, ct);
    }

    private void initializeCreditUnitTypeData(Element rootElement) throws Exception {
        for (CourseCreditUnitType creditUnitType : CourseCreditUnitType.getCourseCreditUnitTypeList()) {
            this.creditUnitTypesByRef.put(creditUnitType.getReference(), creditUnitType);
        }
        Element creditUnitTypesElement = rootElement.element(PointInTimeDataExport.sCreditUnitTypesElementName);
        for (Element creditUnitTypeElement : creditUnitTypesElement.elements()) {
            this.elementCreditUnitType(creditUnitTypeElement);
        }
    }

    private void elementCreditUnitType(Element creditUnitTypeElement) throws Exception {
        Long uid = this.getRequiredLongAttribute(creditUnitTypeElement, PointInTimeDataExport.sUniqueIdAttribute, PointInTimeDataExport.sCreditUnitTypeElementName);
        String reference = this.getRequiredStringAttribute(creditUnitTypeElement, PointInTimeDataExport.sReferenceAttribute, PointInTimeDataExport.sCreditUnitTypeElementName);
        CourseCreditUnitType cut = this.creditUnitTypesByRef.get(reference);
        if (cut == null) {
            String label = this.getRequiredStringAttribute(creditUnitTypeElement, PointInTimeDataExport.sLabelAttribute, PointInTimeDataExport.sCreditUnitTypeElementName);
            String abbreviation = this.getRequiredStringAttribute(creditUnitTypeElement, PointInTimeDataExport.sAbbreviationAttribute, PointInTimeDataExport.sCreditUnitTypeElementName);
            cut = new CourseCreditUnitType();
            cut.setReference(reference);
            cut.setLabel(label);
            cut.setAbbreviation(abbreviation);
            this.getHibSession().persist((Object)cut);
        }
        this.creditUnitTypes.put(uid, cut);
    }

    private void initializePositionTypeData(Element rootElement) throws Exception {
        for (PositionType positionType : PositionType.findAll()) {
            this.positionTypesByRef.put(positionType.getReference(), positionType);
        }
        Element positionTypesElement = rootElement.element(PointInTimeDataExport.sPositionTypesElementName);
        for (Element positionTypeElement : positionTypesElement.elements()) {
            this.elementPositionType(positionTypeElement);
        }
    }

    private void initializeTeachingResponsibilityData(Element rootElement) throws Exception {
        for (TeachingResponsibility instructorTeachingResponsibility : TeachingResponsibility.getInstructorTeachingResponsibilities()) {
            this.teachingResponsibilitiesByRef.put(instructorTeachingResponsibility.getReference(), instructorTeachingResponsibility);
        }
        for (TeachingResponsibility coordinatorTeachingResponsibility : TeachingResponsibility.getCoordinatorTeachingResponsibilities()) {
            this.teachingResponsibilitiesByRef.put(coordinatorTeachingResponsibility.getReference(), coordinatorTeachingResponsibility);
        }
        Element responsibilitiesElement = rootElement.element(PointInTimeDataExport.sTeachingResponsibilitiesElementName);
        for (Element responsibilityElement : responsibilitiesElement.elements()) {
            this.elementTeachingResponsibility(responsibilityElement);
        }
    }

    private void elementInstructionalMethod(Element instructionalMethodElement) throws Exception {
        String reference = this.getRequiredStringAttribute(instructionalMethodElement, PointInTimeDataExport.sReferenceAttribute, PointInTimeDataExport.sInstructionalMethodElementName);
        if (!this.instructionalMethods.containsKey(reference)) {
            String label = this.getRequiredStringAttribute(instructionalMethodElement, PointInTimeDataExport.sLabelAttribute, PointInTimeDataExport.sInstructionalMethodElementName);
            Boolean visible = this.getRequiredBooleanAttribute(instructionalMethodElement, PointInTimeDataExport.sVisibleAttribute, PointInTimeDataExport.sInstructionalMethodElementName);
            InstructionalMethod im = new InstructionalMethod();
            im.setReference(reference);
            im.setLabel(label);
            im.setVisible(visible);
            this.getHibSession().persist((Object)im);
            this.instructionalMethods.put(im.getReference(), im);
        }
    }

    private void initializeInstructionalMethodData(Element rootElement) throws Exception {
        for (InstructionalMethod instructionalMethod : InstructionalMethod.findAll()) {
            this.instructionalMethods.put(instructionalMethod.getReference(), instructionalMethod);
        }
        Element instructionalMethodsElement = rootElement.element(PointInTimeDataExport.sInstructionalMethodsElementName);
        for (Element instructionalMethodElement : instructionalMethodsElement.elements()) {
            this.elementInstructionalMethod(instructionalMethodElement);
        }
    }

    private void elementClassDurationType(Element classDurationTypeElement) throws Exception {
        String reference = this.getRequiredStringAttribute(classDurationTypeElement, PointInTimeDataExport.sReferenceAttribute, PointInTimeDataExport.sClassDurationTypeElementName);
        if (!this.classDurationTypes.containsKey(reference)) {
            String label = this.getRequiredStringAttribute(classDurationTypeElement, PointInTimeDataExport.sLabelAttribute, PointInTimeDataExport.sClassDurationTypeElementName);
            String abbreviation = this.getRequiredStringAttribute(classDurationTypeElement, PointInTimeDataExport.sAbbreviationAttribute, PointInTimeDataExport.sClassDurationTypeElementName);
            String implementation = this.getRequiredStringAttribute(classDurationTypeElement, PointInTimeDataExport.sImplementationAttribute, PointInTimeDataExport.sClassDurationTypeElementName);
            String parameter = this.getRequiredStringAttribute(classDurationTypeElement, PointInTimeDataExport.sParameterAttribute, PointInTimeDataExport.sClassDurationTypeElementName);
            Boolean visible = this.getRequiredBooleanAttribute(classDurationTypeElement, PointInTimeDataExport.sVisibleAttribute, PointInTimeDataExport.sClassDurationTypeElementName);
            ClassDurationType cdt = new ClassDurationType();
            cdt.setReference(reference);
            cdt.setLabel(label);
            cdt.setAbbreviation(abbreviation);
            cdt.setImplementation(implementation);
            cdt.setParameter(parameter);
            cdt.setVisible(visible);
            this.getHibSession().persist((Object)cdt);
            this.classDurationTypes.put(cdt.getReference(), cdt);
        }
    }

    private void initializeClassDurationTypeData(Element rootElement) throws Exception {
        for (ClassDurationType classDurationType : ClassDurationType.findAll()) {
            this.classDurationTypes.put(classDurationType.getReference(), classDurationType);
        }
        Element classDurationTypesElement = rootElement.element(PointInTimeDataExport.sClassDurationTypesElementName);
        for (Element classDurationTypeElement : classDurationTypesElement.elements()) {
            this.elementClassDurationType(classDurationTypeElement);
        }
    }

    private void elementCourseType(Element courseTypeElement) throws Exception {
        Long uid = this.getRequiredLongAttribute(courseTypeElement, PointInTimeDataExport.sUniqueIdAttribute, PointInTimeDataExport.sCourseTypeElementName);
        String reference = this.getRequiredStringAttribute(courseTypeElement, PointInTimeDataExport.sReferenceAttribute, PointInTimeDataExport.sCourseTypeElementName);
        CourseType ct = this.courseTypesByRef.get(reference);
        if (ct == null) {
            String label = this.getRequiredStringAttribute(courseTypeElement, PointInTimeDataExport.sLabelAttribute, PointInTimeDataExport.sCourseTypeElementName);
            ct = new CourseType();
            ct.setReference(reference);
            ct.setLabel(label);
            this.getHibSession().persist((Object)ct);
        }
        this.courseTypes.put(uid, ct);
    }

    private void initializeCourseTypeData(Element rootElement) throws Exception {
        for (CourseType courseType : this.getHibSession().createQuery("from CourseType", CourseType.class).list()) {
            this.courseTypesByRef.put(courseType.getReference(), courseType);
        }
        Element courseTypesElement = rootElement.element(PointInTimeDataExport.sCourseTypesElementName);
        for (Element courseTypeElement : courseTypesElement.elements()) {
            this.elementCourseType(courseTypeElement);
        }
    }

    private void logXmlFileCreateInformation(Element rootElement) {
        String created = this.getOptionalStringAttribute(rootElement, "created");
        if (created != null) {
            this.addNote("Loading offerings XML file created on: " + created);
            ChangeLog.addChange(this.getHibSession(), this.getManager(), this.session, this.session, created, ChangeLog.Source.DATA_IMPORT_OFFERINGS, ChangeLog.Operation.UPDATE, null, null);
            this.updateChangeList(true);
        }
    }

    protected void initializeSession(Element rootElement, String rootElementName) throws Exception {
        Long sessionUid = null;
        String campus = this.getRequiredStringAttribute(rootElement, PointInTimeDataExport.sAcademicInitiativeAttribute, rootElementName);
        String year = this.getRequiredStringAttribute(rootElement, PointInTimeDataExport.sAcademicYearAttribute, rootElementName);
        String term = this.getRequiredStringAttribute(rootElement, PointInTimeDataExport.sAcademicTermAttribute, rootElementName);
        try {
            sessionUid = this.getRequiredLongAttribute(rootElement, PointInTimeDataExport.sAcademicSessionUniqueIdAttribute, rootElementName);
        }
        catch (Exception e) {
            this.info("Could not convert sessionUidString to long.");
            this.info("Looking up session using academicInitiative:  " + campus + ", academicYear:  " + year + " and academicTerm:  " + term);
            sessionUid = null;
        }
        if (sessionUid != null) {
            this.session = Session.getSessionById(sessionUid);
            if (this.session != null) {
                this.info("Could find session using uniqueId: " + sessionUid);
                this.info("Not looking up session using academicInitiative:  " + campus + ", academicYear:  " + year + " and academicTerm:  " + term);
            }
        }
        if (this.session == null) {
            this.session = this.findSession(campus, year, term);
        }
        if (this.session == null) {
            this.info("No session found for academicInitiative:  " + campus + ", academicYear:  " + year + " and academicTerm:  " + term);
            this.info("Creating a new academic session based on data from import file");
            this.session = new Session();
            this.session.setAcademicInitiative(campus);
            this.session.setAcademicTerm(term);
            this.session.setAcademicYear(year);
            this.session.setSessionBeginDateTime(CalendarUtils.getDate(this.getRequiredStringAttribute(rootElement, PointInTimeDataExport.sSessionBeginDateAttribute, rootElementName), this.dateFormat));
            this.session.setSessionEndDateTime(CalendarUtils.getDate(this.getRequiredStringAttribute(rootElement, PointInTimeDataExport.sSessionEndDateAttribute, rootElementName), this.dateFormat));
            this.session.setClassesEndDateTime(CalendarUtils.getDate(this.getRequiredStringAttribute(rootElement, PointInTimeDataExport.sClassesEndDateAttribute, rootElementName), this.dateFormat));
            this.session.setExamBeginDate(this.session.getClassesEndDateTime());
            this.session.setEventBeginDate(this.session.getSessionBeginDateTime());
            this.session.setEventEndDate(this.session.getSessionEndDateTime());
            this.session.setStatusType(DepartmentStatusType.findByRef("initial"));
            this.session.setLastWeekToEnroll(1);
            this.session.setLastWeekToChange(1);
            this.session.setLastWeekToDrop(1);
            String defaultDurationType = this.getOptionalStringAttribute(rootElement, PointInTimeDataExport.sDurationTypeAttribute);
            if (defaultDurationType != null) {
                this.session.setDefaultClassDurationType(this.classDurationTypes.get(defaultDurationType));
            }
            this.getHibSession().persist((Object)this.session);
        }
        this.pointInTimeData = new PointInTimeData();
        this.pointInTimeData.setName(this.getRequiredStringAttribute(rootElement, PointInTimeDataExport.sPointInTimeNameAttribute, rootElementName));
        this.pointInTimeData.setNote(this.getRequiredStringAttribute(rootElement, PointInTimeDataExport.sPointInTimeNoteAttribute, rootElementName));
        this.pointInTimeData.setSavedSuccessfully(Boolean.FALSE);
        this.pointInTimeData.setSession(this.session);
        this.pointInTimeData.setTimestamp(CalendarUtils.getDate(this.getRequiredStringAttribute(rootElement, PointInTimeDataExport.sCreatedAttribute, rootElementName), this.dateFormat + " " + this.timeFormat));
        this.getHibSession().persist((Object)this.pointInTimeData);
    }

    protected void initializeSessionData(Element rootElement) throws Exception {
        this.initializeSession(rootElement, PointInTimeDataExport.sRootElementName);
        this.initializeDepartmentData(rootElement);
        this.initializeCurriculaData(rootElement);
        this.initializeDatePatternData(rootElement);
        this.initializeTimePatternData(rootElement);
        this.initializeLocationData(rootElement);
    }

    private void initializeCurriculaData(Element rootElement) throws Exception {
        Element minorsElement;
        Element majorsElement;
        Element academicClassificationsElement;
        this.loadExistingAcademicAreas(this.session.getUniqueId());
        this.loadExistingAcademicClassifications(this.session.getUniqueId());
        this.loadExistingMajors(this.session.getUniqueId());
        this.loadExistingMinors(this.session.getUniqueId());
        Element academicAreasElement = rootElement.element(PointInTimeDataExport.sAcademicAreasElementName);
        if (academicAreasElement != null) {
            for (Element academicAreaElement : academicAreasElement.elements()) {
                this.elementAcademicArea(academicAreaElement);
            }
        }
        if ((academicClassificationsElement = rootElement.element(PointInTimeDataExport.sAcademicClassificationsElementName)) != null) {
            for (Element academicClassificationElement : academicClassificationsElement.elements()) {
                this.elementAcademicClassification(academicClassificationElement);
            }
        }
        if ((majorsElement = rootElement.element(PointInTimeDataExport.sMajorsElementName)) != null) {
            for (Element majorElement : majorsElement.elements()) {
                this.elementMajor(majorElement);
            }
        }
        if ((minorsElement = rootElement.element(PointInTimeDataExport.sMinorsElementName)) != null) {
            for (Element minorElement : minorsElement.elements()) {
                this.elementMinor(minorElement);
            }
        }
    }

    private void initializeDateTimeFormats(Element rootElement) {
        this.dateFormat = this.getOptionalStringAttribute(rootElement, "dateFormat");
        this.timeFormat = this.getOptionalStringAttribute(rootElement, "timeFormat");
        if (this.timeFormat == null) {
            this.timeFormat = "HHmm";
        }
    }

    protected void initializeTrimLeadingZeros() {
        this.trimLeadingZerosFromExternalId = ApplicationProperty.DataExchangeTrimLeadingZerosFromExternalIds.isTrue();
    }

    private void initializeDatePatternData(Element rootElement) throws Exception {
        this.loadExistingDatePatterns(this.session.getUniqueId());
        Element datePatternsElement = rootElement.element(PointInTimeDataExport.sDatePatternsElementName);
        for (Element datePatternElement : datePatternsElement.elements()) {
            this.elementDatePattern(datePatternElement);
        }
    }

    private void initializeTimePatternData(Element rootElement) throws Exception {
        this.loadExistingTimePatterns(this.session.getUniqueId());
        Element timePatternsElement = rootElement.element(PointInTimeDataExport.sTimePatternsElementName);
        for (Element timePatternElement : timePatternsElement.elements()) {
            this.elementTimePattern(timePatternElement);
        }
    }

    private void elementDatePattern(Element datePatternElement) throws Exception {
        Long uid = this.getRequiredLongAttribute(datePatternElement, PointInTimeDataExport.sUniqueIdAttribute, PointInTimeDataExport.sDatePatternElementName);
        String name = this.getRequiredStringAttribute(datePatternElement, PointInTimeDataExport.sNameAttribute, PointInTimeDataExport.sDatePatternElementName);
        DatePattern dp = this.datePatternsByName.get(name);
        if (dp == null) {
            dp = new DatePattern();
            dp.setName(name);
            String numWksStr = this.getOptionalStringAttribute(datePatternElement, PointInTimeDataExport.sNumberOfWeeksAttribute);
            if (numWksStr != null) {
                dp.setNumberOfWeeks(Float.valueOf(Float.parseFloat(numWksStr)));
            }
            dp.setOffset(this.getRequiredIntegerAttribute(datePatternElement, PointInTimeDataExport.sOffsetAttribute, PointInTimeDataExport.sDatePatternElementName));
            dp.setPattern(this.getRequiredStringAttribute(datePatternElement, PointInTimeDataExport.sPatternAttribute, PointInTimeDataExport.sDatePatternElementName));
            dp.setVisible(this.getRequiredBooleanAttribute(datePatternElement, PointInTimeDataExport.sVisibleAttribute, PointInTimeDataExport.sDatePatternElementName));
            dp.setType(this.getRequiredIntegerAttribute(datePatternElement, PointInTimeDataExport.sTypeAttribute, PointInTimeDataExport.sDatePatternElementName));
            dp.setSession(this.session);
            this.getHibSession().persist((Object)dp);
        }
        this.datePatterns.put(uid, dp);
    }

    private void elementTimePattern(Element timePatternElement) throws Exception {
        Long uid = this.getRequiredLongAttribute(timePatternElement, PointInTimeDataExport.sUniqueIdAttribute, PointInTimeDataExport.sTimePatternElementName);
        String name = this.getRequiredStringAttribute(timePatternElement, PointInTimeDataExport.sNameAttribute, PointInTimeDataExport.sTimePatternElementName);
        TimePattern tp = this.timePatternsByName.get(name);
        if (tp == null) {
            tp = new TimePattern();
            tp.setName(name);
            tp.setMinPerMtg(this.getRequiredIntegerAttribute(timePatternElement, PointInTimeDataExport.sMinutesPerMeetingAttribute, PointInTimeDataExport.sTimePatternElementName));
            tp.setSlotsPerMtg(this.getRequiredIntegerAttribute(timePatternElement, PointInTimeDataExport.sSlotsPerMeetingAttribute, PointInTimeDataExport.sTimePatternElementName));
            tp.setNrMeetings(this.getRequiredIntegerAttribute(timePatternElement, PointInTimeDataExport.sNumberOfMeetingsPerWeekAttribute, PointInTimeDataExport.sTimePatternElementName));
            tp.setVisible(this.getRequiredBooleanAttribute(timePatternElement, PointInTimeDataExport.sVisibleAttribute, PointInTimeDataExport.sTimePatternElementName));
            tp.setType(this.getRequiredIntegerAttribute(timePatternElement, PointInTimeDataExport.sTypeAttribute, PointInTimeDataExport.sTimePatternElementName));
            tp.setBreakTime(this.getRequiredIntegerAttribute(timePatternElement, PointInTimeDataExport.sBreakTimeAttribute, PointInTimeDataExport.sTimePatternElementName));
            tp.setSession(this.session);
            for (Element element : timePatternElement.elements()) {
                if (element.getName().equals(PointInTimeDataExport.sTimePatternDaysElementName)) {
                    this.elementTimePatternDays(element, tp);
                    continue;
                }
                if (!element.getName().equals(PointInTimeDataExport.sTimePatternTimeElementName)) continue;
                this.elementTimePatternTime(element, tp);
            }
            this.getHibSession().persist((Object)tp);
        }
        this.timePatterns.put(uid, tp);
    }

    private void elementTimePatternTime(Element element, TimePattern tp) throws Exception {
        TimePatternTime timePatternTime = new TimePatternTime();
        timePatternTime.setStartSlot(this.getRequiredIntegerAttribute(element, PointInTimeDataExport.sStartSlotAttribute, PointInTimeDataExport.sTimePatternDaysElementName));
        tp.addToTimes(timePatternTime);
    }

    private void elementTimePatternDays(Element element, TimePattern tp) throws Exception {
        TimePatternDays timePatternDays = new TimePatternDays();
        timePatternDays.setDayCode(this.getRequiredIntegerAttribute(element, PointInTimeDataExport.sDayCodeAttribute, PointInTimeDataExport.sTimePatternDaysElementName));
        tp.addToDays(timePatternDays);
    }

    private void initializeLocationData(Element rootElement) throws Exception {
        this.loadExistingBuildings(this.session.getUniqueId());
        this.loadExistingLocations(this.session.getUniqueId());
        Element locationsElement = rootElement.element(PointInTimeDataExport.sLocationsElementName);
        for (Element element : locationsElement.elements()) {
            if (element.getName().equals(PointInTimeDataExport.sBuildingElementName)) {
                this.elementBuilding(element);
                continue;
            }
            if (!element.getName().equals(PointInTimeDataExport.sNonUniversityLocationElementName)) continue;
            this.elementNonUniversityLocation(element);
        }
    }

    private void elementNonUniversityLocation(Element nonUniversityLocationElement) throws Exception {
        Long uid = this.getRequiredLongAttribute(nonUniversityLocationElement, PointInTimeDataExport.sUniqueIdAttribute, PointInTimeDataExport.sNonUniversityLocationElementName);
        Long permId = this.getRequiredLongAttribute(nonUniversityLocationElement, PointInTimeDataExport.sPermanentIdAttribute, PointInTimeDataExport.sNonUniversityLocationElementName);
        String name = this.getRequiredStringAttribute(nonUniversityLocationElement, PointInTimeDataExport.sNameAttribute, PointInTimeDataExport.sNonUniversityLocationElementName);
        Location l = this.locationsByName.get(name + permId.toString());
        if (l == null) {
            String coordinateYstr;
            String coordinateXstr;
            NonUniversityLocation n = new NonUniversityLocation();
            n.setName(name);
            n.setSession(this.session);
            this.session.addToRooms(n);
            Long roomTypeId = this.getRequiredLongAttribute(nonUniversityLocationElement, PointInTimeDataExport.sRoomTypeIdAttribute, PointInTimeDataExport.sNonUniversityLocationElementName);
            n.setRoomType(this.roomTypes.get(roomTypeId));
            Integer capacity = this.getRequiredIntegerAttribute(nonUniversityLocationElement, PointInTimeDataExport.sCapacityAttribute, PointInTimeDataExport.sNonUniversityLocationElementName);
            n.setCapacity(capacity);
            String externalId = this.getOptionalStringAttribute(nonUniversityLocationElement, PointInTimeDataExport.sExternalIdAttribute);
            if (externalId != null) {
                n.setExternalUniqueId(externalId);
            }
            if ((coordinateXstr = this.getOptionalStringAttribute(nonUniversityLocationElement, PointInTimeDataExport.sCoordinateXAttribute)) != null) {
                Double coordinateX = Double.parseDouble(coordinateXstr);
                n.setCoordinateX(coordinateX);
            }
            if ((coordinateYstr = this.getOptionalStringAttribute(nonUniversityLocationElement, PointInTimeDataExport.sCoordinateXAttribute)) != null) {
                Double coordinateY = Double.parseDouble(coordinateYstr);
                n.setCoordinateY(coordinateY);
            }
            n.setIgnoreRoomCheck(Boolean.FALSE);
            n.setIgnoreTooFar(Boolean.FALSE);
            n.setPermanentId(this.getRequiredLongAttribute(nonUniversityLocationElement, PointInTimeDataExport.sPermanentIdAttribute, PointInTimeDataExport.sNonUniversityLocationElementName));
            this.getHibSession().persist((Object)n);
            Long ctrlDeptId = this.getOptionalLongAttribute(nonUniversityLocationElement, PointInTimeDataExport.sControllingDepartmentUniqueIdAttribute);
            if (ctrlDeptId != null) {
                RoomDept rd = new RoomDept();
                rd.setControl(Boolean.TRUE);
                rd.setDepartment(this.departments.get(ctrlDeptId));
                rd.setRoom(n);
                n.addToRoomDepts(rd);
                this.getHibSession().persist((Object)rd);
            }
            l = n;
        }
        this.locations.put(uid, l);
    }

    private void elementBuilding(Element buildingElement) throws Exception {
        Long uid = this.getRequiredLongAttribute(buildingElement, PointInTimeDataExport.sUniqueIdAttribute, PointInTimeDataExport.sBuildingElementName);
        String abbreviation = this.getRequiredStringAttribute(buildingElement, PointInTimeDataExport.sAbbreviationAttribute, PointInTimeDataExport.sBuildingElementName);
        Building b = this.buildingsByAbbv.get(abbreviation);
        if (b == null || !b.getAbbreviation().equals(abbreviation)) {
            String coordinateYstr;
            String coordinateXstr;
            b = new Building();
            b.setAbbreviation(abbreviation);
            b.setSession(this.session);
            this.session.addToBuildings(b);
            String name = this.getRequiredStringAttribute(buildingElement, PointInTimeDataExport.sNameAttribute, PointInTimeDataExport.sBuildingElementName);
            b.setName(name);
            String externalId = this.getOptionalStringAttribute(buildingElement, PointInTimeDataExport.sExternalIdAttribute);
            if (externalId != null) {
                b.setExternalUniqueId(externalId);
            }
            if ((coordinateXstr = this.getOptionalStringAttribute(buildingElement, PointInTimeDataExport.sCoordinateXAttribute)) != null) {
                Double coordinateX = Double.parseDouble(coordinateXstr);
                b.setCoordinateX(coordinateX);
            }
            if ((coordinateYstr = this.getOptionalStringAttribute(buildingElement, PointInTimeDataExport.sCoordinateXAttribute)) != null) {
                Double coordinateY = Double.parseDouble(coordinateYstr);
                b.setCoordinateY(coordinateY);
            }
            this.getHibSession().persist((Object)b);
        }
        this.buildings.put(uid, b);
        for (Element roomElement : buildingElement.elements()) {
            this.elementRoom(roomElement, b);
        }
    }

    private void elementRoom(Element roomElement, Building building) throws Exception {
        Long uid = this.getRequiredLongAttribute(roomElement, PointInTimeDataExport.sUniqueIdAttribute, PointInTimeDataExport.sRoomElementName);
        String roomNumber = this.getRequiredStringAttribute(roomElement, PointInTimeDataExport.sRoomNumberAttribute, PointInTimeDataExport.sRoomElementName);
        Long permId = this.getRequiredLongAttribute(roomElement, PointInTimeDataExport.sPermanentIdAttribute, PointInTimeDataExport.sRoomElementName);
        Location l = this.locationsByName.get(building.getAbbreviation() + roomNumber + permId.toString());
        if (l == null) {
            String coordinateYstr;
            Room r = new Room();
            r.setBuilding(building);
            r.setRoomNumber(roomNumber);
            r.setSession(this.session);
            this.session.addToRooms(r);
            Long roomTypeId = this.getRequiredLongAttribute(roomElement, PointInTimeDataExport.sRoomTypeIdAttribute, PointInTimeDataExport.sRoomElementName);
            r.setRoomType(this.roomTypes.get(roomTypeId));
            Integer capacity = this.getRequiredIntegerAttribute(roomElement, PointInTimeDataExport.sCapacityAttribute, PointInTimeDataExport.sRoomElementName);
            r.setCapacity(capacity);
            String externalId = this.getOptionalStringAttribute(roomElement, PointInTimeDataExport.sExternalIdAttribute);
            if (externalId != null) {
                r.setExternalUniqueId(externalId);
            }
            r.setPermanentId(permId);
            r.setIgnoreRoomCheck(Boolean.FALSE);
            r.setIgnoreTooFar(Boolean.FALSE);
            String coordinateXstr = this.getOptionalStringAttribute(roomElement, PointInTimeDataExport.sCoordinateXAttribute);
            if (coordinateXstr != null) {
                Double coordinateX = Double.parseDouble(coordinateXstr);
                r.setCoordinateX(coordinateX);
            }
            if ((coordinateYstr = this.getOptionalStringAttribute(roomElement, PointInTimeDataExport.sCoordinateXAttribute)) != null) {
                Double coordinateY = Double.parseDouble(coordinateYstr);
                r.setCoordinateY(coordinateY);
            }
            this.getHibSession().persist((Object)r);
            Long ctrlDeptId = this.getOptionalLongAttribute(roomElement, PointInTimeDataExport.sControllingDepartmentUniqueIdAttribute);
            if (ctrlDeptId != null) {
                RoomDept rd = new RoomDept();
                rd.setControl(Boolean.TRUE);
                rd.setDepartment(this.departments.get(ctrlDeptId));
                rd.setRoom(r);
                r.addToroomDepts(rd);
                this.getHibSession().persist((Object)rd);
            }
            l = r;
        }
        this.locations.put(uid, l);
    }

    private void initializeDepartmentData(Element rootElement) throws Exception {
        this.loadExistingDepartments(this.session.getUniqueId());
        this.loadExistingSubjectAreas(this.session.getUniqueId());
        this.loadDepartmentalInstructors(this.session.getUniqueId());
        Element departmentsElement = rootElement.element(PointInTimeDataExport.sDepartmentsElementName);
        for (Element departmentElement : departmentsElement.elements()) {
            this.elementDepartment(departmentElement);
        }
    }

    private void elementDepartment(Element departmentElement) throws Exception {
        Long uid = this.getRequiredLongAttribute(departmentElement, PointInTimeDataExport.sUniqueIdAttribute, PointInTimeDataExport.sDepartmentElementName);
        String deptCode = this.getRequiredStringAttribute(departmentElement, PointInTimeDataExport.sDepartmentCode, PointInTimeDataExport.sDepartmentElementName);
        Department d = this.departmentsByCode.get(deptCode);
        if (d == null) {
            String name = this.getRequiredStringAttribute(departmentElement, PointInTimeDataExport.sNameAttribute, PointInTimeDataExport.sDepartmentElementName);
            String abbreviation = this.getOptionalStringAttribute(departmentElement, PointInTimeDataExport.sAbbreviationAttribute);
            String externalId = this.getRequiredStringAttribute(departmentElement, PointInTimeDataExport.sExternalIdAttribute, PointInTimeDataExport.sDepartmentElementName);
            d = new Department();
            if (abbreviation != null) {
                d.setAbbreviation(abbreviation);
            }
            d.setName(name);
            d.setDeptCode(deptCode);
            d.setExternalUniqueId(externalId);
            d.setSession(this.session);
            d.setAllowEvents(Boolean.FALSE);
            d.setAllowReqTime(Boolean.TRUE);
            d.setAllowReqRoom(Boolean.TRUE);
            d.setAllowReqDistribution(Boolean.TRUE);
            d.setAllowStudentScheduling(Boolean.TRUE);
            d.setInheritInstructorPreferences(Boolean.TRUE);
            d.setExternalManager(Boolean.FALSE);
            d.setDistributionPrefPriority(0);
            this.session.addToDepartments(d);
            this.getHibSession().persist((Object)d);
            this.departmentsByCode.put(deptCode, d);
        }
        this.departments.put(uid, d);
        for (Element element : departmentElement.elements()) {
            if (element.getName().equals(PointInTimeDataExport.sDeptInstructorElementName)) {
                this.elementDepartmentalInstructor(element, d);
            }
            if (!element.getName().equals(PointInTimeDataExport.sSubjectAreaElementName)) continue;
            this.elementSubjectArea(element, d);
        }
    }

    private void elementDepartmentalInstructor(Element departmentalInstructorElement, Department department) throws Exception {
        if (departmentalInstructorElement.getName().equals(PointInTimeDataExport.sDeptInstructorElementName)) {
            Long positionTypeId;
            String email;
            String careerAcct;
            String middleName;
            String firstName;
            PitDepartmentalInstructor pitDeptInstr = new PitDepartmentalInstructor();
            Long uid = this.getRequiredLongAttribute(departmentalInstructorElement, PointInTimeDataExport.sUniqueIdAttribute, PointInTimeDataExport.sDeptInstructorElementName);
            String externalId = this.getOptionalStringAttribute(departmentalInstructorElement, PointInTimeDataExport.sExternalIdAttribute);
            if (externalId != null) {
                pitDeptInstr.setExternalUniqueId(externalId);
            }
            if ((firstName = this.getOptionalStringAttribute(departmentalInstructorElement, PointInTimeDataExport.sFirstNameAttribute)) != null) {
                pitDeptInstr.setFirstName(firstName);
            }
            if ((middleName = this.getOptionalStringAttribute(departmentalInstructorElement, PointInTimeDataExport.sMiddleNameAttribute)) != null) {
                pitDeptInstr.setMiddleName(middleName);
            }
            String lastName = this.getRequiredStringAttribute(departmentalInstructorElement, PointInTimeDataExport.sLastNameAttribute, PointInTimeDataExport.sDeptInstructorElementName);
            pitDeptInstr.setLastName(lastName);
            DepartmentalInstructor di = this.departmentalInstructorsByName.get((lastName == null ? "" : lastName) + (firstName == null ? "" : firstName) + (middleName == null ? "" : middleName) + (externalId == null ? "" : externalId));
            if (di != null) {
                pitDeptInstr.setDepartmentalInstructor(di);
            }
            if ((careerAcct = this.getOptionalStringAttribute(departmentalInstructorElement, PointInTimeDataExport.sCareerAcctAttribute)) != null) {
                pitDeptInstr.setCareerAcct(careerAcct);
            }
            if ((email = this.getOptionalStringAttribute(departmentalInstructorElement, PointInTimeDataExport.sEmailAttribute)) != null) {
                pitDeptInstr.setEmail(email);
            }
            if ((positionTypeId = this.getOptionalLongAttribute(departmentalInstructorElement, PointInTimeDataExport.sPositionTypeUniqueIdAttribute)) != null) {
                pitDeptInstr.setPositionType(this.positionTypes.get(positionTypeId));
            }
            pitDeptInstr.setDepartment(department);
            pitDeptInstr.setPointInTimeData(this.pointInTimeData);
            this.getHibSession().persist((Object)pitDeptInstr);
            this.pitDepartmentInstructors.put(uid, pitDeptInstr);
        }
    }

    private void elementSubjectArea(Element subjectAreaElement, Department department) throws Exception {
        String subjectAreaAbbreviation;
        if (subjectAreaElement.getName().equals(PointInTimeDataExport.sSubjectAreaElementName) && !this.subjectAreas.containsKey(subjectAreaAbbreviation = this.getRequiredStringAttribute(subjectAreaElement, PointInTimeDataExport.sSubjectAreaAbbreviationAttribute, PointInTimeDataExport.sSubjectAreaElementName))) {
            String title = this.getRequiredStringAttribute(subjectAreaElement, PointInTimeDataExport.sTitleAttribute, PointInTimeDataExport.sSubjectAreaElementName);
            String externalId = this.getRequiredStringAttribute(subjectAreaElement, PointInTimeDataExport.sExternalIdAttribute, PointInTimeDataExport.sSubjectAreaElementName);
            SubjectArea sa = new SubjectArea();
            sa.setSubjectAreaAbbreviation(subjectAreaAbbreviation);
            sa.setTitle(title);
            sa.setExternalUniqueId(externalId);
            sa.setDepartment(department);
            department.addToSubjectAreas(sa);
            sa.setSession(this.session);
            this.session.addToSubjectAreas(sa);
            this.getHibSession().persist((Object)sa);
            this.subjectAreas.put(sa.getSubjectAreaAbbreviation(), sa);
        }
    }

    private void elementMajor(Element majorElement) throws Exception {
        Long uid = this.getRequiredLongAttribute(majorElement, PointInTimeDataExport.sUniqueIdAttribute, PointInTimeDataExport.sMajorElementName);
        String code = this.getRequiredStringAttribute(majorElement, PointInTimeDataExport.sCodeAttribute, PointInTimeDataExport.sMajorElementName);
        PosMajor major = this.majorsByCode.get(code);
        if (major == null) {
            String name = this.getRequiredStringAttribute(majorElement, PointInTimeDataExport.sNameAttribute, PointInTimeDataExport.sMajorElementName);
            major = new PosMajor();
            major.setCode(code);
            major.setName(name);
            major.setSession(this.session);
            String externalId = this.getOptionalStringAttribute(majorElement, PointInTimeDataExport.sExternalIdAttribute);
            if (externalId != null) {
                major.setExternalUniqueId(externalId);
            }
            this.getHibSession().persist((Object)major);
        }
        this.majors.put(uid, major);
        for (Element concElement : majorElement.elements()) {
            this.elementConcentration(major, concElement);
        }
    }

    private void elementConcentration(PosMajor major, Element concElement) throws Exception {
        Long uid = this.getRequiredLongAttribute(concElement, PointInTimeDataExport.sUniqueIdAttribute, PointInTimeDataExport.sConcentrationElementName);
        String code = this.getRequiredStringAttribute(concElement, PointInTimeDataExport.sCodeAttribute, PointInTimeDataExport.sConcentrationElementName);
        PosMajorConcentration conc = this.concentrationsByCode.get(major.getCode() + "/" + code);
        if (conc == null) {
            String name = this.getRequiredStringAttribute(concElement, PointInTimeDataExport.sNameAttribute, PointInTimeDataExport.sConcentrationElementName);
            conc = new PosMajorConcentration();
            conc.setCode(code);
            conc.setName(name);
            conc.setMajor(major);
            String externalId = this.getOptionalStringAttribute(concElement, PointInTimeDataExport.sExternalIdAttribute);
            if (externalId != null) {
                conc.setExternalUniqueId(externalId);
            }
            this.getHibSession().persist((Object)conc);
        }
        this.concentrations.put(uid, conc);
    }

    private void elementMinor(Element minorElement) throws Exception {
        Long uid = this.getRequiredLongAttribute(minorElement, PointInTimeDataExport.sUniqueIdAttribute, PointInTimeDataExport.sMinorElementName);
        String code = this.getRequiredStringAttribute(minorElement, PointInTimeDataExport.sCodeAttribute, PointInTimeDataExport.sMinorElementName);
        PosMinor minor = this.minorsByCode.get(code);
        if (minor == null) {
            String name = this.getRequiredStringAttribute(minorElement, PointInTimeDataExport.sNameAttribute, PointInTimeDataExport.sMinorElementName);
            minor = new PosMinor();
            minor.setCode(code);
            minor.setName(name);
            minor.setSession(this.session);
            String externalId = this.getOptionalStringAttribute(minorElement, PointInTimeDataExport.sExternalIdAttribute);
            if (externalId != null) {
                minor.setExternalUniqueId(externalId);
            }
            this.getHibSession().persist((Object)minor);
        }
        this.minors.put(uid, minor);
    }

    private void elementAcademicClassification(Element academicClassificationElement) throws Exception {
        Long uid = this.getRequiredLongAttribute(academicClassificationElement, PointInTimeDataExport.sUniqueIdAttribute, PointInTimeDataExport.sAcademicClassificationElementName);
        String code = this.getRequiredStringAttribute(academicClassificationElement, PointInTimeDataExport.sCodeAttribute, PointInTimeDataExport.sAcademicClassificationElementName);
        AcademicClassification ac = this.academicClassificationsByCode.get(code);
        if (ac == null) {
            String name = this.getRequiredStringAttribute(academicClassificationElement, PointInTimeDataExport.sNameAttribute, PointInTimeDataExport.sAcademicClassificationElementName);
            ac = new AcademicClassification();
            ac.setCode(code);
            ac.setName(name);
            ac.setSession(this.session);
            String externalId = this.getOptionalStringAttribute(academicClassificationElement, PointInTimeDataExport.sExternalIdAttribute);
            if (externalId != null) {
                ac.setExternalUniqueId(externalId);
            }
            this.getHibSession().persist((Object)ac);
        }
        this.academicClassifications.put(uid, ac);
    }

    private void elementAcademicArea(Element academicAreaElement) throws Exception {
        Long uid = this.getRequiredLongAttribute(academicAreaElement, PointInTimeDataExport.sUniqueIdAttribute, PointInTimeDataExport.sAcademicAreaElementName);
        String abbreviation = this.getRequiredStringAttribute(academicAreaElement, PointInTimeDataExport.sAbbreviationAttribute, PointInTimeDataExport.sAcademicAreaElementName);
        AcademicArea aa = this.academicAreasByAbbv.get(abbreviation);
        if (aa == null) {
            String title = this.getRequiredStringAttribute(academicAreaElement, PointInTimeDataExport.sTitleAttribute, PointInTimeDataExport.sAcademicAreaElementName);
            aa = new AcademicArea();
            aa.setAcademicAreaAbbreviation(abbreviation);
            aa.setTitle(title);
            aa.setSession(this.session);
            String externalId = this.getOptionalStringAttribute(academicAreaElement, PointInTimeDataExport.sExternalIdAttribute);
            if (externalId != null) {
                aa.setExternalUniqueId(externalId);
            }
            this.getHibSession().persist((Object)aa);
        }
        this.academicAreas.put(uid, aa);
    }

    private void loadSetupData() throws Exception {
        this.loadItypes();
        this.loadExistingInstructionalOfferings(this.session.getUniqueId());
        this.loadExistingCourseOfferings(this.session.getUniqueId());
        this.loadExistingInstrOfferingConfigs(this.session.getUniqueId());
        this.loadExistingSchedulingSubparts(this.session.getUniqueId());
        this.loadExistingClasses(this.session.getUniqueId());
    }

    private void loadExistingStudents(Long sessionId) {
        for (Student s : this.getHibSession().createQuery("select distinct s from Student as s where s.session.uniqueId=:sessionId", Student.class).setParameter("sessionId", (Object)sessionId).setCacheable(true).list()) {
            this.students.put(s.getUniqueId(), s);
        }
    }

    private void loadExistingTimePatterns(Long sessionId) {
        List patterns = this.getHibSession().createQuery("select distinct tp from TimePattern as tp where tp.session.uniqueId=:sessionId", TimePattern.class).setParameter("sessionId", (Object)sessionId).setCacheable(true).list();
        for (TimePattern tp : patterns) {
            this.timePatternsByName.put(tp.getName(), tp);
        }
    }

    private void loadExistingDatePatterns(Long sessionId) {
        List patterns = this.getHibSession().createQuery("select distinct dp from DatePattern as dp where dp.session.uniqueId=:sessionId", DatePattern.class).setParameter("sessionId", (Object)sessionId).setCacheable(true).list();
        for (DatePattern dp : patterns) {
            this.datePatternsByName.put(dp.getName(), dp);
        }
    }

    private void loadExistingBuildings(Long sessionId) {
        List existingBuildings = this.getHibSession().createQuery("select distinct b from Building as b where b.session.uniqueId=:sessionId", Building.class).setParameter("sessionId", (Object)sessionId).setCacheable(true).list();
        for (Building building : existingBuildings) {
            this.buildingsByAbbv.put(building.getAbbreviation(), building);
        }
    }

    private void loadExistingLocations(Long sessionId) {
        List existingRooms = this.getHibSession().createQuery("select distinct r from Room as r where r.session.uniqueId=:sessionId", Room.class).setParameter("sessionId", (Object)sessionId).setCacheable(true).list();
        for (Room room : existingRooms) {
            this.locationsByName.put(room.getBuildingAbbv() + room.getRoomNumber() + room.getPermanentId().toString(), room);
        }
        List existingNonUniversityLocation = this.getHibSession().createQuery("select distinct n from NonUniversityLocation as n where n.session.uniqueId=:sessionId", NonUniversityLocation.class).setParameter("sessionId", (Object)sessionId).setCacheable(true).list();
        for (NonUniversityLocation nonUniversityLocation : existingNonUniversityLocation) {
            this.locationsByName.put(nonUniversityLocation.getName() + nonUniversityLocation.getPermanentId().toString(), nonUniversityLocation);
        }
    }

    private void elementClassInstructor(Element classInstructorElement, PitClass pitClass) throws Exception {
        PitClassInstructor pci = new PitClassInstructor();
        pci.setPitClassInstructing(pitClass);
        pitClass.addToPitClassInstructors(pci);
        pci.setPitDepartmentalInstructor(this.pitDepartmentInstructors.get(this.getRequiredLongAttribute(classInstructorElement, PointInTimeDataExport.sDepartmentalInstructorUniqueIdAttribute, PointInTimeDataExport.sClassInstructorElementName)));
        pci.setPercentShare(this.getRequiredIntegerAttribute(classInstructorElement, PointInTimeDataExport.sShareAttribute, PointInTimeDataExport.sClassInstructorElementName));
        pci.setNormalizedPercentShare(0);
        Long responsibilityId = this.getOptionalLongAttribute(classInstructorElement, PointInTimeDataExport.sResponsibilityUniqueIdAttribute);
        if (responsibilityId != null) {
            pci.setResponsibility(this.teachingResponsibilities.get(responsibilityId));
        }
        pci.setLead(this.getOptionalBooleanAttribute(classInstructorElement, PointInTimeDataExport.sLeadAttribute, true));
        this.getHibSession().persist((Object)pci);
    }

    private void elementOfferingCoordinator(Element classInstructorElement, PitInstructionalOffering pitInstructionalOffering) throws Exception {
        PitOfferingCoordinator pci = new PitOfferingCoordinator();
        pci.setPitInstructionalOffering(pitInstructionalOffering);
        pitInstructionalOffering.addToPitOfferingCoordinators(pci);
        pci.setPitDepartmentalInstructor(this.pitDepartmentInstructors.get(this.getRequiredLongAttribute(classInstructorElement, PointInTimeDataExport.sDepartmentalInstructorUniqueIdAttribute, PointInTimeDataExport.sClassInstructorElementName)));
        pci.setPercentShare(this.getRequiredIntegerAttribute(classInstructorElement, PointInTimeDataExport.sShareAttribute, PointInTimeDataExport.sOfferingCoordinatorElementName));
        Long responsibilityId = this.getOptionalLongAttribute(classInstructorElement, PointInTimeDataExport.sResponsibilityUniqueIdAttribute);
        if (responsibilityId != null) {
            pci.setResponsibility(this.teachingResponsibilities.get(responsibilityId));
        }
        this.getHibSession().persist((Object)pci);
    }

    private void elementCourse(Element courseElement, PitInstructionalOffering pitInstructionalOffering) throws Exception {
        if (courseElement.getName().equals(PointInTimeDataExport.sCourseElementName)) {
            String externalId;
            Long uidRollFwdFrm;
            Long courseTypeId;
            Integer nbrExpectedStudents;
            Integer lastlikeDemand;
            Integer projectedDemand;
            String title;
            PitCourseOffering pco = new PitCourseOffering();
            pco.setPitInstructionalOffering(pitInstructionalOffering);
            pitInstructionalOffering.addToPitCourseOfferings(pco);
            pco.setSubjectArea(this.subjectAreas.get(this.getRequiredStringAttribute(courseElement, PointInTimeDataExport.sSubjectAreaAbbreviationAttribute, PointInTimeDataExport.sCourseElementName)));
            pco.setCourseNbr(this.getRequiredStringAttribute(courseElement, PointInTimeDataExport.sCourseNbrAttribute, PointInTimeDataExport.sCourseElementName));
            pco.setIsControl(this.getOptionalBooleanAttribute(courseElement, PointInTimeDataExport.sControllingAttribute, true));
            pco.setPermId(this.getRequiredStringAttribute(courseElement, PointInTimeDataExport.sPermanentIdAttribute, PointInTimeDataExport.sCourseElementName));
            pco.setExternalUniqueId(this.getRequiredStringAttribute(courseElement, PointInTimeDataExport.sExternalIdAttribute, PointInTimeDataExport.sCourseElementName));
            Long uid = this.getRequiredLongAttribute(courseElement, PointInTimeDataExport.sUniqueIdAttribute, PointInTimeDataExport.sCourseElementName);
            CourseOffering co = this.courseOfferings.get(uid);
            if (co != null && co.getSubjectArea().getUniqueId().equals(pco.getSubjectArea().getUniqueId()) && co.getCourseNbr().equals(pco.getCourseNbr())) {
                pco.setCourseOffering(co);
            }
            if ((title = this.getOptionalStringAttribute(courseElement, PointInTimeDataExport.sTitleAttribute)) != null) {
                pco.setTitle(title);
            }
            if ((projectedDemand = this.getOptionalIntegerAttribute(courseElement, PointInTimeDataExport.sProjectedDemandAttribute)) != null) {
                pco.setProjectedDemand(projectedDemand);
            }
            if ((lastlikeDemand = this.getOptionalIntegerAttribute(courseElement, PointInTimeDataExport.sLastlikeDemandAttribute)) != null) {
                pco.setDemand(lastlikeDemand);
            }
            if ((nbrExpectedStudents = this.getOptionalIntegerAttribute(courseElement, PointInTimeDataExport.sNumberExpectedStudentsAttribute)) != null) {
                pco.setNbrExpectedStudents(nbrExpectedStudents);
            }
            if ((courseTypeId = this.getOptionalLongAttribute(courseElement, PointInTimeDataExport.sCourseTypeIdAttribute)) != null) {
                pco.setCourseType(this.courseTypes.get(courseTypeId));
            }
            if ((uidRollFwdFrm = this.getOptionalLongAttribute(courseElement, PointInTimeDataExport.sUniqueIdRolledForwardFromAttribute)) != null) {
                pco.setUniqueIdRolledForwardFrom(uidRollFwdFrm);
            }
            if ((externalId = this.getOptionalStringAttribute(courseElement, PointInTimeDataExport.sExternalIdAttribute)) != null) {
                pco.setExternalUniqueId(externalId);
            }
            this.getHibSession().persist((Object)pco);
            this.pitCourseOfferings.put(uid, pco);
        }
    }

    private void elementInstrOffrConfig(Element configElement, PitInstructionalOffering pitInstructionalOffering) throws Exception {
        Long uidRollFwdFrm;
        String instructionalMethodStr;
        PitInstrOfferingConfig pioc = new PitInstrOfferingConfig();
        InstrOfferingConfig ioc = this.instrOfferingConfigs.get(this.getRequiredLongAttribute(configElement, PointInTimeDataExport.sUniqueIdAttribute, PointInTimeDataExport.sConfigElementName));
        if (ioc != null) {
            pioc.setInstrOfferingConfig(ioc);
        }
        pioc.setName(this.getRequiredStringAttribute(configElement, PointInTimeDataExport.sNameAttribute, PointInTimeDataExport.sConfigElementName));
        pioc.setPitInstructionalOffering(pitInstructionalOffering);
        pitInstructionalOffering.addToPitInstrOfferingConfigs(pioc);
        pioc.setUnlimitedEnrollment(this.getRequiredBooleanAttribute(configElement, PointInTimeDataExport.sUnlimitedEnrollmentAttributeName, PointInTimeDataExport.sConfigElementName));
        String durationTypeStr = this.getOptionalStringAttribute(configElement, PointInTimeDataExport.sDurationTypeAttribute);
        if (durationTypeStr != null) {
            pioc.setClassDurationType(this.classDurationTypes.get(durationTypeStr));
        }
        if ((instructionalMethodStr = this.getOptionalStringAttribute(configElement, PointInTimeDataExport.sInstructionalMethodAttribute)) != null) {
            pioc.setInstructionalMethod(this.instructionalMethods.get(instructionalMethodStr));
        }
        if ((uidRollFwdFrm = this.getOptionalLongAttribute(configElement, PointInTimeDataExport.sUniqueIdRolledForwardFromAttribute)) != null) {
            pioc.setUniqueIdRolledForwardFrom(uidRollFwdFrm);
        }
        this.getHibSession().persist((Object)pioc);
        for (Element subpartElement : configElement.elements()) {
            this.elementSubpart(subpartElement, pioc, null);
        }
    }

    private void elementClass(Element classElement, PitSchedulingSubpart pitSchedulingSubpart) throws Exception {
        String externalId;
        Long uidRollFwdFrm;
        Integer numberOfRooms;
        PitClass pc = new PitClass();
        Long uid = this.getRequiredLongAttribute(classElement, PointInTimeDataExport.sUniqueIdAttribute, PointInTimeDataExport.sClassElementName);
        Class_ c = this.classes.get(uid);
        if (c != null) {
            pc.setClazz(c);
        }
        pc.setPitSchedulingSubpart(pitSchedulingSubpart);
        pitSchedulingSubpart.addToPitClasses(pc);
        Long parentClassUid = this.getOptionalLongAttribute(classElement, PointInTimeDataExport.sParentClassUniqueIdAttribute);
        if (parentClassUid != null) {
            PitClass parentPitClass = this.pitClasses.get(parentClassUid);
            pc.setPitParentClass(parentPitClass);
            parentPitClass.addToPitChildClasses(pc);
        }
        pc.setDatePattern(this.datePatterns.get(this.getRequiredLongAttribute(classElement, PointInTimeDataExport.sDatePatternUniqueIdAttribute, PointInTimeDataExport.sClassElementName)));
        Long timePatternId = this.getOptionalLongAttribute(classElement, PointInTimeDataExport.sTimePatternUniqueIdAttribute);
        if (timePatternId != null) {
            pc.setTimePattern(this.timePatterns.get(timePatternId));
        }
        pc.setManagingDept(this.departments.get(this.getRequiredLongAttribute(classElement, PointInTimeDataExport.sManagingDepartmentUniqueIdAttribute, PointInTimeDataExport.sClassElementName)));
        pc.setFundingDept(this.departments.get(this.getRequiredLongAttribute(classElement, PointInTimeDataExport.sFundingDepartmentUniqueIdAttribute, PointInTimeDataExport.sClassElementName)));
        String classSuffix = this.getOptionalStringAttribute(classElement, PointInTimeDataExport.sClassSuffixAttribute);
        if (classSuffix != null) {
            pc.setClassSuffix(classSuffix);
        }
        pc.setSectionNumber(this.getRequiredIntegerAttribute(classElement, PointInTimeDataExport.sSectionNumberAttribute, PointInTimeDataExport.sClassElementName));
        pc.setEnabledForStudentScheduling(this.getOptionalBooleanAttribute(classElement, PointInTimeDataExport.sStudentSchedulingAttribute, true));
        String limitStr = this.getOptionalStringAttribute(classElement, PointInTimeDataExport.sLimitAttribute);
        if (limitStr != null && !limitStr.equalsIgnoreCase("inf")) {
            pc.setLimit(Integer.parseInt(limitStr));
        }
        if ((numberOfRooms = this.getOptionalIntegerAttribute(classElement, PointInTimeDataExport.sNumberOfRoomsAttribute)) != null) {
            pc.setNbrRooms(numberOfRooms);
        }
        if ((uidRollFwdFrm = this.getOptionalLongAttribute(classElement, PointInTimeDataExport.sUniqueIdRolledForwardFromAttribute)) != null) {
            pc.setUniqueIdRolledForwardFrom(uidRollFwdFrm);
        }
        if ((externalId = this.getOptionalStringAttribute(classElement, PointInTimeDataExport.sExternalIdAttribute)) != null) {
            pc.setExternalUniqueId(externalId);
        }
        this.getHibSession().persist((Object)pc);
        this.pitClasses.put(uid, pc);
        Iterator classInstructorElementIt = classElement.elementIterator(PointInTimeDataExport.sClassInstructorElementName);
        while (classInstructorElementIt.hasNext()) {
            Element classInstructorElement = (Element)classInstructorElementIt.next();
            this.elementClassInstructor(classInstructorElement, pc);
        }
        this.updateNormalizedPercentShare(pc);
        Iterator classEventElementIt = classElement.elementIterator(PointInTimeDataExport.sClassEventElementName);
        while (classEventElementIt.hasNext()) {
            Element classEventElement = (Element)classEventElementIt.next();
            this.elementClassEvent(classEventElement, pc);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void updateNormalizedPercentShare(PitClass pc) {
        ArrayList<PitClassInstructor> ciList = new ArrayList<PitClassInstructor>();
        if (pc.getPitClassInstructors() == null || pc.getPitClassInstructors().isEmpty()) {
            return;
        }
        for (PitClassInstructor pitClassInstructor : pc.getPitClassInstructors()) {
            if (pitClassInstructor.getResponsibility() != null && pitClassInstructor.getResponsibility().hasOption(TeachingResponsibility.Option.auxiliary) || pitClassInstructor.getPercentShare() <= 0) continue;
            ciList.add(pitClassInstructor);
        }
        if (ciList.size() == 0) {
            return;
        }
        if (ciList.size() == 1) {
            ((PitClassInstructor)ciList.get(0)).setNormalizedPercentShare(100);
        } else {
            void var4_8;
            int totalShare = 0;
            for (Object pci : ciList) {
                if (((BasePitClassInstructor)pci).getPercentShare() == null) continue;
                totalShare += ((BasePitClassInstructor)pci).getPercentShare().intValue();
            }
            boolean bl = false;
            for (PitClassInstructor pitClassInstructor : ciList) {
                if (pitClassInstructor.getPercentShare() == null) continue;
                pitClassInstructor.setNormalizedPercentShare(100 * pitClassInstructor.getPercentShare() / totalShare);
                var4_8 += pitClassInstructor.getNormalizedPercentShare().intValue();
            }
            if (var4_8 != 100) {
                void var6_13;
                int difference = 100 - var4_8;
                boolean bl2 = false;
                int numToAddToAll = difference / ciList.size();
                int remainderToSpreadUntilGone = difference % ciList.size();
                for (PitClassInstructor pitClassInstructor : ciList) {
                    if (pitClassInstructor.getPercentShare() == null) continue;
                    pitClassInstructor.setNormalizedPercentShare(pitClassInstructor.getNormalizedPercentShare() + numToAddToAll + (remainderToSpreadUntilGone > 0 ? 1 : (remainderToSpreadUntilGone < 0 ? -1 : 0)));
                    var6_13 += pitClassInstructor.getNormalizedPercentShare().intValue();
                    remainderToSpreadUntilGone += remainderToSpreadUntilGone > 0 ? -1 : (remainderToSpreadUntilGone < 0 ? 1 : 0);
                }
                if (var6_13 != 100) {
                    Debug.info(pc.getUniqueId().toString() + ":  Normalized percent share for class instructors does not equal 100:  " + (int)var6_13);
                }
            }
        }
    }

    private void elementClassEvent(Element classEventElement, PitClass pc) throws Exception {
        PitClassEvent pce = new PitClassEvent();
        pce.setPitClass(pc);
        pc.addToPitClassEvents(pce);
        pce.setEventName(this.getRequiredStringAttribute(classEventElement, PointInTimeDataExport.sNameAttribute, PointInTimeDataExport.sClassEventElementName));
        this.getHibSession().persist((Object)pce);
        for (Element classMeetingElement : classEventElement.elements()) {
            this.elementClassMeeting(classMeetingElement, pce);
        }
    }

    private void elementClassMeeting(Element classMeetingElement, PitClassEvent pce) throws Exception {
        Integer stopOffset;
        PitClassMeeting pcm = new PitClassMeeting();
        pcm.setPitClassEvent(pce);
        pce.addToPitClassMeetings(pcm);
        pcm.setMeetingDate(CalendarUtils.getDate(this.getRequiredStringAttribute(classMeetingElement, PointInTimeDataExport.sMeetingDateAttribute, PointInTimeDataExport.sClassMeetingElementName), this.dateFormat));
        pcm.setStartPeriod(this.getRequiredIntegerAttribute(classMeetingElement, PointInTimeDataExport.sStartPeriodAttribute, PointInTimeDataExport.sClassMeetingElementName));
        pcm.setStopPeriod(this.getRequiredIntegerAttribute(classMeetingElement, PointInTimeDataExport.sStopPeriodAttribute, PointInTimeDataExport.sClassMeetingElementName));
        Integer startOffset = this.getOptionalIntegerAttribute(classMeetingElement, PointInTimeDataExport.sStartOffsetAttribute);
        if (startOffset != null) {
            pcm.setStartOffset(startOffset);
        }
        if ((stopOffset = this.getOptionalIntegerAttribute(classMeetingElement, PointInTimeDataExport.sStopOffsetAttribute)) != null) {
            pcm.setStopOffset(stopOffset);
        }
        Location loc = this.locations.get(this.getRequiredLongAttribute(classMeetingElement, PointInTimeDataExport.sLocationUniqueIdAttribute, PointInTimeDataExport.sClassMeetingElementName));
        pcm.setLocationPermanentId(loc.getPermanentId());
        pcm.setTimePatternMinPerMtg(this.getRequiredIntegerAttribute(classMeetingElement, PointInTimeDataExport.sTimePatternMinutesPerMeetingAttribute, PointInTimeDataExport.sClassMeetingElementName));
        pcm.setCalculatedMinPerMtg(this.getRequiredIntegerAttribute(classMeetingElement, PointInTimeDataExport.sCalculatedMinutesPerMeetingAttribute, PointInTimeDataExport.sClassMeetingElementName));
        this.getHibSession().persist((Object)pcm);
        for (Element classMeetingUtilPeriodElement : classMeetingElement.elements()) {
            this.elementClassMeetingUtilPeriod(classMeetingUtilPeriodElement, pcm);
        }
    }

    private void elementClassMeetingUtilPeriod(Element classMeetingUtilPeriodElement, PitClassMeeting pitClassMeeting) throws Exception {
        PitClassMeetingUtilPeriod pcmup = new PitClassMeetingUtilPeriod();
        pcmup.setTimeSlot(this.getRequiredIntegerAttribute(classMeetingUtilPeriodElement, PointInTimeDataExport.sPeriodAttribute, PointInTimeDataExport.sClassMeetingUtilPeriodElementName));
        pcmup.setPitClassMeeting(pitClassMeeting);
        pitClassMeeting.addToPitClassMeetingUtilPeriods(pcmup);
        this.getHibSession().persist((Object)pcmup);
    }

    private void elementSubpart(Element subpartElement, PitInstrOfferingConfig pitInstructionalOfferingConfig, PitSchedulingSubpart parentPitSubpart) throws Exception {
        if (PointInTimeDataExport.sSubpartElementName.equals(subpartElement.getName())) {
            Long uidRollFwdFrm;
            String creditStr;
            Long creditUnitTypeStr;
            PitSchedulingSubpart pss = new PitSchedulingSubpart();
            SchedulingSubpart ss = this.schedulingSubparts.get(this.getRequiredLongAttribute(subpartElement, PointInTimeDataExport.sUniqueIdAttribute, PointInTimeDataExport.sSubpartElementName));
            if (ss != null) {
                pss.setSchedulingSubpart(ss);
            }
            if (parentPitSubpart != null) {
                pss.setPitParentSubpart(parentPitSubpart);
                parentPitSubpart.addToPitChildSubparts(pss);
            }
            pss.setPitInstrOfferingConfig(pitInstructionalOfferingConfig);
            pitInstructionalOfferingConfig.addToSchedulingSubparts(pss);
            pss.setMinutesPerWk(this.getRequiredIntegerAttribute(subpartElement, PointInTimeDataExport.sMinPerWeekAttribute, PointInTimeDataExport.sSubpartElementName));
            pss.setSchedulingSubpartSuffixCache(this.getRequiredStringAttribute(subpartElement, PointInTimeDataExport.sSuffixAttribute, PointInTimeDataExport.sSubpartElementName));
            pss.setItype(this.itypes.get(this.getRequiredStringAttribute(subpartElement, PointInTimeDataExport.sTypeAttribute, PointInTimeDataExport.sSubpartElementName)));
            pss.setStudentAllowOverlap(this.getRequiredBooleanAttribute(subpartElement, PointInTimeDataExport.sStudentAllowOverlapAttribute, PointInTimeDataExport.sSubpartElementName));
            Long creditTypeStr = this.getOptionalLongAttribute(subpartElement, PointInTimeDataExport.sCreditTypeAttribute);
            if (creditTypeStr != null) {
                pss.setCreditType(this.creditTypes.get(creditTypeStr));
            }
            if ((creditUnitTypeStr = this.getOptionalLongAttribute(subpartElement, PointInTimeDataExport.sCreditUnitTypeAttribute)) != null) {
                pss.setCreditUnitType(this.creditUnitTypes.get(creditUnitTypeStr));
            }
            if ((creditStr = this.getOptionalStringAttribute(subpartElement, PointInTimeDataExport.sCreditAttribute)) != null) {
                pss.setCredit(Float.valueOf(Float.parseFloat(creditStr)));
            }
            if ((uidRollFwdFrm = this.getOptionalLongAttribute(subpartElement, PointInTimeDataExport.sUniqueIdRolledForwardFromAttribute)) != null) {
                pss.setUniqueIdRolledForwardFrom(uidRollFwdFrm);
            }
            this.getHibSession().persist((Object)pss);
            Iterator classElementIterator = subpartElement.elementIterator(PointInTimeDataExport.sClassElementName);
            while (classElementIterator.hasNext()) {
                Element classElement = (Element)classElementIterator.next();
                this.elementClass(classElement, pss);
            }
            Iterator childSubpartElementIterator = subpartElement.elementIterator(PointInTimeDataExport.sSubpartElementName);
            while (childSubpartElementIterator.hasNext()) {
                Element childSubpartElement = (Element)childSubpartElementIterator.next();
                this.elementSubpart(childSubpartElement, pitInstructionalOfferingConfig, pss);
            }
        }
    }

    private void loadExistingSubjectAreas(Long sessionId) {
        List subjects = this.getHibSession().createQuery("select distinct sa from SubjectArea as sa where sa.session.uniqueId=:sessionId", SubjectArea.class).setParameter("sessionId", (Object)sessionId).setCacheable(true).list();
        for (SubjectArea sa : subjects) {
            this.subjectAreas.put(sa.getSubjectAreaAbbreviation(), sa);
        }
    }

    private void loadDepartmentalInstructors(Long sessionId) {
        for (DepartmentalInstructor di : this.getHibSession().createQuery("select distinct di from DepartmentalInstructor as di where di.department.session.uniqueId=:sessionId", DepartmentalInstructor.class).setParameter("sessionId", (Object)sessionId).setCacheable(true).list()) {
            this.departmentalInstructorsByName.put((di.getLastName() == null ? "" : di.getLastName()) + (di.getFirstName() == null ? "" : di.getFirstName()) + (di.getMiddleName() == null ? "" : di.getMiddleName()) + (di.getExternalUniqueId() == null ? "" : di.getExternalUniqueId()), di);
        }
    }

    private void loadExistingDepartments(Long sessionId) {
        for (Department department : this.getHibSession().createQuery("select distinct d from Department as d where d.session.uniqueId=:sessionId", Department.class).setParameter("sessionId", (Object)sessionId).setCacheable(true).list()) {
            this.departmentsByCode.put(department.getDeptCode(), department);
        }
    }

    private void loadExistingMinors(Long sessionId) {
        for (PosMinor minor : this.getHibSession().createQuery("select distinct m from PosMinor as m where m.session.uniqueId=:sessionId", PosMinor.class).setParameter("sessionId", (Object)sessionId).setCacheable(true).list()) {
            this.minorsByCode.put(minor.getCode(), minor);
        }
    }

    private void loadExistingMajors(Long sessionId) {
        for (PosMajor major : this.getHibSession().createQuery("select distinct m from PosMajor as m where m.session.uniqueId=:sessionId", PosMajor.class).setParameter("sessionId", (Object)sessionId).setCacheable(true).list()) {
            this.majorsByCode.put(major.getCode(), major);
            for (PosMajorConcentration conc : major.getConcentrations()) {
                this.concentrationsByCode.put(major.getCode() + "/" + conc.getCode(), conc);
            }
        }
    }

    private void loadExistingAcademicClassifications(Long sessionId) {
        for (AcademicClassification ac : this.getHibSession().createQuery("select distinct ac from AcademicClassification as ac where ac.session.uniqueId=:sessionId", AcademicClassification.class).setParameter("sessionId", (Object)sessionId).setCacheable(true).list()) {
            this.academicClassificationsByCode.put(ac.getCode(), ac);
        }
    }

    private void loadExistingAcademicAreas(Long sessionId) {
        for (AcademicArea aa : this.getHibSession().createQuery("select distinct ac from AcademicArea as ac where ac.session.uniqueId=:sessionId", AcademicArea.class).setParameter("sessionId", (Object)sessionId).setCacheable(true).list()) {
            this.academicAreasByAbbv.put(aa.getAcademicAreaAbbreviation(), aa);
        }
    }

    private void loadItypes() {
        TreeSet<ItypeDesc> itypeDescs = ItypeDesc.findAll(false);
        for (ItypeDesc itype : itypeDescs) {
            this.itypes.put(itype.getAbbv().trim(), itype);
        }
    }

    private void loadExistingInstructionalOfferings(Long sessionId) throws Exception {
        for (InstructionalOffering io : InstructionalOffering.findAll(sessionId)) {
            this.instructionalOfferings.put(io.getUniqueId(), io);
        }
    }

    private void loadExistingCourseOfferings(Long sessionId) throws Exception {
        for (CourseOffering courseOffering : CourseOffering.findAll(sessionId)) {
            this.courseOfferings.put(courseOffering.getUniqueId(), courseOffering);
        }
    }

    private void loadExistingInstrOfferingConfigs(Long sessionId) throws Exception {
        String qs = "from InstrOfferingConfig ioc where ioc.instructionalOffering.session.uniqueId = :sessionId";
        for (InstrOfferingConfig instrOfferingConfig : this.getHibSession().createQuery(qs, InstrOfferingConfig.class).setParameter("sessionId", (Object)sessionId).list()) {
            this.instrOfferingConfigs.put(instrOfferingConfig.getUniqueId(), instrOfferingConfig);
        }
    }

    private void loadExistingSchedulingSubparts(Long sessionId) throws Exception {
        String qs = "from SchedulingSubpart ss where ss.instrOfferingConfig.instructionalOffering.session.uniqueId = :sessionId";
        for (SchedulingSubpart schedulingSubpart : this.getHibSession().createQuery(qs, SchedulingSubpart.class).setParameter("sessionId", (Object)sessionId).list()) {
            this.schedulingSubparts.put(schedulingSubpart.getUniqueId(), schedulingSubpart);
        }
    }

    private void loadExistingClasses(Long sessionId) throws Exception {
        for (Class_ c : Class_.findAll(sessionId)) {
            this.classes.put(c.getUniqueId(), c);
        }
    }

    @Override
    protected String getEmailSubject() {
        return "Point In Time Data Import Results - " + this.session.getAcademicYearTerm();
    }

    protected static boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    public Integer str2Slot(String timeString, Integer printOffset) throws Exception {
        int slot = -1;
        try {
            Date date = CalendarUtils.getDate(timeString, this.timeFormat);
            SimpleDateFormat df = new SimpleDateFormat("HHmm");
            int time = Integer.parseInt(df.format(date));
            if (printOffset != null) {
                time -= printOffset.intValue();
            }
            int hour = time / 100;
            int min = time % 100;
            if (hour >= 24) {
                throw new Exception("Invalid time '" + timeString + "' -- hour (" + hour + ") must be between 0 and 23.");
            }
            if (min >= 60) {
                throw new Exception("Invalid time '" + timeString + "' -- minute (" + min + ") must be between 0 and 59.");
            }
            if (min % Constants.SLOT_LENGTH_MIN != 0) {
                min -= min % Constants.SLOT_LENGTH_MIN;
            }
            slot = (hour * 60 + min - Constants.FIRST_SLOT_TIME_MIN) / Constants.SLOT_LENGTH_MIN;
        }
        catch (NumberFormatException ex) {
            throw new Exception("Invalid time '" + timeString + "' -- not a number.");
        }
        if (slot < 0) {
            throw new Exception("Invalid time '" + timeString + "', did not meet format: " + this.timeFormat);
        }
        return slot;
    }
}

