/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.reservation;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Offering;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.Subpart;

public abstract class Restriction {
    private long iId = 0L;
    private Offering iOffering;
    private Set<Config> iConfigs = new HashSet<Config>();
    private Map<Subpart, Set<Section>> iSections = new HashMap<Subpart, Set<Section>>();

    public Restriction(long id, Offering offering) {
        this.iId = id;
        this.iOffering = offering;
        this.iOffering.getRestrictions().add(this);
        this.iOffering.clearRestrictionCache();
    }

    public long getId() {
        return this.iId;
    }

    public abstract boolean isApplicable(Student var1, Course var2);

    @Deprecated
    public boolean isApplicable(Student student) {
        if (this.isApplicable(student, null)) {
            return true;
        }
        for (Request r : student.getRequests()) {
            if (!(r instanceof CourseRequest)) continue;
            for (Course course : ((CourseRequest)r).getCourses()) {
                if (!course.getOffering().equals(this.getOffering()) || !this.isApplicable(student, course)) continue;
                return true;
            }
        }
        return false;
    }

    public Offering getOffering() {
        return this.iOffering;
    }

    public Set<Config> getConfigs() {
        return this.iConfigs;
    }

    public void addConfig(Config config) {
        this.iConfigs.add(config);
    }

    public Map<Subpart, Set<Section>> getSections() {
        return this.iSections;
    }

    public Set<Section> getSections(Subpart subpart) {
        return this.iSections.get(subpart);
    }

    public void addSection(Section section) {
        this.addConfig(section.getSubpart().getConfig());
        while (section != null) {
            Set<Section> sections = this.iSections.get(section.getSubpart());
            if (sections == null) {
                sections = new HashSet<Section>();
                this.iSections.put(section.getSubpart(), sections);
            }
            sections.add(section);
            section = section.getParent();
        }
    }

    public boolean isIncluded(Enrollment enrollment) {
        if (enrollment.getConfig() == null) {
            return false;
        }
        if (!this.iOffering.equals(enrollment.getConfig().getOffering())) {
            return false;
        }
        if (this.iConfigs.isEmpty() && this.iSections.isEmpty()) {
            return false;
        }
        if (!this.iConfigs.isEmpty() && !this.iConfigs.contains(enrollment.getConfig())) {
            return false;
        }
        for (Section section : enrollment.getSections()) {
            Set<Section> sections = this.iSections.get(section.getSubpart());
            if (sections == null || sections.contains(section)) continue;
            return false;
        }
        return true;
    }

    public boolean isIncluded(Config config) {
        if (!this.iOffering.equals(config.getOffering())) {
            return false;
        }
        if (this.iConfigs.isEmpty() && this.iSections.isEmpty()) {
            return false;
        }
        return this.iConfigs.isEmpty() || this.iConfigs.contains(config);
    }

    public boolean isIncluded(Section section) {
        if (!this.iOffering.equals(section.getSubpart().getConfig().getOffering())) {
            return false;
        }
        if (this.iConfigs.isEmpty() && this.iSections.isEmpty()) {
            return false;
        }
        if (!this.iConfigs.isEmpty() && !this.iConfigs.contains(section.getSubpart().getConfig())) {
            return false;
        }
        Set<Section> sections = this.iSections.get(section.getSubpart());
        return sections == null || sections.contains(section);
    }
}

