/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.script;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.hibernate.Session;
import org.springframework.security.access.prepost.PreAuthorize;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.ScriptInterface;
import org.unitime.timetable.model.Script;
import org.unitime.timetable.model.ScriptParameter;
import org.unitime.timetable.model.dao.ScriptDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.server.script.LoadAllScriptsBackend;

@GwtRpcImplements(value=ScriptInterface.SaveOrUpdateScriptRpcRequest.class)
public class SaveOrUpdateScriptBackend
implements GwtRpcImplementation<ScriptInterface.SaveOrUpdateScriptRpcRequest, ScriptInterface> {
    @Override
    @PreAuthorize(value="checkPermission('ScriptEdit')")
    public ScriptInterface execute(ScriptInterface.SaveOrUpdateScriptRpcRequest request, SessionContext context) {
        Session hibSession = ScriptDAO.getInstance().getSession();
        Long scriptId = request.getScript().getId();
        Script script = null;
        if (request.getScript().getId() == null) {
            script = new Script();
            script.setParameters(new HashSet<ScriptParameter>());
        } else {
            script = (Script)ScriptDAO.getInstance().get(scriptId, hibSession);
        }
        script.setName(request.getScript().getName());
        script.setDescription(request.getScript().getDescription());
        script.setPermission(request.getScript().getPermission());
        script.setEngine(request.getScript().getEngine());
        script.setScript(request.getScript().getScript());
        if (request.getScript().hasParameters()) {
            HashMap<String, ScriptParameter> params = new HashMap<String, ScriptParameter>();
            for (ScriptParameter parameter : script.getParameters()) {
                params.put(parameter.getName(), parameter);
            }
            for (ScriptInterface.ScriptParameterInterface p : request.getScript().getParameters()) {
                ScriptParameter parameter = (ScriptParameter)params.remove(p.getName());
                if (parameter == null) {
                    parameter = new ScriptParameter();
                    parameter.setName(p.getName());
                    parameter.setScript(script);
                    script.getParameters().add(parameter);
                }
                parameter.setType(p.getType());
                parameter.setLabel(p.getLabel());
                parameter.setDefaultValue(p.getDefaultValue());
            }
            for (ScriptParameter parameter : params.values()) {
                hibSession.remove((Object)parameter);
                script.getParameters().remove(parameter);
            }
        } else {
            Iterator<ScriptParameter> i = script.getParameters().iterator();
            while (i.hasNext()) {
                hibSession.remove((Object)i.next());
                i.remove();
            }
        }
        if (script.getUniqueId() == null) {
            hibSession.persist((Object)script);
        } else {
            hibSession.merge((Object)script);
        }
        hibSession.flush();
        return LoadAllScriptsBackend.load(script, context);
    }
}

