/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.Column;
import jakarta.persistence.Id;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import org.unitime.commons.annotations.UniqueIdGenerator;
import org.unitime.timetable.model.PreferenceLevel;

@MappedSuperclass
public abstract class BasePreferenceLevel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long iUniqueId;
    private Integer iPrefId;
    private String iPrefProlog;
    private String iPrefName;
    private String iPrefAbbv;

    public BasePreferenceLevel() {
    }

    public BasePreferenceLevel(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @Id
    @UniqueIdGenerator(sequence="pref_level_seq")
    @Column(name="uniqueid")
    public Long getUniqueId() {
        return this.iUniqueId;
    }

    public void setUniqueId(Long uniqueId) {
        this.iUniqueId = uniqueId;
    }

    @Column(name="pref_id", nullable=false, length=2)
    public Integer getPrefId() {
        return this.iPrefId;
    }

    public void setPrefId(Integer prefId) {
        this.iPrefId = prefId;
    }

    @Column(name="pref_prolog", nullable=true, length=2)
    public String getPrefProlog() {
        return this.iPrefProlog;
    }

    public void setPrefProlog(String prefProlog) {
        this.iPrefProlog = prefProlog;
    }

    @Column(name="pref_name", nullable=true, length=20)
    public String getPrefName() {
        return this.iPrefName;
    }

    public void setPrefName(String prefName) {
        this.iPrefName = prefName;
    }

    @Column(name="pref_abbv", nullable=true, length=10)
    public String getPrefAbbv() {
        return this.iPrefAbbv;
    }

    public void setPrefAbbv(String prefAbbv) {
        this.iPrefAbbv = prefAbbv;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof PreferenceLevel)) {
            return false;
        }
        if (this.getUniqueId() == null || ((PreferenceLevel)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((PreferenceLevel)o).getUniqueId());
    }

    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    public String toString() {
        return "PreferenceLevel[" + this.getUniqueId() + "]";
    }

    public String toDebugString() {
        return "PreferenceLevel[\n\tPrefAbbv: " + this.getPrefAbbv() + "\n\tPrefId: " + this.getPrefId() + "\n\tPrefName: " + this.getPrefName() + "\n\tPrefProlog: " + this.getPrefProlog() + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

