/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.timetable.model.base.BaseTeachingClassRequest;
import org.unitime.timetable.model.comparators.ClassComparator;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(name="teachreq_class")
public class TeachingClassRequest
extends BaseTeachingClassRequest
implements Comparable<TeachingClassRequest> {
    private static final long serialVersionUID = 1L;

    protected boolean isParentOf(TeachingClassRequest r) {
        return this.getTeachingClass().isParentOf(r.getTeachingClass());
    }

    @Override
    public int compareTo(TeachingClassRequest o) {
        ClassComparator cmp = new ClassComparator(5);
        return cmp.compare(this.getTeachingClass(), o.getTeachingClass());
    }

    @Override
    public String toString() {
        return this.getTeachingClass().getItypeDesc().trim() + " " + this.getTeachingClass().getSectionNumberString();
    }
}

