/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.commons;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import org.apache.commons.logging.LogFactory;
import org.unitime.commons.ToolBox;

public class Debug {
    private static NumberFormat sNumberFormat = new DecimalFormat("###,#00.00", new DecimalFormatSymbols(Locale.US));

    public static synchronized void error(Throwable e) {
        LogFactory.getLog((String)Debug.getSource(e)).error((Object)e.getMessage(), e);
    }

    public static synchronized void fatal(String message) {
        LogFactory.getLog((String)ToolBox.getCaller()).fatal((Object)message);
    }

    public static synchronized void error(String message) {
        LogFactory.getLog((String)ToolBox.getCaller()).error((Object)message);
    }

    public static synchronized void error(String message, Throwable t) {
        LogFactory.getLog((String)ToolBox.getCaller()).error((Object)message, t);
    }

    public static synchronized void warning(String message) {
        LogFactory.getLog((String)ToolBox.getCaller()).warn((Object)message);
    }

    public static synchronized void info(String message) {
        LogFactory.getLog((String)ToolBox.getCaller()).info((Object)message);
    }

    public static synchronized void debug(String message) {
        LogFactory.getLog((String)ToolBox.getCaller()).debug((Object)message);
    }

    public static synchronized void log(String message) {
        if (message != null) {
            if (message.startsWith("ERROR:")) {
                LogFactory.getLog((String)ToolBox.getCaller()).error((Object)message.substring("ERROR:".length()).trim());
                return;
            }
            if (message.startsWith("WARNING:")) {
                LogFactory.getLog((String)ToolBox.getCaller()).warn((Object)message.substring("WARNING:".length()).trim());
                return;
            }
            if (message.startsWith("INFO:")) {
                LogFactory.getLog((String)ToolBox.getCaller()).info((Object)message.substring("INFO:".length()).trim());
                return;
            }
        }
        LogFactory.getLog((String)ToolBox.getCaller()).debug((Object)message);
    }

    public static synchronized void log(int depth, String message) {
        if (message != null) {
            if (message.startsWith("ERROR:")) {
                LogFactory.getLog((String)ToolBox.getCaller(4 + depth)).error((Object)message.substring("ERROR:".length()).trim());
                return;
            }
            if (message.startsWith("WARNING:")) {
                LogFactory.getLog((String)ToolBox.getCaller(4 + depth)).warn((Object)message.substring("WARNING:".length()).trim());
                return;
            }
            if (message.startsWith("INFO:")) {
                LogFactory.getLog((String)ToolBox.getCaller(4 + depth)).info((Object)message.substring("INFO:".length()).trim());
                return;
            }
        }
        LogFactory.getLog((String)ToolBox.getCaller(4 + depth)).debug((Object)message);
    }

    public static synchronized String getSource(Class source) {
        String name = source.getName();
        if (name != null && name.indexOf(46) > 0) {
            return name.substring(name.lastIndexOf(46) + 1);
        }
        return name;
    }

    public static synchronized String getSource(Object source) {
        if (source == null) {
            return "";
        }
        return Debug.getSource(source.getClass());
    }

    public static synchronized String getMem() {
        return sNumberFormat.format((double)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1048576.0) + "M ";
    }
}

