/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.example.csp;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.example.csp.CSPBinaryConstraint;
import org.cpsolver.ifs.example.csp.CSPValue;
import org.cpsolver.ifs.example.csp.CSPVariable;
import org.cpsolver.ifs.model.Constraint;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.util.DataProperties;

public class StructuredCSPModel
extends Model<CSPVariable, CSPValue> {
    private static Logger sLogger = LogManager.getLogger(StructuredCSPModel.class);
    private DataProperties iProperties = null;

    public StructuredCSPModel(DataProperties properties, long seed) {
        this.iProperties = properties;
        this.generate(seed);
    }

    private void swap(CSPVariable[][] allPairs, int first, int second) {
        CSPVariable[] a = allPairs[first];
        allPairs[first] = allPairs[second];
        allPairs[second] = a;
    }

    private void buildBinaryConstraintGraph(List<CSPVariable> variables, List<CSPBinaryConstraint> constraints, Random rnd) {
        int numberOfAllPairs = variables.size() * (variables.size() - 1) / 2;
        CSPVariable[][] allPairs = new CSPVariable[numberOfAllPairs][];
        int idx = 0;
        for (CSPVariable v1 : variables) {
            for (CSPVariable v2 : variables) {
                if (v1.getId() >= v2.getId()) continue;
                allPairs[idx++] = new CSPVariable[]{v1, v2};
            }
        }
        for (idx = 0; idx < constraints.size(); ++idx) {
            this.swap(allPairs, idx, idx + (int)(rnd.nextDouble() * (double)(numberOfAllPairs - idx)));
        }
        idx = 0;
        for (CSPBinaryConstraint c : constraints) {
            c.addVariable(allPairs[idx][0]);
            c.addVariable(allPairs[idx][1]);
            ++idx;
        }
    }

    private void buildBinaryConstraintGraph2(List<CSPVariable> variables, int numberOfAllPairs, List<CSPBinaryConstraint> constraints, Random rnd) {
        CSPVariable[][] allPairs = new CSPVariable[numberOfAllPairs][];
        int idx = 0;
        for (CSPVariable v1 : variables) {
            for (CSPVariable v2 : variables) {
                if (v1.getId() >= v2.getId() || v1.getKernelId() >= 0 && v1.getKernelId() == v2.getKernelId()) continue;
                allPairs[idx++] = new CSPVariable[]{v1, v2};
            }
        }
        for (idx = 0; idx < constraints.size(); ++idx) {
            this.swap(allPairs, idx, idx + (int)(rnd.nextDouble() * (double)(numberOfAllPairs - idx)));
        }
        idx = 0;
        for (CSPBinaryConstraint c : constraints) {
            c.addVariable(allPairs[idx][0]);
            c.addVariable(allPairs[idx][1]);
            ++idx;
        }
    }

    private void generate(long seed) {
        int k;
        int nrVariables = this.iProperties.getPropertyInt("CSP.NrVariables", 60);
        int nrValues = this.iProperties.getPropertyInt("CSP.DomainSize", 15);
        int nrKernels = this.iProperties.getPropertyInt("CSP.NrKernels", 2);
        int nrKernelVariables = this.iProperties.getPropertyInt("CSP.KernelSize", 8);
        int nrPairValues = nrValues * nrValues;
        float tightnessPerc = this.iProperties.getPropertyFloat("CSP.Tightness", 0.01f);
        float kernelTightnessPerc = this.iProperties.getPropertyFloat("CSP.KernelTightness", 0.097f);
        int nrCompatiblePairs = (int)Math.round((1.0 - (double)tightnessPerc) * (double)nrPairValues);
        int kernelNrCompatiblePairs = (int)Math.round((1.0 - (double)kernelTightnessPerc) * (double)nrPairValues);
        int nrPairVariables = nrVariables * (nrVariables - 1) / 2;
        int nrPairKernelVariables = nrKernelVariables * (nrKernelVariables - 1) / 2;
        float densityPerc = this.iProperties.getPropertyFloat("CSP.Density", 0.01f);
        float densityKernelPerc = this.iProperties.getPropertyFloat("CSP.KernelDensity", 0.097f);
        int density = Math.round(densityPerc * (float)(nrPairVariables -= nrKernels * nrPairKernelVariables));
        int kernelDensity = Math.round(densityKernelPerc * (float)nrPairKernelVariables);
        Random rnd = new Random(seed);
        ArrayList<CSPVariable> generalVariables = new ArrayList<CSPVariable>(nrVariables - nrKernels * nrKernelVariables);
        int varId = 1;
        for (int i = 0; i < nrVariables - nrKernels * nrKernelVariables; ++i) {
            CSPVariable var = new CSPVariable(varId++, nrValues);
            generalVariables.add(var);
            this.addVariable(var);
        }
        sLogger.debug("Created " + generalVariables.size() + " general variables.");
        ArrayList[] kernelVariables = new ArrayList[nrKernels];
        for (int k2 = 0; k2 < nrKernels; ++k2) {
            kernelVariables[k2] = new ArrayList(nrKernelVariables);
            for (int i = 0; i < nrKernelVariables; ++i) {
                CSPVariable var = new CSPVariable(varId++, nrValues, k2);
                kernelVariables[k2].add(var);
                this.addVariable(var);
            }
            if (k2 != 0) continue;
            sLogger.debug("Created " + kernelVariables[0].size() + " kernel variables (per kernel).");
        }
        sLogger.debug("Created " + this.variables().size() + " variables at total.");
        int constId = 1;
        ArrayList<CSPBinaryConstraint> generalConstraints = new ArrayList<CSPBinaryConstraint>(density);
        for (int i = 0; i < density; ++i) {
            CSPBinaryConstraint c = new CSPBinaryConstraint(constId++, nrCompatiblePairs);
            generalConstraints.add(c);
            this.addConstraint(c);
        }
        sLogger.debug("Created " + generalConstraints.size() + " general constraints (tightness=" + tightnessPerc + ").");
        List[] kernelConstraints = new List[nrKernels];
        for (k = 0; k < nrKernels; ++k) {
            kernelConstraints[k] = new ArrayList(kernelDensity);
            for (int i = 0; i < kernelDensity; ++i) {
                CSPBinaryConstraint c = new CSPBinaryConstraint(constId++, kernelNrCompatiblePairs);
                kernelConstraints[k].add(c);
                this.addConstraint(c);
            }
            if (k != 0) continue;
            sLogger.debug("Created " + kernelConstraints[0].size() + " kernel constraints (per kernel, tightness=" + kernelTightnessPerc + ").");
        }
        sLogger.debug("Created " + this.constraints().size() + " constraints at total.");
        for (k = 0; k < nrKernels; ++k) {
            this.buildBinaryConstraintGraph(kernelVariables[k], kernelConstraints[k], rnd);
        }
        this.buildBinaryConstraintGraph2(this.variables(), nrPairVariables, generalConstraints, rnd);
        for (Constraint c : this.constraints()) {
            CSPBinaryConstraint constraint = (CSPBinaryConstraint)c;
            constraint.init(rnd);
        }
        if (this.iProperties.getPropertyBoolean("General.MPP", false)) {
            for (CSPVariable variable : this.variables()) {
                variable.generateInitialValue(rnd);
            }
        }
    }

    @Override
    public Map<String, String> getInfo(Assignment<CSPVariable, CSPValue> assignment) {
        Map<String, String> ret = super.getInfo(assignment);
        ret.put("Solution value", String.valueOf(this.getTotalValue(assignment)));
        return ret;
    }
}

