/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.profile;

import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.hibernate.Internal;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.profile.Association;
import org.hibernate.engine.profile.Fetch;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.BagType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.Type;

public class FetchProfile {
    private static final @UnknownKeyFor @NonNull @Initialized CoreMessageLogger LOG = CoreLogging.messageLogger(FetchProfile.class);
    private final @UnknownKeyFor @NonNull @Initialized String name;
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Fetch> fetches = new HashMap<String, Fetch>();
    private @UnknownKeyFor @NonNull @Initialized boolean containsJoinFetchedCollection;
    private @UnknownKeyFor @NonNull @Initialized boolean containsJoinFetchedBag;
    private @Nullable @UnknownKeyFor @Initialized Fetch bagJoinFetch;

    public FetchProfile(@UnknownKeyFor @NonNull @Initialized String name) {
        this.name = name;
    }

    @Deprecated(forRemoval=true)
    public void addFetch(@UnknownKeyFor @NonNull @Initialized Association association, @UnknownKeyFor @NonNull @Initialized String fetchStyleName) {
        this.addFetch(new Fetch(association, Fetch.Style.parse(fetchStyleName)));
    }

    @Deprecated(forRemoval=true)
    public void addFetch(@UnknownKeyFor @NonNull @Initialized Association association, @UnknownKeyFor @NonNull @Initialized Fetch.Style style) {
        this.addFetch(new Fetch(association, style));
    }

    @Internal
    public void addFetch(@UnknownKeyFor @NonNull @Initialized Fetch fetch) {
        Association association = fetch.getAssociation();
        String role = association.getRole();
        Type associationType = association.getOwner().getPropertyType(association.getAssociationPath());
        if (associationType instanceof CollectionType) {
            LOG.tracev("Handling request to add collection fetch [{0}]", role);
            if (fetch.getMethod() == FetchStyle.JOIN) {
                if (associationType instanceof BagType && this.containsJoinFetchedCollection) {
                    LOG.containsJoinFetchedCollection(role);
                    return;
                }
                if (this.containsJoinFetchedBag) {
                    if (this.bagJoinFetch != null && this.fetches.remove(this.bagJoinFetch.getAssociation().getRole()) != this.bagJoinFetch) {
                        LOG.unableToRemoveBagJoinFetch();
                    }
                    this.bagJoinFetch = null;
                    this.containsJoinFetchedBag = false;
                }
                this.containsJoinFetchedCollection = true;
            }
        }
        this.fetches.put(role, fetch);
    }

    public @UnknownKeyFor @NonNull @Initialized String getName() {
        return this.name;
    }

    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Fetch> getFetches() {
        return this.fetches;
    }

    public @Nullable @UnknownKeyFor @Initialized Fetch getFetchByRole(@UnknownKeyFor @NonNull @Initialized String role) {
        return this.fetches.get(role);
    }

    @Deprecated(forRemoval=true)
    public @UnknownKeyFor @NonNull @Initialized boolean isContainsJoinFetchedCollection() {
        return this.containsJoinFetchedCollection;
    }

    @Deprecated(forRemoval=true)
    public @UnknownKeyFor @NonNull @Initialized boolean isContainsJoinFetchedBag() {
        return this.containsJoinFetchedBag;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "FetchProfile[" + this.name + "]";
    }

    public @UnknownKeyFor @NonNull @Initialized boolean hasSubselectLoadableCollectionsEnabled(@UnknownKeyFor @NonNull @Initialized EntityPersister persister) {
        for (Fetch fetch : this.getFetches().values()) {
            if (fetch.getMethod() != FetchStyle.SUBSELECT || fetch.getAssociation().getOwner() != persister) continue;
            return true;
        }
        return false;
    }
}

