/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.instructor.criteria;

import java.util.Collection;
import java.util.Set;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.criteria.AbstractCriterion;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.instructor.constraints.GroupConstraint;
import org.cpsolver.instructor.criteria.InstructorSchedulingCriterion;
import org.cpsolver.instructor.model.Instructor;
import org.cpsolver.instructor.model.InstructorSchedulingModel;
import org.cpsolver.instructor.model.TeachingAssignment;
import org.cpsolver.instructor.model.TeachingRequest;

public class Distributions
extends InstructorSchedulingCriterion {
    public Distributions() {
        this.setValueUpdateType(AbstractCriterion.ValueUpdateType.NoUpdate);
    }

    @Override
    public double getWeightDefault(DataProperties config) {
        return 1.0;
    }

    @Override
    public double getValue(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, TeachingAssignment value, Set<TeachingAssignment> conflicts) {
        double ret = 0.0;
        for (GroupConstraint.Distribution d : value.getInstructor().getDistributions()) {
            if (d.isHard()) continue;
            ret += (double)Math.abs(d.getPenalty()) * d.getType().getValue(d, assignment, value.getInstructor(), value);
        }
        return ret;
    }

    @Override
    public double getValue(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, Collection<TeachingRequest.Variable> variables) {
        double value = 0.0;
        for (Instructor instructor : this.getAssignedInstructors(assignment, variables)) {
            for (GroupConstraint.Distribution d : instructor.getDistributions()) {
                if (d.isHard()) continue;
                value += (double)Math.abs(d.getPenalty()) * d.getType().getValue(d, assignment, instructor, null);
            }
        }
        return value;
    }

    @Override
    protected double[] computeBounds(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment) {
        double[] bounds = new double[]{0.0, 0.0};
        for (Instructor instructor : ((InstructorSchedulingModel)this.getModel()).getInstructors()) {
            for (GroupConstraint.Distribution d : instructor.getDistributions()) {
                if (d.isHard()) continue;
                bounds[1] = bounds[1] + (double)Math.abs(d.getPenalty());
            }
        }
        return bounds;
    }

    @Override
    public double[] getBounds(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, Collection<TeachingRequest.Variable> variables) {
        double[] bounds = new double[]{0.0, 0.0};
        for (Instructor instructor : this.getInstructors(assignment, variables)) {
            for (GroupConstraint.Distribution d : instructor.getDistributions()) {
                if (d.isHard()) continue;
                bounds[1] = bounds[1] + (double)Math.abs(d.getPenalty());
            }
        }
        return bounds;
    }
}

