/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.header;

import java.io.IOException;
import org.restlet.data.CharacterSet;
import org.restlet.data.MediaType;
import org.restlet.data.Parameter;
import org.restlet.engine.header.ContentType;
import org.restlet.engine.header.HeaderReader;
import org.restlet.engine.header.HeaderUtils;
import org.restlet.util.Series;

public class ContentTypeReader
extends HeaderReader<ContentType> {
    public ContentTypeReader(String header) {
        super(header);
    }

    private ContentType createContentType(StringBuilder mediaType, Series<Parameter> parameters) {
        CharacterSet characterSet = null;
        if (parameters != null) {
            String charSet = parameters.getFirstValue("charset");
            if (charSet != null) {
                parameters.removeAll("charset");
                characterSet = new CharacterSet(charSet);
            }
            return new ContentType(new MediaType(mediaType.toString(), parameters), characterSet);
        }
        return new ContentType(new MediaType(mediaType.toString()), null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ContentType readValue() throws IOException {
        ContentType result = null;
        boolean readingMediaType = true;
        boolean readingParamName = false;
        boolean readingParamValue = false;
        StringBuilder mediaTypeBuffer = new StringBuilder();
        StringBuilder paramNameBuffer = null;
        StringBuilder paramValueBuffer = null;
        Series<Parameter> parameters = null;
        String nextValue = this.readRawValue();
        int nextIndex = 0;
        if (nextValue == null) return result;
        int nextChar = nextValue.charAt(nextIndex++);
        while (result == null) {
            if (readingMediaType) {
                if (nextChar == -1) {
                    if (mediaTypeBuffer.length() > 0) {
                        result = this.createContentType(mediaTypeBuffer, null);
                        paramNameBuffer = new StringBuilder();
                    }
                } else if (nextChar == 59) {
                    if (mediaTypeBuffer.length() <= 0) throw new IOException("Empty mediaType name detected.");
                    readingMediaType = false;
                    readingParamName = true;
                    paramNameBuffer = new StringBuilder();
                    parameters = new Series<Parameter>(Parameter.class);
                } else if (!HeaderUtils.isSpace(nextChar)) {
                    if (!HeaderUtils.isText(nextChar)) throw new IOException("The " + (char)nextChar + " character isn't allowed in a media type name.");
                    mediaTypeBuffer.append((char)nextChar);
                }
            } else if (readingParamName) {
                if (nextChar == 61) {
                    if (paramNameBuffer.length() <= 0) throw new IOException("Empty parameter name detected.");
                    readingParamName = false;
                    readingParamValue = true;
                    paramValueBuffer = new StringBuilder();
                } else if (nextChar == -1) {
                    if (paramNameBuffer.length() > 0) {
                        parameters.add(Parameter.create(paramNameBuffer, null));
                        result = this.createContentType(mediaTypeBuffer, parameters);
                    } else {
                        if (paramNameBuffer.length() != 0) throw new IOException("Empty parameter name detected.");
                        result = this.createContentType(mediaTypeBuffer, parameters);
                    }
                } else if (nextChar == 59) {
                    parameters.add(Parameter.create(paramNameBuffer, null));
                    paramNameBuffer = new StringBuilder();
                    readingParamName = true;
                    readingParamValue = false;
                } else if (!HeaderUtils.isSpace(nextChar) || paramNameBuffer.length() != 0) {
                    if (!HeaderUtils.isTokenChar(nextChar)) throw new IOException("The \"" + (char)nextChar + "\" character isn't allowed in a media type parameter name.");
                    paramNameBuffer.append((char)nextChar);
                }
            } else if (readingParamValue) {
                if (nextChar == -1) {
                    if (paramValueBuffer.length() <= 0) throw new IOException("Empty parameter value detected");
                    parameters.add(Parameter.create(paramNameBuffer, paramValueBuffer));
                    result = this.createContentType(mediaTypeBuffer, parameters);
                } else if (nextChar == 59) {
                    parameters.add(Parameter.create(paramNameBuffer, paramValueBuffer));
                    paramNameBuffer = new StringBuilder();
                    readingParamName = true;
                    readingParamValue = false;
                } else if (nextChar == 34 && paramValueBuffer.length() == 0) {
                    boolean done = false;
                    boolean quotedPair = false;
                    while (!done && nextChar != -1) {
                        int n = nextChar = nextIndex < nextValue.length() ? (int)nextValue.charAt(nextIndex++) : -1;
                        if (quotedPair) {
                            if (!HeaderUtils.isText(nextChar)) throw new IOException("Invalid character \"" + (char)nextChar + "\" detected in quoted string. Please check your value");
                            paramValueBuffer.append((char)nextChar);
                            quotedPair = false;
                            continue;
                        }
                        if (HeaderUtils.isDoubleQuote(nextChar)) {
                            done = true;
                            continue;
                        }
                        if (nextChar == 92) {
                            quotedPair = true;
                            continue;
                        }
                        if (!HeaderUtils.isText(nextChar)) throw new IOException("Invalid character \"" + (char)nextChar + "\" detected in quoted string. Please check your value");
                        paramValueBuffer.append((char)nextChar);
                    }
                } else {
                    if (!HeaderUtils.isTokenChar(nextChar)) throw new IOException("The \"" + (char)nextChar + "\" character isn't allowed in a media type parameter value.");
                    paramValueBuffer.append((char)nextChar);
                }
            }
            nextChar = nextIndex < nextValue.length() ? (int)nextValue.charAt(nextIndex++) : -1;
        }
        return result;
    }
}

