/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.admin;

import org.cpsolver.ifs.util.ToolBox;
import org.hibernate.Session;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.SimpleEditInterface;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Settings;
import org.unitime.timetable.model.dao.SettingsDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.server.admin.AdminTable;

@Service(value="gwtAdminTable[type=defaultSettings]")
public class DefaultSettings
implements AdminTable {
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);

    @Override
    public SimpleEditInterface.PageName name() {
        return new SimpleEditInterface.PageName(MESSAGES.pageDefaultSetting(), MESSAGES.pageDefaultSettings());
    }

    @Override
    @PreAuthorize(value="checkPermission('SettingsAdmin')")
    public SimpleEditInterface load(SessionContext context, Session hibSession) {
        SimpleEditInterface data = new SimpleEditInterface(new SimpleEditInterface.Field(MESSAGES.fieldReference(), SimpleEditInterface.FieldType.text, 217, 30, SimpleEditInterface.Flag.UNIQUE, SimpleEditInterface.Flag.NOT_EMPTY), new SimpleEditInterface.Field(MESSAGES.fieldDescription(), SimpleEditInterface.FieldType.text, 500, 100, SimpleEditInterface.Flag.UNIQUE, SimpleEditInterface.Flag.NOT_EMPTY), new SimpleEditInterface.Field(MESSAGES.fieldDefaulValue(), SimpleEditInterface.FieldType.text, 217, 100, SimpleEditInterface.Flag.NOT_EMPTY), new SimpleEditInterface.Field(MESSAGES.fieldAllowedValues(), SimpleEditInterface.FieldType.textarea, 30, 5, 500, SimpleEditInterface.Flag.NOT_EMPTY));
        data.setSortBy(1);
        for (Settings setting : SettingsDAO.getInstance().findAll()) {
            SimpleEditInterface.Record r = data.addRecord(setting.getUniqueId());
            boolean canEdit = context.hasPermission(Right.SettingsAdmin);
            r.setField(0, setting.getKey(), canEdit);
            r.setField(1, setting.getDescription(), canEdit);
            r.setField(2, setting.getDefaultValue(), canEdit);
            r.setField(3, setting.getAllowedValues() == null ? null : setting.getAllowedValues().replace(',', '\n'), canEdit);
            r.setDeletable(context.hasPermission(Right.SettingsAdmin));
        }
        data.setAddable(context.hasPermission(Right.SettingsAdmin));
        return data;
    }

    @Override
    public void save(SimpleEditInterface data, SessionContext context, Session hibSession) {
        for (Settings setting : SettingsDAO.getInstance().findAll()) {
            SimpleEditInterface.Record r = data.getRecord(setting.getUniqueId());
            if (r == null) {
                this.delete(setting, context, hibSession);
                continue;
            }
            this.update(setting, r, context, hibSession);
        }
        for (SimpleEditInterface.Record r : data.getNewRecords()) {
            this.save(r, context, hibSession);
        }
    }

    @Override
    public void save(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        context.checkPermission(Right.SettingsAdmin);
        Settings setting = new Settings();
        setting.setKey(record.getField(0));
        setting.setDescription(record.getField(1));
        setting.setDefaultValue(record.getField(2));
        setting.setAllowedValues(record.getField(3).replace('\n', ','));
        hibSession.persist((Object)setting);
        record.setUniqueId(setting.getUniqueId());
        ChangeLog.addChange(hibSession, context, setting, setting.getKey(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.CREATE, null, null);
    }

    protected void update(Settings setting, SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        if (setting == null) {
            return;
        }
        context.checkPermission(Right.SettingsAdmin);
        if (ToolBox.equals((Object)setting.getKey(), (Object)record.getField(0)) && ToolBox.equals((Object)setting.getDescription(), (Object)record.getField(1)) && ToolBox.equals((Object)setting.getDefaultValue(), (Object)record.getField(2)) && ToolBox.equals((Object)setting.getAllowedValues(), (Object)record.getField(3).replace('\n', ','))) {
            return;
        }
        setting.setKey(record.getField(0));
        setting.setDescription(record.getField(1));
        setting.setDefaultValue(record.getField(2));
        setting.setAllowedValues(record.getField(3).replace('\n', ','));
        hibSession.merge((Object)setting);
        ChangeLog.addChange(hibSession, context, setting, setting.getKey(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.UPDATE, null, null);
    }

    @Override
    public void update(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        this.update((Settings)SettingsDAO.getInstance().get(record.getUniqueId(), hibSession), record, context, hibSession);
    }

    protected void delete(Settings setting, SessionContext context, Session hibSession) {
        if (setting == null) {
            return;
        }
        context.checkPermission(Right.SettingsAdmin);
        ChangeLog.addChange(hibSession, context, setting, setting.getKey(), ChangeLog.Source.SIMPLE_EDIT, ChangeLog.Operation.DELETE, null, null);
        hibSession.remove((Object)setting);
    }

    @Override
    public void delete(SimpleEditInterface.Record record, SessionContext context, Session hibSession) {
        this.delete((Settings)SettingsDAO.getInstance().get(record.getUniqueId(), hibSession), context, hibSession);
    }
}

