/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.model;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.cpsolver.studentsct.reservation.Reservation;
import org.unitime.timetable.model.CourseReservation;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XReservation;
import org.unitime.timetable.onlinesectioning.model.XReservationType;
import org.unitime.timetable.onlinesectioning.model.XStudent;

public class XCourseReservation
extends XReservation {
    private static final long serialVersionUID = 1L;
    private XCourseId iCourseId;
    private int iLimit = -1;

    public XCourseReservation() {
    }

    public XCourseReservation(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternal(in);
    }

    public XCourseReservation(XOffering offering, CourseReservation reservation) {
        super(XReservationType.Course, offering, reservation);
        this.iCourseId = new XCourseId(reservation.getCourse());
        for (XCourse course : offering.getCourses()) {
            if (!course.getCourseId().equals(this.iCourseId)) continue;
            this.iLimit = course.getLimit();
        }
    }

    public XCourseReservation(org.cpsolver.studentsct.reservation.CourseReservation reservation) {
        super(XReservationType.Course, (Reservation)reservation);
        this.iCourseId = new XCourseId(reservation.getCourse());
        this.iLimit = reservation.getCourse().getLimit();
    }

    public Long getCourseId() {
        return this.iCourseId.getCourseId();
    }

    @Override
    public Long getOfferingId() {
        return this.iCourseId.getOfferingId();
    }

    @Override
    public int getReservationLimit() {
        return this.iLimit;
    }

    @Override
    public boolean isApplicable(XStudent student, XCourseId course) {
        if (course != null) {
            return this.iCourseId.equals(course);
        }
        for (XRequest request : student.getRequests()) {
            if (!(request instanceof XCourseRequest) || !((XCourseRequest)request).getCourseIds().contains(this.iCourseId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.iCourseId = new XCourseId(in);
        this.iLimit = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        this.iCourseId.writeExternal(out);
        out.writeInt(this.iLimit);
    }
}

