/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.shared;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.unitime.timetable.gwt.command.client.GwtRpcRequest;
import org.unitime.timetable.gwt.command.client.GwtRpcResponse;
import org.unitime.timetable.gwt.shared.FilterInterface;
import org.unitime.timetable.gwt.shared.RoomInterface;
import org.unitime.timetable.gwt.shared.SolverInterface;
import org.unitime.timetable.gwt.shared.SuggestionsInterface;
import org.unitime.timetable.gwt.shared.TableInterface;

public class CourseTimetablingSolverInterface {

    public static class SolverReportsResponse
    implements GwtRpcResponse,
    SolverInterface.HasPageMessages,
    Serializable {
        private static final long serialVersionUID = 0L;
        private List<SolverInterface.PageMessage> iPageMessages = null;
        private List<TableInterface> iTables = null;
        private List<RoomInterface.PreferenceInterface> iPreferences = new ArrayList<RoomInterface.PreferenceInterface>();

        @Override
        public boolean hasPageMessages() {
            return this.iPageMessages != null && !this.iPageMessages.isEmpty();
        }

        @Override
        public List<SolverInterface.PageMessage> getPageMessages() {
            return this.iPageMessages;
        }

        @Override
        public void addPageMessage(SolverInterface.PageMessage message) {
            if (this.iPageMessages == null) {
                this.iPageMessages = new ArrayList<SolverInterface.PageMessage>();
            }
            this.iPageMessages.add(message);
        }

        public boolean hasTables() {
            return this.iTables != null && !this.iTables.isEmpty();
        }

        public List<TableInterface> getTables() {
            return this.iTables;
        }

        public void addTable(TableInterface table) {
            if (table == null) {
                return;
            }
            if (this.iTables == null) {
                this.iTables = new ArrayList<TableInterface>();
            }
            this.iTables.add(table);
        }

        public void addPreference(RoomInterface.PreferenceInterface preference) {
            this.iPreferences.add(preference);
        }

        public List<RoomInterface.PreferenceInterface> getPreferences() {
            return this.iPreferences;
        }
    }

    public static class SolverReportsRequest
    implements GwtRpcRequest<SolverReportsResponse>,
    Serializable {
        private static final long serialVersionUID = 0L;
    }

    public static class ListSolutionsResponse
    extends TableInterface
    implements SolverInterface.HasPageMessages {
        private static final long serialVersionUID = 0L;
        private Date iLoadDate;
        private List<SolverInterface.PageMessage> iPageMessages = null;
        private SolverInterface.SolutionInfo iCurrentSolution;
        private List<SolverInterface.ProgressMessage> iLog;
        private List<SolverInterface.SolutionInfo> iSelectedSolutions;
        private String iHost;
        private List<String> iHosts;
        private String iSolverStatus;
        private String iSolverProgress;
        private Long iConfigurationId;
        private List<SolverInterface.SolverConfiguration> iConfigurations;
        private boolean iWorking = false;
        private SolutionOperation iOperation;
        private Map<Long, Integer> iOperations = new HashMap<Long, Integer>();
        private String iMessage = null;
        private List<SolverInterface.SolverOwner> iSolverOwners;
        private List<Long> iOwnerIds;
        private List<String> iErrors = new ArrayList<String>();
        private Boolean iSuccess = false;

        @Override
        public boolean hasPageMessages() {
            return this.iPageMessages != null && !this.iPageMessages.isEmpty();
        }

        @Override
        public List<SolverInterface.PageMessage> getPageMessages() {
            return this.iPageMessages;
        }

        @Override
        public void addPageMessage(SolverInterface.PageMessage message) {
            if (this.iPageMessages == null) {
                this.iPageMessages = new ArrayList<SolverInterface.PageMessage>();
            }
            this.iPageMessages.add(message);
        }

        public String getSolverStatus() {
            return this.iSolverStatus;
        }

        public void setSolverStatus(String solverStatus) {
            this.iSolverStatus = solverStatus;
        }

        public String getSolverProgress() {
            return this.iSolverProgress;
        }

        public void setSolverProgress(String solverProgress) {
            this.iSolverProgress = solverProgress;
        }

        public Long getConfigurationId() {
            return this.iConfigurationId;
        }

        public void setConfigurationId(Long ownerId) {
            this.iConfigurationId = ownerId;
        }

        public boolean hasConfigurations() {
            return this.iConfigurations != null && !this.iConfigurations.isEmpty();
        }

        public SolverInterface.SolverConfiguration getConfiguration(Long id) {
            if (this.iConfigurations == null) {
                return null;
            }
            for (SolverInterface.SolverConfiguration config : this.iConfigurations) {
                if (!id.equals(config.getId())) continue;
                return config;
            }
            return null;
        }

        public List<SolverInterface.SolverConfiguration> getConfigurations() {
            return this.iConfigurations;
        }

        public void addConfiguration(SolverInterface.SolverConfiguration config) {
            if (this.iConfigurations == null) {
                this.iConfigurations = new ArrayList<SolverInterface.SolverConfiguration>();
            }
            this.iConfigurations.add(config);
        }

        public boolean hasCurrentSolution() {
            return this.iCurrentSolution != null;
        }

        public SolverInterface.SolutionInfo getCurrentSolution() {
            return this.iCurrentSolution;
        }

        public void setCurrentSolution(SolverInterface.SolutionInfo current) {
            this.iCurrentSolution = current;
        }

        public boolean hasSelectedSolutions() {
            return this.iSelectedSolutions != null && !this.iSelectedSolutions.isEmpty();
        }

        public void addSelectedSolution(SolverInterface.SolutionInfo selected) {
            if (this.iSelectedSolutions == null) {
                this.iSelectedSolutions = new ArrayList<SolverInterface.SolutionInfo>();
            }
            this.iSelectedSolutions.add(selected);
        }

        public List<SolverInterface.SolutionInfo> getSelectedSolutions() {
            return this.iSelectedSolutions;
        }

        public String getHost() {
            return this.iHost;
        }

        public void setHost(String host) {
            this.iHost = host;
        }

        public boolean hasHosts() {
            return this.iHosts != null && !this.iHosts.isEmpty();
        }

        public List<String> getHosts() {
            return this.iHosts;
        }

        public void addHost(String host) {
            if (this.iHosts == null) {
                this.iHosts = new ArrayList<String>();
            }
            this.iHosts.add(host);
        }

        public void addHost(int index, String host) {
            if (this.iHosts == null) {
                this.iHosts = new ArrayList<String>();
            }
            this.iHosts.add(index, host);
        }

        public boolean hasLog() {
            return this.iLog != null && !this.iLog.isEmpty();
        }

        public void addMessage(int level, Date date, String message, String[] trace) {
            if (this.iLog == null) {
                this.iLog = new ArrayList<SolverInterface.ProgressMessage>();
            }
            this.iLog.add(new SolverInterface.ProgressMessage(level, date, message, trace));
        }

        public List<SolverInterface.ProgressMessage> getLog() {
            return this.iLog;
        }

        public Date getLoadDate() {
            return this.iLoadDate;
        }

        public void setLoadDate(Date date) {
            this.iLoadDate = date;
        }

        public boolean isWorking() {
            return this.iWorking;
        }

        public void setWorking(boolean working) {
            this.iWorking = working;
        }

        public SolutionOperation getOperation() {
            return this.iOperation;
        }

        public void setOperation(SolutionOperation operation) {
            this.iOperation = operation;
        }

        public boolean canExecute(Long solutionId, SolutionOperation operation) {
            Integer operations = this.iOperations.get(solutionId);
            return operations != null && operation.in(operations);
        }

        public void setCanExecute(Long solutionId, SolutionOperation operation, boolean enabled) {
            Integer operations = this.iOperations.get(solutionId);
            if (operations == null) {
                operations = 0;
            }
            if (enabled) {
                this.iOperations.put(solutionId, operation.set(operations));
            } else {
                this.iOperations.put(solutionId, operation.clear(operations));
            }
        }

        public void setCanExecute(Long solutionId, SolverInterface.SolverOperation ... operations) {
            Integer op = this.iOperations.get(solutionId);
            if (op == null) {
                op = 0;
            }
            for (SolverInterface.SolverOperation operation : operations) {
                op = operation.set(op);
            }
            this.iOperations.put(solutionId, op);
        }

        public boolean hasMessage() {
            return this.iMessage != null && !this.iMessage.isEmpty();
        }

        public String getMessage() {
            return this.iMessage;
        }

        public void setMessage(String message) {
            this.iMessage = message;
        }

        public boolean hasSolverOwners() {
            return this.iSolverOwners != null && !this.iSolverOwners.isEmpty();
        }

        public List<SolverInterface.SolverOwner> getSolverOwners() {
            return this.iSolverOwners;
        }

        public void addSolverOwner(SolverInterface.SolverOwner solverOwner) {
            if (this.iSolverOwners == null) {
                this.iSolverOwners = new ArrayList<SolverInterface.SolverOwner>();
            }
            this.iSolverOwners.add(solverOwner);
        }

        public SolverInterface.SolverOwner getSolverOwner(Long id) {
            if (this.iSolverOwners == null || id == null) {
                return null;
            }
            for (SolverInterface.SolverOwner g : this.iSolverOwners) {
                if (!id.equals(g.getId())) continue;
                return g;
            }
            return null;
        }

        public boolean hasOwerIds() {
            return this.iOwnerIds != null && !this.iOwnerIds.isEmpty();
        }

        public List<Long> getOwnerIds() {
            return this.iOwnerIds;
        }

        public void addOwnerId(Long ownerId) {
            if (this.iOwnerIds == null) {
                this.iOwnerIds = new ArrayList<Long>();
            }
            this.iOwnerIds.add(ownerId);
        }

        public boolean hasErrors() {
            return !this.iErrors.isEmpty();
        }

        public List<String> getErrors() {
            return this.iErrors;
        }

        public String getErrorMessage(String separator) {
            Object ret = "";
            if (this.iErrors != null) {
                for (String error : this.iErrors) {
                    if (error == null || error.isEmpty()) continue;
                    ret = (String)ret + (((String)ret).isEmpty() ? "" : separator) + error;
                }
            }
            return ret;
        }

        public void addError(String error) {
            this.iErrors.add(error);
        }

        public boolean hasSuccess() {
            return this.iSuccess != null;
        }

        public boolean isSucceeded() {
            return this.iSuccess != null && this.iSuccess != false;
        }

        public void setSuccess(Boolean success) {
            this.iSuccess = success;
        }
    }

    public static class ListSolutionsRequest
    implements GwtRpcRequest<ListSolutionsResponse>,
    Serializable {
        private static final long serialVersionUID = 0L;
        private SolutionOperation iOperation;
        private List<Long> iSolutionIds;
        private Long iConfigurationId;
        private Long iOwnerId;
        private String iHost;
        private String iNote;

        public ListSolutionsRequest() {
        }

        public ListSolutionsRequest(SolutionOperation operation) {
            this.iOperation = operation;
        }

        public SolutionOperation getOperation() {
            return this.iOperation;
        }

        public void SolutionOperation(SolutionOperation operation) {
            this.iOperation = operation;
        }

        public Long getConfigurationId() {
            return this.iConfigurationId;
        }

        public void setConfigurationId(Long configId) {
            this.iConfigurationId = configId;
        }

        public boolean hasOwner() {
            return this.iOwnerId != null && this.iOwnerId >= 0L;
        }

        public Long getOwnerId() {
            return this.iOwnerId;
        }

        public void setOwnerId(Long configId) {
            this.iOwnerId = configId;
        }

        public boolean hasSolutionIds() {
            return this.iSolutionIds != null && !this.iSolutionIds.isEmpty();
        }

        public List<Long> getSolutionIds() {
            return this.iSolutionIds;
        }

        public void addSolutionId(Long solutionId) {
            if (this.iSolutionIds == null) {
                this.iSolutionIds = new ArrayList<Long>();
            }
            this.iSolutionIds.add(solutionId);
        }

        public String getHost() {
            return this.iHost;
        }

        public void setHost(String host) {
            this.iHost = host;
        }

        public boolean hasNote() {
            return this.iNote != null && !this.iNote.isEmpty();
        }

        public String getNote() {
            return this.iNote;
        }

        public void setNote(String note) {
            this.iNote = note;
        }
    }

    public static enum SolutionOperation implements IsSerializable
    {
        INIT,
        CHECK,
        SELECT,
        DESELECT,
        LOAD,
        LOAD_EMPTY,
        UNLOAD,
        COMMIT,
        UNCOMMIT,
        EXPORT,
        UPDATE_NOTE,
        DELETE,
        RELOAD,
        SAVE,
        SAVE_AS_NEW,
        SAVE_COMMIT,
        SAVE_AS_NEW_COMMIT;


        public int flag() {
            return 1 << this.ordinal();
        }

        public boolean in(int flags) {
            return (flags & this.flag()) != 0;
        }

        public int set(int flags) {
            return this.in(flags) ? flags : flags + this.flag();
        }

        public int clear(int flags) {
            return this.in(flags) ? flags - this.flag() : flags;
        }
    }

    public static class AssignmentHistoryResponse
    extends SolutionChangesResponse {
        private static final long serialVersionUID = 0L;
    }

    public static class AssignmentHistoryRequest
    implements GwtRpcRequest<AssignmentHistoryResponse>,
    Serializable {
        private static final long serialVersionUID = 0L;
        private FilterInterface iFilter;

        public FilterInterface getFilter() {
            return this.iFilter;
        }

        public void setFilter(FilterInterface filter) {
            this.iFilter = filter;
        }
    }

    public static class AssignmentHistoryFilterResponse
    extends AssignedClassesFilterResponse {
        private static final long serialVersionUID = 0L;
    }

    public static class AssignmentHistoryFilterRequest
    implements GwtRpcRequest<AssignmentHistoryFilterResponse>,
    Serializable {
        private static final long serialVersionUID = 0L;
    }

    public static class SolutionChangesResponse
    extends AssignedClassesResponse {
        private static final long serialVersionUID = 0L;
        private String iMessage = null;

        public boolean hasMessage() {
            return this.iMessage != null && !this.iMessage.isEmpty();
        }

        public String getMessage() {
            return this.iMessage;
        }

        public void setMessage(String message) {
            this.iMessage = message;
        }
    }

    public static class SolutionChangesRequest
    implements GwtRpcRequest<SolutionChangesResponse>,
    Serializable {
        private static final long serialVersionUID = 0L;
        private FilterInterface iFilter;

        public FilterInterface getFilter() {
            return this.iFilter;
        }

        public void setFilter(FilterInterface filter) {
            this.iFilter = filter;
        }
    }

    public static class SolutionChangesFilterResponse
    extends AssignedClassesFilterResponse {
        private static final long serialVersionUID = 0L;
    }

    public static class SolutionChangesFilterRequest
    implements GwtRpcRequest<SolutionChangesFilterResponse>,
    Serializable {
        private static final long serialVersionUID = 0L;
    }

    public static class ConflictStatisticsFilterResponse
    extends FilterInterface
    implements SolverInterface.HasPageMessages {
        private static final long serialVersionUID = 0L;
        private SuggestionsInterface.SuggestionProperties iProperties;
        private List<SolverInterface.PageMessage> iPageMessages = null;

        public SuggestionsInterface.SuggestionProperties getSuggestionProperties() {
            return this.iProperties;
        }

        public void setSuggestionProperties(SuggestionsInterface.SuggestionProperties properties) {
            this.iProperties = properties;
        }

        @Override
        public boolean hasPageMessages() {
            return this.iPageMessages != null && !this.iPageMessages.isEmpty();
        }

        @Override
        public List<SolverInterface.PageMessage> getPageMessages() {
            return this.iPageMessages;
        }

        @Override
        public void addPageMessage(SolverInterface.PageMessage message) {
            if (this.iPageMessages == null) {
                this.iPageMessages = new ArrayList<SolverInterface.PageMessage>();
            }
            this.iPageMessages.add(message);
        }
    }

    public static class ConflictStatisticsFilterRequest
    implements GwtRpcRequest<ConflictStatisticsFilterResponse>,
    Serializable {
        private static final long serialVersionUID = 0L;
    }

    public static class NotAssignedClassesResponse
    extends AssignedClassesResponse {
        private static final long serialVersionUID = 0L;
        private boolean iShowNote = false;

        public boolean isShowNote() {
            return this.iShowNote;
        }

        public void setShowNote(boolean showNote) {
            this.iShowNote = showNote;
        }
    }

    public static class NotAssignedClassesRequest
    implements GwtRpcRequest<NotAssignedClassesResponse>,
    Serializable {
        private static final long serialVersionUID = 0L;
        private FilterInterface iFilter;

        public FilterInterface getFilter() {
            return this.iFilter;
        }

        public void setFilter(FilterInterface filter) {
            this.iFilter = filter;
        }
    }

    public static class AssignedClassesResponse
    extends TableInterface
    implements SolverInterface.HasPageMessages {
        private static final long serialVersionUID = 0L;
        private List<SolverInterface.PageMessage> iPageMessages = null;

        @Override
        public boolean hasPageMessages() {
            return this.iPageMessages != null && !this.iPageMessages.isEmpty();
        }

        @Override
        public List<SolverInterface.PageMessage> getPageMessages() {
            return this.iPageMessages;
        }

        @Override
        public void addPageMessage(SolverInterface.PageMessage message) {
            if (this.iPageMessages == null) {
                this.iPageMessages = new ArrayList<SolverInterface.PageMessage>();
            }
            this.iPageMessages.add(message);
        }
    }

    public static class AssignedClassesRequest
    implements GwtRpcRequest<AssignedClassesResponse>,
    Serializable {
        private static final long serialVersionUID = 0L;
        private FilterInterface iFilter;

        public FilterInterface getFilter() {
            return this.iFilter;
        }

        public void setFilter(FilterInterface filter) {
            this.iFilter = filter;
        }
    }

    public static class NotAssignedClassesFilterResponse
    extends AssignedClassesFilterResponse {
        private static final long serialVersionUID = 0L;
    }

    public static class NotAssignedClassesFilterRequest
    implements GwtRpcRequest<NotAssignedClassesFilterResponse>,
    Serializable {
        private static final long serialVersionUID = 0L;
    }

    public static class AssignedClassesFilterResponse
    extends FilterInterface {
        private static final long serialVersionUID = 0L;
        private List<RoomInterface.PreferenceInterface> iPreferences = new ArrayList<RoomInterface.PreferenceInterface>();

        public void addPreference(RoomInterface.PreferenceInterface preference) {
            this.iPreferences.add(preference);
        }

        public List<RoomInterface.PreferenceInterface> getPreferences() {
            return this.iPreferences;
        }
    }

    public static class AssignedClassesFilterRequest
    implements GwtRpcRequest<AssignedClassesFilterResponse>,
    Serializable {
        private static final long serialVersionUID = 0L;
    }
}

