/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.access;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import org.unitime.timetable.gwt.client.ToolBox;
import org.unitime.timetable.gwt.client.access.AccessControlInterface;
import org.unitime.timetable.gwt.client.page.UniTimePageLabel;
import org.unitime.timetable.gwt.client.widgets.LoadingWidget;
import org.unitime.timetable.gwt.client.widgets.UniTimeConfirmationDialog;
import org.unitime.timetable.gwt.command.client.GwtRpcService;
import org.unitime.timetable.gwt.command.client.GwtRpcServiceAsync;
import org.unitime.timetable.gwt.resources.GwtMessages;

public abstract class AccessControlClient {
    public static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    protected static GwtRpcServiceAsync RPC = (GwtRpcServiceAsync)GWT.create(GwtRpcService.class);
    private Timer iTimer;
    private Timer iLeaveTimer;
    private UniTimeConfirmationDialog iLeaveConfirmation;
    private boolean iActive;
    private String iPage;
    private Event.NativePreviewHandler iNativePreviewHandler;
    private HandlerRegistration iHandlerRegistration;
    private AccessControlInterface.Operation iOperation = AccessControlInterface.Operation.CHECK_ACCESS;
    private boolean iWaiting = true;
    private int iLimit;
    private boolean iExecuted = false;

    public AccessControlClient(String page) {
        this.iPage = page;
        this.iNativePreviewHandler = new Event.NativePreviewHandler(){

            public void onPreviewNativeEvent(Event.NativePreviewEvent event) {
                switch (event.getTypeInt()) {
                    case 1: 
                    case 256: {
                        AccessControlClient.this.iActive = true;
                    }
                }
            }
        };
        this.iHandlerRegistration = Event.addNativePreviewHandler((Event.NativePreviewHandler)this.iNativePreviewHandler);
        this.iTimer = new Timer(){

            public void run() {
                AccessControlClient.this.periodicCheckAccess();
            }
        };
    }

    public AccessControlClient() {
        this(ToolBox.getPage());
    }

    protected String getPageName() {
        return UniTimePageLabel.getInstance().getValue().getName();
    }

    protected abstract void executeWhenAccessIsGranted();

    protected void showInactiveWarning(int inactiveMins) {
        if (this.iLeaveConfirmation != null && this.iLeaveConfirmation.isShowing()) {
            return;
        }
        this.iLimit = 60;
        this.iLeaveTimer = new Timer(){

            public void run() {
                if (AccessControlClient.this.iActive) {
                    this.cancel();
                    AccessControlClient.this.iLeaveConfirmation.hide();
                }
                --AccessControlClient.this.iLimit;
                if (AccessControlClient.this.iLimit < 0) {
                    this.cancel();
                } else if (AccessControlClient.this.iLimit == 0) {
                    if (AccessControlClient.this.iLeaveConfirmation.isShowing()) {
                        AccessControlClient.this.iLeaveConfirmation.hide();
                        AccessControlClient.this.leave(true);
                    }
                    this.cancel();
                } else {
                    AccessControlClient.this.iLeaveConfirmation.getYes().setHTML(MESSAGES.buttonWarningInactiveStay(AccessControlClient.this.iLimit));
                }
            }
        };
        this.iLeaveConfirmation = new UniTimeConfirmationDialog(UniTimeConfirmationDialog.Type.CONFIRM, MESSAGES.warnInactive(inactiveMins, this.getPageName()), null, null, new Command(){

            public void execute() {
                AccessControlClient.this.iLeaveTimer.cancel();
                AccessControlClient.this.iActive = true;
            }
        });
        this.iLeaveConfirmation.getYes().setHTML(MESSAGES.buttonWarningInactiveStay(this.iLimit));
        this.iLeaveConfirmation.getNo().setHTML(MESSAGES.buttonWarningInactiveLeave());
        this.iLeaveConfirmation.setText(MESSAGES.dialogWarningInactive());
        this.iLeaveConfirmation.setNoCallback(new Command(){

            public void execute() {
                AccessControlClient.this.iLeaveTimer.cancel();
                AccessControlClient.this.iActive = false;
                AccessControlClient.this.leave(true);
            }
        });
        this.iLeaveConfirmation.center();
        this.iLeaveTimer.scheduleRepeating(1000);
    }

    public void leave(final boolean openMainPage) {
        this.iTimer.cancel();
        AccessControlInterface.PingRequest req = new AccessControlInterface.PingRequest();
        req.setPage(this.iPage);
        req.setOperation(AccessControlInterface.Operation.LOGOUT);
        req.setActive(false);
        RPC.execute(req, new AsyncCallback<AccessControlInterface.PingResponse>(){

            public void onFailure(Throwable caught) {
                if (openMainPage) {
                    AccessControlClient.this.openMainPage();
                }
            }

            public void onSuccess(AccessControlInterface.PingResponse result) {
                if (openMainPage) {
                    AccessControlClient.this.openMainPage();
                }
            }
        });
    }

    public static native void sleep();

    protected void openMainPage() {
        ToolBox.open(GWT.getHostPageBaseURL() + "main.action?message=" + URL.encodeQueryString((String)MESSAGES.closedDueToInactivity(this.getPageName())));
    }

    protected void periodicCheckAccess() {
        AccessControlInterface.PingRequest req = new AccessControlInterface.PingRequest();
        req.setPage(this.iPage);
        req.setOperation(this.iOperation);
        req.setActive(this.iActive || this.iOperation == AccessControlInterface.Operation.CHECK_ACCESS);
        this.iActive = false;
        RPC.execute(req, new AsyncCallback<AccessControlInterface.PingResponse>(){

            public void onFailure(Throwable caught) {
                AccessControlClient.this.iTimer.schedule(20000);
            }

            public void onSuccess(AccessControlInterface.PingResponse result) {
                if (AccessControlClient.this.iWaiting) {
                    LoadingWidget.getInstance().hide();
                }
                if (result.isAccess()) {
                    AccessControlClient.this.iOperation = AccessControlInterface.Operation.PING;
                    if (!AccessControlClient.this.iExecuted) {
                        AccessControlClient.this.executeWhenAccessIsGranted();
                        AccessControlClient.this.iExecuted = true;
                    }
                    AccessControlClient.this.iWaiting = false;
                    if (result.getInactive() != null && !AccessControlClient.this.iActive) {
                        AccessControlClient.this.showInactiveWarning(result.getInactive());
                    }
                } else {
                    AccessControlClient.this.iWaiting = true;
                    LoadingWidget.getInstance().show(MESSAGES.waitTooManyUsersWaitInQueue(result.getQueue()));
                }
                AccessControlClient.this.iTimer.schedule(20000);
            }
        });
    }

    public void checkAccess() {
        this.iExecuted = false;
        LoadingWidget.getInstance().show(MESSAGES.waitLoadingPage());
        this.periodicCheckAccess();
        this.iTimer.schedule(20000);
    }

    public void stopClient() {
        if (this.iHandlerRegistration != null) {
            this.iHandlerRegistration.removeHandler();
            this.iHandlerRegistration = null;
        }
        this.iTimer.cancel();
    }
}

