/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.spring.security;

import jakarta.servlet.http.HttpServletRequest;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AnonymousAuthenticationFilter;
import org.springframework.stereotype.Service;
import org.unitime.timetable.security.context.AnonymousUserContext;

@Service(value="unitimeAnonymousFilter")
public class UniTimeAnonymousAuthenticationFilter
extends AnonymousAuthenticationFilter {
    public UniTimeAnonymousAuthenticationFilter() {
        super("guest");
    }

    protected Authentication createAuthentication(HttpServletRequest request) {
        try {
            AnonymousUserContext user = new AnonymousUserContext();
            if (!user.getAuthorities().isEmpty()) {
                return new AnonymousAuthenticationToken("guest", (Object)user, user.getAuthorities());
            }
            return super.createAuthentication(request);
        }
        catch (Throwable t) {
            return super.createAuthentication(request);
        }
    }
}

