/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.server.rooms;

import java.text.DecimalFormat;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.gwt.shared.RoomInterface;
import org.unitime.timetable.interfaces.RoomUrlProvider;
import org.unitime.timetable.model.AttachmentType;
import org.unitime.timetable.model.Building;
import org.unitime.timetable.model.EventServiceProvider;
import org.unitime.timetable.model.GlobalRoomFeature;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.LocationPicture;
import org.unitime.timetable.model.RoomFeatureType;
import org.unitime.timetable.model.RoomGroup;
import org.unitime.timetable.model.dao.BuildingDAO;
import org.unitime.timetable.model.dao.LocationDAO;
import org.unitime.timetable.onlinesectioning.custom.Customization;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.server.rooms.RoomDetailsBackend;
import org.unitime.timetable.server.rooms.RoomPicturesBackend;

@GwtRpcImplements(value=RoomInterface.RoomHintRequest.class)
public class RoomHintBackend
implements GwtRpcImplementation<RoomInterface.RoomHintRequest, RoomInterface.RoomHintResponse> {
    private static Log sLog = LogFactory.getLog(RoomHintBackend.class);
    protected static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    protected static final GwtConstants CONSTANTS = Localization.create(GwtConstants.class);
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);

    @Override
    public RoomInterface.RoomHintResponse execute(RoomInterface.RoomHintRequest request, SessionContext context) {
        RoomInterface.RoomHintResponse response = new RoomInterface.RoomHintResponse();
        if (request.getLocationId() >= 0L) {
            Location location = (Location)LocationDAO.getInstance().get(request.getLocationId());
            if (location == null) {
                return null;
            }
            response.setId(location.getUniqueId());
            response.setLabel(location.getLabel());
            response.setDisplayName(location.getDisplayName());
            response.setRoomTypeLabel(location.getRoomTypeLabel());
            Object minimap = ApplicationProperty.RoomHintMinimapUrl.value();
            if (minimap != null && location.getCoordinateX() != null && location.getCoordinateY() != null) {
                minimap = ((String)minimap).replace("%x", location.getCoordinateX().toString()).replace("%y", location.getCoordinateY().toString()).replace("%n", location.getLabel()).replace("%i", location.getExternalUniqueId() == null ? "" : location.getExternalUniqueId());
                String apikey = ApplicationProperty.RoomMapStaticApiKey.value();
                if (apikey != null && !apikey.isEmpty()) {
                    minimap = (String)minimap + "&key=" + (String)apikey;
                    String secret = ApplicationProperty.RoomMapStaticSecret.value();
                    if (secret != null && !secret.isEmpty()) {
                        try {
                            minimap = (String)minimap + "&signature=" + new RoomDetailsBackend.UrlSigner(secret).signRequest((String)minimap);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                response.setMiniMapUrl((String)minimap);
            }
            response.setCapacity(location.getCapacity());
            if (location.getExamCapacity() != null && location.getExamCapacity() > 0 && !location.getExamCapacity().equals(location.getCapacity()) && !location.getExamTypes().isEmpty()) {
                response.setExamCapacity(location.getExamCapacity());
                if (location.getExamTypes().size() == 1) {
                    response.setExamType(location.getExamTypes().iterator().next().getLabel().toLowerCase());
                }
            }
            if (location.getArea() != null) {
                response.setArea(new DecimalFormat(CONSTANTS.roomAreaFormat()).format(location.getArea()) + " " + (ApplicationProperty.RoomAreaUnitsMetric.isTrue() ? MSG.roomAreaMetricUnitsShort() : MSG.roomAreaUnitsShort()));
            }
            for (GlobalRoomFeature f : location.getGlobalRoomFeatures()) {
                RoomInterface.FeatureInterface featureInterface = new RoomInterface.FeatureInterface(f.getUniqueId(), f.getAbbv(), f.getLabel());
                featureInterface.setDescription(f.getDescription());
                RoomFeatureType t = f.getFeatureType();
                if (t != null) {
                    featureInterface.setType(new RoomInterface.FeatureTypeInterface(t.getUniqueId(), t.getReference(), t.getLabel(), t.isShowInEventManagement()));
                }
                response.addFeature(featureInterface);
            }
            for (RoomGroup g : location.getGlobalRoomGroups()) {
                RoomInterface.GroupInterface groupInterface = new RoomInterface.GroupInterface(g.getUniqueId(), g.getAbbv(), g.getName());
                groupInterface.setDescription(g.getDescription());
                response.addGroup(groupInterface);
            }
            response.setEventStatus(location.getEventDepartment() == null ? null : location.getEffectiveEventStatus().toString());
            response.setEventDepartment((String)(location.getEventDepartment() == null ? MESSAGES.noEventDepartment() : location.getEventDepartment().getDeptCode() + " - " + location.getEventDepartment().getName()));
            response.setNote(location.getEventMessage());
            if (ApplicationProperty.RoomHintShowBreakTime.isTrue()) {
                response.setBreakTime(location.getEffectiveBreakTime());
            }
            response.setIgnoreRoomCheck(location.isIgnoreRoomCheck());
            RoomUrlProvider url = (RoomUrlProvider)Customization.RoomUrlProvider.getProvider();
            if (url != null) {
                try {
                    response.setUrl(url.getRoomUrl(location));
                }
                catch (Exception e) {
                    sLog.error((Object)("Failed to get room URL: " + e.getMessage()), (Throwable)e);
                }
            }
            for (LocationPicture locationPicture : new TreeSet<LocationPicture>(location.getRoomPictures())) {
                if (locationPicture.getType() != null && (!AttachmentType.VisibilityFlag.IS_IMAGE.in(locationPicture.getType().getVisibility()) || !AttachmentType.VisibilityFlag.SHOW_ROOM_TOOLTIP.in(locationPicture.getType().getVisibility()))) continue;
                response.addPicture(new RoomInterface.RoomPictureInterface(locationPicture.getUniqueId(), locationPicture.getFileName(), locationPicture.getContentType(), locationPicture.getTimeStamp().getTime(), RoomPicturesBackend.getPictureType(locationPicture.getType())));
            }
            if (location.getEventDepartment() != null) {
                EventInterface.EventServiceProviderInterface provider;
                for (EventServiceProvider eventServiceProvider : location.getAllowedServices()) {
                    if (!eventServiceProvider.isVisible().booleanValue() || eventServiceProvider.isAllRooms().booleanValue()) continue;
                    provider = new EventInterface.EventServiceProviderInterface();
                    provider.setId(eventServiceProvider.getUniqueId());
                    provider.setReference(eventServiceProvider.getReference());
                    provider.setLabel(eventServiceProvider.getLabel());
                    provider.setMessage(eventServiceProvider.getNote());
                    provider.setEmail(eventServiceProvider.getEmail());
                    if (eventServiceProvider.getDepartment() != null) {
                        provider.setDepartmentId(eventServiceProvider.getDepartment().getUniqueId());
                    }
                    response.addService(provider);
                }
                for (EventServiceProvider eventServiceProvider : LocationDAO.getInstance().getSession().createQuery("from EventServiceProvider where visible = true and allRooms = true and (session is null or session.uniqueId = :sessionId) and (department is null or department.uniqueId = :departmentId)", EventServiceProvider.class).setParameter("sessionId", (Object)location.getSession().getUniqueId()).setParameter("departmentId", (Object)location.getEventDepartment().getUniqueId()).setCacheable(true).list()) {
                    provider = new EventInterface.EventServiceProviderInterface();
                    provider.setId(eventServiceProvider.getUniqueId());
                    provider.setReference(eventServiceProvider.getReference());
                    provider.setLabel(eventServiceProvider.getLabel());
                    provider.setMessage(eventServiceProvider.getNote());
                    provider.setEmail(eventServiceProvider.getEmail());
                    if (eventServiceProvider.getDepartment() != null) {
                        provider.setDepartmentId(eventServiceProvider.getDepartment().getUniqueId());
                    }
                    response.addService(provider);
                }
            }
            return response;
        }
        Building building = (Building)BuildingDAO.getInstance().get(-request.getLocationId().longValue());
        if (building == null) {
            return null;
        }
        response.setId(-building.getUniqueId().longValue());
        response.setLabel(building.getName());
        String minimap = ApplicationProperty.RoomHintMinimapUrl.value();
        if (minimap != null && building.getCoordinateX() != null && building.getCoordinateY() != null) {
            response.setMiniMapUrl(minimap.replace("%x", building.getCoordinateX().toString()).replace("%y", building.getCoordinateY().toString()).replace("%n", building.getAbbreviation()).replace("%i", building.getExternalUniqueId() == null ? "" : building.getExternalUniqueId()));
        }
        return response;
    }
}

