/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.model;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.cpsolver.studentsct.reservation.CourseRestriction;
import org.cpsolver.studentsct.reservation.CurriculumRestriction;
import org.cpsolver.studentsct.reservation.IndividualRestriction;
import org.cpsolver.studentsct.reservation.Restriction;
import org.unitime.timetable.onlinesectioning.model.XRestrictionType;

public class XRestrictionId
implements Serializable,
Externalizable {
    private static final long serialVersionUID = 1L;
    protected XRestrictionType iType;
    private Long iOfferingId;
    private Long iRestrictionId;

    public XRestrictionId() {
    }

    public XRestrictionId(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readExternal(in);
    }

    public XRestrictionId(XRestrictionType type, Long offeringId, Long reservationId) {
        this.iType = type;
        this.iOfferingId = offeringId;
        this.iRestrictionId = reservationId;
    }

    public XRestrictionId(XRestrictionId reservation) {
        this.iType = reservation.getType();
        this.iOfferingId = reservation.getOfferingId();
        this.iRestrictionId = reservation.getRestrictionId();
    }

    public XRestrictionId(Restriction restriction) {
        this.iOfferingId = restriction.getOffering().getId();
        this.iRestrictionId = restriction.getId();
        this.iType = restriction instanceof IndividualRestriction ? XRestrictionType.Individual : (restriction instanceof CurriculumRestriction ? XRestrictionType.Curriculum : (restriction instanceof CourseRestriction ? XRestrictionType.Course : XRestrictionType.Individual));
    }

    public XRestrictionType getType() {
        return this.iType;
    }

    public Long getOfferingId() {
        return this.iOfferingId;
    }

    public Long getRestrictionId() {
        return this.iRestrictionId;
    }

    public boolean isOverride() {
        return false;
    }

    public boolean canBreakLinkedSections() {
        return false;
    }

    public int hashCode() {
        return (int)(this.getRestrictionId() ^ this.getRestrictionId() >>> 32);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof XRestrictionId)) {
            return false;
        }
        return this.getRestrictionId() == ((XRestrictionId)o).getRestrictionId() && this.getOfferingId().equals(((XRestrictionId)o).getOfferingId());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.iType = XRestrictionType.values()[in.readInt()];
        this.iOfferingId = in.readLong();
        this.iRestrictionId = in.readLong();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.iType.ordinal());
        out.writeLong(this.iOfferingId);
        out.writeLong(this.iRestrictionId);
    }
}

