/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.util.List;
import org.hibernate.FlushMode;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.timetable.model.base.BaseEventContact;
import org.unitime.timetable.model.dao.EventContactDAO;
import org.unitime.timetable.util.NameFormat;
import org.unitime.timetable.util.NameInterface;

@Entity
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Table(name="event_contact")
public class EventContact
extends BaseEventContact
implements NameInterface {
    private static final long serialVersionUID = 1L;

    public EventContact() {
    }

    public EventContact(Long uniqueId) {
        super(uniqueId);
    }

    public static EventContact findByExternalUniqueId(String externalUniqueId) {
        return (EventContact)EventContactDAO.getInstance().getSession().createQuery("select c from EventContact c where c.externalUniqueId=:externalUniqueId", EventContact.class).setParameter("externalUniqueId", (Object)externalUniqueId).setHibernateFlushMode(FlushMode.MANUAL).uniqueResult();
    }

    public static EventContact findByEmail(String email) {
        List ec = EventContactDAO.getInstance().getSession().createQuery("select c from EventContact c where c.emailAddress=:emailAddress", EventContact.class).setParameter("emailAddress", (Object)email).list();
        if (ec.isEmpty()) {
            return null;
        }
        return (EventContact)ec.get(0);
    }

    @Transient
    public String getShortName() {
        StringBuffer sb = new StringBuffer();
        if (this.getFirstName() != null && this.getFirstName().length() > 0) {
            sb.append(this.getFirstName().substring(0, 1).toUpperCase());
            sb.append(". ");
        }
        if (this.getLastName() != null && this.getLastName().length() > 0) {
            sb.append(this.getLastName().substring(0, 1).toUpperCase());
            sb.append(this.getLastName().substring(1, Math.min(10, this.getLastName().length())).toLowerCase().trim());
        }
        return sb.toString();
    }

    @Transient
    public String getName() {
        return (this.getLastName() == null ? "" : this.getLastName().trim()) + ", " + (this.getFirstName() == null ? "" : this.getFirstName().trim()) + " " + (this.getMiddleName() == null ? "" : this.getMiddleName().trim());
    }

    public String getName(String nameFormat) {
        return NameFormat.fromReference(nameFormat).format(this);
    }
}

