/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.client.departments;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.unitime.timetable.gwt.client.admin.AdminCookie;
import org.unitime.timetable.gwt.client.page.UniTimePageHeader;
import org.unitime.timetable.gwt.client.rooms.RoomsTable;
import org.unitime.timetable.gwt.client.widgets.P;
import org.unitime.timetable.gwt.client.widgets.UniTimeTable;
import org.unitime.timetable.gwt.client.widgets.UniTimeTableHeader;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.shared.DepartmentInterface;

public class DepartmentsTable
extends UniTimeTable<DepartmentInterface> {
    protected static final GwtMessages MESSAGES = (GwtMessages)GWT.create(GwtMessages.class);
    private DepartmentInterface.DepartmentsColumn iSortBy = null;
    private boolean iAsc = true;
    private boolean iSelectable = true;
    private boolean iFundingDeptEnabled;

    public DepartmentsTable() {
        this.setHeaderData(false);
        this.addStyleName("unitime-Departments");
    }

    public void selectDept(int row, boolean value) {
        Widget w = this.getWidget(row, 0);
        if (w != null && w instanceof CheckBox) {
            ((CheckBox)w).setValue(Boolean.valueOf(value));
        }
    }

    public void setProperties(boolean fundingDeptEnabled) {
        this.iFundingDeptEnabled = fundingDeptEnabled;
    }

    public String getColumnName(DepartmentInterface.DepartmentsColumn column) {
        switch (column) {
            case CODE: {
                return MESSAGES.colCode();
            }
            case ABBV: {
                return MESSAGES.colAbbv();
            }
            case NAME: {
                return MESSAGES.colName();
            }
            case EXTERNAL_MANAGER: {
                return MESSAGES.colExternalManager();
            }
            case SUBJECTS: {
                return MESSAGES.colSubjects();
            }
            case ROOMS: {
                return MESSAGES.colRooms();
            }
            case STATUS: {
                return MESSAGES.colStatus();
            }
            case DIST_PREF_PRIORITY: {
                return MESSAGES.colDistPrefPriority();
            }
            case ALLOW_REQUIRED: {
                return MESSAGES.colAllowRequired();
            }
            case INSTRUCTOR_PREF: {
                return MESSAGES.colInstructorPref();
            }
            case EVENTS: {
                return MESSAGES.colEvents();
            }
            case STUDENT_SCHEDULING: {
                return MESSAGES.colStudentScheduling();
            }
            case EXT_FUNDING_DEPT: {
                return MESSAGES.colExternalFundingDept();
            }
            case LAST_CHANGE: {
                return MESSAGES.colLastChange();
            }
        }
        return column.name();
    }

    public String getUser() {
        return UniTimePageHeader.getInstance().getMiddle().getText();
    }

    public Widget getColumnWidget(DepartmentInterface.DepartmentsColumn column, DepartmentInterface department) {
        switch (column) {
            case CODE: {
                return new Label(department.getDeptCode() == null ? "" : department.getDeptCode());
            }
            case ABBV: {
                return new Label(department.getAbbreviation() == null ? "" : department.getAbbreviation());
            }
            case NAME: {
                return new HTML(department.getName() == null ? "" : department.getName(), false);
            }
            case EXTERNAL_MANAGER: {
                return new Label(department.isExternalManager() != false ? department.getExternalMgrAbbv() : "");
            }
            case SUBJECTS: {
                return new RoomsTable.IntegerCell(department.getSubjectAreaCount());
            }
            case ROOMS: {
                return new RoomsTable.IntegerCell(department.getRoomDeptCount());
            }
            case STATUS: {
                P widget = new P("departments-status");
                P ext = new P("ext-status");
                ext.setText(department.effectiveStatusType());
                ext.addStyleName("department-StatusItalics");
                widget.add((Widget)ext);
                for (String dependentStatus : department.getDependentStatusesStr()) {
                    P ext1 = new P("ext-status");
                    ext1.setText(dependentStatus);
                    ext1.addStyleName("department-Status");
                    widget.add((Widget)ext1);
                }
                return widget;
            }
            case DIST_PREF_PRIORITY: {
                return new RoomsTable.IntegerCell(department.getDistributionPrefPriority() == null && department.getDistributionPrefPriority() == 0 ? 0 : department.getDistributionPrefPriority());
            }
            case ALLOW_REQUIRED: {
                return new Label(department.allowReq(MESSAGES));
            }
            case INSTRUCTOR_PREF: {
                P instrucPrefWidget = new P("instruc-pref");
                if (department.isInheritInstructorPreferences().booleanValue()) {
                    instrucPrefWidget.addStyleName("department-accept");
                }
                return instrucPrefWidget;
            }
            case EVENTS: {
                P eventWidget = new P("events");
                if (department.isAllowEvents().booleanValue()) {
                    eventWidget.addStyleName("department-accept");
                }
                return eventWidget;
            }
            case STUDENT_SCHEDULING: {
                P allowStudentSchedulingWidget = new P("allowStudentSchedulingWidget");
                if (department.isAllowStudentScheduling().booleanValue()) {
                    allowStudentSchedulingWidget.addStyleName("department-accept");
                }
                return allowStudentSchedulingWidget;
            }
            case EXT_FUNDING_DEPT: {
                P extFundingDeptWidget = new P("extFundingDeptWidget");
                if (this.iFundingDeptEnabled) {
                    if (department.isExternalFundingDept() != null && department.isExternalFundingDept().booleanValue()) {
                        extFundingDeptWidget.addStyleName("department-accept");
                    }
                    return extFundingDeptWidget;
                }
                return null;
            }
            case LAST_CHANGE: {
                return new HTML(department.getLastChangeStr() == null ? "" : department.getLastChangeStr(), false);
            }
        }
        return null;
    }

    protected void addRow(DepartmentInterface department) {
        ArrayList<Widget> line = new ArrayList<Widget>();
        for (DepartmentInterface.DepartmentsColumn col : DepartmentInterface.DepartmentsColumn.values()) {
            if (this.getColumnWidget(col, department) == null) continue;
            line.add(this.getColumnWidget(col, department));
        }
        this.addRow(department, line);
    }

    public void setHeaderData(boolean fundingDepartmentsEnabled) {
        this.clearTable();
        ArrayList<UniTimeTableHeader> header = new ArrayList<UniTimeTableHeader>();
        for (final DepartmentInterface.DepartmentsColumn col : DepartmentInterface.DepartmentsColumn.values()) {
            if (!DepartmentComparator.isApplicable(col) || col == DepartmentInterface.DepartmentsColumn.EXT_FUNDING_DEPT && (col != DepartmentInterface.DepartmentsColumn.EXT_FUNDING_DEPT || !fundingDepartmentsEnabled)) continue;
            final UniTimeTableHeader h = new UniTimeTableHeader(this.getColumnName(col));
            SortOperation op = new SortOperation(){

                public void execute() {
                    DepartmentsTable.this.doSort(col);
                }

                @Override
                public boolean isApplicable() {
                    return DepartmentsTable.this.getRowCount() > 1 && h.isVisible();
                }

                @Override
                public boolean hasSeparator() {
                    return false;
                }

                @Override
                public String getName() {
                    return MESSAGES.opSortBy(this.getColumnName());
                }

                @Override
                public String getColumnName() {
                    return h.getHTML().replace("<br>", " ");
                }
            };
            h.addOperation(op);
            header.add(h);
        }
        this.addRow(null, header);
        for (int i = 0; i < this.getCellCount(0); ++i) {
            this.getCellFormatter().setStyleName(0, i, "unitime-ClickableTableHeader");
        }
        if (this.iSelectable) {
            this.setAllowSelection(true);
            this.addMouseClickListener(new UniTimeTable.MouseClickListener<DepartmentInterface>(){

                @Override
                public void onMouseClick(UniTimeTable.TableEvent<DepartmentInterface> event) {
                    DepartmentsTable.this.selectDept(event.getRow(), DepartmentsTable.this.isSelected(event.getRow()));
                }
            });
        }
        this.setSortBy(AdminCookie.getInstance().getSortDepartmentsBy());
    }

    public void setData(List<DepartmentInterface> departments, boolean showAlldept, boolean fundingDeptVisible) {
        this.clearTable(1);
        this.iFundingDeptEnabled = fundingDeptVisible;
        boolean hasLastChange = false;
        if (departments != null) {
            for (DepartmentInterface department : departments) {
                if (!showAlldept && department.getSubjectAreaCount() == 0 && department.getTimetableManagersCount() == 0 && !department.isExternalManager().booleanValue()) continue;
                this.addRow(department);
                if (department.getLastChangeStr() == null) continue;
                hasLastChange = true;
            }
        }
        this.setColumnVisible(this.getCellCount(0) - 1, hasLastChange);
        this.sort();
    }

    protected void doSort(DepartmentInterface.DepartmentsColumn column) {
        if (column == this.iSortBy) {
            this.iAsc = !this.iAsc;
        } else {
            this.iSortBy = column;
            this.iAsc = true;
        }
        AdminCookie.getInstance().setSortDepartmentsBy(this.getSortBy());
        this.sort();
    }

    public boolean hasSortBy() {
        return this.iSortBy != null;
    }

    public int getSortBy() {
        return this.iSortBy == null ? 0 : (this.iAsc ? 1 + this.iSortBy.ordinal() : -1 - this.iSortBy.ordinal());
    }

    public void setSortBy(int sortBy) {
        if (sortBy == 0) {
            this.iSortBy = null;
            this.iAsc = true;
        } else if (sortBy > 0) {
            this.iSortBy = DepartmentInterface.DepartmentsColumn.values()[sortBy - 1];
            this.iAsc = true;
        } else {
            this.iSortBy = DepartmentInterface.DepartmentsColumn.values()[-1 - sortBy];
            this.iAsc = false;
        }
        this.sort();
    }

    public void sort() {
        if (this.iSortBy == null) {
            return;
        }
        UniTimeTableHeader header = this.getHeader(this.iSortBy.ordinal());
        this.sort(header, new DepartmentComparator(this.iSortBy, true), this.iAsc);
    }

    public static class DepartmentComparator
    implements Comparator<DepartmentInterface> {
        private DepartmentInterface.DepartmentsColumn iColumn;
        private boolean iAsc;

        public DepartmentComparator(DepartmentInterface.DepartmentsColumn column, boolean asc) {
            this.iColumn = column;
            this.iAsc = asc;
        }

        public int compareById(DepartmentInterface r1, DepartmentInterface r2) {
            return this.compare(r1.getUniqueId(), r2.getUniqueId());
        }

        public int compareByDeptCode(DepartmentInterface r1, DepartmentInterface r2) {
            return this.compare(r1.getDeptCode(), r2.getDeptCode());
        }

        public int compareByName(DepartmentInterface r1, DepartmentInterface r2) {
            return this.compare(r1.getName(), r2.getName());
        }

        public int compareByAbbreviation(DepartmentInterface r1, DepartmentInterface r2) {
            return this.compare(r1.getAbbreviation(), r2.getAbbreviation());
        }

        public int compareByExtMgr(DepartmentInterface r1, DepartmentInterface r2) {
            return this.compare(r1.getExternalMgrAbbv(), r2.getExternalMgrAbbv());
        }

        public int compareBySubjectCount(DepartmentInterface r1, DepartmentInterface r2) {
            return this.compare(r1.getSubjectAreaCount(), r2.getSubjectAreaCount());
        }

        public int compareByRoomCount(DepartmentInterface r1, DepartmentInterface r2) {
            return this.compare(r1.getRoomDeptCount(), r2.getRoomDeptCount());
        }

        public int compareByStatus(DepartmentInterface r1, DepartmentInterface r2) {
            return this.compare(r1.getStatusTypeStr(), r2.getStatusTypeStr());
        }

        public int compareByDistPrefPriority(DepartmentInterface r1, DepartmentInterface r2) {
            return this.compare(r1.getDistributionPrefPriority(), r2.getDistributionPrefPriority());
        }

        public int compareByAllowReqd(DepartmentInterface r1, DepartmentInterface r2) {
            return this.compare(r1.allowReq(MESSAGES), r2.allowReq(MESSAGES));
        }

        public int compareByInstrucPref(DepartmentInterface r1, DepartmentInterface r2) {
            return this.compare(r1.isInheritInstructorPreferences(), r2.isInheritInstructorPreferences());
        }

        public int compareByEvent(DepartmentInterface r1, DepartmentInterface r2) {
            return this.compare(r1.isAllowEvents(), r2.isAllowEvents());
        }

        public int compareByStdntSched(DepartmentInterface r1, DepartmentInterface r2) {
            return this.compare(r1.isAllowStudentScheduling(), r2.isAllowStudentScheduling());
        }

        public int compareByLastChange(DepartmentInterface r1, DepartmentInterface r2) {
            return this.compare(r1.getLastChangeStr(), r2.getLastChangeStr());
        }

        public int compareByExtFundingDept(DepartmentInterface r1, DepartmentInterface r2) {
            return this.compare(r1.isExternalFundingDept(), r2.isExternalFundingDept());
        }

        protected int compareByColumn(DepartmentInterface r1, DepartmentInterface r2) {
            switch (this.iColumn) {
                case CODE: {
                    return this.compareByDeptCode(r1, r2);
                }
                case ABBV: {
                    return this.compareByAbbreviation(r1, r2);
                }
                case NAME: {
                    return this.compareByName(r1, r2);
                }
                case EXTERNAL_MANAGER: {
                    return this.compareByExtMgr(r1, r2);
                }
                case SUBJECTS: {
                    return this.compareBySubjectCount(r1, r2);
                }
                case ROOMS: {
                    return this.compareByRoomCount(r1, r2);
                }
                case STATUS: {
                    return this.compareByStatus(r1, r2);
                }
                case DIST_PREF_PRIORITY: {
                    return this.compareByDistPrefPriority(r1, r2);
                }
                case ALLOW_REQUIRED: {
                    return this.compareByAllowReqd(r1, r2);
                }
                case INSTRUCTOR_PREF: {
                    return this.compareByInstrucPref(r1, r2);
                }
                case EVENTS: {
                    return this.compareByEvent(r1, r2);
                }
                case STUDENT_SCHEDULING: {
                    return this.compareByStdntSched(r1, r2);
                }
                case EXT_FUNDING_DEPT: {
                    return this.compareByExtFundingDept(r1, r2);
                }
                case LAST_CHANGE: {
                    return this.compareByLastChange(r1, r2);
                }
            }
            return this.compareByAbbreviation(r1, r2);
        }

        public static boolean isApplicable(DepartmentInterface.DepartmentsColumn column) {
            switch (column) {
                case CODE: 
                case ABBV: 
                case NAME: 
                case EXTERNAL_MANAGER: 
                case SUBJECTS: 
                case ROOMS: 
                case STATUS: 
                case DIST_PREF_PRIORITY: 
                case ALLOW_REQUIRED: 
                case INSTRUCTOR_PREF: 
                case EVENTS: 
                case STUDENT_SCHEDULING: 
                case EXT_FUNDING_DEPT: 
                case LAST_CHANGE: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public int compare(DepartmentInterface r1, DepartmentInterface r2) {
            int cmp = this.compareByColumn(r1, r2);
            if (cmp == 0) {
                cmp = this.compareByAbbreviation(r1, r2);
            }
            if (cmp == 0) {
                cmp = this.compareById(r1, r2);
            }
            return this.iAsc ? cmp : -cmp;
        }

        @Override
        protected int compare(String s1, String s2) {
            if (s1 == null || s1.isEmpty()) {
                return s2 == null || s2.isEmpty() ? 0 : 1;
            }
            return s2 == null || s2.isEmpty() ? -1 : s1.compareToIgnoreCase(s2);
        }

        @Override
        protected int compare(Number n1, Number n2) {
            return n1 == null ? (n2 == null ? 0 : -1) : (n2 == null ? 1 : Double.compare(n1.doubleValue(), n2.doubleValue()));
        }

        @Override
        protected int compare(Boolean b1, Boolean b2) {
            return -Boolean.compare(b1 != null && b1 != false, b2 != null && b2 != false);
        }
    }

    public static interface SortOperation
    extends UniTimeTableHeader.Operation,
    UniTimeTableHeader.HasColumnName {
    }
}

