/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.export.courses;

import java.io.IOException;
import java.util.List;
import org.springframework.stereotype.Service;
import org.unitime.timetable.export.ExportHelper;
import org.unitime.timetable.export.XLSPrinter;
import org.unitime.timetable.export.courses.OfferingsCSV;
import org.unitime.timetable.gwt.client.tables.TableInterface;
import org.unitime.timetable.security.rights.Right;

@Service(value="org.unitime.timetable.export.Exporter:offerings.xls")
public class OfferingsXLS
extends OfferingsCSV {
    @Override
    public String reference() {
        return "offerings.xls";
    }

    @Override
    public void export(ExportHelper helper) throws IOException {
        this.checkPermission(helper, Right.InstructionalOfferingsExportPDF);
        this.exportDataXls(this.getOfferings(helper), helper);
    }

    protected void exportDataXls(List<TableInterface> response, ExportHelper helper) throws IOException {
        XLSPrinter printer = new XLSPrinter(helper.getOutputStream(), false);
        helper.setup(printer.getContentType(), this.reference(), false);
        boolean first = true;
        for (TableInterface table : response) {
            if (!first) {
                printer.newSheet();
            }
            printer.getWorkbook().setSheetName(printer.getSheetIndex(), table.getName());
            first = false;
            if (table.getHeader() != null) {
                for (TableInterface.LineInterface line : table.getHeader()) {
                    printer.printHeader(this.toLine(line));
                }
            }
            if (table.getLines() == null) continue;
            for (TableInterface.LineInterface line : table.getLines()) {
                printer.printLine(printer.toA(line, false));
            }
        }
        printer.flush();
        printer.close();
    }
}

