/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.test;

import java.util.ArrayList;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.TimePatternDays;
import org.unitime.timetable.model.TimePatternModel;
import org.unitime.timetable.model.TimePatternTime;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.dao._RootDAO;

public class SimpleDefaultPreferences {
    public static void main(String[] args) {
        try {
            Log log = LogFactory.getLog(SimpleDefaultPreferences.class);
            HibernateUtil.configureHibernate(ApplicationProperties.getProperties());
            org.hibernate.Session hibSession = new _RootDAO().getSession();
            Session session = Session.getSessionUsingInitiativeYearTerm(ApplicationProperties.getProperty("initiative", "woebegon"), ApplicationProperties.getProperty("year", "2010"), ApplicationProperties.getProperty("term", "Fal"));
            if (session == null) {
                log.fatal((Object)"Academic session not found, use properties initiative, year, and term to set academic session.");
                System.exit(0);
            }
            TreeSet<TimePattern> patterns = new TreeSet<TimePattern>(TimePattern.findAll(session, (Boolean)true));
            for (InstructionalOffering offering : session.getInstructionalOfferings()) {
                log.info((Object)("Processing " + offering.getCourseName()));
                for (CourseOffering course : offering.getCourseOfferings()) {
                    hibSession.merge((Object)course);
                }
                for (InstrOfferingConfig config : offering.getInstrOfferingConfigs()) {
                    boolean unlimited = config.isUnlimitedEnrollment();
                    if (unlimited) {
                        config.setLimit(100);
                        config.setUnlimitedEnrollment(false);
                    }
                    for (SchedulingSubpart subpart : config.getSchedulingSubparts()) {
                        DatePattern datePattern = null;
                        boolean sameDatePattern = true;
                        TimePattern timePattern = null;
                        boolean sameTimePattern = true;
                        ArrayList<int[]> dateTimes = new ArrayList<int[]>();
                        TreeSet<Location> rooms = null;
                        boolean sameRooms = true;
                        for (Class_ clazz : subpart.getClasses()) {
                            log.info((Object)("-- " + clazz.getClassLabel(hibSession)));
                            if (unlimited) {
                                int limit = (int)Math.ceil(100.0 / (double)subpart.getClasses().size());
                                clazz.setMaxExpectedCapacity(limit);
                                clazz.setExpectedCapacity(limit);
                                clazz.setRoomRatio(Float.valueOf(0.0f));
                            }
                            clazz.getPreferences().clear();
                            Assignment assignment = clazz.getCommittedAssignment();
                            if (datePattern == null) {
                                datePattern = clazz.effectiveDatePattern();
                            } else if (sameDatePattern && !datePattern.equals(clazz.effectiveDatePattern())) {
                                sameDatePattern = false;
                            }
                            if (assignment != null) {
                                TimePatternModel m;
                                Object pattern = null;
                                for (TimePattern p : patterns) {
                                    if (p.getNrMeetings() * p.getMinPerMtg() != subpart.getMinutesPerWk()) continue;
                                    TimePatternDays days = null;
                                    for (TimePatternDays d : p.getDays()) {
                                        if (!d.getDayCode().equals(assignment.getDays())) continue;
                                        days = d;
                                        break;
                                    }
                                    if (days == null) continue;
                                    TimePatternTime time = null;
                                    for (TimePatternTime t : p.getTimes()) {
                                        if (!t.getStartSlot().equals(assignment.getStartSlot())) continue;
                                        time = t;
                                        break;
                                    }
                                    if (time == null) continue;
                                    pattern = p;
                                    break;
                                }
                                if (pattern == null) {
                                    pattern = TimePattern.findExactTime(session.getUniqueId());
                                    if (pattern != null) {
                                        m = ((TimePattern)pattern).getTimePatternModel();
                                        m.setExactDays(assignment.getDays());
                                        m.setExactStartSlot(assignment.getStartSlot());
                                        TimePref tp = new TimePref();
                                        tp.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sRequired));
                                        tp.setTimePatternModel(m);
                                        tp.setOwner(clazz);
                                        clazz.getPreferences().add(tp);
                                    }
                                } else {
                                    m = ((TimePattern)pattern).getTimePatternModel();
                                    for (int d = 0; d < m.getNrDays(); ++d) {
                                        for (int t = 0; t < m.getNrTimes(); ++t) {
                                            if (assignment.getStartSlot().intValue() != m.getStartSlot(t) || assignment.getDays().intValue() != m.getDayCode(d)) continue;
                                            m.setPreference(d, t, PreferenceLevel.sStronglyPreferred);
                                            dateTimes.add(new int[]{d, t});
                                        }
                                    }
                                    if (subpart.getClasses().size() > 1) {
                                        TimePref tp = new TimePref();
                                        tp.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sRequired));
                                        tp.setTimePatternModel(m);
                                        tp.setOwner(clazz);
                                        clazz.getPreferences().add(tp);
                                    }
                                }
                                if (timePattern == null) {
                                    timePattern = pattern;
                                } else if (sameTimePattern && !timePattern.equals(pattern)) {
                                    sameTimePattern = false;
                                }
                            }
                            if (assignment != null) {
                                clazz.setNbrRooms(assignment.getRooms().size());
                                if (rooms == null) {
                                    rooms = new TreeSet<Location>(assignment.getRooms());
                                } else if (sameRooms && !rooms.equals(new TreeSet<Location>(assignment.getRooms()))) {
                                    sameRooms = false;
                                }
                                if (subpart.getClasses().size() > 1) {
                                    for (Location room : assignment.getRooms()) {
                                        RoomPref rp = new RoomPref();
                                        rp.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sStronglyPreferred));
                                        rp.setOwner(clazz);
                                        rp.setRoom(room);
                                        clazz.getPreferences().add(rp);
                                    }
                                }
                            }
                            hibSession.merge((Object)clazz);
                        }
                        if (datePattern != null && sameDatePattern && !datePattern.isDefault()) {
                            subpart.setDatePattern(datePattern);
                            for (Class_ clazz : subpart.getClasses()) {
                                clazz.setDatePattern(null);
                                hibSession.merge((Object)clazz);
                            }
                        }
                        subpart.getPreferences().clear();
                        if (timePattern != null && sameTimePattern && !timePattern.isExactTime()) {
                            TimePref tp = new TimePref();
                            tp.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sRequired));
                            TimePatternModel m = timePattern.getTimePatternModel();
                            if (dateTimes.size() == 1) {
                                for (int[] dt : dateTimes) {
                                    m.setPreference(dt[0], dt[1], PreferenceLevel.sStronglyPreferred);
                                }
                            }
                            tp.setTimePatternModel(m);
                            tp.setOwner(subpart);
                            subpart.getPreferences().add(tp);
                        }
                        if (rooms != null && sameRooms) {
                            for (Location room : rooms) {
                                RoomPref rp = new RoomPref();
                                rp.setPrefLevel(PreferenceLevel.getPreferenceLevel(PreferenceLevel.sStronglyPreferred));
                                rp.setOwner(subpart);
                                rp.setRoom(room);
                                subpart.getPreferences().add(rp);
                            }
                            for (Class_ clazz : subpart.getClasses()) {
                                clazz.getPreferences().removeAll(clazz.getPreferences(RoomPref.class));
                                hibSession.persist((Object)clazz);
                            }
                        }
                        hibSession.merge((Object)subpart);
                    }
                    hibSession.merge((Object)config);
                }
                hibSession.merge((Object)offering);
            }
            log.info((Object)"All done.");
            hibSession.flush();
            hibSession.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

