/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.spring.security;

import java.io.IOException;
import java.net.URLEncoder;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationSuccessHandler;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.unitime.timetable.util.LoginManager;

@Service(value="unitimeAuthenticationSuccessHandler")
public class UniTimeAuthenticationSuccessHandler
extends SimpleUrlAuthenticationSuccessHandler {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private RequestCache requestCache = new HttpSessionRequestCache();
    private boolean useReferer = false;

    public UniTimeAuthenticationSuccessHandler() {
        this.setAlwaysUseDefaultTargetUrl(false);
        this.setDefaultTargetUrl("/selectPrimaryRole.action");
        this.setTargetUrlParameter("target");
    }

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        LoginManager.loginSuceeded(authentication.getName());
        request.getSession().removeAttribute("SUGGEST_PASSWORD_RESET");
        super.onAuthenticationSuccess(request, response, authentication);
    }

    protected String determineTargetUrl(HttpServletRequest request, HttpServletResponse response) {
        SavedRequest savedRequest;
        if (this.isAlwaysUseDefaultTargetUrl()) {
            return this.getDefaultTargetUrl();
        }
        String targetUrl = null;
        if (this.getTargetUrlParameter() != null) {
            targetUrl = request.getParameter(this.getTargetUrlParameter());
        }
        if ((savedRequest = this.requestCache.getRequest(request, response)) != null && !StringUtils.hasText((String)targetUrl)) {
            targetUrl = savedRequest.getRedirectUrl();
        }
        if (this.useReferer && !StringUtils.hasText((String)targetUrl)) {
            targetUrl = request.getHeader("Referer");
        }
        if (StringUtils.hasText((String)targetUrl)) {
            try {
                request.setAttribute("target", (Object)targetUrl);
                return this.getDefaultTargetUrl() + "?" + this.getTargetUrlParameter() + "=" + URLEncoder.encode(targetUrl, "UTF-8");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.getDefaultTargetUrl();
    }

    public void setUseReferer(boolean useReferer) {
        this.useReferer = useReferer;
    }
}

