/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.onlinesectioning.status;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.AssignmentMap;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.online.expectations.OverExpectedCriterion;
import org.unitime.commons.NaturalOrderComparator;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.client.sectioning.SectioningStatusFilterBox;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.server.DayCode;
import org.unitime.timetable.gwt.server.Query;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.model.FixedCreditUnitConfig;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.StudentSectioningStatusDAO;
import org.unitime.timetable.onlinesectioning.AcademicSessionInfo;
import org.unitime.timetable.onlinesectioning.OnlineSectioningAction;
import org.unitime.timetable.onlinesectioning.OnlineSectioningHelper;
import org.unitime.timetable.onlinesectioning.OnlineSectioningServer;
import org.unitime.timetable.onlinesectioning.match.AbstractCourseMatcher;
import org.unitime.timetable.onlinesectioning.model.XConfig;
import org.unitime.timetable.onlinesectioning.model.XCourse;
import org.unitime.timetable.onlinesectioning.model.XCourseId;
import org.unitime.timetable.onlinesectioning.model.XCourseRequest;
import org.unitime.timetable.onlinesectioning.model.XEnrollment;
import org.unitime.timetable.onlinesectioning.model.XEnrollments;
import org.unitime.timetable.onlinesectioning.model.XExpectations;
import org.unitime.timetable.onlinesectioning.model.XInstructor;
import org.unitime.timetable.onlinesectioning.model.XOffering;
import org.unitime.timetable.onlinesectioning.model.XOverride;
import org.unitime.timetable.onlinesectioning.model.XRequest;
import org.unitime.timetable.onlinesectioning.model.XRoom;
import org.unitime.timetable.onlinesectioning.model.XSection;
import org.unitime.timetable.onlinesectioning.model.XStudent;
import org.unitime.timetable.onlinesectioning.model.XStudentId;
import org.unitime.timetable.onlinesectioning.model.XSubpart;
import org.unitime.timetable.onlinesectioning.solver.SectioningRequest;
import org.unitime.timetable.onlinesectioning.status.SectioningStatusFilterAction;
import org.unitime.timetable.onlinesectioning.status.StatusPageSuggestionsAction;
import org.unitime.timetable.solver.studentsct.StudentSolver;

public class FindEnrollmentInfoAction
implements OnlineSectioningAction<List<ClassAssignmentInterface.EnrollmentInfo>> {
    private static final long serialVersionUID = 1L;
    protected static StudentSectioningMessages MSG = Localization.create(StudentSectioningMessages.class);
    protected Query iQuery;
    protected Integer iLimit = null;
    protected Long iCourseId;
    protected Set<Long> iCoursesIcoordinate;
    protected Set<Long> iCoursesIcanApprove;
    protected Set<Long> iMyStudents;
    protected Set<String> iSubjectAreas;
    protected boolean iShowUnmatchedClasses = true;
    protected boolean iShowUnmatchedCourses = true;
    protected SectioningStatusFilterBox.SectioningStatusFilterRpcRequest iFilter = null;

    public FindEnrollmentInfoAction withParams(String query, Long courseId, Set<Long> coursesIcoordinage, Set<Long> coursesIcanApprove, Set<Long> myStudents, Set<String> subjects) {
        this.iQuery = new Query(query);
        this.iCourseId = courseId;
        this.iCoursesIcanApprove = coursesIcanApprove;
        this.iCoursesIcoordinate = coursesIcoordinage;
        this.iMyStudents = myStudents;
        this.iSubjectAreas = subjects;
        Matcher m = Pattern.compile("limit:[ ]?([0-9]*)", 2).matcher(query);
        if (m.find()) {
            this.iLimit = Integer.parseInt(m.group(1));
        }
        return this;
    }

    public FindEnrollmentInfoAction showUnmatchedClasses(boolean showUnmatchedClasses) {
        this.iShowUnmatchedClasses = showUnmatchedClasses;
        return this;
    }

    public FindEnrollmentInfoAction showUnmatchedCourses(boolean showUnmatchedCourses) {
        this.iShowUnmatchedCourses = showUnmatchedCourses;
        return this;
    }

    public FindEnrollmentInfoAction withFilter(SectioningStatusFilterBox.SectioningStatusFilterRpcRequest filter) {
        this.iFilter = filter;
        return this;
    }

    public boolean isMyStudent(XStudentId student) {
        return this.iMyStudents != null && this.iMyStudents.contains(student.getStudentId());
    }

    public Query query() {
        return this.iQuery;
    }

    public Integer limit() {
        return this.iLimit;
    }

    public Long courseId() {
        return this.iCourseId;
    }

    public boolean isCourseVisible(Long courseId) {
        return this.iCoursesIcoordinate == null || this.iCoursesIcoordinate.contains(courseId);
    }

    public boolean isConsentToDoCourse(XCourse course) {
        return this.iCoursesIcanApprove != null && course.getConsentLabel() != null && this.iCoursesIcanApprove.contains(course.getCourseId());
    }

    public boolean hasMatchingSubjectArea(String subject) {
        return this.iSubjectAreas == null || this.iSubjectAreas.contains(subject);
    }

    Map<Long, Integer> getClassSnapshots(Long courseId, OnlineSectioningHelper helper) {
        HashMap<Long, Integer> ret = new HashMap<Long, Integer>();
        for (Object[] o : helper.getHibSession().createQuery("select c.uniqueId, c.snapshotLimit from Class_ c inner join c.schedulingSubpart.instrOfferingConfig.instructionalOffering.courseOfferings co where co.uniqueId = :courseId", Object[].class).setParameter("courseId", (Object)courseId).setCacheable(true).list()) {
            Long classId = (Long)o[0];
            Integer limit = (Integer)o[1];
            ret.put(classId, limit);
        }
        return ret;
    }

    Map<Long, Integer> getOfferingSnapshots(Collection<? extends XCourseId> courseIds, OnlineSectioningHelper helper) {
        HashMap<Long, Integer> ret = new HashMap<Long, Integer>();
        ArrayList<Long> ids = new ArrayList<Long>(1000);
        for (XCourseId xCourseId : courseIds) {
            ids.add(xCourseId.getOfferingId());
            if (ids.size() != 1000) continue;
            for (Object[] o : helper.getHibSession().createQuery("select io.uniqueId, io.snapshotLimit from InstructionalOffering io where io.uniqueId in :ids", Object[].class).setParameterList("ids", ids, Long.class).setCacheable(true).list()) {
                Long classId = (Long)o[0];
                Integer limit = (Integer)o[1];
                ret.put(classId, limit);
            }
            ids.clear();
        }
        if (!ids.isEmpty()) {
            for (Object[] objectArray : helper.getHibSession().createQuery("select io.uniqueId, io.snapshotLimit from InstructionalOffering io where io.uniqueId in :ids", Object[].class).setParameterList("ids", ids, Long.class).setCacheable(true).list()) {
                Long classId = (Long)objectArray[0];
                Integer limit = (Integer)objectArray[1];
                ret.put(classId, limit);
            }
        }
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<ClassAssignmentInterface.EnrollmentInfo> execute(OnlineSectioningServer server, OnlineSectioningHelper helper) {
        ArrayList<ClassAssignmentInterface.EnrollmentInfo> ret = new ArrayList<ClassAssignmentInterface.EnrollmentInfo>();
        AcademicSessionInfo session = server.getAcademicSession();
        StatusPageSuggestionsAction.CourseLookup lookup = new StatusPageSuggestionsAction.CourseLookup(session);
        boolean solver = server instanceof StudentSolver;
        Set<Long> studentIds = null;
        if (!solver) {
            studentIds = this.iFilter == null ? null : server.createAction(SectioningStatusFilterAction.class).forRequest(this.iFilter).getStudentIds(server, helper);
        }
        HashSet<String> wlStates = new HashSet<String>();
        HashSet<String> noSubStates = new HashSet<String>();
        Session dbSession = (Session)SessionDAO.getInstance().get(session.getUniqueId());
        for (StudentSectioningStatus status : StudentSectioningStatusDAO.getInstance().findAll(helper.getHibSession())) {
            if (StudentSectioningStatus.hasEffectiveOption(status, dbSession, StudentSectioningStatus.Option.waitlist)) {
                wlStates.add(status.getReference());
                continue;
            }
            if (!StudentSectioningStatus.hasEffectiveOption(status, dbSession, StudentSectioningStatus.Option.nosubs)) continue;
            noSubStates.add(status.getReference());
        }
        OnlineSectioningInterface.WaitListMode defaultWL = null;
        if (server instanceof StudentSolver) {
            defaultWL = OnlineSectioningInterface.WaitListMode.NoSubs;
        }
        if (this.iShowUnmatchedCourses && !SectioningStatusFilterAction.hasNoMatchCourses(this.iFilter, helper)) {
            this.iShowUnmatchedCourses = false;
        }
        if (this.courseId() == null) {
            HashSet<Long> students = new HashSet<Long>();
            HashSet<Long> matchingStudents = new HashSet<Long>();
            int gEnrl = 0;
            int gWait = 0;
            int gRes = 0;
            int gUnasg = 0;
            int gUnasgPrim = 0;
            int gNoSub = 0;
            int gSwap = 0;
            int gtEnrl = 0;
            int gtWait = 0;
            int gtRes = 0;
            int gtUnasg = 0;
            int gtUnasgPrim = 0;
            int gtNoSub = 0;
            int gtSwap = 0;
            int gConNeed = 0;
            int gtConNeed = 0;
            int gOvrNeed = 0;
            int gtOvrNeed = 0;
            Collection<? extends XCourseId> courses = server.findCourses(new FindEnrollmentInfoCourseMatcher(this.iCoursesIcoordinate, this.iCoursesIcanApprove, this.iSubjectAreas, this.iQuery, lookup, server));
            Map<Long, Integer> snapshots = this.getOfferingSnapshots(courses, helper);
            for (XCourseId xCourseId : courses) {
                int n;
                int n2;
                XCourse course;
                XOffering offering = server.getOffering(xCourseId.getOfferingId());
                if (offering == null || (course = offering.getCourse(xCourseId.getCourseId())) == null) continue;
                XEnrollments enrollments = server.getEnrollments(xCourseId.getOfferingId());
                boolean isConsentToDoCourse = this.isConsentToDoCourse(course);
                ClassAssignmentInterface.EnrollmentInfo e = new ClassAssignmentInterface.EnrollmentInfo();
                e.setCourseId(xCourseId.getCourseId());
                e.setOfferingId(offering.getOfferingId());
                e.setSubject(course.getSubjectArea());
                e.setCourseNbr(course.getCourseNumber());
                e.setTitle(course.getTitle());
                e.setConsent(course.getConsentAbbv());
                e.setControl(course.isControlling());
                int match = 0;
                int enrl = 0;
                int wait = 0;
                int res = 0;
                int unasg = 0;
                int unasgPrim = 0;
                int noSub = 0;
                int n3 = 0;
                int tEnrl = 0;
                int tWait = 0;
                int tRes = 0;
                int tUnasg = 0;
                int tUnasgPrim = 0;
                int tNoSub = 0;
                int tSwap = 0;
                int conNeed = 0;
                int tConNeed = 0;
                int ovrNeed = 0;
                int tOvrNeed = 0;
                HashSet<Long> addedStudents = new HashSet<Long>();
                boolean checkOverrides = !this.query().hasAttribute("override");
                for (XCourseRequest xCourseRequest : enrollments.getRequests()) {
                    XStudent student;
                    XOverride override;
                    if (!xCourseRequest.hasCourse(xCourseId.getCourseId())) continue;
                    if (students.add(xCourseRequest.getStudentId())) {
                        addedStudents.add(xCourseRequest.getStudentId());
                    }
                    if (xCourseRequest.getEnrollment() != null && !xCourseRequest.getEnrollment().getCourseId().equals(xCourseId.getCourseId()) || checkOverrides && xCourseRequest.getEnrollment() == null && (override = xCourseRequest.getOverride(xCourseId)) != null && !override.isApproved() && !override.isNotNeeded() || (student = server.getStudent(xCourseRequest.getStudentId())) == null) continue;
                    String status = student.getStatus() == null ? session.getDefaultSectioningStatus() : student.getStatus();
                    OnlineSectioningInterface.WaitListMode wl = OnlineSectioningInterface.WaitListMode.None;
                    if (defaultWL != null) {
                        wl = defaultWL;
                    } else if (status == null || wlStates.contains(status)) {
                        wl = OnlineSectioningInterface.WaitListMode.WaitList;
                    } else if (noSubStates.contains(status)) {
                        wl = OnlineSectioningInterface.WaitListMode.NoSubs;
                    }
                    if (studentIds != null && !studentIds.contains(xCourseRequest.getStudentId())) {
                        if (xCourseRequest.getEnrollment() != null) {
                            ++tEnrl;
                            if (xCourseRequest.getEnrollment().getReservation() != null) {
                                ++tRes;
                            }
                            if (course.getConsentLabel() != null && xCourseRequest.getEnrollment().getApproval() == null) {
                                ++tConNeed;
                            }
                            if (!xCourseRequest.isWaitlist(wl) || !xCourseRequest.getEnrollment().equals(xCourseRequest.getWaitListSwapWithCourseOffering())) continue;
                            ++tSwap;
                            continue;
                        }
                        if (student == null || !student.canAssign(xCourseRequest, wl)) continue;
                        ++tUnasg;
                        if (xCourseRequest.isAlternative() || !xCourseRequest.isPrimary(xCourseId)) continue;
                        ++tUnasgPrim;
                        if (xCourseRequest.isWaitlist(wl)) {
                            ++tWait;
                        }
                        if (!xCourseRequest.isNoSub(wl)) continue;
                        ++tNoSub;
                        continue;
                    }
                    StatusPageSuggestionsAction.CourseRequestMatcher m = new StatusPageSuggestionsAction.CourseRequestMatcher(session, course, student, offering, xCourseRequest, isConsentToDoCourse, this.isMyStudent(student), lookup, server, wl);
                    if (this.query().match(m)) {
                        matchingStudents.add(xCourseRequest.getStudentId());
                        ++match;
                        if (m.enrollment() != null) {
                            ++enrl;
                            if (m.enrollment().getReservation() != null) {
                                ++res;
                            }
                            if (course.getConsentLabel() != null && m.enrollment().getApproval() == null) {
                                ++conNeed;
                            }
                            if (m.request().isWaitlist(wl) && m.request().getEnrollment().equals(m.request().getWaitListSwapWithCourseOffering())) {
                                ++n3;
                            }
                        } else if (m.student().canAssign(m.request(), wl)) {
                            ++unasg;
                            if (!m.request().isAlternative() && m.request().isPrimary(xCourseId)) {
                                ++unasgPrim;
                                if (m.request().isWaitlist(wl)) {
                                    ++wait;
                                }
                                if (m.request().isNoSub(wl)) {
                                    ++noSub;
                                }
                            }
                        }
                        if (m.request().isOverridePending(course)) {
                            ++ovrNeed;
                        }
                    } else if (solver) {
                        if (xCourseRequest.getEnrollment() != null) {
                            ++tEnrl;
                            if (xCourseRequest.getEnrollment().getReservation() != null) {
                                ++tRes;
                            }
                            if (course.getConsentLabel() != null && xCourseRequest.getEnrollment().getApproval() == null) {
                                ++tConNeed;
                            }
                            if (!xCourseRequest.isWaitlist(wl) || !xCourseRequest.getEnrollment().equals(xCourseRequest.getWaitListSwapWithCourseOffering())) continue;
                            ++tSwap;
                            continue;
                        }
                        if (student == null || !student.canAssign(xCourseRequest, wl)) continue;
                        ++tUnasg;
                        if (xCourseRequest.isAlternative() || !xCourseRequest.isPrimary(xCourseId)) continue;
                        ++tUnasgPrim;
                        if (xCourseRequest.isWaitlist(wl)) {
                            ++tWait;
                        }
                        if (!xCourseRequest.isNoSub(wl)) continue;
                        ++tNoSub;
                        continue;
                    }
                    if (m.enrollment() != null) {
                        ++tEnrl;
                        if (m.enrollment().getReservation() != null) {
                            ++tRes;
                        }
                        if (course.getConsentLabel() != null && m.enrollment().getApproval() == null) {
                            ++tConNeed;
                        }
                        if (m.request().isWaitlist(wl) && m.request().getEnrollment().equals(m.request().getWaitListSwapWithCourseOffering())) {
                            ++tSwap;
                        }
                    } else if (m.student().canAssign(m.request(), wl)) {
                        ++tUnasg;
                        if (!m.request().isAlternative() && m.request().isPrimary(xCourseId)) {
                            ++tUnasgPrim;
                            if (m.request().isWaitlist(wl)) {
                                ++tWait;
                            }
                            if (m.request().isNoSub(wl)) {
                                ++tNoSub;
                            }
                        }
                    }
                    if (!m.request().isOverridePending(course)) continue;
                    ++tOvrNeed;
                }
                if (match == 0 && !this.iShowUnmatchedCourses) {
                    students.removeAll(addedStudents);
                    continue;
                }
                e.setNoMatch(match == 0);
                gEnrl += enrl;
                gWait += wait;
                gNoSub += noSub;
                gSwap += n3;
                gUnasg += unasg;
                gUnasgPrim += unasgPrim;
                gRes += res;
                gConNeed += conNeed;
                gOvrNeed += ovrNeed;
                gtEnrl += tEnrl;
                gtWait += tWait;
                gtNoSub += tNoSub;
                gtSwap += tSwap;
                gtUnasg += tUnasg;
                gtUnasgPrim += tUnasgPrim;
                gtRes += tRes;
                gtConNeed += tConNeed;
                gtOvrNeed += tOvrNeed;
                int limit = 0;
                for (XConfig config : offering.getConfigs()) {
                    if (config.getLimit() < 0) {
                        limit = -1;
                        break;
                    }
                    limit += config.getLimit();
                }
                e.setLimit(course.getLimit());
                e.setProjection(course.getProjected());
                e.setSnapshot(snapshots.get(course.getOfferingId()));
                int n4 = Math.max(0, offering.getUnreservedSpace(enrollments));
                if (course.getLimit() >= 0 && n4 > course.getLimit() - enrollments.countEnrollmentsForCourse(xCourseId.getCourseId())) {
                    n2 = course.getLimit() - enrollments.countEnrollmentsForCourse(xCourseId.getCourseId());
                }
                if (n2 == Integer.MAX_VALUE) {
                    n = -1;
                }
                e.setAvailable(n);
                if (n >= 0) {
                    int other = 0;
                    for (XCourse c : offering.getCourses()) {
                        if (c.equals(course)) continue;
                        other += enrollments.countEnrollmentsForCourse(c.getCourseId());
                    }
                    e.setOther(Math.min(course.getLimit() - enrollments.countEnrollmentsForCourse(xCourseId.getCourseId()) - n, other));
                    int lim = 0;
                    for (XConfig f : offering.getConfigs()) {
                        if (lim < 0 || f.getLimit() < 0) {
                            lim = -1;
                            continue;
                        }
                        lim += f.getLimit();
                    }
                    if (lim >= 0 && lim < course.getLimit()) {
                        e.setOther(e.getOther() + course.getLimit() - limit);
                    }
                }
                e.setEnrollment(enrl);
                e.setReservation(res);
                e.setWaitlist(wait);
                e.setNoSub(noSub);
                e.setSwap(n3);
                e.setUnassigned(unasg);
                e.setUnassignedPrimary(unasgPrim);
                e.setTotalEnrollment(tEnrl);
                e.setTotalReservation(tRes);
                e.setTotalWaitlist(tWait);
                e.setTotalSwap(tSwap);
                e.setTotalNoSub(tNoSub);
                e.setTotalUnassigned(tUnasg);
                e.setTotalUnassignedPrimary(tUnasgPrim);
                e.setConsentNeeded(conNeed);
                e.setTotalConsentNeeded(tConNeed);
                e.setOverrideNeeded(ovrNeed);
                e.setTotalOverrideNeeded(tOvrNeed);
                ret.add(e);
                if (this.limit() == null || ret.size() < this.limit()) continue;
                break;
            }
            final NaturalOrderComparator noc = new NaturalOrderComparator();
            Collections.sort(ret, new Comparator<ClassAssignmentInterface.EnrollmentInfo>(){

                @Override
                public int compare(ClassAssignmentInterface.EnrollmentInfo e1, ClassAssignmentInterface.EnrollmentInfo e2) {
                    int cmp = noc.compare(e1.getSubject(), e2.getSubject());
                    if (cmp != 0) {
                        return cmp;
                    }
                    cmp = e1.getCourseNbr().compareTo(e2.getCourseNbr());
                    if (cmp != 0) {
                        return cmp;
                    }
                    return 0;
                }
            });
            ClassAssignmentInterface.EnrollmentInfo enrollmentInfo = new ClassAssignmentInterface.EnrollmentInfo();
            enrollmentInfo.setSubject(MSG.total());
            enrollmentInfo.setCourseNbr("");
            enrollmentInfo.setLimit(students.size());
            enrollmentInfo.setAvailable(matchingStudents.size());
            enrollmentInfo.setEnrollment(gEnrl);
            enrollmentInfo.setReservation(gRes);
            enrollmentInfo.setWaitlist(gWait);
            enrollmentInfo.setNoSub(gNoSub);
            enrollmentInfo.setSwap(gSwap);
            enrollmentInfo.setUnassigned(gUnasg);
            enrollmentInfo.setUnassignedPrimary(gUnasgPrim);
            enrollmentInfo.setTotalEnrollment(gtEnrl);
            enrollmentInfo.setTotalReservation(gtRes);
            enrollmentInfo.setTotalWaitlist(gtWait);
            enrollmentInfo.setTotalNoSub(gtNoSub);
            enrollmentInfo.setTotalSwap(gtSwap);
            enrollmentInfo.setTotalUnassigned(gtUnasg);
            enrollmentInfo.setTotalUnassignedPrimary(gtUnasgPrim);
            enrollmentInfo.setConsentNeeded(gConNeed);
            enrollmentInfo.setTotalConsentNeeded(gtConNeed);
            enrollmentInfo.setOverrideNeeded(gOvrNeed);
            enrollmentInfo.setTotalOverrideNeeded(gtOvrNeed);
            ret.add(enrollmentInfo);
        } else {
            ClassAssignmentInterface.EnrollmentInfo e;
            Map<Long, Integer> snapshots = this.getClassSnapshots(this.courseId(), helper);
            XCourse info = server.getCourse(this.courseId());
            if (info == null) {
                return ret;
            }
            final XOffering offering = server.getOffering(info.getOfferingId());
            if (offering == null) {
                return ret;
            }
            XCourse course = offering.getCourse(info.getCourseId());
            if (course == null) {
                return ret;
            }
            XEnrollments enrollments = server.getEnrollments(info.getOfferingId());
            OverExpectedCriterion overExp = server.getOverExpectedCriterion();
            XExpectations expectations = server.getExpectations(info.getOfferingId());
            boolean isConsentToDoCourse = this.isConsentToDoCourse(info);
            ArrayList<XSection> sections = new ArrayList<XSection>();
            for (XConfig config : offering.getConfigs()) {
                for (XSubpart subpart : config.getSubparts()) {
                    sections.addAll(subpart.getSections());
                }
            }
            Collections.sort(sections, new Comparator<XSection>(){

                @Override
                public int compare(XConfig c1, XConfig c2) {
                    int cmp = c1.getName().compareToIgnoreCase(c2.getName());
                    if (cmp != 0) {
                        return cmp;
                    }
                    return c1.getConfigId().compareTo(c2.getConfigId());
                }

                public boolean isParent(XSubpart s1, XSubpart s2) {
                    XSubpart p1;
                    XSubpart xSubpart = p1 = s1.getParentId() == null ? null : offering.getSubpart(s1.getParentId());
                    if (p1 == null) {
                        return false;
                    }
                    if (p1.equals(s2)) {
                        return true;
                    }
                    return this.isParent(p1, s2);
                }

                @Override
                public int compare(XSubpart s1, XSubpart s2) {
                    int cmp = this.compare(offering.getConfig(s1.getConfigId()), offering.getConfig(s2.getConfigId()));
                    if (cmp != 0) {
                        return cmp;
                    }
                    if (this.isParent(s1, s2)) {
                        return 1;
                    }
                    if (this.isParent(s2, s1)) {
                        return -1;
                    }
                    cmp = s1.getInstructionalType().compareTo(s2.getInstructionalType());
                    if (cmp != 0) {
                        return cmp;
                    }
                    return s1.getSubpartId().compareTo(s2.getSubpartId());
                }

                @Override
                public int compare(XSection s1, XSection s2) {
                    if (s1.getSubpartId().equals(s2.getSubpartId())) {
                        int cmp;
                        if (s1.getParentId() != null && (cmp = this.compare(offering.getSection(s1.getParentId()), offering.getSection(s2.getParentId()))) != 0) {
                            return cmp;
                        }
                        try {
                            cmp = Integer.valueOf(s1.getName(FindEnrollmentInfoAction.this.courseId()) == null ? "0" : s1.getName(FindEnrollmentInfoAction.this.courseId())).compareTo(Integer.valueOf(s2.getName(FindEnrollmentInfoAction.this.courseId()) == null ? "0" : s2.getName(FindEnrollmentInfoAction.this.courseId())));
                            if (cmp != 0) {
                                return cmp;
                            }
                        }
                        catch (NumberFormatException cmp2) {
                            // empty catch block
                        }
                        cmp = (s1.getName(FindEnrollmentInfoAction.this.courseId()) == null ? "" : s1.getName(FindEnrollmentInfoAction.this.courseId())).compareTo(s2.getName(FindEnrollmentInfoAction.this.courseId()) == null ? "" : s2.getName(FindEnrollmentInfoAction.this.courseId()));
                        if (cmp != 0) {
                            return cmp;
                        }
                        return s1.getSectionId().compareTo(s2.getSectionId());
                    }
                    XSection x = s1;
                    while (x != null) {
                        if (this.isParent(offering.getSubpart(s2.getSubpartId()), offering.getSubpart(x.getSubpartId()))) {
                            XSection s = offering.getSection(s2.getParentId());
                            while (!s.getSubpartId().equals(x.getSubpartId())) {
                                s = offering.getSection(s.getParentId());
                            }
                            int cmp = this.compare(x, s);
                            return cmp == 0 ? (x.equals(s1) ? -1 : this.compare(offering.getSubpart(x.getSubpartId()), offering.getSubpart(s.getSubpartId()))) : cmp;
                        }
                        x = offering.getSection(x.getParentId());
                    }
                    x = s2;
                    while (x != null) {
                        if (this.isParent(offering.getSubpart(s1.getSubpartId()), offering.getSubpart(x.getSubpartId()))) {
                            XSection s = offering.getSection(s1.getParentId());
                            while (!s.getSubpartId().equals(x.getSubpartId())) {
                                s = offering.getSection(s.getParentId());
                            }
                            int cmp = this.compare(s, x);
                            return cmp == 0 ? (x.equals(s2) ? 1 : this.compare(offering.getSubpart(s.getSubpartId()), offering.getSubpart(x.getSubpartId()))) : cmp;
                        }
                        x = offering.getSection(x.getParentId());
                    }
                    int cmp = this.compare(offering.getSubpart(s1.getSubpartId()), offering.getSubpart(s2.getSubpartId()));
                    if (cmp != 0) {
                        return cmp;
                    }
                    try {
                        cmp = Integer.valueOf(s1.getName(FindEnrollmentInfoAction.this.courseId()) == null ? "0" : s1.getName(FindEnrollmentInfoAction.this.courseId())).compareTo(Integer.valueOf(s2.getName(FindEnrollmentInfoAction.this.courseId()) == null ? "0" : s2.getName(FindEnrollmentInfoAction.this.courseId())));
                        if (cmp != 0) {
                            return cmp;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    cmp = (s1.getName(FindEnrollmentInfoAction.this.courseId()) == null ? "" : s1.getName(FindEnrollmentInfoAction.this.courseId())).compareTo(s2.getName(FindEnrollmentInfoAction.this.courseId()) == null ? "" : s2.getName(FindEnrollmentInfoAction.this.courseId()));
                    if (cmp != 0) {
                        return cmp;
                    }
                    return s1.getSectionId().compareTo(s2.getSectionId());
                }
            });
            boolean checkOverrides = !this.query().hasAttribute("override");
            HashMap section2students = new HashMap();
            for (XCourseRequest request : enrollments.getRequests()) {
                XOverride override;
                if (request.getEnrollment() != null || !request.hasCourse(this.courseId())) continue;
                XStudent student = server.getStudent(request.getStudentId());
                String status = student.getStatus() == null ? session.getDefaultSectioningStatus() : student.getStatus();
                OnlineSectioningInterface.WaitListMode wl = OnlineSectioningInterface.WaitListMode.None;
                if (defaultWL != null) {
                    wl = defaultWL;
                } else if (status == null || wlStates.contains(status)) {
                    wl = OnlineSectioningInterface.WaitListMode.WaitList;
                } else if (noSubStates.contains(status)) {
                    wl = OnlineSectioningInterface.WaitListMode.NoSubs;
                }
                if (student == null || !student.canAssign(request, wl) || checkOverrides && request.getEnrollment() == null && (override = request.getOverride(info)) != null && !override.isApproved() && !override.isNotNeeded()) continue;
                AssignmentMap assignment = new AssignmentMap();
                CourseRequest r = SectioningRequest.convert((Assignment<Request, Enrollment>)assignment, request, server, wl, helper);
                StatusPageSuggestionsAction.CourseRequestMatcher m = new StatusPageSuggestionsAction.CourseRequestMatcher(session, info, student, offering, request, isConsentToDoCourse, this.isMyStudent(student), lookup, server, wl);
                block9: for (Enrollment en : r.values((Assignment)assignment)) {
                    if (!this.query().match(m.setEnrollment(new XEnrollment(en)))) continue;
                    for (Request x : r.getStudent().getRequests()) {
                        Enrollment enrollment = (Enrollment)assignment.getValue((Variable)x);
                        if (x.equals((Object)r) || enrollment == null || !enrollment.isOverlapping(en)) continue;
                        continue block9;
                    }
                    for (Section s : en.getSections()) {
                        void var35_82;
                        Set set = (Set)section2students.get(s.getId());
                        if (set == null) {
                            HashSet hashSet = new HashSet();
                            section2students.put(s.getId(), hashSet);
                        }
                        var35_82.add(student.getStudentId());
                    }
                }
            }
            if (offering.getCourses().size() > 1) {
                for (XCourse other : offering.getCourses()) {
                    void var35_84;
                    if (other.equals(course)) continue;
                    e = new ClassAssignmentInterface.EnrollmentInfo();
                    e.setCourseId(other.getCourseId());
                    e.setOfferingId(offering.getOfferingId());
                    e.setSubject(other.getSubjectArea());
                    e.setCourseNbr(other.getCourseNumber());
                    e.setTitle(other.getTitle());
                    e.setConsent(other.getConsentAbbv());
                    e.setControl(other.isControlling());
                    e.setConfigId(-1L);
                    e.setMasterCourseId(course.getCourseId());
                    e.setMasterSubject(course.getSubjectArea());
                    e.setMasterCourseNbr(course.getCourseNumber());
                    int enrl = 0;
                    int wait = 0;
                    int res = 0;
                    int unasg = 0;
                    int unasgPrim = 0;
                    int noSub = 0;
                    int swap = 0;
                    int tEnrl = 0;
                    int tWait = 0;
                    boolean bl = false;
                    int tUnasg = 0;
                    int tUnasgPrim = 0;
                    int tNoSub = 0;
                    int tSwap = 0;
                    int conNeed = 0;
                    int tConNeed = 0;
                    int ovrNeed = 0;
                    int tOvrNeed = 0;
                    for (XCourseRequest request : enrollments.getRequests()) {
                        void var48_128;
                        XStudent student;
                        XOverride override;
                        if (!request.hasCourse(other.getCourseId()) || request.getEnrollment() != null && !request.getEnrollment().getCourseId().equals(other.getCourseId()) || checkOverrides && request.getEnrollment() == null && (override = request.getOverride(other)) != null && !override.isApproved() && !override.isNotNeeded() || (student = server.getStudent(request.getStudentId())) == null) continue;
                        String status = student.getStatus() == null ? session.getDefaultSectioningStatus() : student.getStatus();
                        OnlineSectioningInterface.WaitListMode waitListMode = OnlineSectioningInterface.WaitListMode.None;
                        if (defaultWL != null) {
                            OnlineSectioningInterface.WaitListMode waitListMode2 = defaultWL;
                        } else if (status == null || wlStates.contains(status)) {
                            OnlineSectioningInterface.WaitListMode waitListMode3 = OnlineSectioningInterface.WaitListMode.WaitList;
                        } else if (noSubStates.contains(status)) {
                            OnlineSectioningInterface.WaitListMode waitListMode4 = OnlineSectioningInterface.WaitListMode.NoSubs;
                        }
                        if (studentIds != null && !studentIds.contains(request.getStudentId())) {
                            if (request.getEnrollment() != null) {
                                ++tEnrl;
                                if (request.getEnrollment().getReservation() != null) {
                                    ++var35_84;
                                }
                                if (other.getConsentLabel() != null && request.getEnrollment().getApproval() == null) {
                                    ++tConNeed;
                                }
                                if (!request.isWaitlist((OnlineSectioningInterface.WaitListMode)var48_128) || !request.getEnrollment().equals(request.getWaitListSwapWithCourseOffering())) continue;
                                ++tSwap;
                                continue;
                            }
                            if (student == null || !student.canAssign(request, (OnlineSectioningInterface.WaitListMode)var48_128)) continue;
                            ++tUnasg;
                            if (request.isAlternative() || !request.isPrimary(other)) continue;
                            ++tUnasgPrim;
                            if (request.isWaitlist((OnlineSectioningInterface.WaitListMode)var48_128)) {
                                ++tWait;
                            }
                            if (!request.isNoSub((OnlineSectioningInterface.WaitListMode)var48_128)) continue;
                            ++tNoSub;
                            continue;
                        }
                        StatusPageSuggestionsAction.CourseRequestMatcher m = new StatusPageSuggestionsAction.CourseRequestMatcher(session, other, student, offering, request, isConsentToDoCourse, this.isMyStudent(student), lookup, server, (OnlineSectioningInterface.WaitListMode)var48_128);
                        if (this.query().match(m)) {
                            if (m.enrollment() != null) {
                                ++enrl;
                                if (m.enrollment().getReservation() != null) {
                                    ++res;
                                }
                                if (other.getConsentLabel() != null && m.enrollment().getApproval() == null) {
                                    ++conNeed;
                                }
                                if (m.request().isWaitlist((OnlineSectioningInterface.WaitListMode)var48_128) && m.request().getEnrollment().equals(m.request().getWaitListSwapWithCourseOffering())) {
                                    ++swap;
                                }
                            } else if (m.student().canAssign(m.request(), (OnlineSectioningInterface.WaitListMode)var48_128)) {
                                ++unasg;
                                if (!m.request().isAlternative() && m.request().isPrimary(other)) {
                                    ++unasgPrim;
                                    if (m.request().isWaitlist((OnlineSectioningInterface.WaitListMode)var48_128)) {
                                        ++wait;
                                    }
                                    if (m.request().isNoSub((OnlineSectioningInterface.WaitListMode)var48_128)) {
                                        ++noSub;
                                    }
                                }
                            }
                            if (m.request().isOverridePending(other)) {
                                ++ovrNeed;
                            }
                        } else if (solver) {
                            if (request.getEnrollment() != null) {
                                ++tEnrl;
                                if (request.getEnrollment().getReservation() != null) {
                                    ++var35_84;
                                }
                                if (other.getConsentLabel() != null && request.getEnrollment().getApproval() == null) {
                                    ++tConNeed;
                                }
                                if (!request.isWaitlist((OnlineSectioningInterface.WaitListMode)var48_128) || !request.getEnrollment().equals(request.getWaitListSwapWithCourseOffering())) continue;
                                ++tSwap;
                                continue;
                            }
                            if (student == null || !student.canAssign(request, (OnlineSectioningInterface.WaitListMode)var48_128)) continue;
                            ++tUnasg;
                            if (request.isAlternative() || !request.isPrimary(other)) continue;
                            ++tUnasgPrim;
                            if (request.isWaitlist((OnlineSectioningInterface.WaitListMode)var48_128)) {
                                ++tWait;
                            }
                            if (!request.isNoSub((OnlineSectioningInterface.WaitListMode)var48_128)) continue;
                            ++tNoSub;
                            continue;
                        }
                        if (m.enrollment() != null) {
                            ++tEnrl;
                            if (m.enrollment().getReservation() != null) {
                                ++var35_84;
                            }
                            if (other.getConsentLabel() != null && m.enrollment().getApproval() == null) {
                                ++tConNeed;
                            }
                            if (m.request().isWaitlist((OnlineSectioningInterface.WaitListMode)var48_128) && m.request().getEnrollment().equals(m.request().getWaitListSwapWithCourseOffering())) {
                                ++tSwap;
                            }
                        } else if (m.student().canAssign(m.request(), (OnlineSectioningInterface.WaitListMode)var48_128)) {
                            ++tUnasg;
                            if (!m.request().isAlternative() && m.request().isPrimary(other)) {
                                ++tUnasgPrim;
                                if (m.request().isWaitlist((OnlineSectioningInterface.WaitListMode)var48_128)) {
                                    ++tWait;
                                }
                                if (m.request().isNoSub((OnlineSectioningInterface.WaitListMode)var48_128)) {
                                    ++tNoSub;
                                }
                            }
                        }
                        if (!m.request().isOverridePending(other)) continue;
                        ++tOvrNeed;
                    }
                    int limit = 0;
                    for (XConfig config : offering.getConfigs()) {
                        if (config.getLimit() < 0) {
                            limit = -1;
                            break;
                        }
                        limit += config.getLimit();
                    }
                    e.setLimit(other.getLimit());
                    e.setProjection(other.getProjected());
                    int av = Math.max(0, offering.getUnreservedSpace(enrollments));
                    if (other.getLimit() >= 0 && av > other.getLimit() - enrollments.countEnrollmentsForCourse(other.getCourseId())) {
                        av = other.getLimit() - enrollments.countEnrollmentsForCourse(other.getCourseId());
                    }
                    if (av == Integer.MAX_VALUE) {
                        av = -1;
                    }
                    e.setAvailable(av);
                    if (av >= 0) {
                        int otherEnrl = 0;
                        for (XCourse xCourse : offering.getCourses()) {
                            if (xCourse.equals(other)) continue;
                            otherEnrl += enrollments.countEnrollmentsForCourse(xCourse.getCourseId());
                        }
                        e.setOther(Math.min(other.getLimit() - enrollments.countEnrollmentsForCourse(other.getCourseId()) - av, otherEnrl));
                        int lim = 0;
                        for (XConfig f : offering.getConfigs()) {
                            if (lim < 0 || f.getLimit() < 0) {
                                lim = -1;
                                continue;
                            }
                            lim += f.getLimit();
                        }
                        if (lim >= 0 && lim < other.getLimit()) {
                            e.setOther(e.getOther() + other.getLimit() - limit);
                        }
                    }
                    e.setEnrollment(enrl);
                    e.setReservation(res);
                    e.setWaitlist(wait);
                    e.setNoSub(noSub);
                    e.setSwap(swap);
                    e.setUnassigned(unasg);
                    e.setUnassignedPrimary(unasgPrim);
                    e.setTotalEnrollment(tEnrl);
                    e.setTotalReservation((int)var35_84);
                    e.setTotalWaitlist(tWait);
                    e.setTotalNoSub(tNoSub);
                    e.setTotalSwap(tSwap);
                    e.setTotalUnassigned(tUnasg);
                    e.setTotalUnassignedPrimary(tUnasgPrim);
                    e.setConsentNeeded(conNeed);
                    e.setTotalConsentNeeded(tConNeed);
                    e.setOverrideNeeded(ovrNeed);
                    e.setTotalOverrideNeeded(tOvrNeed);
                    ret.add(e);
                }
                final NaturalOrderComparator noc = new NaturalOrderComparator();
                Collections.sort(ret, new Comparator<ClassAssignmentInterface.EnrollmentInfo>(){

                    @Override
                    public int compare(ClassAssignmentInterface.EnrollmentInfo e1, ClassAssignmentInterface.EnrollmentInfo e2) {
                        int cmp = noc.compare(e1.getSubject(), e2.getSubject());
                        if (cmp != 0) {
                            return cmp;
                        }
                        cmp = e1.getCourseNbr().compareTo(e2.getCourseNbr());
                        if (cmp != 0) {
                            return cmp;
                        }
                        return 0;
                    }
                });
            }
            for (XSection section : sections) {
                String consent;
                Object request32;
                StatusPageSuggestionsAction.CourseRequestMatcher m;
                OnlineSectioningInterface.WaitListMode wl;
                String status;
                XStudent student;
                XSection parent;
                e = new ClassAssignmentInterface.EnrollmentInfo();
                e.setCourseId(info.getCourseId());
                e.setOfferingId(offering.getOfferingId());
                e.setSubject(info.getSubjectArea());
                e.setCourseNbr(info.getCourseNumber());
                e.setTitle(info.getTitle());
                e.setConsent(info.getConsentAbbv());
                XSubpart subpart = offering.getSubpart(section.getSubpartId());
                XConfig config = offering.getConfig(subpart.getConfigId());
                e.setConfig(config.getName());
                e.setConfigId(config.getConfigId());
                e.setSubpart(subpart.getName());
                e.setSubpartId(subpart.getSubpartId());
                e.setClazz(section.getName(this.courseId()));
                e.setClazzId(section.getSectionId());
                XSection xSection = parent = section.getParentId() == null ? null : offering.getSection(section.getParentId());
                while (parent != null) {
                    e.incLevel();
                    parent = parent.getParentId() == null ? null : offering.getSection(parent.getParentId());
                }
                int match = 0;
                int enrl = 0;
                int wait = 0;
                int res = 0;
                int unasg = 0;
                int unasgPrim = 0;
                int n = 0;
                int swap = 0;
                int tEnrl = 0;
                int tWait = 0;
                int tRes = 0;
                int tUnasg = 0;
                int tUnasgPrim = 0;
                int tNoSub = 0;
                int tSwap = 0;
                int conNeed = 0;
                int tConNeed = 0;
                int other = 0;
                for (XCourseRequest xCourseRequest : enrollments.getRequests()) {
                    XEnrollment enrollment = xCourseRequest.getEnrollment();
                    if (enrollment == null || !enrollment.getSectionIds().contains(section.getSectionId())) continue;
                    if (!xCourseRequest.getEnrollment().getCourseId().equals(this.courseId())) {
                        ++other;
                        continue;
                    }
                    student = server.getStudent(xCourseRequest.getStudentId());
                    if (student == null) continue;
                    status = student.getStatus() == null ? session.getDefaultSectioningStatus() : student.getStatus();
                    wl = OnlineSectioningInterface.WaitListMode.None;
                    if (defaultWL != null) {
                        wl = defaultWL;
                    } else if (status == null || wlStates.contains(status)) {
                        wl = OnlineSectioningInterface.WaitListMode.WaitList;
                    } else if (noSubStates.contains(status)) {
                        wl = OnlineSectioningInterface.WaitListMode.NoSubs;
                    }
                    m = new StatusPageSuggestionsAction.CourseRequestMatcher(session, info, student, offering, xCourseRequest, isConsentToDoCourse, this.isMyStudent(student), lookup, server, wl);
                    if (this.query().match(m)) {
                        ++match;
                        ++enrl;
                        if (m.enrollment().getReservation() != null) {
                            ++res;
                        }
                        if (info.getConsentLabel() != null && m.enrollment().getApproval() == null) {
                            ++conNeed;
                        }
                        if (m.request().isWaitlist(wl) && m.request().getEnrollment().equals(m.request().getWaitListSwapWithCourseOffering())) {
                            ++swap;
                        }
                    }
                    ++tEnrl;
                    if (m.enrollment().getReservation() != null) {
                        ++tRes;
                    }
                    if (info.getConsentLabel() != null && m.enrollment().getApproval() == null) {
                        ++tConNeed;
                    }
                    if (!m.request().isWaitlist(wl) || !m.request().getEnrollment().equals(m.request().getWaitListSwapWithCourseOffering())) continue;
                    ++tSwap;
                }
                Set students = (Set)section2students.get(section.getSectionId());
                if (students != null) {
                    for (Object request32 : enrollments.getRequests()) {
                        XOverride override;
                        if (!students.contains(((XRequest)request32).getStudentId()) || ((XCourseRequest)request32).getEnrollment() != null || !((XCourseRequest)request32).hasCourse(this.courseId())) continue;
                        student = server.getStudent(((XRequest)request32).getStudentId());
                        status = student.getStatus() == null ? session.getDefaultSectioningStatus() : student.getStatus();
                        wl = OnlineSectioningInterface.WaitListMode.None;
                        if (defaultWL != null) {
                            wl = defaultWL;
                        } else if (status == null || wlStates.contains(status)) {
                            wl = OnlineSectioningInterface.WaitListMode.WaitList;
                        } else if (noSubStates.contains(status)) {
                            wl = OnlineSectioningInterface.WaitListMode.NoSubs;
                        }
                        if (student == null || !student.canAssign((XCourseRequest)request32, wl) || checkOverrides && ((XCourseRequest)request32).getEnrollment() == null && (override = ((XCourseRequest)request32).getOverride(info)) != null && !override.isApproved() && !override.isNotNeeded()) continue;
                        m = new StatusPageSuggestionsAction.CourseRequestMatcher(session, info, student, offering, (XCourseRequest)request32, isConsentToDoCourse, this.isMyStudent(student), lookup, server, wl);
                        if (this.query().match(m)) {
                            ++match;
                            ++unasg;
                            if (!((XRequest)request32).isAlternative() && ((XCourseRequest)request32).isPrimary(info)) {
                                ++unasgPrim;
                                if (((XCourseRequest)request32).isWaitlist(wl)) {
                                    ++wait;
                                }
                                if (((XCourseRequest)request32).isNoSub(wl)) {
                                    ++n;
                                }
                            }
                        }
                        ++tUnasg;
                        if (((XRequest)request32).isAlternative() || !((XCourseRequest)request32).isPrimary(info)) continue;
                        ++tUnasgPrim;
                        if (((XCourseRequest)request32).isWaitlist(wl)) {
                            ++tWait;
                        }
                        if (!((XCourseRequest)request32).isNoSub(wl)) continue;
                        ++tNoSub;
                    }
                }
                if (match == 0 && !this.iShowUnmatchedClasses) continue;
                e.setNoMatch(match == 0);
                e.setLimit(section.getLimit());
                e.setOther(other);
                e.setAvailable(section.isCancelled() || !section.isEnabledForScheduling() ? 0 : Math.max(0, offering.getUnreservedSectionSpace(section.getSectionId(), enrollments)));
                if (e.getAvailable() == Integer.MAX_VALUE) {
                    e.setAvailable(-1);
                }
                e.setProjection(tEnrl + (int)Math.round(expectations.getExpectedSpace(section.getSectionId())));
                e.setSnapshot(snapshots.get(section.getSectionId()));
                e.setEnrollment(enrl);
                e.setReservation(res);
                e.setWaitlist(wait);
                e.setNoSub(n);
                e.setSwap(swap);
                e.setUnassigned(unasg);
                e.setUnassignedPrimary(unasgPrim);
                e.setTotalEnrollment(tEnrl);
                e.setTotalReservation(tRes);
                e.setTotalWaitlist(tWait);
                e.setTotalNoSub(tNoSub);
                e.setTotalSwap(tSwap);
                e.setTotalUnassigned(tUnasg);
                e.setTotalUnassignedPrimary(tUnasgPrim);
                e.setConsentNeeded(conNeed);
                e.setTotalConsentNeeded(tConNeed);
                ClassAssignmentInterface.ClassAssignment classAssignment = new ClassAssignmentInterface.ClassAssignment();
                classAssignment.setClassId(section.getSectionId());
                classAssignment.setSubpart(section.getSubpartName());
                classAssignment.setClassNumber(section.getName(-1L));
                classAssignment.setSection(section.getName(this.courseId()));
                classAssignment.setExternalId(section.getExternalId(this.courseId()));
                classAssignment.setCancelled(section.isCancelled());
                classAssignment.setLimit(new int[]{enrollments.countEnrollmentsForSection(section.getSectionId()), section.getLimit()});
                if (section.getTime() != null) {
                    request32 = DayCode.toDayCodes(section.getTime().getDays()).iterator();
                    while (request32.hasNext()) {
                        DayCode d = (DayCode)((Object)request32.next());
                        classAssignment.addDay(d.getIndex());
                    }
                    classAssignment.setStart(section.getTime().getSlot());
                    classAssignment.setLength(section.getTime().getLength());
                    classAssignment.setBreakTime(section.getTime().getBreakTime());
                    classAssignment.setDatePattern(section.getTime().getDatePatternName());
                }
                if (section.getNrRooms() > 0) {
                    request32 = section.getRooms().iterator();
                    while (request32.hasNext()) {
                        XRoom rm = (XRoom)request32.next();
                        classAssignment.addRoom(rm.getUniqueId(), rm.getName());
                    }
                }
                if (section.getInstructors() != null) {
                    request32 = section.getInstructors().iterator();
                    while (request32.hasNext()) {
                        XInstructor instructor = (XInstructor)request32.next();
                        classAssignment.addInstructor(instructor.getName());
                        classAssignment.addInstructoEmail(instructor.getEmail());
                    }
                }
                if (section.getParentId() != null) {
                    classAssignment.setParentSection(offering.getSection(section.getParentId()).getName(course.getCourseId()));
                }
                classAssignment.setSubpartId(section.getSubpartId());
                classAssignment.addNote(course.getNote());
                classAssignment.addNote(section.getNote());
                classAssignment.setCredit(subpart.getCredit(course.getCourseId()));
                classAssignment.setCreditRange(Float.valueOf(subpart.getCreditMin(course.getCourseId())), Float.valueOf(subpart.getCreditMax(course.getCourseId())));
                Float creditOverride = section.getCreditOverride(course.getCourseId());
                if (creditOverride != null) {
                    classAssignment.setCredit(FixedCreditUnitConfig.formatCredit(creditOverride.floatValue()));
                }
                if (classAssignment.getParentSection() == null && (consent = server.getCourse(this.courseId()).getConsentLabel()) != null) {
                    classAssignment.setParentSection(consent);
                }
                classAssignment.setExpected(overExp.getExpected(section.getLimit(), expectations.getExpectedSpace(section.getSectionId()).doubleValue()));
                e.setAssignment(classAssignment);
                ret.add(e);
            }
        }
        return ret;
    }

    @Override
    public String name() {
        return "find-enrollment-info";
    }

    public static class FindEnrollmentInfoCourseMatcher
    extends AbstractCourseMatcher {
        protected static final long serialVersionUID = 1L;
        protected Set<Long> iCoursesIcoordinate;
        protected Set<Long> iCoursesIcanApprove;
        protected Set<String> iSubjectAreas;
        protected Query iQuery;
        protected StatusPageSuggestionsAction.CourseLookup iLookup;
        protected OnlineSectioningServer iServer;

        public FindEnrollmentInfoCourseMatcher(Set<Long> coursesIcoordinate, Set<Long> coursesIcanApprove, Set<String> subjects, Query query, StatusPageSuggestionsAction.CourseLookup lookup, OnlineSectioningServer server) {
            this.iCoursesIcoordinate = coursesIcoordinate;
            this.iCoursesIcanApprove = coursesIcanApprove;
            this.iSubjectAreas = subjects;
            this.iQuery = query;
            this.iLookup = lookup;
            this.iServer = server;
        }

        public boolean isCourseVisible(Long courseId) {
            return this.iCoursesIcoordinate == null || this.iCoursesIcoordinate.contains(courseId);
        }

        public boolean isConsentToDoCourse(XCourse course) {
            return this.iCoursesIcanApprove != null && course.getConsentLabel() != null && this.iCoursesIcanApprove.contains(course.getCourseId());
        }

        public boolean hasMatchingSubjectArea(String subject) {
            return this.iSubjectAreas == null || this.iSubjectAreas.contains(subject);
        }

        @Override
        public boolean match(XCourseId id) {
            XCourse course = id instanceof XCourse ? (XCourse)id : this.getServer().getCourse(id.getCourseId());
            return course != null && this.isCourseVisible(course.getCourseId()) && this.hasMatchingSubjectArea(course.getSubjectArea()) && this.iQuery.match(new StatusPageSuggestionsAction.CourseInfoMatcher(course, this.isConsentToDoCourse(course), this.iLookup, this.iServer));
        }
    }
}

