/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model.base;

import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.InstructorPref;
import org.unitime.timetable.model.Preference;

@MappedSuperclass
public abstract class BaseInstructorPref
extends Preference
implements Serializable {
    private static final long serialVersionUID = 1L;
    private DepartmentalInstructor iInstructor;

    public BaseInstructorPref() {
    }

    public BaseInstructorPref(Long uniqueId) {
        this.setUniqueId(uniqueId);
    }

    @ManyToOne(optional=false, fetch=FetchType.EAGER)
    @JoinColumn(name="instructor_id", nullable=false)
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    public DepartmentalInstructor getInstructor() {
        return this.iInstructor;
    }

    public void setInstructor(DepartmentalInstructor instructor) {
        this.iInstructor = instructor;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof InstructorPref)) {
            return false;
        }
        if (this.getUniqueId() == null || ((InstructorPref)o).getUniqueId() == null) {
            return false;
        }
        return this.getUniqueId().equals(((InstructorPref)o).getUniqueId());
    }

    @Override
    public int hashCode() {
        if (this.getUniqueId() == null) {
            return super.hashCode();
        }
        return this.getUniqueId().hashCode();
    }

    @Override
    public String toString() {
        return "InstructorPref[" + this.getUniqueId() + "]";
    }

    @Override
    public String toDebugString() {
        return "InstructorPref[\n\tInstructor: " + String.valueOf(this.getInstructor()) + "\n\tNote: " + this.getNote() + "\n\tOwner: " + String.valueOf(this.getOwner()) + "\n\tPrefLevel: " + String.valueOf(this.getPrefLevel()) + "\n\tUniqueId: " + this.getUniqueId() + "]";
    }
}

