/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.model;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.gwt.shared.RoomInterface;
import org.unitime.timetable.model.Department;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.RoomDept;
import org.unitime.timetable.model.dao.DepartmentDAO;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.webutil.RequiredTimeTableModel;

public class RoomSharingModel
extends org.cpsolver.coursett.model.RoomSharingModel
implements RequiredTimeTableModel {
    protected static final GwtConstants CONSTANTS = Localization.create(GwtConstants.class);
    private boolean[][] iEditable = null;
    private int iDefaultSelection = 0;
    private Set iEditingDepartments = null;
    private boolean iAllowFreeForAll = true;
    private String[] iDepartmentNames = null;
    private String[] iDepartmentAbbvs = null;
    private Color[] iDepartmentColors = null;
    public static Color[] sDepartmentColors = new Color[]{new Color(240, 50, 240), new Color(50, 240, 240), new Color(240, 240, 50), new Color(240, 50, 50), new Color(50, 240, 50), new Color(50, 50, 240), new Color(150, 100, 50), new Color(50, 100, 150), new Color(150, 50, 100), new Color(100, 150, 50)};
    public static Color sNotAvailableColor = new Color(150, 150, 150);
    public static Color sFreeForAllColor = new Color(240, 240, 240);
    public static String sNotAvailableName = "Not Available";
    public static String sFreeForAllName = "Free For All";
    public static String sNotAvailableNameAbbv = "N/A";
    public static String sFreeForAllNameAbbv = "Free";
    private List<RoomInterface.RoomSharingDisplayMode> iModes = new ArrayList<RoomInterface.RoomSharingDisplayMode>();

    public RoomSharingModel(Location location, Set editingDepartmentIds) {
        this(location, editingDepartmentIds, null);
    }

    /*
     * WARNING - void declaration
     */
    public RoomSharingModel(Location location, Set editingDepartmentIds, Collection departments) {
        super(1);
        boolean allEditable;
        String mode;
        int i = 0;
        while ((mode = ApplicationProperty.RoomSharingMode.value(String.valueOf(1 + i), i < CONSTANTS.roomSharingModes().length ? CONSTANTS.roomSharingModes()[i] : null)) != null && !mode.isEmpty()) {
            this.iModes.add(new RoomInterface.RoomSharingDisplayMode(mode));
            ++i;
        }
        Vector<Department> givenDepartments = departments;
        this.iPreference = new Long[this.getNrDays()][this.getNrTimes()];
        this.iEditable = new boolean[this.getNrDays()][this.getNrTimes()];
        Hashtable<Character, Long> oldDeptPrefs = new Hashtable<Character, Long>();
        char pref = '0';
        if (location.getManagerIds() != null) {
            StringTokenizer stk = new StringTokenizer(location.getManagerIds(), ",");
            while (stk.hasMoreTokens()) {
                Long id = Long.valueOf(stk.nextToken());
                char c = pref;
                pref = (char)(pref + 1);
                oldDeptPrefs.put(Character.valueOf(c), id);
            }
        }
        if (departments == null) {
            departments = new Vector(location.getRoomDepts().size());
            TreeSet<RoomDept> managers = new TreeSet<RoomDept>(location.getRoomDepts());
            for (RoomDept roomDept : managers) {
                departments.add(roomDept.getDepartment());
            }
        }
        this.iDepartmentIds = new Long[departments.size()];
        this.iDepartmentAbbvs = new String[departments.size()];
        this.iDepartmentNames = new String[departments.size()];
        this.iDepartmentColors = new Color[departments.size()];
        this.iEditingDepartments = editingDepartmentIds;
        this.iDepartmentIdx = new HashMap();
        int idx = 0;
        for (RoomDept roomDept : departments) {
            Department mgr = null;
            if (roomDept instanceof RoomDept) {
                mgr = roomDept.getDepartment();
            } else if (roomDept instanceof Department) {
                mgr = (Department)((Object)roomDept);
            } else if (roomDept instanceof Long) {
                mgr = (Department)DepartmentDAO.getInstance().get((Long)((Object)roomDept));
            }
            if (mgr == null) {
                throw new RuntimeException("Department " + String.valueOf(roomDept) + " not found.");
            }
            this.iDepartmentAbbvs[idx] = mgr.getShortLabel();
            this.iDepartmentNames[idx] = mgr.getDeptCode() + "-" + mgr.getName();
            this.iDepartmentIds[idx] = mgr.getUniqueId();
            this.iDepartmentColors[idx] = givenDepartments == null && mgr.getRoomSharingColor() != null ? Department.hex2color(mgr.getRoomSharingColor()) : Department.hex2color(mgr.getRoomSharingColor(departments));
            this.iDepartmentIdx.put(mgr.getUniqueId(), idx);
            ++idx;
        }
        if (this.iEditingDepartments != null) {
            void var9_17;
            boolean all = true;
            boolean bl = false;
            while (var9_17 < this.iDepartmentIds.length) {
                if (!this.iEditingDepartments.contains(this.iDepartmentIds[var9_17])) {
                    all = false;
                }
                ++var9_17;
            }
            if (all) {
                this.iEditingDepartments = null;
            }
        }
        boolean bl = allEditable = this.iEditingDepartments == null;
        if (!allEditable) {
            boolean bl2;
            boolean bl3 = true;
            for (RoomDept mgr : location.getRoomDepts()) {
                if (this.iEditingDepartments.contains(mgr.getDepartment().getUniqueId())) continue;
                bl2 = false;
            }
            if (bl2) {
                allEditable = true;
            }
        }
        String string = location.getPattern();
        idx = 0;
        for (int d = 0; d < this.getNrDays(); ++d) {
            for (int t = 0; t < this.getNrTimes(); ++t) {
                pref = string != null && idx < string.length() ? string.charAt(idx) : sDefaultPrefChar;
                ++idx;
                if (pref == sNotAvailablePrefChar) {
                    this.iPreference[d][t] = sNotAvailablePref;
                    this.iEditable[d][t] = allEditable;
                    continue;
                }
                if (pref == sFreeForAllPrefChar) {
                    this.iPreference[d][t] = sFreeForAllPref;
                    this.iEditable[d][t] = allEditable;
                    continue;
                }
                Long id = (Long)oldDeptPrefs.get(Character.valueOf(pref));
                if (id != null) {
                    boolean containsId = false;
                    for (int i3 = 0; i3 < this.iDepartmentIds.length; ++i3) {
                        if (!this.iDepartmentIds[i3].equals(id)) continue;
                        containsId = true;
                        break;
                    }
                    if (!containsId) {
                        id = null;
                    }
                }
                if (id == null) {
                    this.iPreference[d][t] = sDefaultPref;
                    this.iEditable[d][t] = allEditable;
                    continue;
                }
                this.iPreference[d][t] = id;
                this.iEditable[d][t] = allEditable ? true : this.iEditingDepartments.contains(id);
            }
        }
    }

    public String getManagerIds() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.getNrDepartments(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.iDepartmentIds[i]);
        }
        return sb.toString();
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public String getStartTime(int time) {
        return Constants.toTime(time * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN);
    }

    @Override
    public String getEndTime(int time) {
        return Constants.toTime((time + 1) * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN);
    }

    @Override
    public String getDayHeader(int day) {
        return CONSTANTS.days()[day];
    }

    @Override
    public void setPreference(int day, int time, String pref) {
        Long p = Long.valueOf(pref);
        this.iPreference[day][time] = p.equals(sFreeForAllPref) || p.equals(sNotAvailablePref) || this.getIndex(p) >= 0 ? p : sDefaultPref;
    }

    @Override
    public String getPreference(int day, int time) {
        return String.valueOf(this.iPreference[day][time]);
    }

    @Override
    public String getFieldText(int day, int time) {
        return this.getPreference(day, time);
    }

    @Override
    public boolean isEditable(int day, int time) {
        return this.iEditable[day][time];
    }

    @Override
    public void setPreferences(String pattern) {
        try {
            int idx = 0;
            for (int d = 0; d < this.getNrDays(); ++d) {
                for (int t = 0; t < this.getNrTimes(); ++t) {
                    char pref = pattern != null && idx < pattern.length() ? pattern.charAt(idx) : sDefaultPrefChar;
                    ++idx;
                    if (pref == sNotAvailablePrefChar) {
                        this.iPreference[d][t] = sNotAvailablePref;
                        this.iEditable[d][t] = true;
                        continue;
                    }
                    if (pref == sFreeForAllPrefChar) {
                        this.iPreference[d][t] = sFreeForAllPref;
                        this.iEditable[d][t] = true;
                        continue;
                    }
                    this.iPreference[d][t] = this.iDepartmentIds[pref - 48];
                    this.iEditable[d][t] = this.iEditingDepartments == null ? true : this.iEditingDepartments.contains(this.iPreference[d][t]);
                }
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void setEventAvailabilityPreference(String pattern) {
        try {
            int idx = 0;
            for (int d = 0; d < this.getNrDays(); ++d) {
                for (int t = 0; t < this.getNrTimes(); ++t) {
                    int pref = pattern != null && idx < pattern.length() ? (int)pattern.charAt(idx) : 48;
                    ++idx;
                    if (pref == 48) {
                        this.iPreference[d][t] = sFreeForAllPref;
                        this.iEditable[d][t] = true;
                        continue;
                    }
                    this.iPreference[d][t] = sNotAvailablePref;
                    this.iEditable[d][t] = true;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Override
    public boolean isExactTime() {
        return false;
    }

    @Override
    public int getExactDays() {
        return -1;
    }

    @Override
    public int getExactStartSlot() {
        return -1;
    }

    @Override
    public void setExactDays(int days) {
    }

    @Override
    public void setExactStartSlot(int slot) {
    }

    @Override
    public String getDefaultPreference() {
        return String.valueOf(sDefaultPref);
    }

    @Override
    public Color getBorder(int day, int time) {
        return null;
    }

    @Override
    public String[] getPreferenceNames() {
        String[] ret = new String[this.getNrDepartments() + (this.iAllowFreeForAll ? 2 : 1)];
        int idx = 0;
        for (int i = 0; i < this.getNrDepartments(); ++i) {
            ret[idx++] = String.valueOf(this.iDepartmentIds[i]);
        }
        ret[idx++] = String.valueOf(sNotAvailablePref);
        if (this.iAllowFreeForAll) {
            ret[idx++] = String.valueOf(sFreeForAllPref);
        }
        return ret;
    }

    @Override
    public Color getPreferenceColor(String pref) {
        Long p = Long.valueOf(pref);
        if (p.equals(sFreeForAllPref)) {
            return sFreeForAllColor;
        }
        if (p.equals(sNotAvailablePref)) {
            return sNotAvailableColor;
        }
        int idx = this.getIndex(p);
        if (idx < 0) {
            return Color.BLACK;
        }
        return this.iDepartmentColors[idx];
    }

    @Override
    public String getPreferenceText(String pref) {
        Long p = Long.valueOf(pref);
        if (p.equals(sFreeForAllPref)) {
            return sFreeForAllName;
        }
        if (p.equals(sNotAvailablePref)) {
            return sNotAvailableName;
        }
        return this.iDepartmentNames == null ? "Department " + (1 + this.getIndex(p)) : this.iDepartmentNames[this.getIndex(p)];
    }

    public String getPreferenceAbbv(Long deptId) {
        if (deptId.equals(sFreeForAllPref)) {
            return sFreeForAllNameAbbv;
        }
        if (deptId.equals(sNotAvailablePref)) {
            return sNotAvailableNameAbbv;
        }
        return this.iDepartmentAbbvs == null ? "D" + (1 + this.getIndex(deptId)) : this.iDepartmentAbbvs[this.getIndex(deptId)];
    }

    @Override
    public int getNrSelections() {
        return this.iModes.size();
    }

    @Override
    public String getSelectionName(int idx) {
        return this.iModes.get(idx).getName();
    }

    @Override
    public int[] getSelectionLimits(int idx) {
        if (idx < 0 || idx >= this.iModes.size()) {
            idx = 0;
        }
        RoomInterface.RoomSharingDisplayMode mode = this.iModes.get(idx);
        return new int[]{mode.getFirstSlot(), mode.getLastSlot() - 1, mode.getFirstDay(), mode.getLastDay(), mode.getStep()};
    }

    @Override
    public void setDefaultSelection(int selection) {
        this.iDefaultSelection = selection;
    }

    @Override
    public void setDefaultSelection(String selection) {
        this.iDefaultSelection = 0;
        if (selection == null) {
            return;
        }
        for (int i = 0; i < this.getNrSelections(); ++i) {
            if (!selection.equals(this.iModes.get(i).toHex()) && !selection.equalsIgnoreCase(this.getSelectionName(i).replaceAll("&times;", "x").replaceAll("\u00d7", "x"))) continue;
            this.iDefaultSelection = i;
            return;
        }
        try {
            this.iDefaultSelection = Integer.parseInt(selection);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    public int getDefaultSelection() {
        return this.iDefaultSelection;
    }

    @Override
    public String getPreferenceCheck() {
        if (this.iEditingDepartments == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer("if (pref!='" + sNotAvailablePref + "' && pref!='" + sFreeForAllPref + "'");
        for (Long editingDeptId : this.iEditingDepartments) {
            sb.append(" && pref!='" + editingDeptId + "'");
        }
        sb.append(") alert('WARNING: When saved, ownership of the selected time slots will be transferred to this department.');");
        sb.append("if (pref=='" + sNotAvailablePref + "' || pref=='" + sFreeForAllPref + "') alert('WARNING: When saved, ownership of the selected time slots will be transferred to room administrator.');");
        return sb.toString();
    }

    public boolean allAvailable(Long departmentId) {
        for (int d = 0; d < this.getNrDays(); ++d) {
            for (int t = 0; t < this.getNrTimes(); ++t) {
                Long pref = this.iPreference[d][t];
                if (pref.equals(sFreeForAllPref) || departmentId != null && departmentId.equals(pref)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isPreferenceEnabled(String pref) {
        return true;
    }

    public String toString() {
        int j;
        int i;
        StringBuffer sb = new StringBuffer();
        boolean[][] out = new boolean[this.getNrDays()][this.getNrTimes()];
        for (i = 0; i < this.getNrDays(); ++i) {
            for (j = 0; j < this.getNrTimes(); ++j) {
                out[i][j] = false;
            }
        }
        for (i = 0; i < this.getNrDays(); ++i) {
            for (j = 0; j < this.getNrTimes(); ++j) {
                if (out[i][j]) continue;
                out[i][j] = true;
                if (sFreeForAllPref.equals(this.iPreference[i][j])) continue;
                int endDay = i;
                int endTime = j;
                while (endTime + 1 < this.getNrTimes() && !out[i][endTime + 1] && this.iPreference[i][endTime + 1].equals(this.iPreference[i][j])) {
                    ++endTime;
                }
                while (endDay + 1 < this.getNrDays()) {
                    boolean same = true;
                    for (int x = j; x <= endTime; ++x) {
                        if (out[endDay + 1][x] || this.iPreference[i][x].equals(this.iPreference[endDay + 1][x])) continue;
                        same = false;
                        break;
                    }
                    if (!same) break;
                    ++endDay;
                }
                for (int a = i; a <= endDay; ++a) {
                    for (int b = j; b <= endTime; ++b) {
                        out[a][b] = true;
                    }
                }
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(this.getPreferenceAbbv(this.iPreference[i][j]) + " ");
                int nrDays = endDay - i + 1;
                if (i != 0 || endDay + 1 != Constants.DAY_CODES.length) {
                    for (int a = i; a <= endDay; ++a) {
                        sb.append(nrDays == 1 ? CONSTANTS.days()[a] : CONSTANTS.shortDays()[a]);
                    }
                }
                if (j == 0 && endTime + 1 == this.getNrTimes()) continue;
                sb.append(" ");
                sb.append(Constants.toTime(j * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN));
                sb.append(" - ");
                sb.append(Constants.toTime((endTime + 1) * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN));
            }
        }
        return sb.toString();
    }
}

