/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.gwt.server;

import java.util.ArrayList;
import java.util.Collection;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.resources.StudentSectioningConstants;

public enum DayCode {
    MON(64),
    TUE(32),
    WED(16),
    THU(8),
    FRI(4),
    SAT(2),
    SUN(1);

    private static StudentSectioningConstants CFG;
    private final int iCode;

    private DayCode(int code) {
        this.iCode = code;
    }

    public int getCode() {
        return this.iCode;
    }

    public int getIndex() {
        return this.ordinal();
    }

    public String getAbbv() {
        return CFG.shortDays()[this.ordinal()];
    }

    public String getShort() {
        return CFG.days()[this.ordinal()];
    }

    public String getName() {
        return CFG.longDays()[this.ordinal()];
    }

    public static int nrDays(int days) {
        int nrDays = 0;
        for (DayCode dc : DayCode.values()) {
            if ((days & dc.getCode()) == 0) continue;
            ++nrDays;
        }
        return nrDays;
    }

    public static ArrayList<DayCode> toDayCodes(int days) {
        Integer firstDay = ApplicationProperty.TimePatternFirstDayOfWeek.intValue();
        ArrayList<DayCode> dayCodes = new ArrayList<DayCode>(DayCode.values().length);
        for (int i = 0; i < DayCode.values().length; ++i) {
            int idx = firstDay == null ? i : (i + firstDay) % 7;
            DayCode dc = DayCode.values()[idx];
            if ((days & dc.getCode()) == 0) continue;
            dayCodes.add(dc);
        }
        return dayCodes;
    }

    public static String toString(int days) {
        StringBuffer daysStr = new StringBuffer();
        for (DayCode dc : DayCode.values()) {
            if ((days & dc.getCode()) == 0) continue;
            daysStr.append(dc.getAbbv());
        }
        return daysStr.toString();
    }

    public static ArrayList<DayCode> toDayCodes(String days) {
        ArrayList<DayCode> dayCodes = new ArrayList<DayCode>(DayCode.values().length);
        for (DayCode dc : DayCode.values()) {
            if (days.indexOf(dc.getAbbv()) < 0) continue;
            dayCodes.add(dc);
        }
        return dayCodes;
    }

    public static ArrayList<DayCode> toDayCodes(Collection<Integer> days) {
        ArrayList<DayCode> dayCodes = new ArrayList<DayCode>(DayCode.values().length);
        for (DayCode dc : DayCode.values()) {
            if (!days.contains(dc.ordinal())) continue;
            dayCodes.add(dc);
        }
        return dayCodes;
    }

    public static String toString(ArrayList<DayCode> days) {
        StringBuffer daysStr = new StringBuffer();
        for (DayCode dc : days) {
            daysStr.append(dc.getAbbv());
        }
        return daysStr.toString();
    }

    public static int toInt(ArrayList<DayCode> days) {
        int dayCode = 0;
        for (DayCode dc : days) {
            dayCode |= dc.getCode();
        }
        return dayCode;
    }

    public int nrDays(ArrayList<DayCode> days) {
        return days.size();
    }

    static {
        CFG = Localization.create(StudentSectioningConstants.class);
    }
}

