/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.filter;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseBoolean;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.command.server.GwtRpcLogging;
import org.unitime.timetable.gwt.shared.MenuInterface;
import org.unitime.timetable.security.SessionContext;

public class BusySessions {

    @GwtRpcImplements(value=MenuInterface.IsSessionBusyRpcRequest.class)
    @GwtRpcLogging(value=GwtRpcLogging.Level.ON_EXCEPTION)
    public static class Backend
    implements GwtRpcImplementation<MenuInterface.IsSessionBusyRpcRequest, GwtRpcResponseBoolean> {
        @Autowired
        private Tracker unitimeBusySessions;

        @Override
        public GwtRpcResponseBoolean execute(MenuInterface.IsSessionBusyRpcRequest request, SessionContext context) {
            return new GwtRpcResponseBoolean(this.unitimeBusySessions.isWorking(context.getHttpSessionId()));
        }
    }

    @Service(value="unitimeBusySessions")
    public static class Tracker {
        private ConcurrentMap<String, Integer> iCounters = new ConcurrentHashMap<String, Integer>();

        public void create(String id) {
            this.iCounters.put(id, 0);
        }

        public void destroy(String id) {
            this.iCounters.remove(id);
        }

        public String increment(String id) {
            this.iCounters.merge(id, 1, (t, u) -> t + u);
            return id;
        }

        public void decrement(String id) {
            this.iCounters.merge(id, -1, (t, u) -> Math.max(0, t + u));
        }

        public boolean isWorking(String id) {
            if (id == null) {
                return false;
            }
            Integer counter = (Integer)this.iCounters.get(id);
            return counter != null && counter > 1;
        }

        public boolean isActive(String id) {
            if (id == null) {
                return false;
            }
            return this.iCounters.containsKey(id);
        }
    }

    public static class Listener
    implements HttpSessionListener {
        private Tracker iTracker;

        protected Tracker getTracker(HttpSessionEvent event) {
            if (this.iTracker == null) {
                WebApplicationContext applicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)event.getSession().getServletContext());
                this.iTracker = (Tracker)applicationContext.getBean("unitimeBusySessions");
            }
            return this.iTracker;
        }

        public void sessionCreated(HttpSessionEvent event) {
            Tracker tracker = this.getTracker(event);
            if (tracker != null) {
                tracker.create(event.getSession().getId());
            }
        }

        public void sessionDestroyed(HttpSessionEvent event) {
            Tracker tracker = this.getTracker(event);
            if (tracker != null) {
                tracker.destroy(event.getSession().getId());
            }
        }
    }

    public static class Filter
    implements javax.servlet.Filter {
        private Tracker iTracker;

        protected Tracker getTracker(ServletRequest request) {
            if (this.iTracker == null) {
                WebApplicationContext applicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)request.getServletContext());
                this.iTracker = (Tracker)applicationContext.getBean("unitimeBusySessions");
            }
            return this.iTracker;
        }

        protected String increment(ServletRequest request) {
            Tracker tracker;
            if (request instanceof HttpServletRequest && (tracker = this.getTracker(request)) != null) {
                return tracker.increment(((HttpServletRequest)request).getSession().getId());
            }
            return null;
        }

        protected void decrement(ServletRequest request, String id) {
            Tracker tracker;
            if (request instanceof HttpServletRequest && id != null && (tracker = this.getTracker(request)) != null) {
                tracker.decrement(id);
            }
        }

        public void destroy() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            String id = this.increment(request);
            try {
                chain.doFilter(request, response);
            }
            finally {
                this.decrement(request, id);
            }
        }

        public void init(FilterConfig config) throws ServletException {
        }
    }
}

