/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.api.connectors;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Type;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.text.StringEscapeUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.springframework.stereotype.Service;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.api.ApiConnector;
import org.unitime.timetable.api.ApiHelper;
import org.unitime.timetable.api.XmlApiHelper;
import org.unitime.timetable.dataexchange.DataExchangeHelper;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.rights.Right;

@Service(value="/api/exchange")
public class DataExchangeConnector
extends ApiConnector {
    @Override
    protected ApiHelper createHelper(HttpServletRequest request, HttpServletResponse response) {
        return new XmlApiHelper(request, response, this.sessionContext, this.getCacheMode());
    }

    @Override
    public void doGet(ApiHelper helper) throws IOException {
        helper.getSessionContext().checkPermissionAnyAuthority(Right.ApiDataExchangeConnector, new Qualifiable[0]);
        Long sessionId = helper.getAcademicSessionId();
        if (sessionId == null) {
            throw new IllegalArgumentException("Academic session not provided, please set the term parameter.");
        }
        Session session = (Session)SessionDAO.getInstance().get(sessionId, helper.getHibSession());
        if (session == null) {
            throw new IllegalArgumentException("Given academic session no longer exists.");
        }
        String type = helper.getParameter("type");
        if (type == null) {
            throw new IllegalArgumentException("Export TYPE parameter not provided.");
        }
        ApplicationProperties.setSessionId(sessionId);
        try {
            helper.setResponse(DataExchangeHelper.exportDocument(type, session, ApplicationProperties.getProperties(), null));
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    @Override
    public void doPost(ApiHelper helper) throws IOException {
        helper.getSessionContext().checkPermissionAnyAuthority(Right.ApiDataExchangeConnector, new Qualifiable[0]);
        Document document = (Document)helper.getRequest((Type)((Object)Document.class));
        Document output = DocumentHelper.createDocument();
        final Element messages = output.addElement("html");
        try {
            DataExchangeHelper.importDocument(document, helper.getSessionContext().isAuthenticated() ? helper.getSessionContext().getUser().getExternalUserId() : null, new Log(){

                protected void printMessage(Element e, Object message, Throwable t) {
                    e.setText(message == null ? "null" : message.toString());
                    if (t != null) {
                        StringWriter writer = new StringWriter();
                        PrintWriter pw = new PrintWriter(writer);
                        t.printStackTrace(new PrintWriter(writer));
                        pw.flush();
                        pw.close();
                        e.addElement("pre").addAttribute(QName.get((String)"space", (Namespace)Namespace.XML_NAMESPACE), "preserve").addAttribute("style", "color: red;").setText(StringEscapeUtils.escapeHtml4((String)writer.toString()));
                    }
                }

                public void warn(Object message, Throwable t) {
                    this.printMessage(messages.addElement("p").addAttribute("style", "color: orange;"), message, t);
                }

                public void warn(Object message) {
                    this.printMessage(messages.addElement("p").addAttribute("style", "color: orange;"), message, null);
                }

                public void trace(Object message, Throwable t) {
                    this.printMessage(messages.addElement("p").addAttribute("style", "font-style: italic; color: gray;"), message, t);
                }

                public void trace(Object message) {
                    this.printMessage(messages.addElement("p").addAttribute("style", "font-style: italic; color: gray;"), message, null);
                }

                public boolean isWarnEnabled() {
                    return true;
                }

                public boolean isTraceEnabled() {
                    return false;
                }

                public boolean isInfoEnabled() {
                    return true;
                }

                public boolean isFatalEnabled() {
                    return true;
                }

                public boolean isErrorEnabled() {
                    return true;
                }

                public boolean isDebugEnabled() {
                    return false;
                }

                public void info(Object message, Throwable t) {
                    this.printMessage(messages.addElement("p"), message, t);
                }

                public void info(Object message) {
                    this.printMessage(messages.addElement("p"), message, null);
                }

                public void fatal(Object message, Throwable t) {
                    this.printMessage(messages.addElement("p").addAttribute("style", "font-weight: bold; color: red;"), message, t);
                }

                public void fatal(Object message) {
                    this.printMessage(messages.addElement("p").addAttribute("style", "font-weight: bold; color: red;"), message, null);
                }

                public void error(Object message, Throwable t) {
                    this.printMessage(messages.addElement("p").addAttribute("style", "color: red;"), message, t);
                }

                public void error(Object message) {
                    this.printMessage(messages.addElement("p").addAttribute("style", "color: red;"), message, null);
                }

                public void debug(Object message, Throwable t) {
                    this.printMessage(messages.addElement("p").addAttribute("style", "color: gray;"), message, t);
                }

                public void debug(Object message) {
                    this.printMessage(messages.addElement("p").addAttribute("style", "color: gray;"), message, null);
                }
            });
            helper.setResponse(output);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    @Override
    protected String getName() {
        return "exchange";
    }
}

