/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.unitime.commons.MultiComparable;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.commons.web.WebTable;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.ConstantsMessages;
import org.unitime.localization.messages.ExaminationMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.form.ExamAssignmentReportForm;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamOwner;
import org.unitime.timetable.model.ExamPeriod;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.Meeting;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.base.BaseStudent;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.model.dao.ExamDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.exam.ExamSolverProxy;
import org.unitime.timetable.solver.exam.ui.ExamAssignment;
import org.unitime.timetable.solver.exam.ui.ExamAssignmentInfo;
import org.unitime.timetable.solver.exam.ui.ExamInfo;
import org.unitime.timetable.solver.exam.ui.ExamRoomInfo;
import org.unitime.timetable.util.ExportUtils;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.util.LookupTables;
import org.unitime.timetable.util.RoomAvailability;
import org.unitime.timetable.webutil.BackTracker;
import org.unitime.timetable.webutil.PdfWebTable;

@Action(value="examAssignmentReport", results={@Result(name={"show"}, type="tiles", location="examAssignmentReport.tiles")})
@TilesDefinition(name="examAssignmentReport.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Examination Reports"), @TilesPutAttribute(name="body", value="/exam/assignmentReport.jsp"), @TilesPutAttribute(name="showSolverWarnings", value="exams")})
public class ExamAssignmentReportAction
extends UniTimeAction<ExamAssignmentReportForm> {
    private static final long serialVersionUID = -5536751983250422597L;
    protected static final ConstantsMessages CONST = Localization.create(ConstantsMessages.class);
    protected static final ExaminationMessages MSG = Localization.create(ExaminationMessages.class);

    public String execute() throws Exception {
        this.sessionContext.checkPermission(Right.ExaminationReports);
        ExamSolverProxy solver = this.getExaminationSolverService().getSolver();
        if (this.form == null) {
            this.form = new ExamAssignmentReportForm();
            ((ExamAssignmentReportForm)this.form).reset();
            if (solver != null) {
                ((ExamAssignmentReportForm)this.form).setExamType(solver.getExamTypeId());
            }
        }
        if (((ExamAssignmentReportForm)this.form).getOp() != null) {
            this.op = ((ExamAssignmentReportForm)this.form).getOp();
        }
        if (MSG.actionExportPdf().equals(this.op) || MSG.actionExportCsv().equals(this.op) || MSG.buttonApply().equals(this.op)) {
            ((ExamAssignmentReportForm)this.form).save(this.sessionContext);
        } else if (MSG.buttonRefresh().equals(this.op)) {
            ((ExamAssignmentReportForm)this.form).reset();
            if (solver != null) {
                ((ExamAssignmentReportForm)this.form).setExamType(solver.getExamTypeId());
            }
        }
        ((ExamAssignmentReportForm)this.form).setCanSeeAll(this.sessionContext.getUser().getCurrentAuthority().hasRight(Right.DepartmentIndependent));
        Session session = (Session)SessionDAO.getInstance().get(this.sessionContext.getUser().getCurrentAcademicSessionId());
        RoomAvailability.setAvailabilityWarning(this.request, session, ((ExamAssignmentReportForm)this.form).getExamType(), true, false);
        ((ExamAssignmentReportForm)this.form).load(this.sessionContext);
        Collection<ExamAssignmentInfo> assignedExams = null;
        if (((ExamAssignmentReportForm)this.form).getSubjectArea() != null && ((ExamAssignmentReportForm)this.form).getSubjectArea() != 0L && ((ExamAssignmentReportForm)this.form).getExamType() != null) {
            assignedExams = solver != null && solver.getExamTypeId().equals(((ExamAssignmentReportForm)this.form).getExamType()) ? solver.getAssignedExams(((ExamAssignmentReportForm)this.form).getSubjectArea()) : (ApplicationProperty.ExaminationCacheConflicts.isTrue() && ((ExamAssignmentReportForm)this.form).getSubjectArea() != null && ((ExamAssignmentReportForm)this.form).getSubjectArea() > 0L ? Exam.findAssignedExams(session.getUniqueId(), ((ExamAssignmentReportForm)this.form).getSubjectArea(), ((ExamAssignmentReportForm)this.form).getExamType()) : ExamAssignmentReportAction.findAssignedExams(session.getUniqueId(), ((ExamAssignmentReportForm)this.form).getSubjectArea(), ((ExamAssignmentReportForm)this.form).getExamType()));
        }
        WebTable.setOrder(this.sessionContext, "examAssignmentReport[" + ((ExamAssignmentReportForm)this.form).getReport() + "].ord", this.request.getParameter("ord"), 1);
        PdfWebTable table = this.getTable(session.getUniqueId(), true, (ExamAssignmentReportForm)this.form, assignedExams);
        if (MSG.actionExportPdf().equals(this.op) && table != null) {
            ExportUtils.exportPDF(this.getTable(session.getUniqueId(), false, (ExamAssignmentReportForm)this.form, assignedExams), WebTable.getOrder(this.sessionContext, "examAssignmentReport[" + ((ExamAssignmentReportForm)this.form).getReport() + "].ord"), this.response, "xreport");
            return null;
        }
        if (MSG.actionExportCsv().equals(this.op) && table != null) {
            ExportUtils.exportCSV(this.getTable(session.getUniqueId(), false, (ExamAssignmentReportForm)this.form, assignedExams), WebTable.getOrder(this.sessionContext, "examAssignmentReport[" + ((ExamAssignmentReportForm)this.form).getReport() + "].ord"), this.response, "xreport");
            return null;
        }
        if (table != null) {
            ((ExamAssignmentReportForm)this.form).setTable(table.printTable(WebTable.getOrder(this.sessionContext, "examAssignmentReport[" + ((ExamAssignmentReportForm)this.form).getReport() + "].ord")), table.getNrColumns(), assignedExams.size());
            BackTracker.markForBack(this.request, "examAssignmentReport.action?form.op=" + MSG.buttonApply() + "&form.examType=" + ((ExamAssignmentReportForm)this.getForm()).getExamType() + "&form.subjectArea=" + ((ExamAssignmentReportForm)this.getForm()).getSubjectArea() + "&form.showSections=" + ((ExamAssignmentReportForm)this.getForm()).getShowSections() + "&form.report=" + ((ExamAssignmentReportForm)this.getForm()).getReport() + "&form.filter=" + URLEncoder.encode(((ExamAssignmentReportForm)this.getForm()).getFilter(), "utf-8"), MSG.backExaminationReports(((ExamAssignmentReportForm)this.form).getReportName(), ((ExamAssignmentReportForm)this.form).getSubjectArea() == -1L ? CONST.all() : ((ExamAssignmentReportForm)this.form).getSubjectAreaAbbv()), true, true);
        }
        if (this.request.getParameter("backId") != null) {
            this.request.setAttribute("hash", (Object)this.request.getParameter("backId"));
        }
        LookupTables.setupExamTypes(this.request, this.sessionContext.getUser(), DepartmentStatusType.Status.ExamTimetable);
        return "show";
    }

    public static TreeSet<ExamAssignmentInfo> findAssignedExams(Long sessionId, Long subjectAreaId, Long examTypeId) throws Exception {
        CacheAssignedExams cache = new CacheAssignedExams(sessionId, examTypeId);
        if (subjectAreaId == null || subjectAreaId < 0L) {
            return cache.getAssignedExams();
        }
        return cache.getAssignedExamsOfSubjectArea(subjectAreaId);
    }

    public boolean match(ExamAssignmentReportForm form, String name) {
        if (form.getFilter() == null || form.getFilter().trim().length() == 0) {
            return true;
        }
        String n = (name == null ? "" : name).toUpperCase();
        StringTokenizer stk1 = new StringTokenizer(form.getFilter().toUpperCase(), ";");
        while (stk1.hasMoreTokens()) {
            StringTokenizer stk2 = new StringTokenizer(stk1.nextToken(), " ,");
            boolean match = true;
            while (match && stk2.hasMoreTokens()) {
                String token = stk2.nextToken().trim();
                if (token.length() == 0) continue;
                if (token.indexOf(42) >= 0 || token.indexOf(63) >= 0) {
                    try {
                        String tokenRegExp = "\\s+" + token.replaceAll("\\.", "\\.").replaceAll("\\?", ".+").replaceAll("\\*", ".*") + "\\s";
                        if (Pattern.compile(tokenRegExp).matcher(" " + n + " ").find()) continue;
                        match = false;
                    }
                    catch (PatternSyntaxException e) {
                        match = false;
                    }
                    continue;
                }
                if (n.indexOf(token) >= 0) continue;
                match = false;
            }
            if (!match) continue;
            return true;
        }
        return false;
    }

    public boolean match(ExamAssignmentReportForm form, ExamAssignment exam) {
        if (exam == null) {
            return false;
        }
        if (form.getShowSections()) {
            for (ExamInfo.ExamSectionInfo section : exam.getSections()) {
                if (!this.match(form, section.getName())) continue;
                return true;
            }
            return false;
        }
        return this.match(form, exam.getExamName());
    }

    public PdfWebTable getTable(Long sessionId, boolean html, ExamAssignmentReportForm form, Collection<ExamAssignmentInfo> exams) {
        if (exams == null || exams.isEmpty()) {
            return null;
        }
        try {
            switch (ExamAssignmentReportForm.ExamReport.valueOf(form.getReport())) {
                case ExamAssignmentReport: {
                    return this.generateAssignmentReport(html, form, exams);
                }
                case RoomAssignmentReport: {
                    return this.generateRoomReport(html, form, exams);
                }
                case PeriodUsage: {
                    return this.generatePeriodUsageReport(html, form, exams, sessionId);
                }
                case NrExamsADay: {
                    return this.generateNrExamsADayReport(html, form, exams);
                }
                case RoomSplits: {
                    return this.generateRoomSplitReport(html, form, exams);
                }
                case ViolatedDistributions: {
                    return this.generateViolatedDistributionsReport(html, form, exams);
                }
                case IndividualStudentConflicts: {
                    return this.generateIndividualConflictsReport(html, sessionId, form, exams, true, true, true, true, UserProperty.NameFormat.get(this.sessionContext.getUser()));
                }
                case IndividualDirectStudentConflicts: {
                    return this.generateIndividualConflictsReport(html, sessionId, form, exams, true, true, false, false, UserProperty.NameFormat.get(this.sessionContext.getUser()));
                }
                case IndividualBackToBackStudentConflicts: {
                    return this.generateIndividualConflictsReport(html, sessionId, form, exams, true, false, false, true, UserProperty.NameFormat.get(this.sessionContext.getUser()));
                }
                case IndividualMore2ADayStudentConflicts: {
                    return this.generateIndividualConflictsReport(html, sessionId, form, exams, true, false, true, false, UserProperty.NameFormat.get(this.sessionContext.getUser()));
                }
                case IndividualInstructorConflicts: {
                    return this.generateIndividualConflictsReport(html, sessionId, form, exams, false, true, true, true, UserProperty.NameFormat.get(this.sessionContext.getUser()));
                }
                case IndividualDirectInstructorConflicts: {
                    return this.generateIndividualConflictsReport(html, sessionId, form, exams, false, true, false, false, UserProperty.NameFormat.get(this.sessionContext.getUser()));
                }
                case IndividualBackToBackInstructorConflicts: {
                    return this.generateIndividualConflictsReport(html, sessionId, form, exams, false, false, false, true, UserProperty.NameFormat.get(this.sessionContext.getUser()));
                }
                case IndividualMore2ADayInstructorConflicts: {
                    return this.generateIndividualConflictsReport(html, sessionId, form, exams, false, false, true, false, UserProperty.NameFormat.get(this.sessionContext.getUser()));
                }
                case DirectStudentConflicts: {
                    return this.generateDirectConflictsReport(html, form, exams, true);
                }
                case BackToBackStudentConflicts: {
                    return this.generateBackToBackConflictsReport(html, form, exams, true);
                }
                case More2ADayStudentConflicts: {
                    return this.generate2MoreADayConflictsReport(html, form, exams, true);
                }
                case DirectInstructorConflicts: {
                    return this.generateDirectConflictsReport(html, form, exams, false);
                }
                case BackToBackInstructorConflicts: {
                    return this.generateBackToBackConflictsReport(html, form, exams, false);
                }
                case More2ADayInstructorConflicts: {
                    return this.generate2MoreADayConflictsReport(html, form, exams, false);
                }
                case IndividualStudentSchedule: {
                    return this.generateIndividualAssignmentReport(html, sessionId, form, exams, true, UserProperty.NameFormat.get(this.sessionContext.getUser()));
                }
                case IndividualInstructorSchedule: {
                    return this.generateIndividualAssignmentReport(html, sessionId, form, exams, false, UserProperty.NameFormat.get(this.sessionContext.getUser()));
                }
                case Statistics: {
                    return this.generateStatisticsReport(html, sessionId, form, exams);
                }
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private PdfWebTable generateAssignmentReport(boolean html, ExamAssignmentReportForm form, Collection<ExamAssignmentInfo> exams) {
        String nl = html ? "<br>" : "\n";
        PdfWebTable table = new PdfWebTable(10, form.getReportName(), "examAssignmentReport.action?ord=%%", new String[]{form.getShowSections() ? MSG.colOwner() : MSG.colExamination(), MSG.colEnrollment(), MSG.colSeatingType().replace("\n", nl), MSG.colDate(), MSG.colTime(), MSG.colRoom(), MSG.colRoomCapacity(), MSG.colInstructor(), MSG.colStudentConflicts().replace("\n", nl), MSG.colInstructorConflicts().replace("\n", nl)}, new String[]{"left", "right", "center", "left", "left", "left", "right", "left", "center", "center"}, new boolean[]{true, true, true, true, true, true, true, true, true, true});
        table.setRowStyle("white-space:nowrap");
        for (ExamAssignmentInfo exam : exams) {
            if (form.getShowSections()) {
                boolean firstSection = true;
                for (ExamInfo.ExamSectionInfo section : exam.getSections()) {
                    if (!this.match(form, section.getName())) continue;
                    int idc = exam.getNrInstructorDirectConflicts(section);
                    String idcStr = idc <= 0 ? "0" : (html ? "<font color='" + PreferenceLevel.prolog2color("P") + "'>" + idc + "</font>" : String.valueOf(idc));
                    int im2d = exam.getNrInstructorMoreThanTwoConflicts(section);
                    String im2dStr = im2d <= 0 ? "0" : (html ? "<font color='" + PreferenceLevel.prolog2color("2") + "'>" + im2d + "</font>" : String.valueOf(im2d));
                    int ibtb = exam.getNrInstructorBackToBackConflicts(section);
                    int idbtb = exam.getNrInstructorDistanceBackToBackConflicts(section);
                    String ibtbStr = ibtb <= 0 && idbtb <= 0 ? "0" : (html ? "<font color='" + PreferenceLevel.prolog2color("1") + "'>" + ibtb + (String)(idbtb > 0 ? " (d:" + idbtb + ")" : "") + "</font>" : ibtb + (String)(idbtb > 0 ? " (d:" + idbtb + ")" : ""));
                    int dc = exam.getNrDirectConflicts(section);
                    String dcStr = dc <= 0 ? "0" : (html ? "<font color='" + PreferenceLevel.prolog2color("P") + "'>" + dc + "</font>" : String.valueOf(dc));
                    int m2d = exam.getNrMoreThanTwoConflicts(section);
                    String m2dStr = m2d <= 0 ? "0" : (html ? "<font color='" + PreferenceLevel.prolog2color("2") + "'>" + m2d + "</font>" : String.valueOf(m2d));
                    int btb = exam.getNrBackToBackConflicts(section);
                    int dbtb = exam.getNrDistanceBackToBackConflicts(section);
                    String btbStr = btb <= 0 && dbtb <= 0 ? "0" : (html ? "<font color='" + PreferenceLevel.prolog2color("1") + "'>" + btb + (String)(dbtb > 0 ? " (d:" + dbtb + ")" : "") + "</font>" : btb + (String)(dbtb > 0 ? " (d:" + dbtb + ")" : ""));
                    table.addLine("onClick=\"document.location='examDetail.action?examId=" + exam.getExamId() + "';\"", new String[]{(String)(html ? "<a name='" + exam.getExamId() + "'>" : "") + section.getName() + (html ? "</a>" : ""), String.valueOf(section.getNrStudents()), exam.getSeatingTypeLabel(), exam.getDate(html), exam.getTime(html), exam.getRoomsName(html, ", "), exam.getRoomsCapacity(html, ", "), exam.getInstructorName("; "), dc == 0 && m2d == 0 && btb == 0 && dbtb == 0 ? "" : dcStr + ", " + m2dStr + ", " + btbStr, idc == 0 && im2d == 0 && ibtb == 0 && idbtb == 0 ? "" : idcStr + ", " + im2dStr + ", " + ibtbStr}, new Comparable[]{new MultiComparable((Comparable)((Object)section.getName()), exam), new MultiComparable(Integer.valueOf(-section.getNrStudents()), (Comparable)((Object)section.getName()), exam), new MultiComparable(Integer.valueOf(exam.getSeatingType()), (Comparable)((Object)section.getName()), exam), new MultiComparable(exam.getPeriodOrd(), (Comparable)((Object)section.getName()), exam), new MultiComparable(Integer.valueOf(exam.getPeriod() == null ? -1 : exam.getPeriod().getStartSlot()), (Comparable)((Object)section.getName()), exam), new MultiComparable((Comparable)((Object)exam.getRoomsName(":")), (Comparable)((Object)section.getName()), exam), new MultiComparable(Integer.valueOf(-exam.getRoomsCapacity()), (Comparable)((Object)section.getName()), exam), new MultiComparable((Comparable)((Object)exam.getInstructorName(":")), (Comparable)((Object)section.getName()), exam), new MultiComparable(Integer.valueOf(-dc), Integer.valueOf(-m2d), Integer.valueOf(-btb), Integer.valueOf(-dbtb), (Comparable)((Object)section.getName()), exam), new MultiComparable(Integer.valueOf(-idc), Integer.valueOf(-im2d), Integer.valueOf(-ibtb), Integer.valueOf(-idbtb), (Comparable)((Object)section.getName()), exam)}, firstSection ? exam.getExamId().toString() : null);
                    firstSection = false;
                }
                continue;
            }
            if (!this.match(form, exam.getExamName())) continue;
            int idc = exam.getNrInstructorDirectConflicts();
            String idcStr = idc <= 0 ? "0" : (html ? "<font color='" + PreferenceLevel.prolog2color("P") + "'>" + idc + "</font>" : String.valueOf(idc));
            int im2d = exam.getNrInstructorMoreThanTwoConflicts();
            String im2dStr = im2d <= 0 ? "0" : (html ? "<font color='" + PreferenceLevel.prolog2color("2") + "'>" + im2d + "</font>" : String.valueOf(im2d));
            int ibtb = exam.getNrInstructorBackToBackConflicts();
            int idbtb = exam.getNrInstructorDistanceBackToBackConflicts();
            String ibtbStr = ibtb <= 0 && idbtb <= 0 ? "0" : (html ? "<font color='" + PreferenceLevel.prolog2color("1") + "'>" + ibtb + (String)(idbtb > 0 ? " (d:" + idbtb + ")" : "") + "</font>" : ibtb + (String)(idbtb > 0 ? " (d:" + idbtb + ")" : ""));
            int dc = exam.getNrDirectConflicts();
            String dcStr = dc <= 0 ? "0" : (html ? "<font color='" + PreferenceLevel.prolog2color("P") + "'>" + dc + "</font>" : String.valueOf(dc));
            int m2d = exam.getNrMoreThanTwoConflicts();
            String m2dStr = m2d <= 0 ? "0" : (html ? "<font color='" + PreferenceLevel.prolog2color("2") + "'>" + m2d + "</font>" : String.valueOf(m2d));
            int btb = exam.getNrBackToBackConflicts();
            int dbtb = exam.getNrDistanceBackToBackConflicts();
            String btbStr = btb <= 0 && dbtb <= 0 ? "0" : (html ? "<font color='" + PreferenceLevel.prolog2color("1") + "'>" + btb + (String)(dbtb > 0 ? " (d:" + dbtb + ")" : "") + "</font>" : btb + (String)(dbtb > 0 ? " (d:" + dbtb + ")" : ""));
            table.addLine("onClick=\"document.location='examDetail.action?examId=" + exam.getExamId() + "';\"", new String[]{(String)(html ? "<a name='" + exam.getExamId() + "'>" : "") + exam.getExamName() + (html ? "</a>" : ""), String.valueOf(exam.getNrStudents()), exam.getSeatingTypeLabel(), exam.getDate(html), exam.getTime(html), exam.getRoomsName(html, ", "), exam.getRoomsCapacity(html, ", "), exam.getInstructorName("; "), dc == 0 && m2d == 0 && btb == 0 && dbtb == 0 ? "" : dcStr + ", " + m2dStr + ", " + btbStr, idc == 0 && im2d == 0 && ibtb == 0 && idbtb == 0 ? "" : idcStr + ", " + im2dStr + ", " + ibtbStr}, new Comparable[]{exam, new MultiComparable(Integer.valueOf(exam.getNrStudents()), exam), new MultiComparable(Integer.valueOf(exam.getSeatingType()), exam), new MultiComparable(exam.getPeriodOrd(), exam), new MultiComparable(exam.getPeriod().getStartSlot(), exam), new MultiComparable((Comparable)((Object)exam.getRoomsName(":")), exam), new MultiComparable(Integer.valueOf(-exam.getRoomsCapacity()), exam), new MultiComparable((Comparable)((Object)exam.getInstructorName(":")), exam), new MultiComparable(Integer.valueOf(-dc), Integer.valueOf(-m2d), Integer.valueOf(-btb), Integer.valueOf(-dbtb), exam), new MultiComparable(Integer.valueOf(-idc), Integer.valueOf(-im2d), Integer.valueOf(-ibtb), Integer.valueOf(-idbtb), exam)}, exam.getExamId().toString());
        }
        return table;
    }

    private PdfWebTable generateRoomReport(boolean html, ExamAssignmentReportForm form, Collection<ExamAssignmentInfo> exams) {
        String nl = html ? "<br>" : "\n";
        PdfWebTable table = new PdfWebTable(11, form.getReportName(), "examAssignmentReport.action?ord=%%", new String[]{MSG.colRoom(), MSG.colRoomCapacity(), MSG.colExamCapacity().replace("\n", nl), MSG.colDate(), MSG.colTime(), form.getShowSections() ? MSG.colOwner() : MSG.colExamination(), MSG.colEnrollment(), MSG.colSeatingType().replace("\n", nl), MSG.colInstructor(), MSG.colStudentConflicts().replace("\n", nl), MSG.colInstructorConflicts().replace("\n", nl)}, new String[]{"left", "right", "right", "left", "left", "left", "right", "center", "left", "center", "center"}, new boolean[]{true, true, true, true, true, true, true, true, true, true, true});
        table.setRowStyle("white-space:nowrap");
        table.setBlankWhenSame(true);
        for (ExamAssignmentInfo exam : exams) {
            boolean match = false;
            for (ExamRoomInfo room : exam.getRooms()) {
                if (!this.match(form, room.getName())) continue;
                match = true;
                break;
            }
            if (!match) continue;
            if (form.getShowSections()) {
                for (ExamInfo.ExamSectionInfo section : exam.getSections()) {
                    int idc = exam.getNrInstructorDirectConflicts(section);
                    String idcStr = idc <= 0 ? "0" : (html ? "<font color='" + PreferenceLevel.prolog2color("P") + "'>" + idc + "</font>" : String.valueOf(idc));
                    int im2d = exam.getNrInstructorMoreThanTwoConflicts(section);
                    String im2dStr = im2d <= 0 ? "0" : (html ? "<font color='" + PreferenceLevel.prolog2color("2") + "'>" + im2d + "</font>" : String.valueOf(im2d));
                    int ibtb = exam.getNrInstructorBackToBackConflicts(section);
                    int idbtb = exam.getNrInstructorDistanceBackToBackConflicts(section);
                    String ibtbStr = ibtb <= 0 && idbtb <= 0 ? "0" : (html ? "<font color='" + PreferenceLevel.prolog2color("1") + "'>" + ibtb + (String)(idbtb > 0 ? " (d:" + idbtb + ")" : "") + "</font>" : ibtb + (String)(idbtb > 0 ? " (d:" + idbtb + ")" : ""));
                    int dc = exam.getNrDirectConflicts(section);
                    String dcStr = dc <= 0 ? "0" : (html ? "<font color='" + PreferenceLevel.prolog2color("P") + "'>" + dc + "</font>" : String.valueOf(dc));
                    int m2d = exam.getNrMoreThanTwoConflicts(section);
                    String m2dStr = m2d <= 0 ? "0" : (html ? "<font color='" + PreferenceLevel.prolog2color("2") + "'>" + m2d + "</font>" : String.valueOf(m2d));
                    int btb = exam.getNrBackToBackConflicts(section);
                    int dbtb = exam.getNrDistanceBackToBackConflicts(section);
                    String btbStr = btb <= 0 && dbtb <= 0 ? "0" : (html ? "<font color='" + PreferenceLevel.prolog2color("1") + "'>" + btb + (String)(dbtb > 0 ? " (d:" + dbtb + ")" : "") + "</font>" : btb + (String)(dbtb > 0 ? " (d:" + dbtb + ")" : ""));
                    boolean firstRoom = true;
                    for (ExamRoomInfo room : exam.getRooms()) {
                        if (!this.match(form, room.getName())) continue;
                        table.addLine("onClick=\"document.location='examDetail.action?examId=" + exam.getExamId() + "';\"", new String[]{room.getName(), String.valueOf(room.getCapacity()), String.valueOf(room.getExamCapacity()), exam.getDate(html), exam.getTime(html), (String)(html ? "<a name='" + exam.getExamId() + "'>" : "") + section.getName() + (html ? "</a>" : ""), String.valueOf(section.getNrStudents()), exam.getSeatingTypeLabel(), exam.getInstructorName("; "), dc == 0 && m2d == 0 && btb == 0 && dbtb == 0 ? "" : dcStr + ", " + m2dStr + ", " + btbStr, idc == 0 && im2d == 0 && ibtb == 0 && idbtb == 0 ? "" : idcStr + ", " + im2dStr + ", " + ibtbStr}, new Comparable[]{new MultiComparable((Comparable)((Object)room.getName())), new MultiComparable(Integer.valueOf(-room.getCapacity()), (Comparable)((Object)room.getName())), new MultiComparable(Integer.valueOf(-room.getExamCapacity()), (Comparable)((Object)room.getName())), new MultiComparable((Comparable)((Object)room.getName()), exam.getPeriodOrd(), (Comparable)((Object)section.getName()), exam), new MultiComparable((Comparable)((Object)room.getName()), exam.getPeriod().getStartSlot(), (Comparable)((Object)section.getName()), exam), new MultiComparable((Comparable)((Object)room.getName()), (Comparable)((Object)section.getName()), exam), new MultiComparable((Comparable)((Object)room.getName()), Integer.valueOf(-section.getNrStudents()), (Comparable)((Object)section.getName()), exam), new MultiComparable((Comparable)((Object)room.getName()), Integer.valueOf(exam.getSeatingType()), (Comparable)((Object)section.getName()), exam), new MultiComparable((Comparable)((Object)room.getName()), (Comparable)((Object)exam.getInstructorName(":")), (Comparable)((Object)section.getName()), exam), new MultiComparable((Comparable)((Object)room.getName()), Integer.valueOf(-dc), Integer.valueOf(-m2d), Integer.valueOf(-btb), Integer.valueOf(-dbtb), (Comparable)((Object)section.getName()), exam), new MultiComparable((Comparable)((Object)room.getName()), Integer.valueOf(-idc), Integer.valueOf(-im2d), Integer.valueOf(-ibtb), Integer.valueOf(-idbtb), (Comparable)((Object)section.getName()), exam)}, firstRoom ? exam.getExamId().toString() : null);
                        firstRoom = false;
                    }
                }
                continue;
            }
            int idc = exam.getNrInstructorDirectConflicts();
            String idcStr = idc <= 0 ? "0" : (html ? "<font color='" + PreferenceLevel.prolog2color("P") + "'>" + idc + "</font>" : String.valueOf(idc));
            int im2d = exam.getNrInstructorMoreThanTwoConflicts();
            String im2dStr = im2d <= 0 ? "0" : (html ? "<font color='" + PreferenceLevel.prolog2color("2") + "'>" + im2d + "</font>" : String.valueOf(im2d));
            int ibtb = exam.getNrInstructorBackToBackConflicts();
            int idbtb = exam.getNrInstructorDistanceBackToBackConflicts();
            String ibtbStr = ibtb <= 0 && idbtb <= 0 ? "0" : (html ? "<font color='" + PreferenceLevel.prolog2color("1") + "'>" + ibtb + (String)(idbtb > 0 ? " (d:" + idbtb + ")" : "") + "</font>" : ibtb + (String)(idbtb > 0 ? " (d:" + idbtb + ")" : ""));
            int dc = exam.getNrDirectConflicts();
            String dcStr = dc <= 0 ? "0" : (html ? "<font color='" + PreferenceLevel.prolog2color("P") + "'>" + dc + "</font>" : String.valueOf(dc));
            int m2d = exam.getNrMoreThanTwoConflicts();
            String m2dStr = m2d <= 0 ? "0" : (html ? "<font color='" + PreferenceLevel.prolog2color("2") + "'>" + m2d + "</font>" : String.valueOf(m2d));
            int btb = exam.getNrBackToBackConflicts();
            int dbtb = exam.getNrDistanceBackToBackConflicts();
            String btbStr = btb <= 0 && dbtb <= 0 ? "0" : (html ? "<font color='" + PreferenceLevel.prolog2color("1") + "'>" + btb + (String)(dbtb > 0 ? " (d:" + dbtb + ")" : "") + "</font>" : btb + (String)(dbtb > 0 ? " (d:" + dbtb + ")" : ""));
            boolean firstRoom = true;
            for (ExamRoomInfo room : exam.getRooms()) {
                if (!this.match(form, room.getName())) continue;
                table.addLine("onClick=\"document.location='examDetail.action?examId=" + exam.getExamId() + "';\"", new String[]{room.getName(), String.valueOf(room.getCapacity()), String.valueOf(room.getExamCapacity()), exam.getDate(html), exam.getTime(html), (String)(html ? "<a name='" + exam.getExamId() + "'>" : "") + exam.getExamName() + (html ? "</a>" : ""), String.valueOf(exam.getNrStudents()), exam.getSeatingTypeLabel(), exam.getInstructorName("; "), dc == 0 && m2d == 0 && btb == 0 && dbtb == 0 ? "" : dcStr + ", " + m2dStr + ", " + btbStr, idc == 0 && im2d == 0 && ibtb == 0 && idbtb == 0 ? "" : idcStr + ", " + im2dStr + ", " + ibtbStr}, new Comparable[]{new MultiComparable((Comparable)((Object)room.getName())), new MultiComparable(Integer.valueOf(-room.getCapacity()), (Comparable)((Object)room.getName())), new MultiComparable(Integer.valueOf(-room.getExamCapacity()), (Comparable)((Object)room.getName())), new MultiComparable((Comparable)((Object)room.getName()), exam.getPeriodOrd(), exam), new MultiComparable((Comparable)((Object)room.getName()), exam.getPeriod().getStartSlot(), exam), new MultiComparable((Comparable)((Object)room.getName()), exam), new MultiComparable((Comparable)((Object)room.getName()), Integer.valueOf(-exam.getNrStudents()), exam), new MultiComparable((Comparable)((Object)room.getName()), Integer.valueOf(exam.getSeatingType()), exam), new MultiComparable((Comparable)((Object)room.getName()), (Comparable)((Object)exam.getInstructorName(":")), exam), new MultiComparable((Comparable)((Object)room.getName()), Integer.valueOf(-dc), Integer.valueOf(-m2d), Integer.valueOf(-btb), Integer.valueOf(-dbtb), exam), new MultiComparable((Comparable)((Object)room.getName()), Integer.valueOf(-idc), Integer.valueOf(-im2d), Integer.valueOf(-ibtb), Integer.valueOf(-idbtb), exam)}, firstRoom ? exam.getExamId().toString() : null);
                firstRoom = false;
            }
        }
        return table;
    }

    private PdfWebTable generatePeriodUsageReport(boolean html, ExamAssignmentReportForm form, Collection<ExamAssignmentInfo> exams, Long sessionId) {
        String nl = html ? "<br>" : "\n";
        PdfWebTable table = new PdfWebTable(8, form.getReportName(), "examAssignmentReport.action?ord=%%", new String[]{MSG.colDate(), MSG.colTime(), form.getShowSections() ? MSG.colOwners() : MSG.colExaminations(), MSG.colTotalEnrollment(), (form.getShowSections() ? MSG.colOwners() : MSG.colExaminations()) + nl + MSG.withNOrMoreStudents(10), (form.getShowSections() ? MSG.colOwners() : MSG.colExaminations()) + nl + MSG.withNOrMoreStudents(50), (form.getShowSections() ? MSG.colOwners() : MSG.colExaminations()) + nl + MSG.withNOrMoreStudents(100), (form.getShowSections() ? MSG.colOwners() : MSG.colExaminations()) + nl + MSG.withNOrMoreStudents(500)}, new String[]{"left", "left", "right", "right", "right", "right", "right", "right"}, new boolean[]{true, true, true, true, true, true, true, true});
        int tnrExams = 0;
        int tnrStudents = 0;
        int tnrExams10 = 0;
        int tnrExams50 = 0;
        int tnrExams100 = 0;
        int tnrExams500 = 0;
        table.setRowStyle("white-space:nowrap");
        for (ExamPeriod period : ExamPeriod.findAll(sessionId, form.getExamType())) {
            Object periodDate = period.getStartDateLabel();
            String periodTime = period.getStartTimeLabel() + " - " + period.getEndTimeLabel();
            if (html && period.getPrefLevel() != null && !PreferenceLevel.sNeutral.equals(period.getPrefLevel().getPrefProlog())) {
                periodDate = "<font color='" + PreferenceLevel.prolog2color(period.getPrefLevel().getPrefProlog()) + "'>" + (String)periodDate + "</font>";
                periodTime = "<font color='" + PreferenceLevel.prolog2color(period.getPrefLevel().getPrefProlog()) + "'>" + periodTime + "</font>";
            }
            int nrExams = 0;
            int nrStudents = 0;
            int nrExams10 = 0;
            int nrExams50 = 0;
            int nrExams100 = 0;
            int nrExams500 = 0;
            for (ExamAssignmentInfo exam : exams) {
                if (!period.getUniqueId().equals(exam.getPeriodId())) continue;
                if (form.getShowSections()) {
                    for (ExamInfo.ExamSectionInfo section : exam.getSections()) {
                        if (!this.match(form, section.getName())) continue;
                        ++nrExams;
                        nrStudents += section.getNrStudents();
                        if (section.getNrStudents() >= 10) {
                            ++nrExams10;
                        }
                        if (section.getNrStudents() >= 50) {
                            ++nrExams50;
                        }
                        if (section.getNrStudents() >= 100) {
                            ++nrExams100;
                        }
                        if (section.getNrStudents() < 500) continue;
                        ++nrExams500;
                    }
                    continue;
                }
                if (!this.match(form, exam.getExamName())) continue;
                ++nrExams;
                int nrStudentsThisExam = exam.getStudentIds().size();
                nrStudents += nrStudentsThisExam;
                if (nrStudentsThisExam >= 10) {
                    ++nrExams10;
                }
                if (nrStudentsThisExam >= 50) {
                    ++nrExams50;
                }
                if (nrStudentsThisExam >= 100) {
                    ++nrExams100;
                }
                if (nrStudentsThisExam < 500) continue;
                ++nrExams500;
            }
            if (nrExams == 0) continue;
            table.addLine(new String[]{periodDate, periodTime, String.valueOf(nrExams), String.valueOf(nrStudents), String.valueOf(nrExams10), String.valueOf(nrExams50), String.valueOf(nrExams100), String.valueOf(nrExams500)}, new Comparable[]{new MultiComparable(Integer.valueOf(0), period), new MultiComparable(Integer.valueOf(0), period.getStartSlot(), period.getDateOffset(), period), new MultiComparable(Integer.valueOf(0), Integer.valueOf(nrExams)), new MultiComparable(Integer.valueOf(0), Integer.valueOf(nrStudents)), new MultiComparable(Integer.valueOf(0), Integer.valueOf(nrExams10)), new MultiComparable(Integer.valueOf(0), Integer.valueOf(nrExams50)), new MultiComparable(Integer.valueOf(0), Integer.valueOf(nrExams100)), new MultiComparable(Integer.valueOf(0), Integer.valueOf(nrExams500))});
            tnrExams += nrExams;
            tnrExams10 += nrExams10;
            tnrExams50 += nrExams50;
            tnrExams100 += nrExams100;
            tnrExams500 += nrExams500;
            tnrStudents += nrStudents;
        }
        table.addLine(new String[]{html ? "<b>" + MSG.colTotals() + "</b>" : MSG.colTotals(), "", html ? "<b>" + tnrExams + "</b>" : String.valueOf(tnrExams), html ? "<b>" + tnrStudents + "</b>" : String.valueOf(tnrStudents), html ? "<b>" + tnrExams10 + "</b>" : String.valueOf(tnrExams10), html ? "<b>" + tnrExams50 + "</b>" : String.valueOf(tnrExams50), html ? "<b>" + tnrExams100 + "</b>" : String.valueOf(tnrExams100), html ? "<b>" + tnrExams500 + "</b>" : String.valueOf(tnrExams500)}, new Comparable[]{new MultiComparable(Integer.valueOf(1), null), new MultiComparable(Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(0), null), new MultiComparable(Integer.valueOf(1), Integer.valueOf(tnrExams)), new MultiComparable(Integer.valueOf(1), Integer.valueOf(tnrStudents)), new MultiComparable(Integer.valueOf(1), Integer.valueOf(tnrExams10)), new MultiComparable(Integer.valueOf(1), Integer.valueOf(tnrExams50)), new MultiComparable(Integer.valueOf(1), Integer.valueOf(tnrExams100)), new MultiComparable(Integer.valueOf(1), Integer.valueOf(tnrExams500))});
        return table;
    }

    private PdfWebTable generateNrExamsADayReport(boolean html, ExamAssignmentReportForm form, Collection<ExamAssignmentInfo> exams) {
        Formats.Format<Date> df = Formats.getDateFormat(Formats.Pattern.DATE_EXAM_PERIOD);
        String nl = html ? "<br>" : "\n";
        PdfWebTable table = new PdfWebTable(8, form.getReportName(), "examAssignmentReport.action?ord=%%", new String[]{MSG.colDate(), MSG.colStudentsWithNoExam().replace("\n", nl), MSG.colStudentsWithOneExam().replace("\n", nl), MSG.colStudentsWithTwoExams().replace("\n", nl), MSG.colStudentsWithThreeExams().replace("\n", nl), MSG.colStudentsWithFourOrMoreExams().replace("\n", nl), MSG.colStudentBTBExams().replace("\n", nl), MSG.colStudentDistanceBTBExams().replace("\n", nl)}, new String[]{"left", "right", "right", "right", "right", "right", "right", "right", "right"}, new boolean[]{true, true, true, true, true, true, true, true});
        table.setRowStyle("white-space:nowrap");
        HashSet<Long> studentIds = new HashSet<Long>();
        Hashtable date2students = new Hashtable();
        Hashtable<Date, Integer> date2btb = new Hashtable<Date, Integer>();
        Hashtable<Date, Integer> date2dbtb = new Hashtable<Date, Integer>();
        for (ExamAssignmentInfo exam : exams) {
            if (!form.getShowSections() && !this.match(form, exam.getExamName())) continue;
            Hashtable<Long, Integer> students = (Hashtable<Long, Integer>)date2students.get(exam.getPeriod().getStartDate());
            if (students == null) {
                students = new Hashtable<Long, Integer>();
                date2students.put(exam.getPeriod().getStartDate(), students);
            }
            for (ExamInfo.ExamSectionInfo section : exam.getSections()) {
                if (form.getShowSections() && !this.match(form, section.getName())) continue;
                studentIds.addAll(section.getStudentIds());
                Iterator<Long> iterator = section.getStudentIds().iterator();
                while (iterator.hasNext()) {
                    Long studentId;
                    Integer nrExamsThisDay = (Integer)students.get(studentId = iterator.next());
                    students.put(studentId, 1 + (nrExamsThisDay == null ? 0 : nrExamsThisDay));
                }
                int btb = 0;
                int dbtb = 0;
                for (ExamAssignmentInfo.BackToBackConflict conf : exam.getBackToBackConflicts()) {
                    if (exam.getPeriod().compareTo(conf.getOtherExam().getPeriod()) >= 0) continue;
                    if (form.getShowSections() && form.getFilter() != null && form.getFilter().trim().length() > 0) {
                        Enumeration<Long> e = conf.getStudents().elements();
                        while (e.hasMoreElements()) {
                            Long studentId = e.nextElement();
                            if (!section.getStudentIds().contains(studentId)) continue;
                            ++btb;
                            if (!conf.isDistance()) continue;
                            ++dbtb;
                        }
                        continue;
                    }
                    btb += conf.getNrStudents();
                    if (!conf.isDistance()) continue;
                    dbtb += conf.getNrStudents();
                }
                if (btb > 0) {
                    date2btb.put(exam.getPeriod().getStartDate(), btb + (date2btb.get(exam.getPeriod().getStartDate()) == null ? 0 : (Integer)date2btb.get(exam.getPeriod().getStartDate())));
                }
                if (dbtb <= 0) continue;
                date2dbtb.put(exam.getPeriod().getStartDate(), dbtb + (date2dbtb.get(exam.getPeriod().getStartDate()) == null ? 0 : (Integer)date2dbtb.get(exam.getPeriod().getStartDate())));
            }
        }
        int tNoExam = 0;
        int tOneExam = 0;
        int tTwoExams = 0;
        int tThreeExams = 0;
        int tFourExams = 0;
        int tBtb = 0;
        int tDistBtb = 0;
        for (Map.Entry entry : date2students.entrySet()) {
            int noExam = 0;
            int oneExam = 0;
            int twoExams = 0;
            int threeExams = 0;
            int fourExams = 0;
            int btb = 0;
            int dbtb = 0;
            for (Map.Entry student : ((Hashtable)entry.getValue()).entrySet()) {
                if ((Integer)student.getValue() == 1) {
                    ++oneExam;
                    continue;
                }
                if ((Integer)student.getValue() == 2) {
                    ++twoExams;
                    continue;
                }
                if ((Integer)student.getValue() == 3) {
                    ++threeExams;
                    continue;
                }
                if ((Integer)student.getValue() < 4) continue;
                ++fourExams;
            }
            noExam = studentIds.size() - oneExam - twoExams - threeExams - fourExams;
            btb = date2btb.get(entry.getKey()) == null ? 0 : (Integer)date2btb.get(entry.getKey());
            dbtb = date2dbtb.get(entry.getKey()) == null ? 0 : (Integer)date2dbtb.get(entry.getKey());
            table.addLine(new String[]{df.format((Date)entry.getKey()), String.valueOf(noExam), String.valueOf(oneExam), String.valueOf(twoExams), String.valueOf(threeExams), String.valueOf(fourExams), String.valueOf(btb), String.valueOf(dbtb)}, new Comparable[]{new MultiComparable(Integer.valueOf(0), (Comparable)entry.getKey()), new MultiComparable(Integer.valueOf(0), Integer.valueOf(noExam)), new MultiComparable(Integer.valueOf(0), Integer.valueOf(oneExam)), new MultiComparable(Integer.valueOf(0), Integer.valueOf(twoExams)), new MultiComparable(Integer.valueOf(0), Integer.valueOf(threeExams)), new MultiComparable(Integer.valueOf(0), Integer.valueOf(fourExams)), new MultiComparable(Integer.valueOf(0), Integer.valueOf(btb)), new MultiComparable(Integer.valueOf(0), Integer.valueOf(dbtb))});
            tNoExam += noExam;
            tOneExam += oneExam;
            tTwoExams += twoExams;
            tThreeExams += threeExams;
            tFourExams += fourExams;
            tBtb += btb;
            tDistBtb += dbtb;
        }
        table.addLine(new String[]{html ? "<b>" + MSG.colTotals() + "</b>" : MSG.colTotals(), html ? "<b>" + tNoExam + "</b>" : String.valueOf(tNoExam), html ? "<b>" + tOneExam + "</b>" : String.valueOf(tOneExam), html ? "<b>" + tTwoExams + "</b>" : String.valueOf(tTwoExams), html ? "<b>" + tThreeExams + "</b>" : String.valueOf(tThreeExams), html ? "<b>" + tFourExams + "</b>" : String.valueOf(tFourExams), html ? "<b>" + tBtb + "</b>" : String.valueOf(tBtb), html ? "<b>" + tDistBtb + "</b>" : String.valueOf(tDistBtb)}, new Comparable[]{new MultiComparable(Integer.valueOf(1), null), new MultiComparable(Integer.valueOf(1), Integer.valueOf(tNoExam)), new MultiComparable(Integer.valueOf(1), Integer.valueOf(tOneExam)), new MultiComparable(Integer.valueOf(1), Integer.valueOf(tTwoExams)), new MultiComparable(Integer.valueOf(1), Integer.valueOf(tThreeExams)), new MultiComparable(Integer.valueOf(1), Integer.valueOf(tFourExams)), new MultiComparable(Integer.valueOf(1), Integer.valueOf(tBtb)), new MultiComparable(Integer.valueOf(1), Integer.valueOf(tDistBtb))});
        return table;
    }

    private PdfWebTable generateRoomSplitReport(boolean html, ExamAssignmentReportForm form, Collection<ExamAssignmentInfo> exams) {
        String nl = html ? "<br>" : "\n";
        ArrayList<String> colNames = new ArrayList<String>(Arrays.asList(form.getShowSections() ? MSG.colOwner() : MSG.colExamination(), MSG.colEnrollment(), MSG.colSeatingType().replace("\n", nl), MSG.colDate(), MSG.colTime(), MSG.colAverageDistance().replace("\n", nl)));
        ArrayList<String> colCmp = new ArrayList<String>(Arrays.asList("left", "left", "center", "left", "left", "left"));
        ArrayList<Boolean> colOrd = new ArrayList<Boolean>(Arrays.asList(true, true, true, true, true, true));
        int maxSplits = 2;
        for (ExamAssignmentInfo exam : exams) {
            if (exam.getRooms() == null || exam.getRooms().size() <= maxSplits) continue;
            maxSplits = exam.getRooms().size();
        }
        for (int i = 1; i <= maxSplits; ++i) {
            String pos;
            switch (i) {
                case 1: {
                    pos = MSG.col1stExam();
                    break;
                }
                case 2: {
                    pos = MSG.col2ndExam();
                    break;
                }
                case 3: {
                    pos = MSG.col3rdExam();
                    break;
                }
                default: {
                    pos = MSG.colNthExam(i);
                }
            }
            colNames.add(pos + " " + MSG.colRoom());
            colNames.add(pos + " " + MSG.colRoom() + nl + MSG.colRoomCapacity());
            colCmp.add("left");
            colCmp.add("left");
            colOrd.add(true);
            colOrd.add(true);
        }
        boolean[] ord = new boolean[colOrd.size()];
        for (int i = 0; i < colOrd.size(); ++i) {
            ord[i] = (Boolean)colOrd.get(i);
        }
        PdfWebTable table = new PdfWebTable(colNames.size(), form.getReportName(), "examAssignmentReport.action?ord=%%", colNames.toArray(new String[colNames.size()]), colCmp.toArray(new String[colCmp.size()]), ord);
        table.setRowStyle("white-space:nowrap");
        for (ExamAssignmentInfo exam : exams) {
            if (exam.getRooms() == null || exam.getRooms().size() <= 1) continue;
            if (form.getShowSections()) {
                boolean firstSection = true;
                for (ExamInfo.ExamSectionInfo examSectionInfo : exam.getSections()) {
                    if (!this.match(form, examSectionInfo.getName())) continue;
                    double distance = 0.0;
                    for (ExamRoomInfo r1 : exam.getRooms()) {
                        for (ExamRoomInfo r2 : exam.getRooms()) {
                            if (r1.getLocationId().compareTo(r2.getLocationId()) >= 0) continue;
                            distance += r1.getDistance(r2);
                        }
                    }
                    distance /= (double)(exam.getRooms().size() * (exam.getRooms().size() - 1) / 2);
                    ArrayList<Object> line = new ArrayList<Object>(colNames.size());
                    line.add((String)(html ? "<a name='" + exam.getExamId() + "'>" : "") + examSectionInfo.getName() + (html ? "</a>" : ""));
                    line.add(String.valueOf(examSectionInfo.getNrStudents()));
                    line.add(exam.getSeatingTypeLabel());
                    line.add(exam.getDate(html));
                    line.add(exam.getTime(html));
                    line.add((int)(distance * 10.0) == 0 ? "" : (int)(distance * 10.0) + " m");
                    ArrayList<MultiComparable> cmp = new ArrayList<MultiComparable>(colNames.size());
                    cmp.add(new MultiComparable((Comparable)((Object)examSectionInfo.getName()), exam));
                    cmp.add(new MultiComparable(Integer.valueOf(exam.getNrStudents()), (Comparable)((Object)examSectionInfo.getName()), exam));
                    cmp.add(new MultiComparable(Integer.valueOf(exam.getSeatingType()), (Comparable)((Object)examSectionInfo.getName()), exam));
                    cmp.add(new MultiComparable(exam.getPeriodOrd(), (Comparable)((Object)examSectionInfo.getName()), exam));
                    cmp.add(new MultiComparable(exam.getPeriod().getStartSlot(), (Comparable)((Object)examSectionInfo.getName()), exam));
                    cmp.add(new MultiComparable(Double.valueOf(-distance), (Comparable)((Object)examSectionInfo.getName()), exam));
                    for (ExamRoomInfo room : exam.getRooms()) {
                        line.add(html ? room.toString() : room.getName());
                        line.add(html ? "<font color='" + PreferenceLevel.int2color(room.getPreference()) + "'>" + room.getCapacity(exam) + "</font>" : String.valueOf(room.getCapacity(exam)));
                        cmp.add(new MultiComparable((Comparable)((Object)room.getName()), (Comparable)((Object)examSectionInfo.getName()), exam));
                        cmp.add(new MultiComparable(Integer.valueOf(room.getCapacity(exam)), (Comparable)((Object)examSectionInfo.getName()), exam));
                    }
                    for (int i = exam.getRooms().size(); i < maxSplits; ++i) {
                        line.add("");
                        line.add("");
                        cmp.add(new MultiComparable((Comparable)((Object)""), (Comparable)((Object)examSectionInfo.getName()), exam));
                        cmp.add(new MultiComparable(Integer.valueOf(0), (Comparable)((Object)examSectionInfo.getName()), exam));
                    }
                    table.addLine("onClick=\"document.location='examDetail.action?examId=" + exam.getExamId() + "';\"", line.toArray(new String[line.size()]), cmp.toArray(new Comparable[cmp.size()]), firstSection ? exam.getExamId().toString() : null);
                    firstSection = false;
                }
                continue;
            }
            if (!this.match(form, exam.getExamName())) continue;
            double distance = 0.0;
            for (ExamRoomInfo r1 : exam.getRooms()) {
                for (ExamRoomInfo r2 : exam.getRooms()) {
                    if (r1.getLocationId().compareTo(r2.getLocationId()) >= 0) continue;
                    distance += r1.getDistance(r2);
                }
            }
            distance /= (double)(exam.getRooms().size() * (exam.getRooms().size() - 1) / 2);
            ArrayList<Object> arrayList = new ArrayList<Object>(colNames.size());
            arrayList.add((String)(html ? "<a name='" + exam.getExamId() + "'>" : "") + exam.getExamName() + (html ? "</a>" : ""));
            arrayList.add(String.valueOf(exam.getNrStudents()));
            arrayList.add(exam.getSeatingTypeLabel());
            arrayList.add(exam.getDate(html));
            arrayList.add(exam.getTime(html));
            arrayList.add((int)(distance * 10.0) == 0 ? "" : (int)(distance * 10.0) + " m");
            ArrayList<MultiComparable> cmp = new ArrayList<MultiComparable>(colNames.size());
            cmp.add(new MultiComparable(exam));
            cmp.add(new MultiComparable(Integer.valueOf(exam.getNrStudents()), exam));
            cmp.add(new MultiComparable(Integer.valueOf(exam.getSeatingType()), exam));
            cmp.add(new MultiComparable(exam.getPeriodOrd(), exam));
            cmp.add(new MultiComparable(exam.getPeriod().getStartSlot(), exam));
            cmp.add(new MultiComparable(Double.valueOf(-distance), exam));
            for (ExamRoomInfo room : exam.getRooms()) {
                arrayList.add(html ? room.toString() : room.getName());
                arrayList.add(html ? "<font color='" + PreferenceLevel.int2color(room.getPreference()) + "'>" + room.getCapacity(exam) + "</font>" : String.valueOf(room.getCapacity(exam)));
                cmp.add(new MultiComparable((Comparable)((Object)room.getName()), exam));
                cmp.add(new MultiComparable(Integer.valueOf(room.getCapacity(exam)), exam));
            }
            for (int i = exam.getRooms().size(); i < maxSplits; ++i) {
                arrayList.add("");
                arrayList.add("");
                cmp.add(new MultiComparable((Comparable)((Object)""), exam));
                cmp.add(new MultiComparable(Integer.valueOf(0), exam));
            }
            table.addLine("onClick=\"document.location='examDetail.action?examId=" + exam.getExamId() + "';\"", arrayList.toArray(new String[arrayList.size()]), cmp.toArray(new Comparable[cmp.size()]), exam.getExamId().toString());
        }
        return table;
    }

    private PdfWebTable generateViolatedDistributionsReport(boolean html, ExamAssignmentReportForm form, Collection<ExamAssignmentInfo> exams) {
        String nl = html ? "<br>" : "\n";
        PdfWebTable table = new PdfWebTable(8, form.getReportName(), "examAssignmentReport.action?ord=%%", new String[]{MSG.colPreference(), MSG.colDistribution(), form.getShowSections() ? MSG.colOwner() : MSG.colExamination(), MSG.colEnrollment(), MSG.colSeatingType().replace("\n", nl), MSG.colDate(), MSG.colTime(), MSG.colRoom()}, new String[]{"left", "left", "left", "right", "center", "left", "left", "left"}, new boolean[]{true, true, true, true, true, true, true, true});
        table.setRowStyle("white-space:nowrap");
        HashSet<ExamAssignmentInfo.DistributionConflict> conflicts = new HashSet<ExamAssignmentInfo.DistributionConflict>();
        for (ExamAssignmentInfo exam : exams) {
            if (!this.match(form, exam)) continue;
            for (ExamAssignmentInfo.DistributionConflict conf : exam.getDistributionConflicts()) {
                if (conflicts.contains(conf)) continue;
                conf.getOtherExams().add(exam);
                conflicts.add(conf);
            }
        }
        for (ExamAssignmentInfo.DistributionConflict conf : conflicts) {
            Object classes = "";
            Object enrollment = "";
            Object seating = "";
            Object date = "";
            Object time = "";
            Object room = "";
            int idx = 0;
            Comparable[] dates = new Date[conf.getOtherExams().size()];
            Comparable[] times = new Integer[conf.getOtherExams().size()];
            int enrl = 0;
            for (ExamInfo exam : conf.getOtherExams()) {
                enrl += exam.getNrStudents();
                if (form.getShowSections()) {
                    if (exam instanceof ExamAssignment) {
                        ExamAssignment ea = (ExamAssignment)exam;
                        dates[idx] = ea.getPeriod().getStartTime();
                        times[idx] = ea.getPeriod().getStartSlot();
                    } else {
                        dates[idx] = new Date(0L);
                        times[idx] = -1;
                    }
                    ++idx;
                    boolean firstSection = true;
                    for (ExamInfo.ExamSectionInfo section : exam.getSections()) {
                        if (((String)classes).length() > 0) {
                            classes = (String)classes + nl;
                            enrollment = (String)enrollment + nl;
                            seating = (String)seating + nl;
                            date = (String)date + nl;
                            time = (String)time + nl;
                            room = (String)room + nl;
                        }
                        classes = (String)classes + section.getName();
                        enrollment = (String)enrollment + section.getNrStudents();
                        if (firstSection) {
                            seating = (String)seating + exam.getSeatingTypeLabel();
                            if (exam instanceof ExamAssignment) {
                                ExamAssignment ea = (ExamAssignment)exam;
                                date = (String)date + ea.getDate(html);
                                time = (String)time + ea.getTime(html);
                                room = (String)room + ea.getRoomsName(html, ", ");
                            }
                        }
                        firstSection = false;
                    }
                    continue;
                }
                if (((String)classes).length() > 0) {
                    classes = (String)classes + nl;
                    enrollment = (String)enrollment + nl;
                    seating = (String)seating + nl;
                    date = (String)date + nl;
                    time = (String)time + nl;
                    room = (String)room + nl;
                }
                classes = (String)classes + exam.getExamName();
                enrollment = (String)enrollment + exam.getNrStudents();
                seating = (String)seating + exam.getSeatingTypeLabel();
                if (!(exam instanceof ExamAssignment)) continue;
                ExamAssignment ea = (ExamAssignment)exam;
                date = (String)date + ea.getDate(html);
                time = (String)time + ea.getTime(html);
                room = (String)room + ea.getRoomsName(html, ", ");
            }
            table.addLine(new String[]{(String)(html ? "<font color='" + PreferenceLevel.prolog2color(conf.getPreference()) + "'>" : "") + PreferenceLevel.prolog2string(conf.getPreference()) + (html ? "</font>" : ""), (String)(html ? "<font color='" + PreferenceLevel.prolog2color(conf.getPreference()) + "'>" : "") + conf.getType() + (html ? "</font>" : ""), classes, enrollment, seating, date, time, room}, new Comparable[]{new MultiComparable(conf), new MultiComparable((Comparable)((Object)conf.getType()), conf), new MultiComparable((Comparable)classes, conf), new MultiComparable(Integer.valueOf(-enrl), conf), new MultiComparable((Comparable)seating, conf), new MultiComparable(dates), new MultiComparable(times), new MultiComparable((Comparable)room, conf)});
        }
        return table;
    }

    private PdfWebTable generateIndividualConflictsReport(boolean html, Long sessionId, ExamAssignmentReportForm form, Collection<ExamAssignmentInfo> exams, boolean studentConf, boolean direct, boolean m2d, boolean btb, String nameFormat) {
        Hashtable<Long, Student> students = new Hashtable<Long, Student>();
        if (studentConf) {
            HashSet<Long> allStudentIds = new HashSet<Long>();
            for (ExamAssignmentInfo exam : exams) {
                if (direct) {
                    for (ExamAssignmentInfo.DirectConflict directConflict : exam.getDirectConflicts()) {
                        allStudentIds.addAll(directConflict.getStudents());
                    }
                }
                if (btb) {
                    for (ExamAssignmentInfo.BackToBackConflict backToBackConflict : exam.getBackToBackConflicts()) {
                        allStudentIds.addAll(backToBackConflict.getStudents());
                    }
                }
                if (!m2d) continue;
                for (ExamAssignmentInfo.MoreThanTwoADayConflict moreThanTwoADayConflict : exam.getMoreThanTwoADaysConflicts()) {
                    allStudentIds.addAll(moreThanTwoADayConflict.getStudents());
                }
            }
            Object inSet = null;
            int idx = 0;
            Iterator i = allStudentIds.iterator();
            while (i.hasNext()) {
                if (idx == 1000) {
                    for (Student student : StudentDAO.getInstance().getSession().createQuery("select s from Student s where s.uniqueId in (" + inSet + ")", Student.class).list()) {
                        students.put(student.getUniqueId(), student);
                    }
                    idx = 0;
                    inSet = null;
                }
                inSet = inSet == null ? i.next().toString() : (String)inSet + "," + String.valueOf(i.next());
                ++idx;
            }
            if (inSet != null) {
                for (Student student : StudentDAO.getInstance().getSession().createQuery("select s from Student s where s.uniqueId in (" + inSet + ")", Student.class).list()) {
                    students.put(student.getUniqueId(), student);
                }
            }
        }
        String nl = html ? "<br>" : "\n";
        PdfWebTable table = new PdfWebTable(10, form.getReportName(), "examAssignmentReport.action?ord=%%", new String[]{studentConf ? MSG.colStudentId() : MSG.colInstructorId(), MSG.colStudentOrInstructorName(), MSG.colType(), form.getShowSections() ? MSG.colOwner() : MSG.colExamination(), MSG.colEnrollment(), MSG.colSeatingType().replace("\n", nl), MSG.colDate(), MSG.colTime(), MSG.colRoom(), MSG.colDistance()}, new String[]{"left", "left", "left", "left", "right", "center", "left", "left", "left", "left"}, new boolean[]{true, true, true, true, true, true, true, true, true, true});
        table.setRowStyle("white-space:nowrap");
        table.setBlankWhenSame(true);
        for (ExamAssignmentInfo exam : exams) {
            boolean firstSection;
            Object room;
            Object time;
            Object date;
            Object seating;
            Object enrollment;
            Object classes;
            DepartmentalInstructor instructor;
            Student student;
            String name;
            String id;
            if (direct) {
                for (ExamAssignmentInfo.DirectConflict directConflict : studentConf ? exam.getDirectConflicts() : exam.getInstructorDirectConflicts()) {
                    if (directConflict.getOtherExam() != null && exam.compareTo(directConflict.getOtherExam()) >= 0 && exams.contains(directConflict.getOtherExam())) continue;
                    for (Long studentId : directConflict.getStudents()) {
                        id = "";
                        name = "";
                        if (studentConf) {
                            student = (Student)students.get(studentId);
                            id = student.getExternalUniqueId();
                            name = student.getName(nameFormat);
                        } else {
                            instructor = (DepartmentalInstructor)DepartmentalInstructorDAO.getInstance().get(studentId);
                            id = instructor.getExternalUniqueId();
                            name = instructor.getName(nameFormat);
                        }
                        if (!this.match(form, id) && !this.match(form, name)) continue;
                        if (form.getShowSections()) {
                            classes = "";
                            enrollment = "";
                            seating = "";
                            date = "";
                            time = "";
                            room = "";
                            firstSection = true;
                            for (ExamInfo.ExamSectionInfo examSectionInfo : exam.getSections()) {
                                if (studentConf && !examSectionInfo.getStudentIds().contains(studentId)) continue;
                                if (((String)classes).length() > 0) {
                                    classes = (String)classes + nl;
                                    enrollment = (String)enrollment + nl;
                                    seating = (String)seating + nl;
                                    date = (String)date + nl;
                                    time = (String)time + nl;
                                    room = (String)room + nl;
                                }
                                classes = (String)classes + examSectionInfo.getName();
                                enrollment = (String)enrollment + String.valueOf(examSectionInfo.getNrStudents());
                                if (firstSection) {
                                    seating = (String)seating + exam.getSeatingTypeLabel();
                                    date = (String)date + exam.getDate(html);
                                    time = (String)time + exam.getTime(html);
                                    room = (String)room + exam.getRoomsName(html, ", ");
                                }
                                firstSection = false;
                            }
                            firstSection = true;
                            if (directConflict.getOtherExam() != null) {
                                for (ExamInfo.ExamSectionInfo examSectionInfo : directConflict.getOtherExam().getSections()) {
                                    if (studentConf && !examSectionInfo.getStudentIds().contains(studentId)) continue;
                                    if (((String)classes).length() > 0) {
                                        classes = (String)classes + nl;
                                        enrollment = (String)enrollment + nl;
                                        seating = (String)seating + nl;
                                        date = (String)date + nl;
                                        time = (String)time + nl;
                                        room = (String)room + nl;
                                    }
                                    classes = (String)classes + examSectionInfo.getName();
                                    enrollment = (String)enrollment + String.valueOf(examSectionInfo.getNrStudents());
                                    if (firstSection) {
                                        seating = (String)seating + directConflict.getOtherExam().getSeatingTypeLabel();
                                        room = (String)room + directConflict.getOtherExam().getRoomsName(html, ", ");
                                        if (!exam.getPeriod().equals(directConflict.getOtherExam().getPeriod()) || exam.getLength() != directConflict.getOtherExam().getLength()) {
                                            time = (String)time + directConflict.getOtherExam().getTime(html);
                                        }
                                    }
                                    firstSection = false;
                                }
                            } else if (directConflict.getOtherEventId() != null) {
                                classes = (String)classes + nl;
                                enrollment = (String)enrollment + nl;
                                seating = (String)seating + nl;
                                date = (String)date + nl;
                                time = (String)time + nl;
                                room = (String)room + nl;
                                classes = (String)classes + directConflict.getOtherEventName();
                                enrollment = (String)enrollment + directConflict.getOtherEventSize();
                                seating = (String)seating + (directConflict.isOtherClass() ? MSG.typeClass() : MSG.typeEvent());
                                room = (String)room + directConflict.getOtherEventRoom();
                                time = (String)time + directConflict.getOtherEventTime();
                            }
                            table.addLine("onClick=\"document.location='examDetail.action?examId=" + exam.getExamId() + "';\"", new String[]{id, name, (String)(html ? "<font color='" + PreferenceLevel.prolog2color("P") + "'>" : "") + MSG.conflictDirect() + (html ? "</font>" : ""), classes, enrollment, seating, date, time, room, ""}, new Comparable[]{new MultiComparable((Comparable)((Object)id), exam, Integer.valueOf(0)), new MultiComparable((Comparable)((Object)name), (Comparable)((Object)id), exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(0), exam, Integer.valueOf(0)), new MultiComparable(exam, exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(-exam.getNrStudents() - (directConflict.getOtherExam() == null ? 0 : directConflict.getOtherExam().getNrStudents())), exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(exam.getSeatingType()), exam, Integer.valueOf(0)), new MultiComparable(exam.getPeriodOrd(), exam, Integer.valueOf(0)), new MultiComparable(exam.getPeriod().getStartSlot(), exam, Integer.valueOf(0)), new MultiComparable((Comparable)((Object)exam.getRoomsName(":")), exam, Integer.valueOf(0)), new MultiComparable(Double.valueOf(-1.0), exam, Integer.valueOf(0))}, exam.getExamId().toString());
                            continue;
                        }
                        if (directConflict.getOtherExam() != null) {
                            table.addLine("onClick=\"document.location='examDetail.action?examId=" + exam.getExamId() + "';\"", new String[]{id, name, (String)(html ? "<font color='" + PreferenceLevel.prolog2color("P") + "'>" : "") + MSG.conflictDirect() + (html ? "</font>" : ""), exam.getExamName() + nl + directConflict.getOtherExam().getExamName(), exam.getNrStudents() + nl + directConflict.getOtherExam().getNrStudents(), exam.getSeatingTypeLabel() + nl + directConflict.getOtherExam().getSeatingTypeLabel(), exam.getDate(html) + nl, exam.getTime(html) + nl + (exam.getPeriod().equals(directConflict.getOtherExam().getPeriod()) && exam.getLength() == directConflict.getOtherExam().getLength() ? "" : directConflict.getOtherExam().getTime(html)), exam.getRoomsName(html, ", ") + nl + directConflict.getOtherExam().getRoomsName(html, ", "), ""}, new Comparable[]{new MultiComparable((Comparable)((Object)id), exam, Integer.valueOf(0)), new MultiComparable((Comparable)((Object)name), (Comparable)((Object)id), exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(0), exam, Integer.valueOf(0)), new MultiComparable(exam, exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(-exam.getNrStudents() - directConflict.getOtherExam().getNrStudents()), exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(exam.getSeatingType()), exam, Integer.valueOf(0)), new MultiComparable(exam.getPeriodOrd(), exam, Integer.valueOf(0)), new MultiComparable(exam.getPeriod().getStartSlot(), exam, Integer.valueOf(0)), new MultiComparable((Comparable)((Object)exam.getRoomsName(":")), exam, Integer.valueOf(0)), new MultiComparable(Double.valueOf(-1.0), exam, Integer.valueOf(0))}, exam.getExamId().toString());
                            continue;
                        }
                        if (directConflict.getOtherEventId() == null) continue;
                        table.addLine("onClick=\"document.location='examDetail.action?examId=" + exam.getExamId() + "';\"", new String[]{id, name, (String)(html ? "<font color='" + PreferenceLevel.prolog2color("P") + "'>" : "") + MSG.conflictDirect() + (html ? "</font>" : ""), exam.getExamName() + nl + directConflict.getOtherEventName(), String.valueOf(exam.getNrStudents()) + nl + directConflict.getOtherEventSize(), exam.getSeatingTypeLabel() + nl + (directConflict.isOtherClass() ? MSG.typeClass() : MSG.typeEvent()), exam.getDate(html) + nl, exam.getTime(html) + nl + directConflict.getOtherEventTime(), exam.getRoomsName(html, ", ") + nl + directConflict.getOtherEventRoom(), ""}, new Comparable[]{new MultiComparable((Comparable)((Object)id), exam, Integer.valueOf(0)), new MultiComparable((Comparable)((Object)name), (Comparable)((Object)id), exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(0), exam, Integer.valueOf(0)), new MultiComparable(exam, exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(-exam.getNrStudents() - directConflict.getOtherEventSize()), exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(exam.getSeatingType()), exam, Integer.valueOf(0)), new MultiComparable(exam.getPeriodOrd(), exam, Integer.valueOf(0)), new MultiComparable(exam.getPeriod().getStartSlot(), exam, Integer.valueOf(0)), new MultiComparable((Comparable)((Object)exam.getRoomsName(":")), exam, Integer.valueOf(0)), new MultiComparable(Double.valueOf(-1.0), exam, Integer.valueOf(0))}, exam.getExamId().toString());
                    }
                }
            }
            if (btb) {
                for (ExamAssignmentInfo.BackToBackConflict backToBackConflict : studentConf ? exam.getBackToBackConflicts() : exam.getInstructorBackToBackConflicts()) {
                    if (exam.compareTo(backToBackConflict.getOtherExam()) >= 0 && exams.contains(backToBackConflict.getOtherExam())) continue;
                    for (Long studentId : backToBackConflict.getStudents()) {
                        id = "";
                        name = "";
                        if (studentConf) {
                            student = (Student)students.get(studentId);
                            id = student.getExternalUniqueId();
                            name = student.getName(nameFormat);
                        } else {
                            instructor = (DepartmentalInstructor)DepartmentalInstructorDAO.getInstance().get(studentId);
                            id = instructor.getExternalUniqueId();
                            name = instructor.getName(nameFormat);
                        }
                        if (!this.match(form, id) && !this.match(form, name)) continue;
                        if (form.getShowSections()) {
                            classes = "";
                            enrollment = "";
                            seating = "";
                            date = "";
                            time = "";
                            room = "";
                            firstSection = true;
                            for (ExamInfo.ExamSectionInfo examSectionInfo : exam.getSections()) {
                                if (studentConf && !examSectionInfo.getStudentIds().contains(studentId)) continue;
                                if (((String)classes).length() > 0) {
                                    classes = (String)classes + nl;
                                    enrollment = (String)enrollment + nl;
                                    seating = (String)seating + nl;
                                    date = (String)date + nl;
                                    time = (String)time + nl;
                                    room = (String)room + nl;
                                }
                                classes = (String)classes + examSectionInfo.getName();
                                enrollment = (String)enrollment + String.valueOf(examSectionInfo.getNrStudents());
                                if (firstSection) {
                                    seating = (String)seating + exam.getSeatingTypeLabel();
                                    date = (String)date + exam.getDate(html);
                                    time = (String)time + exam.getTime(html);
                                    room = (String)room + exam.getRoomsName(html, ", ");
                                }
                                firstSection = false;
                            }
                            firstSection = true;
                            for (ExamInfo.ExamSectionInfo examSectionInfo : backToBackConflict.getOtherExam().getSections()) {
                                if (studentConf && !examSectionInfo.getStudentIds().contains(studentId)) continue;
                                if (((String)classes).length() > 0) {
                                    classes = (String)classes + nl;
                                    enrollment = (String)enrollment + nl;
                                    seating = (String)seating + nl;
                                    date = (String)date + nl;
                                    time = (String)time + nl;
                                    room = (String)room + nl;
                                }
                                classes = (String)classes + examSectionInfo.getName();
                                enrollment = (String)enrollment + String.valueOf(examSectionInfo.getNrStudents());
                                if (firstSection) {
                                    seating = (String)seating + exam.getSeatingTypeLabel();
                                    time = (String)time + backToBackConflict.getOtherExam().getTime(html);
                                    room = (String)room + backToBackConflict.getOtherExam().getRoomsName(html, ", ");
                                }
                                firstSection = false;
                            }
                            table.addLine("onClick=\"document.location='examDetail.action?examId=" + exam.getExamId() + "';\"", new String[]{id, name, (String)(html ? "<font color='" + PreferenceLevel.prolog2color("1") + "'>" : "") + MSG.conflictBackToBack() + (html ? "</font>" : ""), classes, enrollment, seating, date, time, room, (int)(backToBackConflict.getDistance() * 10.0) + " m"}, new Comparable[]{new MultiComparable((Comparable)((Object)id), exam, Integer.valueOf(0)), new MultiComparable((Comparable)((Object)name), (Comparable)((Object)id), exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(2), exam, Integer.valueOf(0)), new MultiComparable(exam, exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(-exam.getNrStudents() - backToBackConflict.getOtherExam().getNrStudents()), exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(exam.getSeatingType()), exam, Integer.valueOf(0)), new MultiComparable(exam.getPeriodOrd(), exam, Integer.valueOf(0)), new MultiComparable(exam.getPeriod().getStartSlot(), exam, Integer.valueOf(0)), new MultiComparable((Comparable)((Object)exam.getRoomsName(":")), exam, Integer.valueOf(0)), new MultiComparable(Double.valueOf(backToBackConflict.getDistance()), exam, Integer.valueOf(0))}, exam.getExamId().toString());
                            continue;
                        }
                        table.addLine("onClick=\"document.location='examDetail.action?examId=" + exam.getExamId() + "';\"", new String[]{id, name, (String)(html ? "<font color='" + PreferenceLevel.prolog2color("1") + "'>" : "") + MSG.conflictBackToBack() + (html ? "</font>" : ""), exam.getExamName() + nl + backToBackConflict.getOtherExam().getExamName(), exam.getNrStudents() + nl + backToBackConflict.getOtherExam().getNrStudents(), exam.getSeatingTypeLabel() + nl + backToBackConflict.getOtherExam().getSeatingTypeLabel(), exam.getDate(html) + nl, exam.getTime(html) + nl + backToBackConflict.getOtherExam().getTime(html), exam.getRoomsName(html, ", ") + nl + backToBackConflict.getOtherExam().getRoomsName(html, ", "), (int)(backToBackConflict.getDistance() * 10.0) + " m"}, new Comparable[]{new MultiComparable((Comparable)((Object)id), exam, Integer.valueOf(0)), new MultiComparable((Comparable)((Object)name), (Comparable)((Object)id), exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(2), exam, Integer.valueOf(0)), new MultiComparable(exam, exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(-exam.getNrStudents() - backToBackConflict.getOtherExam().getNrStudents()), exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(exam.getSeatingType()), exam, Integer.valueOf(0)), new MultiComparable(exam.getPeriodOrd(), exam, Integer.valueOf(0)), new MultiComparable(exam.getPeriod().getStartSlot(), exam, Integer.valueOf(0)), new MultiComparable((Comparable)((Object)exam.getRoomsName(":")), exam, Integer.valueOf(0)), new MultiComparable(Double.valueOf(backToBackConflict.getDistance()), exam, Integer.valueOf(0))}, exam.getExamId().toString());
                    }
                }
            }
            if (!m2d) continue;
            block16: for (ExamAssignmentInfo.MoreThanTwoADayConflict moreThanTwoADayConflict : studentConf ? exam.getMoreThanTwoADaysConflicts() : exam.getInstructorMoreThanTwoADaysConflicts()) {
                for (ExamAssignment other : moreThanTwoADayConflict.getOtherExams()) {
                    if (exam.compareTo(other) < 0 || !exams.contains(other)) continue;
                    continue block16;
                }
                for (Long studentId : moreThanTwoADayConflict.getStudents()) {
                    int nrStudents;
                    id = "";
                    name = "";
                    if (studentConf) {
                        student = (Student)students.get(studentId);
                        id = student.getExternalUniqueId();
                        name = student.getName(nameFormat);
                    } else {
                        instructor = (DepartmentalInstructor)DepartmentalInstructorDAO.getInstance().get(studentId);
                        id = instructor.getExternalUniqueId();
                        name = instructor.getName(nameFormat);
                    }
                    if (!this.match(form, id) && !this.match(form, name)) continue;
                    if (form.getShowSections()) {
                        classes = "";
                        enrollment = "";
                        seating = "";
                        date = "";
                        time = "";
                        room = "";
                        nrStudents = exam.getNrStudents();
                        boolean firstSection2 = true;
                        for (ExamInfo.ExamSectionInfo section2 : exam.getSections()) {
                            if (studentConf && !section2.getStudentIds().contains(studentId)) continue;
                            if (((String)classes).length() > 0) {
                                classes = (String)classes + nl;
                                enrollment = (String)enrollment + nl;
                                seating = (String)seating + nl;
                                date = (String)date + nl;
                                time = (String)time + nl;
                                room = (String)room + nl;
                            }
                            classes = (String)classes + section2.getName();
                            enrollment = (String)enrollment + String.valueOf(section2.getNrStudents());
                            if (firstSection2) {
                                seating = (String)seating + exam.getSeatingTypeLabel();
                                date = (String)date + exam.getDate(html);
                                time = (String)time + exam.getTime(html);
                                room = (String)room + exam.getRoomsName(html, ", ");
                            }
                            firstSection2 = false;
                        }
                        for (ExamAssignment other : moreThanTwoADayConflict.getOtherExams()) {
                            firstSection2 = true;
                            nrStudents += other.getNrStudents();
                            for (ExamInfo.ExamSectionInfo section3 : other.getSections()) {
                                if (studentConf && !section3.getStudentIds().contains(studentId)) continue;
                                if (((String)classes).length() > 0) {
                                    classes = (String)classes + nl;
                                    enrollment = (String)enrollment + nl;
                                    seating = (String)seating + nl;
                                    date = (String)date + nl;
                                    time = (String)time + nl;
                                    room = (String)room + nl;
                                }
                                classes = (String)classes + section3.getName();
                                enrollment = (String)enrollment + String.valueOf(section3.getNrStudents());
                                if (firstSection2) {
                                    seating = (String)seating + other.getSeatingTypeLabel();
                                    time = (String)time + other.getTime(html);
                                    room = (String)room + other.getRoomsName(html, ", ");
                                }
                                firstSection2 = false;
                            }
                        }
                        table.addLine("onClick=\"document.location='examDetail.action?examId=" + exam.getExamId() + "';\"", new String[]{id, name, (String)(html ? "<font color='" + PreferenceLevel.prolog2color("2") + "'>" : "") + (html ? "&gt;" : "") + "2 A Day" + (html ? "</font>" : ""), classes, enrollment, seating, date, time, room, ""}, new Comparable[]{new MultiComparable((Comparable)((Object)id), exam, Integer.valueOf(0)), new MultiComparable((Comparable)((Object)name), (Comparable)((Object)id), exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(1), exam, Integer.valueOf(0)), new MultiComparable(exam, exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(-nrStudents), exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(exam.getSeatingType()), exam, Integer.valueOf(0)), new MultiComparable(exam.getPeriodOrd(), exam, Integer.valueOf(0)), new MultiComparable(exam.getPeriod().getStartSlot(), exam, Integer.valueOf(0)), new MultiComparable((Comparable)((Object)exam.getRoomsName(":")), exam, Integer.valueOf(0)), new MultiComparable(Double.valueOf(-1.0), exam, Integer.valueOf(0))}, exam.getExamId().toString());
                        continue;
                    }
                    classes = exam.getExamName();
                    enrollment = "" + exam.getNrStudents();
                    seating = exam.getSeatingTypeLabel();
                    date = exam.getDate(html);
                    time = exam.getTime(html);
                    room = exam.getRoomsName(html, ", ");
                    nrStudents = exam.getNrStudents();
                    for (ExamAssignment examAssignment : moreThanTwoADayConflict.getOtherExams()) {
                        classes = (String)classes + nl + examAssignment.getExamName();
                        enrollment = (String)enrollment + nl + examAssignment.getNrStudents();
                        seating = (String)seating + nl + examAssignment.getSeatingTypeLabel();
                        time = (String)time + nl + examAssignment.getTime(html);
                        room = (String)room + nl + examAssignment.getRoomsName(html, ", ");
                    }
                    table.addLine("onClick=\"document.location='examDetail.action?examId=" + exam.getExamId() + "';\"", new String[]{id, name, (String)(html ? "<font color='" + PreferenceLevel.prolog2color("2") + "'>" : "") + (html ? "&gt;" : "") + "2 A Day" + (html ? "</font>" : ""), classes, enrollment, seating, date, time, room, ""}, new Comparable[]{new MultiComparable((Comparable)((Object)id), exam, Integer.valueOf(0)), new MultiComparable((Comparable)((Object)name), (Comparable)((Object)id), exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(1), exam, Integer.valueOf(0)), new MultiComparable(exam, exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(-nrStudents), exam, Integer.valueOf(0)), new MultiComparable(Integer.valueOf(exam.getSeatingType()), exam, Integer.valueOf(0)), new MultiComparable(exam.getPeriodOrd(), exam, Integer.valueOf(0)), new MultiComparable(exam.getPeriod().getStartSlot(), exam, Integer.valueOf(0)), new MultiComparable((Comparable)((Object)exam.getRoomsName(":")), exam, Integer.valueOf(0)), new MultiComparable(Double.valueOf(-1.0), exam, Integer.valueOf(0))}, exam.getExamId().toString());
                }
            }
        }
        return table;
    }

    private PdfWebTable generateDirectConflictsReport(boolean html, ExamAssignmentReportForm form, Collection<ExamAssignmentInfo> exams, boolean studentConf) {
        String nl = html ? "<br>" : "\n";
        DecimalFormat df = new DecimalFormat("0.0");
        PdfWebTable table = new PdfWebTable(10, form.getReportName(), "examAssignmentReport.action?ord=%%", new String[]{MSG.col1stExam() + " " + (form.getShowSections() ? MSG.colOwner() : MSG.colExamination()), MSG.col1stExam() + " " + MSG.colEnrollment(), MSG.col1stExam() + " " + MSG.colSeatingType().replace("\n", nl), MSG.col2ndExam() + " " + (form.getShowSections() ? MSG.colOwner() : MSG.colExamination()), MSG.col2ndExam() + " " + MSG.colEnrollment(), MSG.col2ndExam() + " " + MSG.colSeatingType().replace("\n", nl), MSG.colDate(), MSG.colTime(), MSG.conflictDirect(), MSG.colDirectPercent()}, new String[]{"left", "right", "center", "left", "right", "center", "left", "left", "right", "right"}, new boolean[]{true, true, true, true, true, true, true, true, true, true});
        table.setRowStyle("white-space:nowrap");
        for (ExamAssignmentInfo exam : exams) {
            if (!this.match(form, exam)) continue;
            for (ExamAssignmentInfo.DirectConflict conflict : studentConf ? exam.getDirectConflicts() : exam.getInstructorDirectConflicts()) {
                if (this.match(form, conflict.getOtherExam()) && exam.compareTo(conflict.getOtherExam()) >= 0) continue;
                ExamAssignment other = conflict.getOtherExam();
                if (form.getShowSections()) {
                    for (ExamInfo.ExamSectionInfo section1 : exam.getSections()) {
                        if (other != null) {
                            for (ExamInfo.ExamSectionInfo section2 : conflict.getOtherExam().getSections()) {
                                if (!this.match(form, section1.getName()) && !this.match(form, section2.getName())) continue;
                                int nrStudents = 0;
                                if (studentConf) {
                                    for (Long studentId : section1.getStudentIds()) {
                                        if (!section2.getStudentIds().contains(studentId)) continue;
                                        ++nrStudents;
                                    }
                                } else {
                                    nrStudents = conflict.getNrStudents();
                                }
                                if (nrStudents == 0) continue;
                                table.addLine("onClick=\"document.location='examDetail.action?examId=" + exam.getExamId() + "';\"", new String[]{section1.getName(), String.valueOf(section1.getNrStudents()), exam.getSeatingTypeLabel(), section2.getName(), String.valueOf(section2.getNrStudents()), conflict.getOtherExam().getSeatingTypeLabel(), exam.getDate(html), exam.getTime(html), String.valueOf(nrStudents), df.format(100.0 * (double)nrStudents / (double)Math.min(section1.getNrStudents(), section2.getNrStudents()))}, new Comparable[]{new MultiComparable((Comparable)((Object)section1.getName()), (Comparable)((Object)section2.getName()), exam, other), new MultiComparable(Integer.valueOf(-section1.getNrStudents()), Integer.valueOf(-section2.getNrStudents()), (Comparable)((Object)section1.getName()), (Comparable)((Object)section2.getName()), exam, other), new MultiComparable(Integer.valueOf(exam.getSeatingType()), Integer.valueOf(other.getSeatingType()), (Comparable)((Object)section1.getName()), (Comparable)((Object)section2.getName()), exam, other), new MultiComparable((Comparable)((Object)section2.getName()), (Comparable)((Object)section1.getName()), other, exam), new MultiComparable(Integer.valueOf(-section2.getNrStudents()), Integer.valueOf(-section1.getNrStudents()), (Comparable)((Object)section2.getName()), (Comparable)((Object)section1.getName()), other, exam), new MultiComparable(Integer.valueOf(other.getSeatingType()), Integer.valueOf(exam.getSeatingType()), (Comparable)((Object)section2.getName()), (Comparable)((Object)section1.getName()), other, exam), new MultiComparable(exam.getPeriodOrd(), exam, other), new MultiComparable(exam.getPeriod().getStartSlot(), exam, other), new MultiComparable(Integer.valueOf(-nrStudents), exam, other), new MultiComparable(Double.valueOf(-100.0 * (double)nrStudents / (double)Math.min(section1.getNrStudents(), section2.getNrStudents())), exam, other)}, exam.getExamId().toString());
                            }
                            continue;
                        }
                        if (conflict.getOtherEventId() == null || !this.match(form, section1.getName())) continue;
                        int nrStudents = 0;
                        for (Long studentId : section1.getStudentIds()) {
                            if (!conflict.getStudents().contains(studentId)) continue;
                            ++nrStudents;
                        }
                        if (nrStudents == 0) continue;
                        table.addLine("onClick=\"document.location='examDetail.action?examId=" + exam.getExamId() + "';\"", new String[]{section1.getName(), String.valueOf(section1.getNrStudents()), exam.getSeatingTypeLabel(), conflict.getOtherEventName(), String.valueOf(conflict.getOtherEventSize()), conflict.isOtherClass() ? MSG.typeClass() : MSG.typeEvent(), exam.getDate(html), exam.getTime(html), String.valueOf(nrStudents), df.format(100.0 * (double)nrStudents / (double)Math.min(section1.getNrStudents(), conflict.getOtherEventSize()))}, new Comparable[]{new MultiComparable((Comparable)((Object)section1.getName()), (Comparable)((Object)conflict.getOtherEventName()), exam, other), new MultiComparable(Integer.valueOf(-section1.getNrStudents()), Integer.valueOf(-conflict.getOtherEventSize()), (Comparable)((Object)section1.getName()), (Comparable)((Object)conflict.getOtherEventName()), exam, other), new MultiComparable(Integer.valueOf(exam.getSeatingType()), Integer.valueOf(-1), (Comparable)((Object)section1.getName()), (Comparable)((Object)conflict.getOtherEventName()), exam, other), new MultiComparable((Comparable)((Object)conflict.getOtherEventName()), (Comparable)((Object)section1.getName()), other, exam), new MultiComparable(Integer.valueOf(-conflict.getOtherEventSize()), Integer.valueOf(-section1.getNrStudents()), (Comparable)((Object)conflict.getOtherEventName()), (Comparable)((Object)section1.getName()), other, exam), new MultiComparable(Integer.valueOf(-1), Integer.valueOf(exam.getSeatingType()), (Comparable)((Object)conflict.getOtherEventName()), (Comparable)((Object)section1.getName()), other, exam), new MultiComparable(exam.getPeriodOrd(), exam, other), new MultiComparable(exam.getPeriod().getStartSlot(), exam, other), new MultiComparable(Integer.valueOf(-nrStudents), exam, other), new MultiComparable(Double.valueOf(-100.0 * (double)nrStudents / (double)Math.min(section1.getNrStudents(), conflict.getOtherEventSize())), exam, other)}, exam.getExamId().toString());
                    }
                    continue;
                }
                if (other != null) {
                    table.addLine("onClick=\"document.location='examDetail.action?examId=" + exam.getExamId() + "';\"", new String[]{exam.getExamName(), String.valueOf(exam.getNrStudents()), exam.getSeatingTypeLabel(), other.getExamName(), String.valueOf(other.getNrStudents()), conflict.getOtherExam().getSeatingTypeLabel(), exam.getDate(html), exam.getTime(html), String.valueOf(conflict.getNrStudents()), df.format(100.0 * (double)conflict.getNrStudents() / (double)Math.min(exam.getNrStudents(), other.getNrStudents()))}, new Comparable[]{new MultiComparable(exam, other), new MultiComparable(Integer.valueOf(-exam.getNrStudents()), Integer.valueOf(-other.getNrStudents()), exam, other), new MultiComparable(Integer.valueOf(exam.getSeatingType()), Integer.valueOf(other.getSeatingType()), exam, other), new MultiComparable(other, exam), new MultiComparable(Integer.valueOf(-other.getNrStudents()), Integer.valueOf(-exam.getNrStudents()), other, exam), new MultiComparable(Integer.valueOf(other.getSeatingType()), Integer.valueOf(exam.getSeatingType()), other, exam), new MultiComparable(exam.getPeriodOrd(), exam, other), new MultiComparable(exam.getPeriod().getStartSlot(), exam, other), new MultiComparable(Integer.valueOf(-conflict.getNrStudents()), exam, other), new MultiComparable(Double.valueOf(-100.0 * (double)conflict.getNrStudents() / (double)Math.min(exam.getNrStudents(), other.getNrStudents())), exam, other)}, exam.getExamId().toString());
                    continue;
                }
                if (conflict.getOtherEventId() == null) continue;
                table.addLine("onClick=\"document.location='examDetail.action?examId=" + exam.getExamId() + "';\"", new String[]{exam.getExamName(), String.valueOf(exam.getNrStudents()), exam.getSeatingTypeLabel(), conflict.getOtherEventName(), String.valueOf(conflict.getOtherEventSize()), conflict.isOtherClass() ? MSG.typeClass() : MSG.typeEvent(), exam.getDate(html), exam.getTime(html), String.valueOf(conflict.getNrStudents()), df.format(100.0 * (double)conflict.getNrStudents() / (double)Math.min(exam.getNrStudents(), conflict.getOtherEventSize()))}, new Comparable[]{new MultiComparable(exam, other), new MultiComparable(Integer.valueOf(-exam.getNrStudents()), Integer.valueOf(-conflict.getOtherEventSize()), exam, other), new MultiComparable(Integer.valueOf(exam.getSeatingType()), Integer.valueOf(-1), exam, other), new MultiComparable(other, exam), new MultiComparable(Integer.valueOf(-conflict.getOtherEventSize()), Integer.valueOf(-exam.getNrStudents()), other, exam), new MultiComparable(Integer.valueOf(-1), Integer.valueOf(exam.getSeatingType()), other, exam), new MultiComparable(exam.getPeriodOrd(), exam, other), new MultiComparable(exam.getPeriod().getStartSlot(), exam, other), new MultiComparable(Integer.valueOf(-conflict.getNrStudents()), exam, other), new MultiComparable(Double.valueOf(-100.0 * (double)conflict.getNrStudents() / (double)Math.min(exam.getNrStudents(), conflict.getOtherEventSize())), exam, other)}, exam.getExamId().toString());
            }
        }
        return table;
    }

    private PdfWebTable generateBackToBackConflictsReport(boolean html, ExamAssignmentReportForm form, Collection<ExamAssignmentInfo> exams, boolean studentConf) {
        String nl = html ? "<br>" : "\n";
        DecimalFormat df = new DecimalFormat("0.0");
        PdfWebTable table = new PdfWebTable(11, form.getReportName(), "examAssignmentReport.action?ord=%%", new String[]{MSG.col1stExam() + " " + (form.getShowSections() ? MSG.colOwner() : MSG.colExamination()), MSG.col1stExam() + " " + MSG.colEnrollment(), MSG.col1stExam() + " " + MSG.colSeatingType().replace("\n", nl), MSG.col2ndExam() + " " + (form.getShowSections() ? MSG.colOwner() : MSG.colExamination()), MSG.col2ndExam() + " " + MSG.colEnrollment(), MSG.col2ndExam() + " " + MSG.colSeatingType().replace("\n", nl), MSG.colDate(), MSG.colTime(), MSG.conflictBackToBack(), MSG.colBackToBackPercent(), MSG.colDistanceMeters()}, new String[]{"left", "right", "center", "left", "right", "center", "left", "left", "right", "right", "right"}, new boolean[]{true, true, true, true, true, true, true, true, true, true, true});
        table.setRowStyle("white-space:nowrap");
        for (ExamAssignmentInfo exam : exams) {
            if (!this.match(form, exam)) continue;
            for (ExamAssignmentInfo.BackToBackConflict conflict : studentConf ? exam.getBackToBackConflicts() : exam.getInstructorBackToBackConflicts()) {
                if (this.match(form, conflict.getOtherExam()) && exam.getPeriod().compareTo(conflict.getOtherExam().getPeriod()) >= 0) continue;
                ExamAssignment other = conflict.getOtherExam();
                if (form.getShowSections()) {
                    for (ExamInfo.ExamSectionInfo section1 : exam.getSections()) {
                        for (ExamInfo.ExamSectionInfo section2 : conflict.getOtherExam().getSections()) {
                            int nrStudents = 0;
                            if (!this.match(form, section1.getName()) && !this.match(form, section2.getName())) continue;
                            if (studentConf) {
                                for (Long studentId : section1.getStudentIds()) {
                                    if (!section2.getStudentIds().contains(studentId)) continue;
                                    ++nrStudents;
                                }
                            } else {
                                nrStudents = conflict.getNrStudents();
                            }
                            if (nrStudents == 0) continue;
                            table.addLine("onClick=\"document.location='examDetail.action?examId=" + exam.getExamId() + "';\"", new String[]{section1.getName(), String.valueOf(section1.getNrStudents()), exam.getSeatingTypeLabel(), section2.getName(), String.valueOf(section2.getNrStudents()), conflict.getOtherExam().getSeatingTypeLabel(), exam.getDate(html), exam.getTime(html), String.valueOf(nrStudents), df.format(100.0 * (double)nrStudents / (double)Math.min(section1.getNrStudents(), section2.getNrStudents())), String.valueOf((int)(10.0 * conflict.getDistance()))}, new Comparable[]{new MultiComparable((Comparable)((Object)section1.getName()), (Comparable)((Object)section2.getName()), exam, other), new MultiComparable(Integer.valueOf(-section1.getNrStudents()), Integer.valueOf(-section2.getNrStudents()), (Comparable)((Object)section1.getName()), (Comparable)((Object)section2.getName()), exam, other), new MultiComparable(Integer.valueOf(exam.getSeatingType()), Integer.valueOf(other.getSeatingType()), (Comparable)((Object)section1.getName()), (Comparable)((Object)section2.getName()), exam, other), new MultiComparable((Comparable)((Object)section2.getName()), (Comparable)((Object)section1.getName()), other, exam), new MultiComparable(Integer.valueOf(-section2.getNrStudents()), Integer.valueOf(-section1.getNrStudents()), (Comparable)((Object)section2.getName()), (Comparable)((Object)section1.getName()), other, exam), new MultiComparable(Integer.valueOf(other.getSeatingType()), Integer.valueOf(exam.getSeatingType()), (Comparable)((Object)section2.getName()), (Comparable)((Object)section1.getName()), other, exam), new MultiComparable(exam.getPeriodOrd(), exam, other), new MultiComparable(exam.getPeriod().getStartSlot(), exam, other), new MultiComparable(Integer.valueOf(-nrStudents), exam, other), new MultiComparable(Double.valueOf(-100.0 * (double)nrStudents / (double)Math.min(section1.getNrStudents(), section2.getNrStudents())), exam, other), new MultiComparable(Double.valueOf(-conflict.getDistance()), exam, other)}, exam.getExamId().toString());
                        }
                    }
                    continue;
                }
                table.addLine("onClick=\"document.location='examDetail.action?examId=" + exam.getExamId() + "';\"", new String[]{exam.getExamName(), String.valueOf(exam.getNrStudents()), exam.getSeatingTypeLabel(), other.getExamName(), String.valueOf(other.getNrStudents()), conflict.getOtherExam().getSeatingTypeLabel(), exam.getDate(html), exam.getTime(html), String.valueOf(conflict.getNrStudents()), df.format(100.0 * (double)conflict.getNrStudents() / (double)Math.min(exam.getNrStudents(), other.getNrStudents())), String.valueOf((int)(10.0 * conflict.getDistance()))}, new Comparable[]{new MultiComparable(exam, other), new MultiComparable(Integer.valueOf(-exam.getNrStudents()), Integer.valueOf(-other.getNrStudents()), exam, other), new MultiComparable(Integer.valueOf(exam.getSeatingType()), Integer.valueOf(other.getSeatingType()), exam, other), new MultiComparable(other, exam), new MultiComparable(Integer.valueOf(-other.getNrStudents()), Integer.valueOf(-exam.getNrStudents()), other, exam), new MultiComparable(Integer.valueOf(other.getSeatingType()), Integer.valueOf(exam.getSeatingType()), other, exam), new MultiComparable(exam.getPeriodOrd(), exam, other), new MultiComparable(exam.getPeriod().getStartSlot(), exam, other), new MultiComparable(Integer.valueOf(-conflict.getNrStudents()), exam, other), new MultiComparable(Double.valueOf(-100.0 * (double)conflict.getNrStudents() / (double)Math.min(exam.getNrStudents(), other.getNrStudents())), exam, other), new MultiComparable(Double.valueOf(-conflict.getDistance()), exam, other)}, exam.getExamId().toString());
            }
        }
        return table;
    }

    private PdfWebTable generate2MoreADayConflictsReport(boolean html, ExamAssignmentReportForm form, Collection<ExamAssignmentInfo> exams, boolean studentConf) {
        DecimalFormat df = new DecimalFormat("0.0");
        int max = 0;
        for (ExamAssignmentInfo exam : exams) {
            if (!this.match(form, exam)) continue;
            block1: for (ExamAssignmentInfo.MoreThanTwoADayConflict conflict : studentConf ? exam.getMoreThanTwoADaysConflicts() : exam.getInstructorMoreThanTwoADaysConflicts()) {
                for (ExamAssignment other : conflict.getOtherExams()) {
                    if (!this.match(form, other) || exam.compareTo(other) < 0) continue;
                    continue block1;
                }
                max = Math.max(max, conflict.getOtherExams().size() + 1);
            }
        }
        if (max <= 2) {
            return null;
        }
        String[] colName = new String[3 + 3 * max];
        String[] colAlign = new String[3 + 3 * max];
        boolean[] colOrd = new boolean[3 + 3 * max];
        int idx = 0;
        colName[idx] = MSG.colDate();
        colAlign[idx] = "left";
        colOrd[idx++] = true;
        for (int i = 0; i < max; ++i) {
            String th = i == 0 ? MSG.col1stExam() : (i == 1 ? MSG.col2ndExam() : (i == 2 ? MSG.col3rdExam() : MSG.colNthExam(i + 1)));
            colName[idx] = th + " " + (form.getShowSections() ? MSG.colOwner() : MSG.colExamination());
            colAlign[idx] = "left";
            colOrd[idx++] = true;
            colName[idx] = th + " " + MSG.colEnrollment();
            colAlign[idx] = "right";
            colOrd[idx++] = true;
            colName[idx] = th + " " + MSG.colTime();
            colAlign[idx] = "left";
            colOrd[idx++] = true;
        }
        colName[idx] = html ? MSG.conflictMoreThanTwoADay().replace(">", "&gt;") : MSG.conflictMoreThanTwoADay();
        colAlign[idx] = "left";
        colOrd[idx++] = true;
        colName[idx] = html ? MSG.colMoreThanTwoADayPercent().replace(">", "&gt;") : MSG.colMoreThanTwoADayPercent();
        colAlign[idx] = "left";
        colOrd[idx++] = true;
        PdfWebTable table = new PdfWebTable(3 + 3 * max, form.getReportName(), "examAssignmentReport.action?ord=%%", colName, colAlign, colOrd);
        table.setRowStyle("white-space:nowrap");
        for (ExamAssignmentInfo exam : exams) {
            if (!this.match(form, exam)) continue;
            block5: for (ExamAssignmentInfo.MoreThanTwoADayConflict conflict : studentConf ? exam.getMoreThanTwoADaysConflicts() : exam.getInstructorMoreThanTwoADaysConflicts()) {
                Comparable[] cmp;
                String[] line;
                for (ExamAssignment other : conflict.getOtherExams()) {
                    if (!this.match(form, other) || exam.compareTo(other) < 0) continue;
                    continue block5;
                }
                Vector<ExamAssignment> examsThisConf = new Vector<ExamAssignment>(max);
                examsThisConf.add(exam);
                examsThisConf.addAll(conflict.getOtherExams());
                Collections.sort(examsThisConf, new Comparator<ExamAssignment>(){

                    @Override
                    public int compare(ExamAssignment a1, ExamAssignment a2) {
                        return a1.compareTo(a2);
                    }
                });
                if (form.getShowSections()) {
                    idx = 0;
                    line = new String[3 + 3 * max];
                    cmp = new Comparable[3 + 3 * max];
                    line[idx] = exam.getDate(false);
                    cmp[idx] = new MultiComparable(exam.getPeriodOrd(), new MultiComparable(examsThisConf));
                    this.m2dReportAddLines(form, html, studentConf, table, max, examsThisConf, 0, line, cmp, 1, exam.getNrStudents(), null, false);
                    continue;
                }
                idx = 0;
                line = new String[3 + 3 * max];
                cmp = new Comparable[3 + 3 * max];
                line[idx] = exam.getDate(false);
                cmp[idx++] = new MultiComparable(exam.getPeriodOrd(), new MultiComparable(examsThisConf));
                int minStudents = exam.getNrStudents();
                for (ExamAssignment x : examsThisConf) {
                    line[idx] = x.getExamName();
                    cmp[idx++] = new MultiComparable(x, new MultiComparable(examsThisConf));
                    line[idx] = String.valueOf(x.getNrStudents());
                    cmp[idx++] = new MultiComparable(Integer.valueOf(-x.getNrStudents()), x, new MultiComparable(examsThisConf));
                    line[idx] = x.getTime(html);
                    cmp[idx++] = new MultiComparable(x.getPeriod().getStartSlot(), x, new MultiComparable(examsThisConf));
                    minStudents = Math.min(minStudents, x.getNrStudents());
                }
                for (int i = examsThisConf.size(); i < max; ++i) {
                    line[idx] = "";
                    cmp[idx++] = new MultiComparable(null, new MultiComparable(examsThisConf));
                    line[idx] = "";
                    cmp[idx++] = new MultiComparable(Integer.valueOf(1), null, new MultiComparable(examsThisConf));
                    line[idx] = "";
                    cmp[idx++] = new MultiComparable(Integer.valueOf(-1), null, new MultiComparable(examsThisConf));
                }
                line[idx] = String.valueOf(conflict.getNrStudents());
                cmp[idx++] = new MultiComparable(Integer.valueOf(-conflict.getNrStudents()), new MultiComparable(examsThisConf));
                line[idx] = df.format(100.0 * (double)conflict.getNrStudents() / (double)minStudents);
                cmp[idx++] = new MultiComparable(Double.valueOf(-100.0 * (double)conflict.getNrStudents() / (double)minStudents), new MultiComparable(examsThisConf));
                table.addLine("onClick=\"document.location='examDetail.action?examId=" + examsThisConf.firstElement().getExamId() + "';\"", line, cmp, examsThisConf.firstElement().getExamId().toString());
            }
        }
        return table;
    }

    private void m2dReportAddLines(ExamAssignmentReportForm form, boolean html, boolean studentConf, PdfWebTable table, int max, Vector<ExamAssignment> exams, int pos, String[] line, Comparable[] cmp, int idx, int minStudents, Set<Long> students, boolean match) {
        if (students != null && students.isEmpty()) {
            return;
        }
        if (pos == max) {
            if (!match) {
                return;
            }
            line[idx] = String.valueOf(students.size());
            cmp[idx++] = new MultiComparable(Integer.valueOf(-students.size()), new MultiComparable(exams));
            line[idx] = new DecimalFormat("0.0").format(100.0 * (double)students.size() / (double)minStudents);
            cmp[idx++] = new MultiComparable(Double.valueOf(-100.0 * (double)students.size() / (double)minStudents), new MultiComparable(exams));
            table.addLine("onClick=\"document.location='examDetail.action?examId=" + exams.firstElement().getExamId() + "';\"", (String[])line.clone(), (Comparable[])cmp.clone(), exams.firstElement().getExamId().toString());
            return;
        }
        if (pos < exams.size()) {
            ExamAssignment exam = exams.elementAt(pos);
            HashSet<Object> newStudents = null;
            for (ExamInfo.ExamSectionInfo section : exam.getSections()) {
                if (students == null) {
                    if (studentConf) {
                        newStudents = new HashSet<Long>(section.getStudentIds());
                    } else {
                        newStudents = new HashSet();
                        for (ExamInfo.ExamInstructorInfo i : section.getExam().getInstructors()) {
                            newStudents.add(i.getId());
                        }
                    }
                } else {
                    newStudents = new HashSet();
                    for (Long studentId : students) {
                        if (studentConf && section.getStudentIds().contains(studentId)) {
                            newStudents.add(studentId);
                        }
                        if (studentConf || !section.getExam().hasInstructor(studentId)) continue;
                        newStudents.add(studentId);
                    }
                }
                if (newStudents.isEmpty()) continue;
                line[idx] = section.getName();
                cmp[idx] = new MultiComparable((Comparable)((Object)section.getName()), new MultiComparable(exams));
                line[idx + 1] = String.valueOf(section.getNrStudents());
                cmp[idx + 1] = new MultiComparable(Integer.valueOf(-section.getNrStudents()), (Comparable)((Object)section.getName()), new MultiComparable(exams));
                line[idx + 2] = exam.getTime(html);
                cmp[idx + 2] = new MultiComparable(exam.getPeriod().getStartSlot(), (Comparable)((Object)section.getName()), new MultiComparable(exams));
                this.m2dReportAddLines(form, html, studentConf, table, max, exams, pos + 1, line, cmp, idx + 3, Math.min(section.getNrStudents(), minStudents), newStudents, match || this.match(form, section.getName()));
            }
        } else {
            line[idx] = "";
            cmp[idx++] = new MultiComparable(null, new MultiComparable(exams));
            line[idx] = "";
            cmp[idx++] = new MultiComparable(Integer.valueOf(1), null, new MultiComparable(exams));
            line[idx] = "";
            cmp[idx++] = new MultiComparable(Integer.valueOf(-1), null, new MultiComparable(exams));
            this.m2dReportAddLines(form, html, studentConf, table, max, exams, pos + 1, line, cmp, idx, minStudents, students, match);
        }
    }

    private PdfWebTable generateIndividualAssignmentReport(boolean html, Long sessionId, ExamAssignmentReportForm form, Collection<ExamAssignmentInfo> exams, boolean student, String nameFormat) {
        Hashtable<Long, Student> students = new Hashtable<Long, Student>();
        if (student) {
            HashSet<Long> allStudentIds = new HashSet<Long>();
            for (ExamAssignmentInfo exam : exams) {
                for (ExamInfo.ExamSectionInfo examSectionInfo : exam.getSections()) {
                    allStudentIds.addAll(examSectionInfo.getStudentIds());
                }
            }
            Object inSet = null;
            int idx = 0;
            Iterator<Object> i = allStudentIds.iterator();
            while (i.hasNext()) {
                if (idx == 1000) {
                    for (Iterator<ExamInfo.ExamInstructorInfo> s : StudentDAO.getInstance().getSession().createQuery("select s from Student s where s.uniqueId in (" + inSet + ")", Student.class).list()) {
                        students.put(((BaseStudent)((Object)s)).getUniqueId(), (Student)((Object)s));
                    }
                    idx = 0;
                    inSet = null;
                }
                inSet = inSet == null ? i.next().toString() : (String)inSet + "," + String.valueOf(i.next());
                ++idx;
            }
            if (inSet != null) {
                for (Student student2 : StudentDAO.getInstance().getSession().createQuery("select s from Student s where s.uniqueId in (" + inSet + ")", Student.class).list()) {
                    students.put(student2.getUniqueId(), student2);
                }
            }
        }
        PdfWebTable table = student ? new PdfWebTable(7, form.getReportName(), "examAssignmentReport.action?ord=%%", new String[]{student ? MSG.colStudentId() : MSG.colInstructorId(), MSG.colStudentOrInstructorName(), form.getShowSections() ? MSG.colOwner() : MSG.colExamination(), MSG.colDate(), MSG.colTime(), MSG.colRoom(), MSG.colInstructor()}, new String[]{"left", "left", "left", "left", "left", "left", "left"}, new boolean[]{true, true, true, true, true, true, true}) : new PdfWebTable(6, form.getReportName(), "examAssignmentReport.action?ord=%%", new String[]{student ? MSG.colStudentId() : MSG.colInstructorId(), MSG.colStudentOrInstructorName(), form.getShowSections() ? MSG.colOwner() : MSG.colExamination(), MSG.colDate(), MSG.colTime(), MSG.colRoom()}, new String[]{"left", "left", "left", "left", "left", "left"}, new boolean[]{true, true, true, true, true, true});
        table.setRowStyle("white-space:nowrap");
        table.setBlankWhenSame(true);
        for (ExamAssignmentInfo exam : exams) {
            if (form.getShowSections()) {
                for (ExamInfo.ExamSectionInfo examSectionInfo : exam.getSections()) {
                    if (student) {
                        for (Long studentId : examSectionInfo.getStudentIds()) {
                            Student s = (Student)students.get(studentId);
                            if (s == null || !this.match(form, s.getExternalUniqueId()) && !this.match(form, s.getName(nameFormat))) continue;
                            table.addLine("onClick=\"document.location='examDetail.action?examId=" + exam.getExamId() + "';\"", new String[]{s.getExternalUniqueId(), s.getName(nameFormat), (String)(html ? "<a name='" + exam.getExamId() + "'>" : "") + examSectionInfo.getName() + (html ? "</a>" : ""), exam.getDate(html), exam.getTime(html), exam.getRoomsName(html, ", "), exam.getInstructorName("; ")}, new Comparable[]{new MultiComparable((Comparable)((Object)s.getExternalUniqueId()), (Comparable)((Object)examSectionInfo.getName()), exam), new MultiComparable((Comparable)((Object)s.getName(nameFormat)), (Comparable)((Object)s.getExternalUniqueId()), (Comparable)((Object)examSectionInfo.getName()), exam), new MultiComparable((Comparable)((Object)examSectionInfo.getName()), exam), new MultiComparable(exam.getPeriodOrd(), (Comparable)((Object)examSectionInfo.getName()), exam), new MultiComparable(Integer.valueOf(exam.getPeriod() == null ? -1 : exam.getPeriod().getStartSlot()), (Comparable)((Object)examSectionInfo.getName()), exam), new MultiComparable((Comparable)((Object)exam.getRoomsName(":")), (Comparable)((Object)examSectionInfo.getName()), exam), new MultiComparable((Comparable)((Object)exam.getInstructorName(":")), (Comparable)((Object)examSectionInfo.getName()), exam)});
                        }
                        continue;
                    }
                    for (ExamInfo.ExamInstructorInfo instructor : examSectionInfo.getExam().getInstructors()) {
                        if (!this.match(form, instructor.getExternalUniqueId()) && !this.match(form, instructor.getName())) continue;
                        table.addLine("onClick=\"document.location='examDetail.action?examId=" + exam.getExamId() + "';\"", new String[]{instructor.getExternalUniqueId(), instructor.getName(), (String)(html ? "<a name='" + exam.getExamId() + "'>" : "") + examSectionInfo.getName() + (html ? "</a>" : ""), exam.getDate(html), exam.getTime(html), exam.getRoomsName(html, ", ")}, new Comparable[]{new MultiComparable((Comparable)((Object)instructor.getExternalUniqueId()), (Comparable)((Object)examSectionInfo.getName()), exam), new MultiComparable((Comparable)((Object)instructor.getName()), (Comparable)((Object)instructor.getExternalUniqueId()), (Comparable)((Object)examSectionInfo.getName()), exam), new MultiComparable((Comparable)((Object)examSectionInfo.getName()), exam), new MultiComparable(exam.getPeriodOrd(), (Comparable)((Object)examSectionInfo.getName()), exam), new MultiComparable(Integer.valueOf(exam.getPeriod() == null ? -1 : exam.getPeriod().getStartSlot()), (Comparable)((Object)examSectionInfo.getName()), exam), new MultiComparable((Comparable)((Object)exam.getRoomsName(":")), (Comparable)((Object)examSectionInfo.getName()), exam)});
                    }
                }
                continue;
            }
            if (student) {
                HashSet<Long> studentIds = new HashSet<Long>();
                for (ExamInfo.ExamSectionInfo section2 : exam.getSections()) {
                    studentIds.addAll(section2.getStudentIds());
                }
                for (Long studentId : studentIds) {
                    Student s = (Student)students.get(studentId);
                    if (s == null || !this.match(form, s.getExternalUniqueId()) && !this.match(form, s.getName(nameFormat))) continue;
                    table.addLine("onClick=\"document.location='examDetail.action?examId=" + exam.getExamId() + "';\"", new String[]{s.getExternalUniqueId(), s.getName(nameFormat), (String)(html ? "<a name='" + exam.getExamId() + "'>" : "") + exam.getExamName() + (html ? "</a>" : ""), exam.getDate(html), exam.getTime(html), exam.getRoomsName(html, ", "), exam.getInstructorName("; ")}, new Comparable[]{new MultiComparable((Comparable)((Object)s.getExternalUniqueId()), exam), new MultiComparable((Comparable)((Object)s.getName(nameFormat)), (Comparable)((Object)s.getExternalUniqueId()), exam), new MultiComparable(exam), new MultiComparable(exam.getPeriodOrd(), exam), new MultiComparable(Integer.valueOf(exam.getPeriod() == null ? -1 : exam.getPeriod().getStartSlot()), exam), new MultiComparable((Comparable)((Object)exam.getRoomsName(":")), exam), new MultiComparable((Comparable)((Object)exam.getInstructorName(":")), exam)});
                }
                continue;
            }
            for (ExamInfo.ExamInstructorInfo examInstructorInfo : exam.getInstructors()) {
                if (!this.match(form, examInstructorInfo.getExternalUniqueId()) && !this.match(form, examInstructorInfo.getName())) continue;
                table.addLine("onClick=\"document.location='examDetail.action?examId=" + exam.getExamId() + "';\"", new String[]{examInstructorInfo.getExternalUniqueId(), examInstructorInfo.getName(), (String)(html ? "<a name='" + exam.getExamId() + "'>" : "") + exam.getExamName() + (html ? "</a>" : ""), exam.getDate(html), exam.getTime(html), exam.getRoomsName(html, ", ")}, new Comparable[]{new MultiComparable((Comparable)((Object)examInstructorInfo.getExternalUniqueId()), exam), new MultiComparable((Comparable)((Object)examInstructorInfo.getName()), (Comparable)((Object)examInstructorInfo.getExternalUniqueId()), exam), new MultiComparable(exam), new MultiComparable(exam.getPeriodOrd(), exam), new MultiComparable(Integer.valueOf(exam.getPeriod() == null ? -1 : exam.getPeriod().getStartSlot()), exam), new MultiComparable((Comparable)((Object)exam.getRoomsName(":")), exam)});
            }
        }
        return table;
    }

    private PdfWebTable generateStatisticsReport(boolean html, long sessionId, ExamAssignmentReportForm form, Collection<ExamAssignmentInfo> exams) {
        String sp = html ? "&nbsp;" : " ";
        String indent = html ? "&nbsp;&nbsp;&nbsp;&nbsp;" : "    ";
        PdfWebTable table = new PdfWebTable(2, form.getReportName(), "examAssignmentReport.action?ord=%%", new String[]{MSG.colName(), MSG.colValue()}, new String[]{"left", "right"}, new boolean[]{true, true});
        table.setRowStyle("white-space:nowrap");
        int row = 0;
        int sdc = 0;
        int sdcna = 0;
        int sbtb = 0;
        int sdbtb = 0;
        int sm2d = 0;
        int idc = 0;
        int idcna = 0;
        int ibtb = 0;
        int idbtb = 0;
        int im2d = 0;
        HashSet[] sct = new HashSet[]{new HashSet(), new HashSet(), new HashSet(), new HashSet()};
        HashSet<Long> students = new HashSet<Long>();
        int studentExams = 0;
        DecimalFormat df1 = new DecimalFormat("0.00");
        DecimalFormat df2 = new DecimalFormat("#,##0");
        int instructorExams = 0;
        HashSet instructors = new HashSet();
        for (ExamAssignmentInfo exam : exams) {
            for (ExamInfo.ExamSectionInfo section : exam.getSections()) {
                sct[section.getOwnerType()].add(section.getOwnerId());
                students.addAll(section.getStudentIds());
            }
            studentExams += exam.getStudentIds().size();
            instructorExams += exam.getInstructors().size();
            for (ExamAssignmentInfo.DirectConflict dc : exam.getDirectConflicts()) {
                if (dc.getOtherExam() != null && exam.compareTo(dc.getOtherExam()) >= 0 && exams.contains(dc.getOtherExam())) continue;
                sdc += dc.getNrStudents();
                if (dc.getOtherExam() != null) continue;
                sdcna += dc.getNrStudents();
            }
            for (ExamAssignmentInfo.DirectConflict dc : exam.getInstructorDirectConflicts()) {
                if (dc.getOtherExam() != null && exam.compareTo(dc.getOtherExam()) >= 0 && exams.contains(dc.getOtherExam())) continue;
                idc += dc.getNrStudents();
                if (dc.getOtherExam() != null) continue;
                idcna += dc.getNrStudents();
            }
            for (ExamAssignmentInfo.BackToBackConflict btb : exam.getBackToBackConflicts()) {
                if (btb.getOtherExam() != null && exam.compareTo(btb.getOtherExam()) >= 0 && exams.contains(btb.getOtherExam())) continue;
                sbtb += btb.getNrStudents();
                if (!btb.isDistance()) continue;
                sdbtb += btb.getNrStudents();
            }
            for (ExamAssignmentInfo.BackToBackConflict btb : exam.getInstructorBackToBackConflicts()) {
                if (btb.getOtherExam() != null && exam.compareTo(btb.getOtherExam()) >= 0 && exams.contains(btb.getOtherExam())) continue;
                ibtb += btb.getNrStudents();
                if (!btb.isDistance()) continue;
                idbtb += btb.getNrStudents();
            }
            block6: for (ExamAssignmentInfo.MoreThanTwoADayConflict m2d : exam.getMoreThanTwoADaysConflicts()) {
                for (ExamAssignment other : m2d.getOtherExams()) {
                    if (exam.compareTo(other) < 0 || !exams.contains(other)) continue;
                    continue block6;
                }
                sm2d += m2d.getNrStudents();
            }
            block8: for (ExamAssignmentInfo.MoreThanTwoADayConflict m2d : exam.getInstructorMoreThanTwoADaysConflicts()) {
                for (ExamAssignment other : m2d.getOtherExams()) {
                    if (exam.compareTo(other) < 0 || !exams.contains(other)) continue;
                    continue block8;
                }
                im2d += m2d.getNrStudents();
            }
        }
        table.addLine(new String[]{MSG.propNumberOfExams(), df2.format(exams.size())}, new Comparable[]{Integer.valueOf(row++), null, null});
        for (int i = 0; i < ExamOwner.sOwnerTypes.length; ++i) {
            if (sct[i].isEmpty()) continue;
            table.addLine(new String[]{indent + MSG.propOwnersWithAnExam(i == 3 ? MSG.typeClasses() : (i == 2 ? MSG.typeConfigs() : (i == 1 ? MSG.typeCourses() : MSG.typeOfferings()))), df2.format(sct[i].size())}, new Comparable[]{Integer.valueOf(row++), null, null});
        }
        table.addLine(new String[]{sp, ""}, new Comparable[]{Integer.valueOf(row++), null, null});
        table.addLine(new String[]{indent + MSG.propStudentsEnrolledInClasses(), df2.format(StudentDAO.getInstance().getSession().createQuery("select count(distinct s) from Student s inner join s.classEnrollments c where s.session.uniqueId=:sessionId", Number.class).setParameter("sessionId", (Object)sessionId).uniqueResult())}, new Comparable[]{Integer.valueOf(row++), null, null});
        table.addLine(new String[]{indent + MSG.propStudentsHavingAnExam(), df2.format(students.size())}, new Comparable[]{Integer.valueOf(row++), null, null});
        table.addLine(new String[]{indent + MSG.propStudentExamEnrollments(), df2.format(studentExams)}, new Comparable[]{Integer.valueOf(row++), null, null});
        table.addLine(new String[]{sp, ""}, new Comparable[]{Integer.valueOf(row++), null, null});
        if (!instructors.isEmpty()) {
            table.addLine(new String[]{MSG.propRegisteredInstructors(), df2.format(StudentDAO.getInstance().getSession().createQuery("select count(i.externalUniqueId) from DepartmentalInstructor i where i.department.session.uniqueId=:sessionId", Number.class).setParameter("sessionId", (Object)sessionId).uniqueResult())}, new Comparable[]{Integer.valueOf(row++), null, null});
            table.addLine(new String[]{indent + MSG.propInstructorsHavingAnExam(), df2.format(instructors.size())}, new Comparable[]{Integer.valueOf(row++), null, null});
            table.addLine(new String[]{indent + MSG.propInstructorExamEnrollments(), df2.format(instructorExams)}, new Comparable[]{Integer.valueOf(row++), null, null});
            table.addLine(new String[]{sp, ""}, new Comparable[]{Integer.valueOf(row++), null, null});
        }
        if (sdc > 0) {
            table.addLine(new String[]{MSG.propDirectStudentConflicts(), df2.format(sdc)}, new Comparable[]{Integer.valueOf(row++), null, null});
        }
        if (sdcna > 0) {
            table.addLine(new String[]{indent + MSG.propConflictWithOtherExam(), df2.format(sdc - sdcna)}, new Comparable[]{Integer.valueOf(row++), null, null});
            table.addLine(new String[]{indent + MSG.propStudentNotAvailable(), df2.format(sdcna)}, new Comparable[]{Integer.valueOf(row++), null, null});
        }
        if (sm2d > 0) {
            table.addLine(new String[]{MSG.propStudentMoreThanTwoExamsADayConflicts(), df2.format(sm2d)}, new Comparable[]{Integer.valueOf(row++), null, null});
        }
        if (sbtb > 0) {
            table.addLine(new String[]{MSG.propStudentBackToBackConflicts(), df2.format(sbtb)}, new Comparable[]{Integer.valueOf(row++), null, null});
        }
        if (sdbtb > 0) {
            table.addLine(new String[]{indent + MSG.propStudentDistanceBackToBackConflicts(), df2.format(sdbtb)}, new Comparable[]{Integer.valueOf(row++), null, null});
        }
        if (idc > 0 || im2d > 0 || ibtb > 0) {
            table.addLine(new String[]{sp, ""}, new Comparable[]{Integer.valueOf(row++), null, null});
        }
        if (idc > 0) {
            table.addLine(new String[]{MSG.propDirectInstructorConflicts(), df2.format(idc)}, new Comparable[]{Integer.valueOf(row++), null, null});
        }
        if (idcna > 0) {
            table.addLine(new String[]{indent + MSG.propConflictWithOtherExam(), df2.format(idc - idcna)}, new Comparable[]{Integer.valueOf(row++), null, null});
            table.addLine(new String[]{indent + MSG.propInstructorNotAvailable(), df2.format(idcna)}, new Comparable[]{Integer.valueOf(row++), null, null});
        }
        if (im2d > 0) {
            table.addLine(new String[]{MSG.propInstructorMoreThanTwoExamsADayConflicts(), df2.format(im2d)}, new Comparable[]{Integer.valueOf(row++), null, null});
        }
        if (ibtb > 0) {
            table.addLine(new String[]{MSG.propInstructorBackToBackConflicts(), df2.format(ibtb)}, new Comparable[]{Integer.valueOf(row++), null, null});
        }
        if (idbtb > 0) {
            table.addLine(new String[]{indent + MSG.propInstructorDistanceBackToBackConflicts(), df2.format(idbtb)}, new Comparable[]{Integer.valueOf(row++), null, null});
        }
        table.addLine(new String[]{sp, ""}, new Comparable[]{Integer.valueOf(row++), null, null});
        if (sdc > 0) {
            table.addLine(new String[]{MSG.propDirectStudentConflicts(), df1.format(100.0 * (double)sdc / (double)studentExams) + "%"}, new Comparable[]{Integer.valueOf(row++), null, null});
        }
        if (sdcna > 0) {
            table.addLine(new String[]{indent + MSG.propConflictWithOtherExam(), df1.format(100.0 * (double)(sdc - sdcna) / (double)studentExams) + "%"}, new Comparable[]{Integer.valueOf(row++), null, null});
            table.addLine(new String[]{indent + MSG.propStudentNotAvailable(), df1.format(100.0 * (double)sdcna / (double)studentExams) + "%"}, new Comparable[]{Integer.valueOf(row++), null, null});
        }
        if (sm2d > 0) {
            table.addLine(new String[]{MSG.propStudentMoreThanTwoExamsADayConflicts(), df1.format(100.0 * (double)sm2d / (double)studentExams) + "%"}, new Comparable[]{Integer.valueOf(row++), null, null});
        }
        if (sbtb > 0) {
            table.addLine(new String[]{MSG.propStudentBackToBackConflicts(), df1.format(100.0 * (double)sbtb / (double)studentExams) + "%"}, new Comparable[]{Integer.valueOf(row++), null, null});
        }
        if (sdbtb > 0) {
            table.addLine(new String[]{indent + MSG.propStudentDistanceBackToBackConflicts(), df1.format(100.0 * (double)sdbtb / (double)studentExams) + "%"}, new Comparable[]{Integer.valueOf(row++), null, null});
        }
        if (idc > 0 || im2d > 0 || ibtb > 0) {
            table.addLine(new String[]{sp, ""}, new Comparable[]{Integer.valueOf(row++), null, null});
        }
        if (idc > 0) {
            table.addLine(new String[]{MSG.propDirectInstructorConflicts(), df1.format(100.0 * (double)idc / (double)studentExams) + "%"}, new Comparable[]{Integer.valueOf(row++), null, null});
        }
        if (idcna > 0) {
            table.addLine(new String[]{indent + MSG.propConflictWithOtherExam(), df1.format(100.0 * (double)(idc - idcna) / (double)studentExams) + "%"}, new Comparable[]{Integer.valueOf(row++), null, null});
            table.addLine(new String[]{indent + MSG.propInstructorNotAvailable(), df1.format(100.0 * (double)idcna / (double)studentExams) + "%"}, new Comparable[]{Integer.valueOf(row++), null, null});
        }
        if (im2d > 0) {
            table.addLine(new String[]{MSG.propInstructorMoreThanTwoExamsADayConflicts(), df1.format(100.0 * (double)im2d / (double)studentExams) + "%"}, new Comparable[]{Integer.valueOf(row++), null, null});
        }
        if (ibtb > 0) {
            table.addLine(new String[]{MSG.propInstructorBackToBackConflicts(), df1.format(100.0 * (double)ibtb / (double)studentExams) + "%"}, new Comparable[]{Integer.valueOf(row++), null, null});
        }
        if (idbtb > 0) {
            table.addLine(new String[]{indent + MSG.propInstructorDistanceBackToBackConflicts(), df1.format(100.0 * (double)idbtb / (double)studentExams) + "%"}, new Comparable[]{Integer.valueOf(row++), null, null});
        }
        table.setRowStyle("white-space:nowrap");
        return table;
    }

    public static class CacheAssignedExams {
        Long sessionId;
        Long examTypeId;
        Hashtable<Long, Exam> exams = new Hashtable();
        Hashtable<Long, Set<Long>> owner2students = new Hashtable();
        Hashtable<Long, Set<Exam>> student2exams = new Hashtable();
        Hashtable<Long, Set<Meeting>> period2meetings = new Hashtable();
        Hashtable<Long, Hashtable<Long, Set<Long>>> owner2course2students = new Hashtable();
        ExamAssignmentInfo.Parameters p;

        public CacheAssignedExams(Long sessionId, Long examTypeId) {
            Set<Meeting> meetings;
            Meeting meeting;
            Long periodId;
            Set<Long> studentsOfCourse;
            Hashtable<Long, Set<Long>> course2students;
            Long courseId;
            Set<Exam> examsOfStudent;
            Set<Long> studentsOfOwner;
            Long studentId;
            Long ownerId;
            Long examId;
            this.sessionId = sessionId;
            this.examTypeId = examTypeId;
            for (Exam exam : ExamDAO.getInstance().getSession().createQuery("select x from Exam x where x.session.uniqueId=:sessionId and x.examType.uniqueId=:examTypeId", Exam.class).setParameter("sessionId", (Object)sessionId).setParameter("examTypeId", (Object)examTypeId).setCacheable(true).list()) {
                this.exams.put(exam.getUniqueId(), exam);
            }
            ExamDAO.getInstance().getSession().createQuery("select c from Class_ c, ExamOwner o where o.exam.session.uniqueId=:sessionId and o.exam.examType.uniqueId=:examTypeId and o.ownerType=:classType and c.uniqueId=o.ownerId", Class_.class).setParameter("sessionId", (Object)sessionId).setParameter("examTypeId", (Object)examTypeId).setParameter("classType", (Object)3).setCacheable(true).list();
            ExamDAO.getInstance().getSession().createQuery("select c from InstrOfferingConfig c, ExamOwner o where o.exam.session.uniqueId=:sessionId and o.exam.examType.uniqueId=:examTypeId and o.ownerType=:configType and c.uniqueId=o.ownerId", InstrOfferingConfig.class).setParameter("sessionId", (Object)sessionId).setParameter("examTypeId", (Object)examTypeId).setParameter("configType", (Object)2).setCacheable(true).list();
            ExamDAO.getInstance().getSession().createQuery("select c from CourseOffering c, ExamOwner o where o.exam.session.uniqueId=:sessionId and o.exam.examType.uniqueId=:examTypeId and o.ownerType=:courseType and c.uniqueId=o.ownerId", CourseOffering.class).setParameter("sessionId", (Object)sessionId).setParameter("examTypeId", (Object)examTypeId).setParameter("courseType", (Object)1).setCacheable(true).list();
            ExamDAO.getInstance().getSession().createQuery("select c from InstructionalOffering c, ExamOwner o where o.exam.session.uniqueId=:sessionId and o.exam.examType.uniqueId=:examTypeId and o.ownerType=:offeringType and c.uniqueId=o.ownerId", InstructionalOffering.class).setParameter("sessionId", (Object)sessionId).setParameter("examTypeId", (Object)examTypeId).setParameter("offeringType", (Object)0).setCacheable(true).list();
            for (Object[] o : ExamDAO.getInstance().getSession().createQuery("select x.uniqueId, o.uniqueId, e.student.uniqueId, e.courseOffering.uniqueId from Exam x inner join x.owners o, StudentClassEnrollment e inner join e.clazz c where x.session.uniqueId=:sessionId and x.examType.uniqueId=:examTypeId and o.ownerType=3 and o.ownerId=c.uniqueId", Object[].class).setParameter("sessionId", (Object)sessionId).setParameter("examTypeId", (Object)examTypeId).setCacheable(true).list()) {
                examId = (Long)o[0];
                ownerId = (Long)o[1];
                studentId = (Long)o[2];
                studentsOfOwner = this.owner2students.get(ownerId);
                if (studentsOfOwner == null) {
                    studentsOfOwner = new HashSet<Long>();
                    this.owner2students.put(ownerId, studentsOfOwner);
                }
                studentsOfOwner.add(studentId);
                examsOfStudent = this.student2exams.get(studentId);
                if (examsOfStudent == null) {
                    examsOfStudent = new HashSet<Exam>();
                    this.student2exams.put(studentId, examsOfStudent);
                }
                examsOfStudent.add(this.exams.get(examId));
                courseId = (Long)o[3];
                course2students = this.owner2course2students.get(ownerId);
                if (course2students == null) {
                    course2students = new Hashtable();
                    this.owner2course2students.put(ownerId, course2students);
                }
                if ((studentsOfCourse = course2students.get(courseId)) == null) {
                    studentsOfCourse = new HashSet<Long>();
                    course2students.put(courseId, studentsOfCourse);
                }
                studentsOfCourse.add(studentId);
            }
            for (Object[] o : ExamDAO.getInstance().getSession().createQuery("select x.uniqueId, o.uniqueId, e.student.uniqueId, e.courseOffering.uniqueId from Exam x inner join x.owners o, StudentClassEnrollment e inner join e.clazz c inner join c.schedulingSubpart.instrOfferingConfig ioc where x.session.uniqueId=:sessionId and x.examType.uniqueId=:examTypeId and o.ownerType=2 and o.ownerId=ioc.uniqueId", Object[].class).setParameter("sessionId", (Object)sessionId).setParameter("examTypeId", (Object)examTypeId).setCacheable(true).list()) {
                examId = (Long)o[0];
                ownerId = (Long)o[1];
                studentId = (Long)o[2];
                studentsOfOwner = this.owner2students.get(ownerId);
                if (studentsOfOwner == null) {
                    studentsOfOwner = new HashSet<Long>();
                    this.owner2students.put(ownerId, studentsOfOwner);
                }
                studentsOfOwner.add(studentId);
                examsOfStudent = this.student2exams.get(studentId);
                if (examsOfStudent == null) {
                    examsOfStudent = new HashSet<Exam>();
                    this.student2exams.put(studentId, examsOfStudent);
                }
                examsOfStudent.add(this.exams.get(examId));
                courseId = (Long)o[3];
                course2students = this.owner2course2students.get(ownerId);
                if (course2students == null) {
                    course2students = new Hashtable();
                    this.owner2course2students.put(ownerId, course2students);
                }
                if ((studentsOfCourse = course2students.get(courseId)) == null) {
                    studentsOfCourse = new HashSet<Long>();
                    course2students.put(courseId, studentsOfCourse);
                }
                studentsOfCourse.add(studentId);
            }
            for (Object[] o : ExamDAO.getInstance().getSession().createQuery("select x.uniqueId, o.uniqueId, e.student.uniqueId, e.courseOffering.uniqueId from Exam x inner join x.owners o, StudentClassEnrollment e inner join e.courseOffering co where x.session.uniqueId=:sessionId and x.examType.uniqueId=:examTypeId and o.ownerType=1 and o.ownerId=co.uniqueId", Object[].class).setParameter("sessionId", (Object)sessionId).setParameter("examTypeId", (Object)examTypeId).setCacheable(true).list()) {
                examId = (Long)o[0];
                ownerId = (Long)o[1];
                studentId = (Long)o[2];
                studentsOfOwner = this.owner2students.get(ownerId);
                if (studentsOfOwner == null) {
                    studentsOfOwner = new HashSet<Long>();
                    this.owner2students.put(ownerId, studentsOfOwner);
                }
                studentsOfOwner.add(studentId);
                examsOfStudent = this.student2exams.get(studentId);
                if (examsOfStudent == null) {
                    examsOfStudent = new HashSet<Exam>();
                    this.student2exams.put(studentId, examsOfStudent);
                }
                examsOfStudent.add(this.exams.get(examId));
                courseId = (Long)o[3];
                course2students = this.owner2course2students.get(ownerId);
                if (course2students == null) {
                    course2students = new Hashtable();
                    this.owner2course2students.put(ownerId, course2students);
                }
                if ((studentsOfCourse = course2students.get(courseId)) == null) {
                    studentsOfCourse = new HashSet<Long>();
                    course2students.put(courseId, studentsOfCourse);
                }
                studentsOfCourse.add(studentId);
            }
            for (Object[] o : ExamDAO.getInstance().getSession().createQuery("select x.uniqueId, o.uniqueId, e.student.uniqueId, e.courseOffering.uniqueId from Exam x inner join x.owners o, StudentClassEnrollment e inner join e.courseOffering.instructionalOffering io where x.session.uniqueId=:sessionId and x.examType.uniqueId=:examTypeId and o.ownerType=0 and o.ownerId=io.uniqueId", Object[].class).setParameter("sessionId", (Object)sessionId).setParameter("examTypeId", (Object)examTypeId).setCacheable(true).list()) {
                examId = (Long)o[0];
                ownerId = (Long)o[1];
                studentId = (Long)o[2];
                studentsOfOwner = this.owner2students.get(ownerId);
                if (studentsOfOwner == null) {
                    studentsOfOwner = new HashSet<Long>();
                    this.owner2students.put(ownerId, studentsOfOwner);
                }
                studentsOfOwner.add(studentId);
                examsOfStudent = this.student2exams.get(studentId);
                if (examsOfStudent == null) {
                    examsOfStudent = new HashSet<Exam>();
                    this.student2exams.put(studentId, examsOfStudent);
                }
                examsOfStudent.add(this.exams.get(examId));
                courseId = (Long)o[3];
                course2students = this.owner2course2students.get(ownerId);
                if (course2students == null) {
                    course2students = new Hashtable();
                    this.owner2course2students.put(ownerId, course2students);
                }
                if ((studentsOfCourse = course2students.get(courseId)) == null) {
                    studentsOfCourse = new HashSet<Long>();
                    course2students.put(courseId, studentsOfCourse);
                }
                studentsOfCourse.add(studentId);
            }
            for (Object[] o : ExamDAO.getInstance().getSession().createQuery("select p.uniqueId, m from ClassEvent ce inner join ce.meetings m, ExamPeriod p where p.startSlot - :travelTime < m.stopPeriod and m.startPeriod < p.startSlot + p.length + :travelTime and " + HibernateUtil.addDate("p.session.examBeginDate", "p.dateOffset") + " = m.meetingDate and p.session.uniqueId=:sessionId and p.examType.uniqueId=:examTypeId", Object[].class).setParameter("travelTime", (Object)ApplicationProperty.ExaminationTravelTimeClass.intValue()).setParameter("sessionId", (Object)sessionId).setParameter("examTypeId", (Object)examTypeId).setCacheable(true).list()) {
                periodId = (Long)o[0];
                meeting = (Meeting)o[1];
                meetings = this.period2meetings.get(periodId);
                if (meetings == null) {
                    meetings = new HashSet<Meeting>();
                    this.period2meetings.put(periodId, meetings);
                }
                meetings.add(meeting);
            }
            for (Object[] o : ExamDAO.getInstance().getSession().createQuery("select p.uniqueId, m from CourseEvent ce inner join ce.meetings m, ExamPeriod p where ce.reqAttendance=true and m.approvalStatus = 1 and p.startSlot - :travelTime < m.stopPeriod and m.startPeriod < p.startSlot + p.length + :travelTime and " + HibernateUtil.addDate("p.session.examBeginDate", "p.dateOffset") + " = m.meetingDate and p.session.uniqueId=:sessionId and p.examType.uniqueId=:examTypeId", Object[].class).setParameter("travelTime", (Object)ApplicationProperty.ExaminationTravelTimeCourse.intValue()).setParameter("sessionId", (Object)sessionId).setParameter("examTypeId", (Object)examTypeId).setCacheable(true).list()) {
                periodId = (Long)o[0];
                meeting = (Meeting)o[1];
                meetings = this.period2meetings.get(periodId);
                if (meetings == null) {
                    meetings = new HashSet<Meeting>();
                    this.period2meetings.put(periodId, meetings);
                }
                meetings.add(meeting);
            }
            for (Object[] o : ExamDAO.getInstance().getSession().createQuery("select p.uniqueId, m from ExamEvent ce inner join ce.meetings m, ExamPeriod p where ce.exam.examType.uniqueId != :examTypeId and m.approvalStatus = 1 and p.startSlot - :travelTime < m.stopPeriod and m.startPeriod < p.startSlot + p.length + :travelTime and " + HibernateUtil.addDate("p.session.examBeginDate", "p.dateOffset") + " = m.meetingDate and p.session.uniqueId=:sessionId and p.examType.uniqueId=:examTypeId", Object[].class).setParameter("travelTime", (Object)ApplicationProperty.ExaminationTravelTimeCourse.intValue()).setParameter("sessionId", (Object)sessionId).setParameter("examTypeId", (Object)examTypeId).setCacheable(true).list()) {
                periodId = (Long)o[0];
                meeting = (Meeting)o[1];
                meetings = this.period2meetings.get(periodId);
                if (meetings == null) {
                    meetings = new HashSet<Meeting>();
                    this.period2meetings.put(periodId, meetings);
                }
                meetings.add(meeting);
            }
            this.p = new ExamAssignmentInfo.Parameters(sessionId, examTypeId);
        }

        public TreeSet<ExamAssignmentInfo> getAssignedExams() {
            TreeSet<ExamAssignmentInfo> ret = new TreeSet<ExamAssignmentInfo>();
            for (Exam exam : ExamDAO.getInstance().getSession().createQuery("select x from Exam x where x.examType.uniqueId=:examTypeId and x.session.uniqueId=:sessionId and x.assignedPeriod is not null", Exam.class).setParameter("sessionId", (Object)this.sessionId).setParameter("examTypeId", (Object)this.examTypeId).setCacheable(true).list()) {
                ExamAssignmentInfo info = new ExamAssignmentInfo(exam, this.owner2students, this.owner2course2students, this.student2exams, this.period2meetings, this.p);
                ret.add(info);
            }
            return ret;
        }

        public TreeSet<ExamAssignmentInfo> getAssignedExamsOfSubjectArea(Long subjectAreaId) {
            TreeSet<ExamAssignmentInfo> ret = new TreeSet<ExamAssignmentInfo>();
            for (Exam exam : ExamDAO.getInstance().getSession().createQuery("select distinct x from Exam x inner join x.owners o where o.course.subjectArea.uniqueId=:subjectAreaId and x.examType.uniqueId=:examTypeId and x.session.uniqueId=:sessionId and x.assignedPeriod is not null", Exam.class).setParameter("sessionId", (Object)this.sessionId).setParameter("examTypeId", (Object)this.examTypeId).setParameter("subjectAreaId", (Object)subjectAreaId).setCacheable(true).list()) {
                ExamAssignmentInfo info = new ExamAssignmentInfo(exam, this.owner2students, this.owner2course2students, this.student2exams, this.period2meetings, this.p);
                ret.add(info);
            }
            return ret;
        }

        public TreeSet<ExamAssignmentInfo> getAssignedExamsOfLocation(Long locationId) throws Exception {
            TreeSet<ExamAssignmentInfo> ret = new TreeSet<ExamAssignmentInfo>();
            for (Exam exam : ExamDAO.getInstance().getSession().createQuery("select distinct x from Exam x inner join x.assignedRooms r where r.uniqueId=:locationId and x.assignedPeriod is not null and x.examType.uniqueId=:examTypeId", Exam.class).setParameter("locationId", (Object)locationId).setParameter("examTypeId", (Object)this.examTypeId).setCacheable(true).list()) {
                ExamAssignmentInfo info = new ExamAssignmentInfo(exam, this.owner2students, this.owner2course2students, this.student2exams, this.period2meetings, this.p);
                ret.add(info);
            }
            return ret;
        }

        public TreeSet<ExamAssignmentInfo> getAssignedExamsOfInstructor(Long instructorId) throws Exception {
            TreeSet<ExamAssignmentInfo> ret = new TreeSet<ExamAssignmentInfo>();
            for (Exam exam : ExamDAO.getInstance().getSession().createQuery("select distinct x from Exam x inner join x.instructors i where i.uniqueId=:instructorId and x.assignedPeriod is not null and x.examType.uniqueId=:examTypeId", Exam.class).setParameter("instructorId", (Object)instructorId).setParameter("examTypeId", (Object)this.examTypeId).setCacheable(true).list()) {
                ExamAssignmentInfo info = new ExamAssignmentInfo(exam, this.owner2students, this.owner2course2students, this.student2exams, this.period2meetings, this.p);
                ret.add(info);
            }
            return ret;
        }
    }
}

