/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.unitime.commons.Email;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.ExaminationMessages;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.form.EnrollmentAuditPdfReportForm;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.SubjectAreaDAO;
import org.unitime.timetable.reports.enrollment.PdfEnrollmentAuditReport;
import org.unitime.timetable.reports.exam.InstructorExamReport;
import org.unitime.timetable.reports.exam.PdfLegacyExamReport;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.Constants;

@Action(value="enrollmentAuditPdfReport", results={@Result(name={"show"}, type="tiles", location="enrollmentAuditPdfReport.tiles")})
@TilesDefinition(name="enrollmentAuditPdfReport.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Enrollment Audit PDF Reports"), @TilesPutAttribute(name="body", value="/user/pdfEnrollmentAuditReport.jsp")})
public class EnrollmentAuditPdfReportAction
extends UniTimeAction<EnrollmentAuditPdfReportForm> {
    private static final long serialVersionUID = -7475297473237927492L;
    private static Log sLog = LogFactory.getLog(EnrollmentAuditPdfReportAction.class);
    protected static final ExaminationMessages MSG = Localization.create(ExaminationMessages.class);

    public String execute() throws Exception {
        if (this.form == null) {
            this.form = new EnrollmentAuditPdfReportForm();
        }
        this.sessionContext.checkPermission(Right.EnrollmentAuditPDFReports);
        if (((EnrollmentAuditPdfReportForm)this.form).getOp() != null) {
            this.op = ((EnrollmentAuditPdfReportForm)this.form).getOp();
        }
        if (MSG.actionGenerateReport().equals(this.op)) {
            ((EnrollmentAuditPdfReportForm)this.form).save(this.sessionContext);
        }
        ((EnrollmentAuditPdfReportForm)this.form).load(this.sessionContext);
        if (MSG.actionGenerateReport().equals(this.op)) {
            ((EnrollmentAuditPdfReportForm)this.form).validate(this);
            if (this.hasFieldErrors()) {
                return "show";
            }
            Session session = (Session)SessionDAO.getInstance().get(this.sessionContext.getUser().getCurrentAcademicSessionId());
            try {
                block35: {
                    ((EnrollmentAuditPdfReportForm)this.form).setReport("");
                    Hashtable<CallSite, File> output = new Hashtable<CallSite, File>();
                    for (int i = 0; i < ((EnrollmentAuditPdfReportForm)this.form).getReports().length; ++i) {
                        Class<? extends PdfEnrollmentAuditReport> reportClass = EnrollmentAuditPdfReportForm.RegisteredReport.valueOf(((EnrollmentAuditPdfReportForm)this.form).getReports()[i]).getImplementation();
                        String reportName = ((EnrollmentAuditPdfReportForm)this.form).getReportName(EnrollmentAuditPdfReportForm.RegisteredReport.valueOf(((EnrollmentAuditPdfReportForm)this.form).getReports()[i]));
                        String name = session.getAcademicTerm() + session.getAcademicYear() + "_" + ((EnrollmentAuditPdfReportForm)this.form).getReports()[i];
                        String string = PdfLegacyExamReport.getExtension(((EnrollmentAuditPdfReportForm)this.form).getReportMode().ordinal());
                        ((EnrollmentAuditPdfReportForm)this.form).log(MSG.statusGeneratingReport(reportName));
                        if (((EnrollmentAuditPdfReportForm)this.form).getAll()) {
                            File file = ApplicationProperties.getTempFile(name, string);
                            ((EnrollmentAuditPdfReportForm)this.form).log("&nbsp;&nbsp;" + MSG.infoWritingReport("<a href='temp/" + file.getName() + "'>" + reportName + string + "</a>"));
                            PdfEnrollmentAuditReport report = reportClass.getConstructor(Integer.TYPE, File.class, Session.class).newInstance(((EnrollmentAuditPdfReportForm)this.form).getReportMode().ordinal(), file, session);
                            report.setShowId(((EnrollmentAuditPdfReportForm)this.form).getExternalId());
                            report.setShowName(((EnrollmentAuditPdfReportForm)this.form).getStudentName());
                            report.printReport();
                            report.close();
                            output.put((CallSite)((Object)(reportName + string)), file);
                            continue;
                        }
                        TreeSet<SubjectArea> subjectAreas = new TreeSet<SubjectArea>();
                        Object subjAbbvs = "";
                        for (int j = 0; j < ((EnrollmentAuditPdfReportForm)this.form).getSubjects().length; ++j) {
                            SubjectArea subject = (SubjectArea)SubjectAreaDAO.getInstance().get(Long.valueOf(((EnrollmentAuditPdfReportForm)this.form).getSubjects()[j]));
                            if (((String)subjAbbvs).length() == 0) {
                                subjAbbvs = subject.getSubjectAreaAbbreviation();
                            } else if (((String)subjAbbvs).length() < 40) {
                                subjAbbvs = (String)subjAbbvs + "_" + subject.getSubjectAreaAbbreviation();
                            } else if (((String)subjAbbvs).charAt(((String)subjAbbvs).length() - 1) != '.') {
                                subjAbbvs = (String)subjAbbvs + "_...";
                            }
                            subjectAreas.add(subject);
                        }
                        File file = ApplicationProperties.getTempFile(name + (String)subjAbbvs, string);
                        ((EnrollmentAuditPdfReportForm)this.form).log("&nbsp;&nbsp;" + MSG.infoWritingReport("<a href='temp/" + file.getName() + "'>" + (String)subjAbbvs + "_" + reportName + string + "</a>"));
                        PdfEnrollmentAuditReport report = reportClass.getConstructor(Integer.TYPE, File.class, Session.class, TreeSet.class, String.class).newInstance(((EnrollmentAuditPdfReportForm)this.form).getReportMode().ordinal(), file, session, subjectAreas, subjAbbvs);
                        report.setShowId(((EnrollmentAuditPdfReportForm)this.form).getExternalId());
                        report.setShowName(((EnrollmentAuditPdfReportForm)this.form).getStudentName());
                        report.printReport();
                        report.close();
                        output.put((CallSite)((Object)((String)subjAbbvs + "_" + reportName + string)), file);
                    }
                    byte[] buffer = new byte[32768];
                    int len = 0;
                    if (output.isEmpty()) {
                        ((EnrollmentAuditPdfReportForm)this.form).log("<font color='orange'>" + MSG.warnNoReportGenerated() + "</font>");
                    } else if (((EnrollmentAuditPdfReportForm)this.form).getEmail()) {
                        ((EnrollmentAuditPdfReportForm)this.form).log(MSG.statusSendingEmails());
                        try {
                            Object s;
                            Email mail = Email.createEmail();
                            mail.setSubject(((EnrollmentAuditPdfReportForm)this.form).getSubject() == null ? "Enrollment Audit Report" : ((EnrollmentAuditPdfReportForm)this.form).getSubject());
                            mail.setText((String)(((EnrollmentAuditPdfReportForm)this.form).getMessage() == null ? "" : ((EnrollmentAuditPdfReportForm)this.form).getMessage() + "\r\n\r\n") + MSG.emailForUpToDateEnrlReportVisit(this.request.getScheme() + "://" + this.request.getServerName() + ":" + this.request.getServerPort() + this.request.getContextPath()) + "/\r\n\r\n" + MSG.emailFooter(Constants.getVersion()));
                            if (((EnrollmentAuditPdfReportForm)this.form).getAddress() != null) {
                                s = new StringTokenizer(((EnrollmentAuditPdfReportForm)this.form).getAddress(), ";,\n\r ");
                                while (((StringTokenizer)s).hasMoreTokens()) {
                                    mail.addRecipient(((StringTokenizer)s).nextToken(), null);
                                }
                            }
                            if (((EnrollmentAuditPdfReportForm)this.form).getCc() != null) {
                                s = new StringTokenizer(((EnrollmentAuditPdfReportForm)this.form).getCc(), ";,\n\r ");
                                while (((StringTokenizer)s).hasMoreTokens()) {
                                    mail.addRecipientCC(((StringTokenizer)s).nextToken(), null);
                                }
                            }
                            if (((EnrollmentAuditPdfReportForm)this.form).getBcc() != null) {
                                s = new StringTokenizer(((EnrollmentAuditPdfReportForm)this.form).getBcc(), ";,\n\r ");
                                while (((StringTokenizer)s).hasMoreTokens()) {
                                    mail.addRecipientBCC(((StringTokenizer)s).nextToken(), null);
                                }
                            }
                            for (Map.Entry entry : output.entrySet()) {
                                mail.addAttachment((File)entry.getValue(), session.getAcademicTerm() + session.getAcademicYear() + "_" + (String)entry.getKey());
                            }
                            mail.send();
                            ((EnrollmentAuditPdfReportForm)this.form).log(MSG.infoEmailSent());
                        }
                        catch (Exception e) {
                            ((EnrollmentAuditPdfReportForm)this.form).log("<font color='red'>" + MSG.errorUnableToSendEmail(e.getMessage()) + "</font>");
                        }
                    }
                    if (output.isEmpty()) {
                        return null;
                    }
                    if (output.size() == 1) {
                        this.request.setAttribute("RqOpenUrl", (Object)("temp/" + ((File)output.elements().nextElement()).getName()));
                    } else {
                        FileInputStream fis = null;
                        ZipOutputStream zip = null;
                        try {
                            File file = ApplicationProperties.getTempFile(session.getAcademicTerm() + session.getAcademicYear(), "zip");
                            ((EnrollmentAuditPdfReportForm)this.form).log(MSG.statusWritingReport("<a href='temp/" + file.getName() + "'>" + session.getAcademicTerm() + session.getAcademicYear() + ".zip</a>"));
                            zip = new ZipOutputStream(new FileOutputStream(file));
                            for (Map.Entry entry : output.entrySet()) {
                                zip.putNextEntry(new ZipEntry((String)entry.getKey()));
                                fis = new FileInputStream((File)entry.getValue());
                                while ((len = fis.read(buffer)) > 0) {
                                    zip.write(buffer, 0, len);
                                }
                                fis.close();
                                fis = null;
                                zip.closeEntry();
                            }
                            zip.flush();
                            zip.close();
                            this.request.setAttribute("RqOpenUrl", (Object)("temp/" + file.getName()));
                        }
                        catch (IOException iOException) {
                            if (fis != null) {
                                fis.close();
                            }
                            if (zip == null) break block35;
                            zip.close();
                        }
                    }
                }
                ((EnrollmentAuditPdfReportForm)this.form).log(MSG.statusAllDone());
            }
            catch (Exception e) {
                ((EnrollmentAuditPdfReportForm)this.form).log("<font color='red'>" + MSG.errorTaskFailedWithMessage(e.getMessage()) + "</font>");
                sLog.error((Object)e.getMessage(), (Throwable)e);
                this.addFieldError("report", MSG.errorUnableToGenerateReport(e.getMessage()));
            }
        }
        return "show";
    }

    public static class FileGenerator
    implements InstructorExamReport.FileGenerator {
        String iName;

        public FileGenerator(String name) {
            this.iName = name;
        }

        @Override
        public File generate(String prefix, String ext) {
            return ApplicationProperties.getTempFile(this.iName + "_" + prefix, ext);
        }
    }
}

