/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct;

import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cpsolver.coursett.Constants;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.EmptyAssignment;
import org.cpsolver.ifs.heuristics.RouletteWheelSelection;
import org.cpsolver.studentsct.model.Config;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.FreeTimeRequest;
import org.cpsolver.studentsct.model.Offering;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.SctAssignment;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.Subpart;

public class StudentPreferencePenalties {
    private static Logger sLog = LogManager.getLogger(StudentPreferencePenalties.class);
    private static DecimalFormat sDF = new DecimalFormat("0.000");
    private static boolean sDebug = false;
    public static int sDistTypeUniform = 0;
    public static int sDistTypePreference = 1;
    public static int sDistTypePreferenceQuadratic = 2;
    public static int sDistTypePreferenceReverse = 3;
    public static int[][] sStudentRequestDistribution = new int[][]{{1, 1, 4, 7, 10, 10, 5, 8, 8, 6, 3, 1}, {1, 2, 4, 7, 10, 10, 5, 8, 8, 6, 3, 1}, {1, 2, 4, 7, 10, 10, 5, 8, 8, 6, 3, 1}, {1, 2, 4, 7, 10, 10, 5, 8, 8, 6, 3, 1}, {1, 2, 4, 7, 10, 10, 5, 4, 3, 2, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}};
    private HashMap<String, Double> iWeight = new HashMap();

    public StudentPreferencePenalties(int disributionType) {
        RouletteWheelSelection<int[]> roulette = new RouletteWheelSelection<int[]>();
        for (int d = 0; d < sStudentRequestDistribution.length; ++d) {
            for (int t = 0; t < sStudentRequestDistribution[d].length; ++t) {
                if (disributionType == sDistTypeUniform) {
                    roulette.add(new int[]{d, t}, 1.0);
                    continue;
                }
                if (disributionType == sDistTypePreference) {
                    roulette.add(new int[]{d, t}, sStudentRequestDistribution[d][t]);
                    continue;
                }
                if (disributionType == sDistTypePreferenceQuadratic) {
                    roulette.add(new int[]{d, t}, sStudentRequestDistribution[d][t] * sStudentRequestDistribution[d][t]);
                    continue;
                }
                if (disributionType == sDistTypePreferenceReverse) {
                    roulette.add(new int[]{d, t}, 11 - sStudentRequestDistribution[d][t]);
                    continue;
                }
                roulette.add(new int[]{d, t}, 1.0);
            }
        }
        int idx = 0;
        while (roulette.hasMoreElements()) {
            int[] dt = (int[])roulette.nextElement();
            this.iWeight.put(dt[0] + "." + dt[1], (double)idx / (double)(roulette.size() - 1));
            if (sDebug) {
                sLog.debug("  -- " + (idx + 1) + ". preference is " + this.toString(dt[0], dt[1]) + " (P:" + sDF.format((double)idx / (double)(roulette.size() - 1)) + ")");
            }
            ++idx;
        }
    }

    public static int day(int slot) {
        return slot / 288;
    }

    public static int time(int slot) {
        int s = slot % 288;
        int min = s * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN;
        if (min < 450) {
            return 0;
        }
        int idx = 1 + (min - 450) / 60;
        return idx > 11 ? 11 : idx;
    }

    public String toString(int day, int time) {
        if (time == 0) {
            return Constants.DAY_NAMES_SHORT[day] + " morning";
        }
        if (time == 11) {
            return Constants.DAY_NAMES_SHORT[day] + " evening";
        }
        return Constants.DAY_NAMES_SHORT[day] + " " + (6 + time) + ":30";
    }

    public double getPenalty(TimeLocation time) {
        int nrSlots = 0;
        double penalty = 0.0;
        TimeLocation.IntEnumeration e = time.getSlots();
        while (e.hasMoreElements()) {
            int slot = (Integer)e.nextElement();
            ++nrSlots;
            penalty += this.iWeight.get(StudentPreferencePenalties.day(slot) + "." + StudentPreferencePenalties.time(slot)).doubleValue();
        }
        return penalty / (double)nrSlots;
    }

    public double getPenalty(SctAssignment assignment) {
        return assignment.getTime() == null ? 0.0 : this.getPenalty(assignment.getTime());
    }

    public double getPenalty(Enrollment enrollment) {
        double penalty = 0.0;
        for (Section section : enrollment.getSections()) {
            penalty += this.getPenalty(section);
        }
        return penalty / (double)enrollment.getAssignments().size();
    }

    public double getMinPenalty(Request request) {
        if (request instanceof CourseRequest) {
            return this.getMinPenalty((CourseRequest)request);
        }
        if (request instanceof FreeTimeRequest) {
            return this.getPenalty(((FreeTimeRequest)request).getTime());
        }
        return 0.0;
    }

    public double getMinPenalty(CourseRequest request) {
        double min = Double.MAX_VALUE;
        for (Course course : request.getCourses()) {
            min = Math.min(min, this.getMinPenalty(course.getOffering()));
        }
        return min == Double.MAX_VALUE ? 0.0 : min;
    }

    public double getMinPenalty(Offering offering) {
        double min = Double.MAX_VALUE;
        for (Config config : offering.getConfigs()) {
            min = Math.min(min, this.getMinPenalty(config));
        }
        return min == Double.MAX_VALUE ? 0.0 : min;
    }

    public double getMinPenalty(Config config) {
        double min = 0.0;
        for (Subpart subpart : config.getSubparts()) {
            min += this.getMinPenalty(subpart);
        }
        return min / (double)config.getSubparts().size();
    }

    public double getMinPenalty(Subpart subpart) {
        double min = Double.MAX_VALUE;
        for (Section section : subpart.getSections()) {
            min = Math.min(min, this.getPenalty(section));
        }
        return min == Double.MAX_VALUE ? 0.0 : min;
    }

    public double getMaxPenalty(Request request) {
        if (request instanceof CourseRequest) {
            return this.getMaxPenalty((CourseRequest)request);
        }
        if (request instanceof FreeTimeRequest) {
            return this.getPenalty(((FreeTimeRequest)request).getTime());
        }
        return 0.0;
    }

    public double getMaxPenalty(CourseRequest request) {
        double max = Double.MIN_VALUE;
        for (Course course : request.getCourses()) {
            max = Math.max(max, this.getMaxPenalty(course.getOffering()));
        }
        return max == Double.MIN_VALUE ? 0.0 : max;
    }

    public double getMaxPenalty(Offering offering) {
        double max = Double.MIN_VALUE;
        for (Config config : offering.getConfigs()) {
            max = Math.max(max, this.getMaxPenalty(config));
        }
        return max == Double.MIN_VALUE ? 0.0 : max;
    }

    public double getMaxPenalty(Config config) {
        double max = 0.0;
        for (Subpart subpart : config.getSubparts()) {
            max += this.getMaxPenalty(subpart);
        }
        return max / (double)config.getSubparts().size();
    }

    public double getMaxPenalty(Subpart subpart) {
        double max = Double.MIN_VALUE;
        for (Section section : subpart.getSections()) {
            max = Math.max(max, this.getPenalty(section));
        }
        return max == Double.MIN_VALUE ? 0.0 : max;
    }

    public double[] getMinMaxAvailableEnrollmentPenalty(Assignment<Request, Enrollment> assignment, Request request) {
        if (request instanceof CourseRequest) {
            return this.getMinMaxAvailableEnrollmentPenalty(assignment, (CourseRequest)request);
        }
        double pen = this.getPenalty(((FreeTimeRequest)request).getTime());
        return new double[]{pen, pen};
    }

    public double[] getMinMaxAvailableEnrollmentPenalty(Assignment<Request, Enrollment> assignment, CourseRequest request) {
        List<Enrollment> enrollments = request.getAvaiableEnrollments(assignment);
        if (enrollments.isEmpty()) {
            return new double[]{0.0, 0.0};
        }
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        for (Enrollment enrollment : enrollments) {
            double penalty = this.getPenalty(enrollment);
            min = Math.min(min, penalty);
            max = Math.max(max, penalty);
        }
        return new double[]{min, max};
    }

    public double[] getMinMaxEnrollmentPenalty(Request request) {
        if (request instanceof CourseRequest) {
            return this.getMinMaxEnrollmentPenalty((CourseRequest)request);
        }
        double pen = this.getPenalty(((FreeTimeRequest)request).getTime());
        return new double[]{pen, pen};
    }

    public double[] getMinMaxEnrollmentPenalty(CourseRequest request) {
        List<Enrollment> enrollments = request.values((Assignment<Request, Enrollment>)new EmptyAssignment<Request, Enrollment>());
        if (enrollments.isEmpty()) {
            return new double[]{0.0, 0.0};
        }
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        for (Enrollment enrollment : enrollments) {
            double penalty = this.getPenalty(enrollment);
            min = Math.min(min, penalty);
            max = Math.max(max, penalty);
        }
        return new double[]{min, max};
    }

    public static void setPenalties(Student student, int distributionType) {
        if (sDebug) {
            sLog.debug("Setting penalties for " + student);
        }
        StudentPreferencePenalties penalties = new StudentPreferencePenalties(distributionType);
        for (Request request : student.getRequests()) {
            if (!(request instanceof CourseRequest)) continue;
            CourseRequest courseRequest = (CourseRequest)request;
            if (sDebug) {
                sLog.debug("-- " + courseRequest);
            }
            for (Course course : courseRequest.getCourses()) {
                if (sDebug) {
                    sLog.debug("  -- " + course.getName());
                }
                for (Config config : course.getOffering().getConfigs()) {
                    if (sDebug) {
                        sLog.debug("    -- " + config.getName());
                    }
                    for (Subpart subpart : config.getSubparts()) {
                        if (sDebug) {
                            sLog.debug("      -- " + subpart.getName());
                        }
                        for (Section section : subpart.getSections()) {
                            section.setPenalty(penalties.getPenalty(section));
                            if (!sDebug) continue;
                            sLog.debug("        -- " + section);
                        }
                    }
                }
            }
            courseRequest.clearCache();
        }
    }
}

