/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.instructor.constraints;

import java.util.Set;
import org.cpsolver.coursett.Constants;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.context.AssignmentConstraintContext;
import org.cpsolver.ifs.assignment.context.ConstraintWithContext;
import org.cpsolver.instructor.criteria.SameInstructor;
import org.cpsolver.instructor.model.TeachingAssignment;
import org.cpsolver.instructor.model.TeachingRequest;

public class SameInstructorConstraint
extends ConstraintWithContext<TeachingRequest.Variable, TeachingAssignment, Context> {
    private Long iId;
    private String iName;
    private int iPreference = 0;
    private boolean iRequired = false;
    private boolean iProhibited = false;

    public SameInstructorConstraint(Long id, String name, String preference) {
        this.iId = id;
        this.iName = name;
        this.iPreference = Constants.preference2preferenceLevel(preference);
        if ("R".equals(preference)) {
            this.iRequired = true;
        } else if ("P".equals(preference)) {
            this.iProhibited = true;
        }
    }

    public Long getConstraintId() {
        return this.iId;
    }

    @Override
    public String getName() {
        return this.iName;
    }

    public String toString() {
        return "Same Instructor " + this.getName();
    }

    public boolean isRequired() {
        return this.iRequired;
    }

    public boolean isProhibited() {
        return this.iProhibited;
    }

    public int getPreference() {
        return this.iPreference;
    }

    @Override
    public boolean isHard() {
        return this.isRequired() || this.isProhibited();
    }

    public boolean isSatisfiedPair(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, TeachingAssignment a1, TeachingAssignment a2) {
        if (this.isRequired() || !this.isProhibited() && this.getPreference() <= 0) {
            return a1.getInstructor().equals(a2.getInstructor());
        }
        if (this.isProhibited() || !this.isRequired() && this.getPreference() > 0) {
            return !a1.getInstructor().equals(a2.getInstructor());
        }
        return true;
    }

    @Override
    public void computeConflicts(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, TeachingAssignment value, Set<TeachingAssignment> conflicts) {
        if (this.isHard()) {
            for (TeachingRequest.Variable request : this.variables()) {
                TeachingAssignment conflict;
                if (request.equals(value.variable()) || (conflict = assignment.getValue(request)) == null || this.isSatisfiedPair(assignment, value, conflict)) continue;
                conflicts.add(conflict);
            }
        }
    }

    public int getCurrentPreference(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, TeachingAssignment value) {
        if (this.isHard()) {
            return 0;
        }
        if (this.countAssignedVariables(assignment) + (assignment.getValue((TeachingRequest.Variable)value.variable()) == null ? 1 : 0) < 2) {
            return 0;
        }
        int nrViolatedPairsAfter = 0;
        int nrViolatedPairsBefore = 0;
        for (TeachingRequest.Variable v1 : this.variables()) {
            for (TeachingRequest.Variable v2 : this.variables()) {
                TeachingAssignment p2;
                if (v1.getId() >= v2.getId()) continue;
                TeachingAssignment p1 = v1.equals(value.variable()) ? null : assignment.getValue(v1);
                TeachingAssignment teachingAssignment = p2 = v2.equals(value.variable()) ? null : assignment.getValue(v2);
                if (p1 != null && p2 != null && !this.isSatisfiedPair(assignment, p1, p2)) {
                    ++nrViolatedPairsBefore;
                }
                if (v1.equals(value.variable())) {
                    p1 = value;
                }
                if (v2.equals(value.variable())) {
                    p2 = value;
                }
                if (p1 == null || p2 == null || this.isSatisfiedPair(assignment, p1, p2)) continue;
                ++nrViolatedPairsAfter;
            }
        }
        return (nrViolatedPairsAfter > 0 ? Math.abs(this.iPreference) * nrViolatedPairsAfter : 0) - (nrViolatedPairsBefore > 0 ? Math.abs(this.iPreference) * nrViolatedPairsBefore : 0);
    }

    public int getCurrentPreference(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment) {
        if (this.isHard()) {
            return 0;
        }
        if (this.countAssignedVariables(assignment) < 2) {
            return 0;
        }
        int nrViolatedPairs = 0;
        for (TeachingRequest.Variable v1 : this.variables()) {
            TeachingAssignment p1 = assignment.getValue(v1);
            if (p1 == null) continue;
            for (TeachingRequest.Variable v2 : this.variables()) {
                TeachingAssignment p2 = assignment.getValue(v2);
                if (p2 == null || v1.getId() >= v2.getId() || this.isSatisfiedPair(assignment, p1, p2)) continue;
                ++nrViolatedPairs;
            }
        }
        return nrViolatedPairs > 0 ? Math.abs(this.iPreference) * nrViolatedPairs : 0;
    }

    @Override
    public Context createAssignmentContext(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment) {
        return new Context(assignment);
    }

    public class Context
    implements AssignmentConstraintContext<TeachingRequest.Variable, TeachingAssignment> {
        private int iLastPreference = 0;

        public Context(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment) {
            this.updateCriterion(assignment);
        }

        @Override
        public void assigned(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, TeachingAssignment value) {
            this.updateCriterion(assignment);
        }

        @Override
        public void unassigned(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, TeachingAssignment value) {
            this.updateCriterion(assignment);
        }

        private void updateCriterion(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment) {
            if (!SameInstructorConstraint.this.isHard()) {
                SameInstructorConstraint.this.getModel().getCriterion(SameInstructor.class).inc(assignment, -this.iLastPreference);
                this.iLastPreference = SameInstructorConstraint.this.getCurrentPreference(assignment);
                SameInstructorConstraint.this.getModel().getCriterion(SameInstructor.class).inc(assignment, this.iLastPreference);
            }
        }

        public int getPreference() {
            return this.iLastPreference;
        }
    }
}

