/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.criteria;

import java.util.Map;
import java.util.Set;
import org.cpsolver.exam.criteria.StudentBackToBackConflicts;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamInstructor;
import org.cpsolver.exam.model.ExamModel;
import org.cpsolver.exam.model.ExamPeriod;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.util.DataProperties;

public class InstructorBackToBackConflicts
extends StudentBackToBackConflicts {
    @Override
    public String getWeightName() {
        return "Exams.InstructorBackToBackConflictWeight";
    }

    @Override
    public String getXmlWeightName() {
        return "instructorBackToBackConflictWeight";
    }

    @Override
    public double getWeightDefault(DataProperties config) {
        return 10.0;
    }

    @Override
    public double getValue(Assignment<Exam, ExamPlacement> assignment, ExamPlacement value, Set<ExamPlacement> conflicts) {
        Exam exam = (Exam)value.variable();
        int penalty = 0;
        ExamPeriod period = value.getPeriod();
        Map<ExamInstructor, Set<Exam>> prev = period.prev() != null && (this.isDayBreakBackToBack() || period.prev().getDay() == period.getDay()) ? ((ExamModel)this.getModel()).getInstructorsOfPeriod(assignment, period.prev()) : null;
        Map<ExamInstructor, Set<Exam>> next = period.next() != null && (this.isDayBreakBackToBack() || period.next().getDay() == period.getDay()) ? ((ExamModel)this.getModel()).getInstructorsOfPeriod(assignment, period.next()) : null;
        for (ExamInstructor s : exam.getInstructors()) {
            int nrExams;
            Set<Exam> exams;
            if (prev != null && (exams = prev.get(s)) != null) {
                nrExams = exams.size() + (exams.contains(exam) ? -1 : 0);
                penalty += nrExams;
            }
            if (next == null || (exams = next.get(s)) == null) continue;
            nrExams = exams.size() + (exams.contains(exam) ? -1 : 0);
            penalty += nrExams;
        }
        return penalty;
    }

    @Override
    public String getName() {
        return "Instructor Back-To-Back Conflicts";
    }

    @Override
    public String toString(Assignment<Exam, ExamPlacement> assignment) {
        return "iBTB:" + sDoubleFormat.format(this.getValue(assignment));
    }
}

