/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.criteria;

import java.util.Collection;
import java.util.Set;
import org.cpsolver.coursett.criteria.TimetablingCriterion;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.criteria.AbstractCriterion;
import org.cpsolver.ifs.perturbations.PerturbationsCounter;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;

public class Perturbations
extends TimetablingCriterion {
    private PerturbationsCounter<Lecture, Placement> iPerturbationsCounter = null;

    public Perturbations() {
        this.setValueUpdateType(AbstractCriterion.ValueUpdateType.NoUpdate);
    }

    @Override
    public String getPlacementSelectionWeightName() {
        return "Placement.MPP_DeltaInitialAssignmentWeight";
    }

    @Override
    public boolean init(Solver<Lecture, Placement> solver) {
        this.iPerturbationsCounter = solver.getPerturbationsCounter();
        return super.init(solver);
    }

    @Override
    public double getWeightDefault(DataProperties config) {
        return config.getPropertyDouble("Comparator.PerturbationPenaltyWeight", 1.0);
    }

    public PerturbationsCounter<Lecture, Placement> getPerturbationsCounter() {
        return this.iPerturbationsCounter;
    }

    @Override
    public double getValue(Assignment<Lecture, Placement> assignment, Placement value, Set<Placement> conflicts) {
        return this.getPerturbationsCounter().getPerturbationPenalty(assignment, this.getModel(), value, conflicts);
    }

    @Override
    public double getValue(Assignment<Lecture, Placement> assignment) {
        return this.getPerturbationsCounter().getPerturbationPenalty(assignment, this.getModel());
    }

    @Override
    public double getValue(Assignment<Lecture, Placement> assignment, Collection<Lecture> variables) {
        return this.getPerturbationsCounter().getPerturbationPenalty(assignment, this.getModel(), variables);
    }

    @Override
    public double[] getBounds(Assignment<Lecture, Placement> assignment) {
        return new double[]{0.0, 0.0};
    }

    @Override
    public double[] getBounds(Assignment<Lecture, Placement> assignment, Collection<Lecture> variables) {
        return new double[]{0.0, 0.0};
    }
}

