/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.chain;

import biweekly.ICalendar;
import biweekly.component.ICalComponent;
import biweekly.io.chain.ChainingWriter;
import biweekly.io.json.JCalWriter;
import biweekly.io.scribe.component.ICalComponentScribe;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.property.ICalProperty;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.TimeZone;

public class ChainingJsonWriter
extends ChainingWriter<ChainingJsonWriter> {
    private boolean prettyPrint = false;

    public ChainingJsonWriter(Collection<ICalendar> icals) {
        super(icals);
    }

    public ChainingJsonWriter prettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
        return this;
    }

    @Override
    public ChainingJsonWriter tz(TimeZone defaultTimeZone, boolean outlookCompatible) {
        return (ChainingJsonWriter)super.tz(defaultTimeZone, outlookCompatible);
    }

    @Override
    public ChainingJsonWriter register(ICalPropertyScribe<? extends ICalProperty> scribe) {
        return (ChainingJsonWriter)super.register(scribe);
    }

    @Override
    public ChainingJsonWriter register(ICalComponentScribe<? extends ICalComponent> scribe) {
        return (ChainingJsonWriter)super.register(scribe);
    }

    public String go() {
        StringWriter sw = new StringWriter();
        try {
            this.go(sw);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return sw.toString();
    }

    public void go(OutputStream out) throws IOException {
        this.go(new JCalWriter(out, this.wrapInArray()));
    }

    public void go(File file) throws IOException {
        JCalWriter writer = new JCalWriter(file, this.wrapInArray());
        try {
            this.go(writer);
        }
        finally {
            writer.close();
        }
    }

    public void go(Writer writer) throws IOException {
        this.go(new JCalWriter(writer, this.wrapInArray()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void go(JCalWriter writer) throws IOException {
        if (this.defaultTimeZone != null) {
            writer.setGlobalTimezone(this.defaultTimeZone);
        }
        writer.setPrettyPrint(this.prettyPrint);
        if (this.index != null) {
            writer.setScribeIndex(this.index);
        }
        try {
            for (ICalendar ical : this.icals) {
                writer.write(ical);
                writer.flush();
            }
        }
        finally {
            writer.closeJsonStream();
        }
    }

    private boolean wrapInArray() {
        return this.icals.size() > 1;
    }
}

