/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.inboundhandler;

import java.util.concurrent.TimeUnit;
import org.infinispan.commands.CancellableCommand;
import org.infinispan.commands.CancellationService;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commands.remote.MultipleRpcCommand;
import org.infinispan.commands.remote.SingleRpcCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.remoting.inboundhandler.BaseBlockingRunnable;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.inboundhandler.PerCacheInboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.Reply;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.ResponseGenerator;
import org.infinispan.statetransfer.OutdatedTopologyException;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.util.concurrent.BlockingRunnable;
import org.infinispan.util.concurrent.BlockingTaskAwareExecutorService;
import org.infinispan.util.logging.Log;

public abstract class BasePerCacheInboundInvocationHandler
implements PerCacheInboundInvocationHandler {
    protected static int NO_TOPOLOGY_COMMAND = Integer.MIN_VALUE;
    protected BlockingTaskAwareExecutorService remoteCommandsExecutor;
    protected StateTransferLock stateTransferLock;
    protected StateTransferManager stateTransferManager;
    private ResponseGenerator responseGenerator;
    private CancellationService cancellationService;

    protected static int extractCommandTopologyId(SingleRpcCommand command) {
        ReplicableCommand innerCmd = command.getCommand();
        if (innerCmd instanceof TopologyAffectedCommand) {
            return BasePerCacheInboundInvocationHandler.extractCommandTopologyId((TopologyAffectedCommand)innerCmd);
        }
        return -1;
    }

    protected static int extractCommandTopologyId(MultipleRpcCommand command) {
        int commandTopologyId = -1;
        for (ReplicableCommand innerCmd : command.getCommands()) {
            if (!(innerCmd instanceof TopologyAffectedCommand)) continue;
            commandTopologyId = Math.max(BasePerCacheInboundInvocationHandler.extractCommandTopologyId((TopologyAffectedCommand)innerCmd), commandTopologyId);
        }
        return commandTopologyId;
    }

    protected static int extractCommandTopologyId(TopologyAffectedCommand command) {
        return command.getTopologyId();
    }

    @Inject
    public void injectDependencies(@ComponentName(value="org.infinispan.executors.remote") BlockingTaskAwareExecutorService remoteCommandsExecutor, ResponseGenerator responseGenerator, CancellationService cancellationService, StateTransferLock stateTransferLock, StateTransferManager stateTransferManager) {
        this.remoteCommandsExecutor = remoteCommandsExecutor;
        this.responseGenerator = responseGenerator;
        this.cancellationService = cancellationService;
        this.stateTransferLock = stateTransferLock;
        this.stateTransferManager = stateTransferManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final Response invokePerform(CacheRpcCommand cmd) throws Throwable {
        try {
            Response response;
            if (this.isTraceEnabled()) {
                this.getLog().tracef("Calling perform() on %s", cmd);
            }
            if (cmd instanceof CancellableCommand) {
                this.cancellationService.register(Thread.currentThread(), ((CancellableCommand)cmd).getUUID());
            }
            Response response2 = response = this.responseGenerator.getResponse(cmd, cmd.perform(null));
            return response2;
        }
        finally {
            if (cmd instanceof CancellableCommand) {
                this.cancellationService.unregister(((CancellableCommand)cmd).getUUID());
            }
        }
    }

    final ExceptionResponse exceptionHandlingCommand(CacheRpcCommand command, Throwable throwable) {
        this.getLog().exceptionHandlingCommand(command, throwable);
        return new ExceptionResponse((Exception)((Object)new CacheException("Problems invoking command.", throwable)));
    }

    final ExceptionResponse exceptionHandlingCommand(CacheRpcCommand command, Exception exception) {
        this.getLog().exceptionHandlingCommand(command, exception);
        return new ExceptionResponse(exception);
    }

    final ExceptionResponse outdatedTopology(OutdatedTopologyException exception) {
        this.getLog().outdatedTopology((Throwable)((Object)exception));
        return new ExceptionResponse((Exception)((Object)exception));
    }

    final ExceptionResponse interruptedException(CacheRpcCommand command) {
        this.getLog().shutdownHandlingCommand(command);
        return new ExceptionResponse((Exception)((Object)new CacheException("Cache is shutting down")));
    }

    protected final void unexpectedDeliverMode(ReplicableCommand command, DeliverOrder deliverOrder) {
        throw new IllegalArgumentException(String.format("Unexpected deliver mode %s for command%s", new Object[]{deliverOrder, command}));
    }

    protected final void handleRunnable(BlockingRunnable runnable, boolean onExecutorService) {
        if (onExecutorService) {
            this.remoteCommandsExecutor.execute(runnable);
        } else {
            runnable.run();
        }
    }

    protected final BlockingRunnable createDefaultRunnable(CacheRpcCommand command, Reply reply, int commandTopologyId, boolean waitTransactionalData, boolean onExecutorService) {
        final int waitTopologyId = Math.max(commandTopologyId, 0);
        if (onExecutorService) {
            if (waitTransactionalData) {
                return new DefaultTopologyRunnable(this, command, reply, commandTopologyId){

                    @Override
                    public boolean isReady() {
                        return BasePerCacheInboundInvocationHandler.this.stateTransferLock.transactionDataReceived(waitTopologyId);
                    }
                };
            }
            return new DefaultTopologyRunnable(this, command, reply, commandTopologyId){

                @Override
                public boolean isReady() {
                    return BasePerCacheInboundInvocationHandler.this.stateTransferLock.topologyReceived(waitTopologyId);
                }
            };
        }
        if (waitTransactionalData) {
            return new DefaultTopologyRunnable(this, command, reply, commandTopologyId){

                @Override
                public boolean isReady() {
                    return true;
                }

                @Override
                protected Response beforeInvoke() throws Exception {
                    BasePerCacheInboundInvocationHandler.this.stateTransferLock.waitForTransactionData(waitTopologyId, 1L, TimeUnit.DAYS);
                    return super.beforeInvoke();
                }
            };
        }
        return new DefaultTopologyRunnable(this, command, reply, commandTopologyId){

            @Override
            public boolean isReady() {
                return true;
            }

            @Override
            protected Response beforeInvoke() throws Exception {
                BasePerCacheInboundInvocationHandler.this.stateTransferLock.waitForTopology(waitTopologyId, 1L, TimeUnit.DAYS);
                return super.beforeInvoke();
            }
        };
    }

    protected abstract Log getLog();

    protected abstract boolean isTraceEnabled();

    private static abstract class DefaultTopologyRunnable
    extends BaseBlockingRunnable {
        private final int commandTopologyId;

        protected DefaultTopologyRunnable(BasePerCacheInboundInvocationHandler handler, CacheRpcCommand command, Reply reply, int commandTopologyId) {
            super(handler, command, reply);
            this.commandTopologyId = commandTopologyId;
        }

        @Override
        protected Response beforeInvoke() throws Exception {
            if (0 <= this.commandTopologyId && this.commandTopologyId < this.handler.stateTransferManager.getFirstTopologyAsMember()) {
                if (this.handler.isTraceEnabled()) {
                    this.handler.getLog().tracef("Ignoring command sent before the local node was a member (command topology id is %d)", this.commandTopologyId);
                }
                return CacheNotFoundResponse.INSTANCE;
            }
            return null;
        }
    }
}

