/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cache.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.transaction.InvalidTransactionException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.infinispan.AdvancedCache;
import org.infinispan.Version;
import org.infinispan.atomic.Delta;
import org.infinispan.batch.BatchContainer;
import org.infinispan.cache.impl.DecoratedCache;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.read.EntryRetrievalCommand;
import org.infinispan.commands.read.EntrySetCommand;
import org.infinispan.commands.read.GetAllCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.read.KeySetCommand;
import org.infinispan.commands.read.SizeCommand;
import org.infinispan.commands.read.ValuesCommand;
import org.infinispan.commands.remote.GetKeysInGroupCommand;
import org.infinispan.commands.write.ApplyDeltaCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.commons.util.CloseableIterable;
import org.infinispan.commons.util.CloseableIteratorCollection;
import org.infinispan.commons.util.CloseableIteratorSet;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.concurrent.AbstractInProcessNotifyingFuture;
import org.infinispan.commons.util.concurrent.NotifyingFuture;
import org.infinispan.commons.util.concurrent.NotifyingFutureImpl;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.format.PropertyFormatter;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.context.InvocationContextFactory;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.eviction.EvictionManager;
import org.infinispan.expiration.ExpirationManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.SurvivesRestarts;
import org.infinispan.filter.AcceptAllKeyValueFilter;
import org.infinispan.filter.KeyFilter;
import org.infinispan.filter.KeyValueFilter;
import org.infinispan.filter.NullValueConverter;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.iteration.EntryIterable;
import org.infinispan.jmx.annotations.DataType;
import org.infinispan.jmx.annotations.DisplayType;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.partitionhandling.impl.PartitionHandlingManager;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.security.AuthorizationManager;
import org.infinispan.stats.Stats;
import org.infinispan.stats.impl.StatsImpl;
import org.infinispan.topology.LocalTopologyManager;
import org.infinispan.transaction.impl.TransactionCoordinator;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.transaction.xa.TransactionXaAdapter;
import org.infinispan.transaction.xa.recovery.RecoveryManager;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@SurvivesRestarts
@MBean(objectName="Cache", description="Component that represents an individual cache instance.")
public class CacheImpl<K, V>
implements AdvancedCache<K, V> {
    public static final String OBJECT_NAME = "Cache";
    protected InvocationContextContainer icc;
    protected InvocationContextFactory invocationContextFactory;
    protected CommandsFactory commandsFactory;
    protected InterceptorChain invoker;
    protected Configuration config;
    protected CacheNotifier notifier;
    protected BatchContainer batchContainer;
    protected ComponentRegistry componentRegistry;
    protected TransactionManager transactionManager;
    protected RpcManager rpcManager;
    protected StreamingMarshaller marshaller;
    protected Metadata defaultMetadata;
    private final String name;
    private EvictionManager evictionManager;
    private ExpirationManager<K, V> expirationManager;
    private DataContainer dataContainer;
    private static final Log log = LogFactory.getLog(CacheImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    private EmbeddedCacheManager cacheManager;
    private LockManager lockManager;
    private DistributionManager distributionManager;
    private ExecutorService asyncExecutor;
    private TransactionTable txTable;
    private RecoveryManager recoveryManager;
    private TransactionCoordinator txCoordinator;
    private AuthorizationManager authorizationManager;
    private PartitionHandlingManager partitionHandlingManager;
    private GlobalConfiguration globalCfg;
    private boolean isClassLoaderInContext;
    private LocalTopologyManager localTopologyManager;

    public CacheImpl(String name) {
        this.name = name;
    }

    @Inject
    public void injectDependencies(EvictionManager evictionManager, ExpirationManager expirationManager, InvocationContextFactory invocationContextFactory, InvocationContextContainer icc, CommandsFactory commandsFactory, InterceptorChain interceptorChain, Configuration configuration, CacheNotifier notifier, ComponentRegistry componentRegistry, TransactionManager transactionManager, BatchContainer batchContainer, RpcManager rpcManager, DataContainer dataContainer, @ComponentName(value="org.infinispan.marshaller.cache") StreamingMarshaller marshaller, DistributionManager distributionManager, EmbeddedCacheManager cacheManager, @ComponentName(value="org.infinispan.executors.transport") ExecutorService asyncExecutor, TransactionTable txTable, RecoveryManager recoveryManager, TransactionCoordinator txCoordinator, LockManager lockManager, AuthorizationManager authorizationManager, GlobalConfiguration globalCfg, PartitionHandlingManager partitionHandlingManager, LocalTopologyManager localTopologyManager) {
        this.commandsFactory = commandsFactory;
        this.invoker = interceptorChain;
        this.config = configuration;
        this.notifier = notifier;
        this.componentRegistry = componentRegistry;
        this.transactionManager = transactionManager;
        this.batchContainer = batchContainer;
        this.rpcManager = rpcManager;
        this.evictionManager = evictionManager;
        this.expirationManager = expirationManager;
        this.dataContainer = dataContainer;
        this.marshaller = marshaller;
        this.cacheManager = cacheManager;
        this.invocationContextFactory = invocationContextFactory;
        this.icc = icc;
        this.distributionManager = distributionManager;
        this.asyncExecutor = asyncExecutor;
        this.txTable = txTable;
        this.recoveryManager = recoveryManager;
        this.txCoordinator = txCoordinator;
        this.lockManager = lockManager;
        this.authorizationManager = authorizationManager;
        this.globalCfg = globalCfg;
        this.partitionHandlingManager = partitionHandlingManager;
        this.localTopologyManager = localTopologyManager;
        this.defaultMetadata = new EmbeddedMetadata.Builder().lifespan(this.config.expiration().lifespan()).maxIdle(this.config.expiration().maxIdle()).build();
    }

    private void assertKeyNotNull(Object key) {
        if (key == null) {
            throw new NullPointerException("Null keys are not supported!");
        }
    }

    private void assertKeyValueNotNull(Object key, Object value) {
        this.assertKeyNotNull(key);
        if (value == null) {
            throw new NullPointerException("Null values are not supported!");
        }
    }

    private void assertValueNotNull(Object value) {
        if (value == null) {
            throw new NullPointerException("Null values are not supported!");
        }
    }

    private void assertKeysNotNull(Map<?, ?> data) {
        if (data == null) {
            throw new NullPointerException("Expected map cannot be null");
        }
        for (Object key : data.keySet()) {
            if (key != null) continue;
            throw new NullPointerException("Null keys are not supported!");
        }
    }

    public final V put(K key, V value) {
        return this.put(key, value, this.defaultMetadata);
    }

    public final V put(K key, V value, long lifespan, TimeUnit unit) {
        return this.put(key, value, lifespan, unit, this.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS);
    }

    public final V putIfAbsent(K key, V value, long lifespan, TimeUnit unit) {
        return this.putIfAbsent(key, value, lifespan, unit, this.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS);
    }

    public final void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit unit) {
        this.putAll(map, lifespan, unit, this.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS);
    }

    public final V replace(K key, V value, long lifespan, TimeUnit unit) {
        return this.replace(key, value, lifespan, unit, this.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS);
    }

    public final boolean replace(K key, V oldValue, V value, long lifespan, TimeUnit unit) {
        return this.replace(key, oldValue, value, lifespan, unit, this.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS);
    }

    public final V putIfAbsent(K key, V value) {
        return this.putIfAbsent(key, value, this.defaultMetadata);
    }

    public final boolean replace(K key, V oldValue, V newValue) {
        return this.replace(key, oldValue, newValue, this.defaultMetadata);
    }

    public final V replace(K key, V value) {
        return this.replace(key, value, this.defaultMetadata);
    }

    public final NotifyingFuture<V> putAsync(K key, V value) {
        return this.putAsync(key, value, this.defaultMetadata);
    }

    public final NotifyingFuture<V> putAsync(K key, V value, long lifespan, TimeUnit unit) {
        return this.putAsync(key, value, lifespan, unit, this.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS);
    }

    public final NotifyingFuture<Void> putAllAsync(Map<? extends K, ? extends V> data) {
        return this.putAllAsync(data, this.defaultMetadata, null, null);
    }

    public final NotifyingFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, long lifespan, TimeUnit unit) {
        return this.putAllAsync(data, lifespan, TimeUnit.MILLISECONDS, this.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS);
    }

    public final NotifyingFuture<V> putIfAbsentAsync(K key, V value) {
        return this.putIfAbsentAsync(key, value, this.defaultMetadata, null, null);
    }

    public final NotifyingFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit unit) {
        return this.putIfAbsentAsync(key, value, lifespan, unit, this.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS);
    }

    public final NotifyingFuture<V> replaceAsync(K key, V value) {
        return this.replaceAsync(key, value, this.defaultMetadata, null, null);
    }

    public final NotifyingFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit unit) {
        return this.replaceAsync(key, value, lifespan, unit, this.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS);
    }

    public final NotifyingFuture<Boolean> replaceAsync(K key, V oldValue, V newValue) {
        return this.replaceAsync(key, oldValue, newValue, this.defaultMetadata, null, null);
    }

    public final NotifyingFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, long lifespan, TimeUnit unit) {
        return this.replaceAsync(key, oldValue, newValue, lifespan, unit, this.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS);
    }

    public final void putAll(Map<? extends K, ? extends V> m) {
        this.putAll(m, this.defaultMetadata, null, null);
    }

    public final boolean remove(Object key, Object value) {
        return this.remove(key, value, null, null);
    }

    final boolean remove(Object key, Object value, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        InvocationContext ctx = this.getInvocationContextWithImplicitTransaction(false, explicitClassLoader, 1);
        return this.removeInternal(key, value, explicitFlags, ctx);
    }

    private boolean removeInternal(Object key, Object value, EnumSet<Flag> explicitFlags, InvocationContext ctx) {
        this.assertKeyValueNotNull(key, value);
        RemoveCommand command = this.commandsFactory.buildRemoveCommand(key, value, explicitFlags);
        return (Boolean)this.executeCommandAndCommitIfNeeded(ctx, command);
    }

    @Override
    public final int size() {
        return this.size(null, null);
    }

    final int size(EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        SizeCommand command = this.commandsFactory.buildSizeCommand(explicitFlags);
        return (Integer)this.invoker.invoke(this.getInvocationContextForRead(explicitClassLoader, -1), command);
    }

    public final boolean isEmpty() {
        return this.isEmpty(null, null);
    }

    final boolean isEmpty(EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        try (CloseableIterable<CacheEntry<Object, Void>> iterable = this.filterEntries(AcceptAllKeyValueFilter.getInstance(), explicitFlags, explicitClassLoader).converter(NullValueConverter.getInstance());){
            boolean bl = !iterable.iterator().hasNext();
            return bl;
        }
    }

    public final boolean containsKey(Object key) {
        return this.containsKey(key, null, null);
    }

    final boolean containsKey(Object key, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        this.assertKeyNotNull(key);
        InvocationContext ctx = this.getInvocationContextForRead(explicitClassLoader, 1);
        GetKeyValueCommand command = this.commandsFactory.buildGetKeyValueCommand(key, explicitFlags);
        Object response = this.invoker.invoke(ctx, command);
        return response != null;
    }

    public final boolean containsValue(Object value) {
        return this.containsValue(value, null, null);
    }

    final boolean containsValue(Object value, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        this.assertValueNotNull(value);
        try (EntryIterable<Object, Object> iterable = this.filterEntries(AcceptAllKeyValueFilter.getInstance(), explicitFlags, explicitClassLoader);){
            Iterator i$ = iterable.iterator();
            while (i$.hasNext()) {
                CacheEntry entry = (CacheEntry)i$.next();
                if (!value.equals(entry.getValue())) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public final V get(Object key) {
        return this.get(key, null, null);
    }

    final V get(Object key, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        this.assertKeyNotNull(key);
        InvocationContext ctx = this.getInvocationContextForRead(explicitClassLoader, 1);
        GetKeyValueCommand command = this.commandsFactory.buildGetKeyValueCommand(key, explicitFlags);
        return (V)this.invoker.invoke(ctx, command);
    }

    public final CacheEntry getCacheEntry(Object key, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        this.assertKeyNotNull(key);
        InvocationContext ctx = this.getInvocationContextForRead(explicitClassLoader, 1);
        GetCacheEntryCommand command = this.commandsFactory.buildGetCacheEntryCommand(key, explicitFlags);
        Object ret = this.invoker.invoke(ctx, command);
        return (CacheEntry)ret;
    }

    @Override
    public final CacheEntry getCacheEntry(K key) {
        return this.getCacheEntry(key, null, null);
    }

    @Override
    public Map<K, V> getAll(Set<?> keys) {
        return this.getAll(keys, null, null);
    }

    public final Map<K, V> getAll(Set<?> keys, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        InvocationContext ctx = this.getInvocationContextForRead(explicitClassLoader, keys.size());
        GetAllCommand command = this.commandsFactory.buildGetAllCommand(keys, explicitFlags, false);
        Map map = (Map)this.invoker.invoke(ctx, command);
        Iterator entryIterator = map.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry entry = entryIterator.next();
            if (entry.getValue() != null) continue;
            entryIterator.remove();
        }
        return map;
    }

    @Override
    public Map<K, CacheEntry<K, V>> getAllCacheEntries(Set<?> keys) {
        return this.getAllCacheEntries(keys, null, null);
    }

    public final Map<K, CacheEntry<K, V>> getAllCacheEntries(Set<?> keys, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        InvocationContext ctx = this.getInvocationContextForRead(explicitClassLoader, keys.size());
        GetAllCommand command = this.commandsFactory.buildGetAllCommand(keys, explicitFlags, true);
        Map map = (Map)this.invoker.invoke(ctx, command);
        Iterator entryIterator = map.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry entry = entryIterator.next();
            if (entry.getValue() != null) continue;
            entryIterator.remove();
        }
        return map;
    }

    @Override
    public EntryIterable<K, V> filterEntries(KeyValueFilter<? super K, ? super V> filter) {
        return this.filterEntries(filter, null, null);
    }

    protected EntryIterable<K, V> filterEntries(KeyValueFilter<? super K, ? super V> filter, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        InvocationContext ctx = this.getInvocationContextForRead(explicitClassLoader, -1);
        EntryRetrievalCommand command = this.commandsFactory.buildEntryRetrievalCommand(explicitFlags, filter);
        return (EntryIterable)this.invoker.invoke(ctx, command);
    }

    @Override
    public Map<K, V> getGroup(String groupName) {
        return this.getGroup(groupName, null, null);
    }

    protected final Map<K, V> getGroup(String groupName, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        InvocationContext ctx = this.getInvocationContextForRead(explicitClassLoader, -1);
        return Collections.unmodifiableMap(this.internalGetGroup(groupName, explicitFlags, explicitClassLoader, ctx));
    }

    private Map<K, V> internalGetGroup(String groupName, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader, InvocationContext ctx) {
        GetKeysInGroupCommand command = this.commandsFactory.buildGetKeysInGroupCommand(explicitFlags, groupName);
        return (Map)this.invoker.invoke(ctx, command);
    }

    @Override
    public void removeGroup(String groupName) {
        this.removeGroup(groupName, null, null);
    }

    protected final void removeGroup(String groupName, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        if (this.transactionManager == null) {
            this.nonTransactionalRemoveGroup(groupName, explicitFlags, explicitClassLoader);
        } else {
            this.transactionalRemoveGroup(groupName, explicitFlags, explicitClassLoader);
        }
    }

    private void transactionalRemoveGroup(String groupName, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        boolean onGoingTransaction;
        boolean bl = onGoingTransaction = this.getOngoingTransaction() != null;
        if (!onGoingTransaction) {
            this.tryBegin();
        }
        try {
            InvocationContext context = this.getInvocationContextWithImplicitTransaction(false, explicitClassLoader, -1);
            Map<K, V> keys = this.internalGetGroup(groupName, explicitFlags, explicitClassLoader, context);
            EnumSet<Flag> removeFlags = explicitFlags == null ? EnumSet.noneOf(Flag.class) : EnumSet.copyOf(explicitFlags);
            removeFlags.add(Flag.IGNORE_RETURN_VALUES);
            for (K key : keys.keySet()) {
                this.removeInternal(key, removeFlags, context);
            }
            if (!onGoingTransaction) {
                this.tryCommit();
            }
        }
        catch (RuntimeException e) {
            if (!onGoingTransaction) {
                this.tryRollback();
            }
            throw e;
        }
    }

    private void nonTransactionalRemoveGroup(String groupName, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        InvocationContext context = this.getInvocationContextForRead(explicitClassLoader, -1);
        Map<K, V> keys = this.internalGetGroup(groupName, explicitFlags, explicitClassLoader, context);
        EnumSet<Flag> removeFlags = explicitFlags == null ? EnumSet.noneOf(Flag.class) : EnumSet.copyOf(explicitFlags);
        removeFlags.add(Flag.IGNORE_RETURN_VALUES);
        for (K key : keys.keySet()) {
            this.remove(key, removeFlags, explicitClassLoader);
        }
    }

    public final V remove(Object key) {
        return this.remove(key, null, null);
    }

    final V remove(Object key, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        InvocationContext ctx = this.getInvocationContextWithImplicitTransaction(false, explicitClassLoader, 1);
        return this.removeInternal(key, explicitFlags, ctx);
    }

    private V removeInternal(Object key, EnumSet<Flag> explicitFlags, InvocationContext ctx) {
        this.assertKeyNotNull(key);
        RemoveCommand command = this.commandsFactory.buildRemoveCommand(key, null, explicitFlags);
        return (V)this.executeCommandAndCommitIfNeeded(ctx, command);
    }

    @ManagedOperation(description="Clears the cache", displayName="Clears the cache", name="clear")
    public final void clearOperation() {
        this.clear(null, null);
    }

    @Override
    public final void clear() {
        this.clear(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void clear(EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        Transaction tx = this.suspendOngoingTransactionIfExists();
        try {
            InvocationContext context = this.invocationContextFactory.createClearNonTxInvocationContext();
            this.setInvocationContextClassLoader(context, explicitClassLoader);
            ClearCommand command = this.commandsFactory.buildClearCommand(explicitFlags);
            this.invoker.invoke(context, command);
        }
        finally {
            this.resumePreviousOngoingTransaction(tx, true, "Had problems trying to resume a transaction after clear()");
        }
    }

    @Override
    public CloseableIteratorSet<K> keySet() {
        return this.keySet(null, null);
    }

    CloseableIteratorSet<K> keySet(EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        InvocationContext ctx = this.getInvocationContextForRead(explicitClassLoader, -1);
        KeySetCommand command = this.commandsFactory.buildKeySetCommand(explicitFlags);
        return (CloseableIteratorSet)this.invoker.invoke(ctx, command);
    }

    @Override
    public CloseableIteratorCollection<V> values() {
        return this.values(null, null);
    }

    CloseableIteratorCollection<V> values(EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        InvocationContext ctx = this.getInvocationContextForRead(explicitClassLoader, -1);
        ValuesCommand command = this.commandsFactory.buildValuesCommand(explicitFlags);
        return (CloseableIteratorCollection)this.invoker.invoke(ctx, command);
    }

    @Override
    public CloseableIteratorSet<Map.Entry<K, V>> entrySet() {
        return this.entrySet(null, null);
    }

    CloseableIteratorSet<Map.Entry<K, V>> entrySet(EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        InvocationContext ctx = this.getInvocationContextForRead(explicitClassLoader, -1);
        EntrySetCommand command = this.commandsFactory.buildEntrySetCommand(explicitFlags);
        return (CloseableIteratorSet)this.invoker.invoke(ctx, command);
    }

    @Override
    public final void putForExternalRead(K key, V value) {
        this.putForExternalRead(key, value, null, null);
    }

    @Override
    public void putForExternalRead(K key, V value, long lifespan, TimeUnit lifespanUnit) {
        this.putForExternalRead(key, value, lifespan, lifespanUnit, this.defaultMetadata.maxIdle(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void putForExternalRead(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit idleTimeUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, idleTimeUnit).build();
        this.putForExternalRead(key, value, metadata);
    }

    @Override
    public void putForExternalRead(K key, V value, Metadata metadata) {
        Metadata merged = this.applyDefaultMetadata(metadata);
        this.putForExternalRead(key, value, merged, null, null);
    }

    final void putForExternalRead(K key, V value, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        this.putForExternalRead(key, value, this.defaultMetadata, explicitFlags, explicitClassLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void putForExternalRead(K key, V value, Metadata metadata, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        Transaction ongoingTransaction = null;
        try {
            ongoingTransaction = this.suspendOngoingTransactionIfExists();
            EnumSet<Flag> flags = EnumSet.of(Flag.FAIL_SILENTLY, Flag.FORCE_ASYNCHRONOUS, Flag.ZERO_LOCK_ACQUISITION_TIMEOUT, Flag.PUT_FOR_EXTERNAL_READ);
            if (explicitFlags != null && !explicitFlags.isEmpty()) {
                flags.addAll(explicitFlags);
            }
            this.putIfAbsent(key, value, metadata, flags, explicitClassLoader);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Caught exception while doing putForExternalRead()", e);
            }
        }
        finally {
            this.resumePreviousOngoingTransaction(ongoingTransaction, true, "Had problems trying to resume a transaction after putForExternalRead()");
        }
    }

    @Override
    public final void evict(K key) {
        this.evict(key, null, null);
    }

    final void evict(K key, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        this.assertKeyNotNull(key);
        InvocationContext ctx = this.createSingleKeyNonTxInvocationContext(explicitClassLoader);
        EvictCommand command = this.commandsFactory.buildEvictCommand(key, explicitFlags);
        this.invoker.invoke(ctx, command);
    }

    private InvocationContext createSingleKeyNonTxInvocationContext(ClassLoader explicitClassLoader) {
        InvocationContext ctx = this.invocationContextFactory.createSingleKeyNonTxInvocationContext();
        return this.setInvocationContextClassLoader(ctx, explicitClassLoader);
    }

    @Override
    public Configuration getCacheConfiguration() {
        return this.config;
    }

    @Override
    public void addListener(Object listener) {
        this.notifier.addListener(listener);
    }

    @Override
    public void addListener(Object listener, KeyFilter<? super K> filter) {
        this.notifier.addListener(listener, filter);
    }

    @Override
    public <C> void addListener(Object listener, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter) {
        this.notifier.addListener(listener, filter, converter);
    }

    @Override
    public void removeListener(Object listener) {
        this.notifier.removeListener(listener);
    }

    @Override
    public Set<Object> getListeners() {
        return this.notifier.getListeners();
    }

    private InvocationContext getInvocationContextForWrite(ClassLoader explicitClassLoader, int keyCount, boolean isPutForExternalRead) {
        InvocationContext ctx = isPutForExternalRead ? this.invocationContextFactory.createSingleKeyNonTxInvocationContext() : this.invocationContextFactory.createInvocationContext(true, keyCount);
        return this.setInvocationContextClassLoader(ctx, explicitClassLoader);
    }

    private InvocationContext getInvocationContextForRead(ClassLoader explicitClassLoader, int keyCount) {
        Transaction transaction;
        if (this.config.transaction().transactionMode().isTransactional() && (transaction = this.getOngoingTransaction()) != null) {
            return this.getInvocationContext(transaction, explicitClassLoader, false);
        }
        InvocationContext result = this.invocationContextFactory.createInvocationContext(false, keyCount);
        this.setInvocationContextClassLoader(result, explicitClassLoader);
        return result;
    }

    private InvocationContext getInvocationContextWithImplicitTransactionForAsyncOps(boolean isPutForExternalRead, ClassLoader explicitClassLoader, int keyCount) {
        InvocationContext ctx = this.getInvocationContextWithImplicitTransaction(isPutForExternalRead, explicitClassLoader, keyCount);
        try {
            if (this.isTxInjected(ctx)) {
                this.transactionManager.suspend();
            }
        }
        catch (SystemException e) {
            throw new CacheException((Throwable)e);
        }
        return ctx;
    }

    private InvocationContext getInvocationContextWithImplicitTransaction(boolean isPutForExternalRead, ClassLoader explicitClassLoader, int keyCount) {
        InvocationContext invocationContext;
        boolean txInjected = false;
        if (this.config.transaction().transactionMode().isTransactional() && !isPutForExternalRead) {
            Transaction transaction = this.getOngoingTransaction();
            if (transaction == null && this.config.transaction().autoCommit()) {
                transaction = this.tryBegin();
                txInjected = true;
            }
            invocationContext = this.getInvocationContext(transaction, explicitClassLoader, txInjected);
        } else {
            invocationContext = this.getInvocationContextForWrite(explicitClassLoader, keyCount, isPutForExternalRead);
        }
        return invocationContext;
    }

    private boolean isPutForExternalRead(EnumSet<Flag> explicitFlags) {
        return explicitFlags != null && explicitFlags.contains((Object)Flag.PUT_FOR_EXTERNAL_READ);
    }

    private InvocationContext getInvocationContext(Transaction tx, ClassLoader explicitClassLoader, boolean implicitTransaction) {
        InvocationContext ctx = this.invocationContextFactory.createInvocationContext(tx, implicitTransaction);
        return this.setInvocationContextClassLoader(ctx, explicitClassLoader);
    }

    private InvocationContext setInvocationContextClassLoader(InvocationContext ctx, ClassLoader explicitClassLoader) {
        if (this.isClassLoaderInContext) {
            ctx.setClassLoader(explicitClassLoader != null ? explicitClassLoader : this.getClassLoader());
        }
        return ctx;
    }

    @Override
    public boolean lock(K ... keys) {
        this.assertKeyNotNull(keys);
        return this.lock(Arrays.asList(keys), null, null);
    }

    @Override
    public boolean lock(Collection<? extends K> keys) {
        return this.lock(keys, null, null);
    }

    boolean lock(Collection<? extends K> keys, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        if (!this.config.transaction().transactionMode().isTransactional()) {
            throw new UnsupportedOperationException("Calling lock() on non-transactional caches is not allowed");
        }
        if (keys == null || keys.isEmpty()) {
            throw new IllegalArgumentException("Cannot lock empty list of keys");
        }
        InvocationContext ctx = this.getInvocationContextForWrite(explicitClassLoader, -1, false);
        LockControlCommand command = this.commandsFactory.buildLockControlCommand(keys, explicitFlags);
        return (Boolean)this.invoker.invoke(ctx, command);
    }

    @Override
    public void applyDelta(K deltaAwareValueKey, Delta delta, Object ... locksToAcquire) {
        if (locksToAcquire == null || locksToAcquire.length == 0) {
            throw new IllegalArgumentException("Cannot lock empty list of keys");
        }
        InvocationContext ctx = this.getInvocationContextForWrite(null, -1, false);
        ApplyDeltaCommand command = this.commandsFactory.buildApplyDeltaCommand(deltaAwareValueKey, delta, Arrays.asList(locksToAcquire));
        this.invoker.invoke(ctx, command);
    }

    @ManagedOperation(description="Starts the cache.", displayName="Starts cache.")
    public void start() {
        this.componentRegistry.start();
        boolean bl = this.isClassLoaderInContext = this.config.clustering().cacheMode().isClustered() || this.config.persistence().usingStores() || this.config.storeAsBinary().enabled();
        if (log.isDebugEnabled()) {
            log.debugf("Started cache %s on %s", this.getName(), this.getCacheManager().getAddress());
        }
    }

    @ManagedOperation(description="Stops the cache.", displayName="Stops cache.")
    public void stop() {
        this.stop(null);
    }

    void stop(ClassLoader explicitClassLoader) {
        if (log.isDebugEnabled()) {
            log.debugf("Stopping cache %s on %s", this.getName(), this.getCacheManager().getAddress());
        }
        this.componentRegistry.stop();
    }

    @Override
    public List<CommandInterceptor> getInterceptorChain() {
        return this.invoker.asList();
    }

    @Override
    public void addInterceptor(CommandInterceptor i, int position) {
        this.invoker.addInterceptor(i, position);
    }

    @Override
    public boolean addInterceptorAfter(CommandInterceptor i, Class<? extends CommandInterceptor> afterInterceptor) {
        return this.invoker.addInterceptorAfter(i, afterInterceptor);
    }

    @Override
    public boolean addInterceptorBefore(CommandInterceptor i, Class<? extends CommandInterceptor> beforeInterceptor) {
        return this.invoker.addInterceptorBefore(i, beforeInterceptor);
    }

    @Override
    public void removeInterceptor(int position) {
        this.invoker.removeInterceptor(position);
    }

    @Override
    public void removeInterceptor(Class<? extends CommandInterceptor> interceptorType) {
        this.invoker.removeInterceptor(interceptorType);
    }

    @Override
    public EvictionManager getEvictionManager() {
        return this.evictionManager;
    }

    @Override
    public ExpirationManager getExpirationManager() {
        return this.expirationManager;
    }

    @Override
    public ComponentRegistry getComponentRegistry() {
        return this.componentRegistry;
    }

    @Override
    public DistributionManager getDistributionManager() {
        return this.distributionManager;
    }

    @Override
    public AuthorizationManager getAuthorizationManager() {
        return this.authorizationManager;
    }

    @Override
    public ComponentStatus getStatus() {
        return this.componentRegistry.getStatus();
    }

    @ManagedAttribute(description="Returns the cache status", displayName="Cache status", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public String getCacheStatus() {
        return this.getStatus().toString();
    }

    @Override
    public AvailabilityMode getAvailability() {
        if (this.partitionHandlingManager != null) {
            return this.partitionHandlingManager.getAvailabilityMode();
        }
        return AvailabilityMode.AVAILABLE;
    }

    @Override
    public void setAvailability(AvailabilityMode availability) {
        if (this.localTopologyManager != null) {
            try {
                this.localTopologyManager.setCacheAvailability(this.getName(), availability);
            }
            catch (Exception e) {
                throw new CacheException((Throwable)e);
            }
        }
    }

    @ManagedAttribute(description="Returns the cache availability", displayName="Cache availability", dataType=DataType.TRAIT, writable=true)
    public String getCacheAvailability() {
        return this.getAvailability().toString();
    }

    public void setCacheAvailability(String availabilityString) throws Exception {
        this.setAvailability(AvailabilityMode.valueOf(availabilityString));
    }

    public boolean startBatch() {
        if (!this.config.invocationBatching().enabled()) {
            throw new CacheConfigurationException("Invocation batching not enabled in current configuration! Please enable it.");
        }
        return this.batchContainer.startBatch();
    }

    public void endBatch(boolean successful) {
        if (!this.config.invocationBatching().enabled()) {
            throw new CacheConfigurationException("Invocation batching not enabled in current configuration! Please enable it.");
        }
        this.batchContainer.endBatch(successful);
    }

    public String getName() {
        return this.name;
    }

    @ManagedAttribute(description="Returns the cache name", displayName="Cache name", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public String getCacheName() {
        String name = this.getName().equals("___defaultcache") ? "Default Cache" : this.getName();
        return name + "(" + this.getCacheConfiguration().clustering().cacheMode().toString().toLowerCase() + ")";
    }

    @ManagedAttribute(description="Returns the version of Infinispan", displayName="Infinispan version", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public String getVersion() {
        return Version.getVersion();
    }

    public String toString() {
        return "Cache '" + this.name + "'@" + (this.config != null && this.config.clustering().cacheMode().isClustered() ? this.getCacheManager().getAddress() : Util.hexIdHashCode((Object)this));
    }

    @Override
    public BatchContainer getBatchContainer() {
        return this.batchContainer;
    }

    @Override
    public InvocationContextContainer getInvocationContextContainer() {
        return this.icc;
    }

    @Override
    public DataContainer getDataContainer() {
        return this.dataContainer;
    }

    @Override
    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    @Override
    public LockManager getLockManager() {
        return this.lockManager;
    }

    @Override
    public EmbeddedCacheManager getCacheManager() {
        return this.cacheManager;
    }

    @Override
    public Stats getStats() {
        return new StatsImpl(this.invoker);
    }

    @Override
    public XAResource getXAResource() {
        return new TransactionXaAdapter(this.txTable, this.recoveryManager, this.txCoordinator, this.commandsFactory, this.rpcManager, null, this.config, this.name);
    }

    public final V put(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit idleTimeUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, idleTimeUnit).build();
        return this.put(key, value, metadata, null, null);
    }

    final V put(K key, V value, Metadata metadata, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        InvocationContext ctx = this.getInvocationContextWithImplicitTransaction(false, explicitClassLoader, 1);
        return this.putInternal(key, value, metadata, explicitFlags, ctx);
    }

    private V putInternal(K key, V value, Metadata metadata, EnumSet<Flag> explicitFlags, InvocationContext ctx) {
        this.assertKeyValueNotNull(key, value);
        Metadata merged = this.applyDefaultMetadata(metadata);
        PutKeyValueCommand command = this.commandsFactory.buildPutKeyValueCommand(key, value, merged, explicitFlags);
        return (V)this.executeCommandAndCommitIfNeeded(ctx, command);
    }

    public final V putIfAbsent(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit idleTimeUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, idleTimeUnit).build();
        return this.putIfAbsent(key, value, metadata, null, null);
    }

    final V putIfAbsent(K key, V value, Metadata metadata, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        InvocationContext ctx = this.getInvocationContextWithImplicitTransaction(this.isPutForExternalRead(explicitFlags), explicitClassLoader, 1);
        return this.putIfAbsentInternal(key, value, metadata, explicitFlags, ctx);
    }

    private V putIfAbsentInternal(K key, V value, Metadata metadata, EnumSet<Flag> explicitFlags, InvocationContext ctx) {
        this.assertKeyValueNotNull(key, value);
        PutKeyValueCommand command = this.commandsFactory.buildPutKeyValueCommand(key, value, metadata, explicitFlags);
        command.setPutIfAbsent(true);
        command.setValueMatcher(ValueMatcher.MATCH_EXPECTED);
        return (V)this.executeCommandAndCommitIfNeeded(ctx, command);
    }

    public final void putAll(Map<? extends K, ? extends V> map, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit idleTimeUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, idleTimeUnit).build();
        this.putAll(map, metadata, null, null);
    }

    final void putAll(Map<? extends K, ? extends V> map, Metadata metadata, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        InvocationContext ctx = this.getInvocationContextWithImplicitTransaction(false, explicitClassLoader, map.size());
        this.putAllInternal(map, metadata, explicitFlags, ctx);
    }

    private void putAllInternal(Map<? extends K, ? extends V> map, Metadata metadata, EnumSet<Flag> explicitFlags, InvocationContext ctx) {
        this.assertKeysNotNull(map);
        PutMapCommand command = this.commandsFactory.buildPutMapCommand(map, metadata, explicitFlags);
        this.executeCommandAndCommitIfNeeded(ctx, command);
    }

    public final V replace(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit idleTimeUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, idleTimeUnit).build();
        return this.replace(key, value, metadata, null, null);
    }

    final V replace(K key, V value, Metadata metadata, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        InvocationContext ctx = this.getInvocationContextWithImplicitTransaction(false, explicitClassLoader, 1);
        return this.replaceInternal(key, value, metadata, explicitFlags, ctx);
    }

    private V replaceInternal(K key, V value, Metadata metadata, EnumSet<Flag> explicitFlags, InvocationContext ctx) {
        this.assertKeyValueNotNull(key, value);
        ReplaceCommand command = this.commandsFactory.buildReplaceCommand(key, null, value, metadata, explicitFlags);
        return (V)this.executeCommandAndCommitIfNeeded(ctx, command);
    }

    public final boolean replace(K key, V oldValue, V value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit idleTimeUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdleTime, idleTimeUnit).build();
        return this.replace(key, oldValue, value, metadata, null, null);
    }

    final boolean replace(K key, V oldValue, V value, Metadata metadata, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        InvocationContext ctx = this.getInvocationContextWithImplicitTransaction(false, explicitClassLoader, 1);
        return this.replaceInternal(key, oldValue, value, metadata, explicitFlags, ctx);
    }

    private boolean replaceInternal(K key, V oldValue, V value, Metadata metadata, EnumSet<Flag> explicitFlags, InvocationContext ctx) {
        this.assertKeyValueNotNull(key, value);
        this.assertValueNotNull(oldValue);
        ReplaceCommand command = this.commandsFactory.buildReplaceCommand(key, oldValue, value, metadata, explicitFlags);
        return (Boolean)this.executeCommandAndCommitIfNeeded(ctx, command);
    }

    private <X> NotifyingFuture<X> wrapInFuture(final Object retval) {
        if (retval instanceof NotifyingFuture) {
            return (NotifyingFuture)retval;
        }
        return new AbstractInProcessNotifyingFuture<X>(){

            public X get() throws InterruptedException, ExecutionException {
                return retval;
            }
        };
    }

    public final NotifyingFuture<V> putAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        return this.putAsync(key, value, metadata, null, null);
    }

    final NotifyingFuture<V> putAsync(final K key, final V value, final Metadata metadata, final EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        final NotifyingFutureImpl result = new NotifyingFutureImpl();
        final InvocationContext ctx = this.getInvocationContextWithImplicitTransactionForAsyncOps(false, explicitClassLoader, 1);
        Future returnValue = this.asyncExecutor.submit(new Callable<V>(){

            @Override
            public V call() throws Exception {
                try {
                    CacheImpl.this.associateImplicitTransactionWithCurrentThread(ctx);
                    Object retval = CacheImpl.this.putInternal(key, value, metadata, explicitFlags, ctx);
                    try {
                        result.notifyDone(retval);
                        log.trace("Finished notifying");
                    }
                    catch (Throwable e) {
                        log.trace("Exception while notifying the future", e);
                    }
                    return retval;
                }
                catch (Exception e) {
                    try {
                        result.notifyException((Throwable)e);
                        log.trace("Finished notifying");
                    }
                    catch (Throwable e2) {
                        log.trace("Exception while notifying the future", e2);
                    }
                    throw e;
                }
            }
        });
        result.setFuture(returnValue);
        return result;
    }

    public final NotifyingFuture<Void> putAllAsync(Map<? extends K, ? extends V> data, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        return this.putAllAsync(data, metadata, null, null);
    }

    final NotifyingFuture<Void> putAllAsync(final Map<? extends K, ? extends V> data, final Metadata metadata, final EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        final NotifyingFutureImpl result = new NotifyingFutureImpl();
        final InvocationContext ctx = this.getInvocationContextWithImplicitTransactionForAsyncOps(false, explicitClassLoader, data.size());
        Future<Void> returnValue = this.asyncExecutor.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    CacheImpl.this.associateImplicitTransactionWithCurrentThread(ctx);
                    CacheImpl.this.putAllInternal(data, metadata, explicitFlags, ctx);
                    try {
                        result.notifyDone(null);
                    }
                    catch (Throwable t) {
                        log.trace("Error when notifying", t);
                    }
                    return null;
                }
                catch (Exception e) {
                    try {
                        result.notifyException((Throwable)e);
                    }
                    catch (Throwable t) {
                        log.trace("Error when notifying", t);
                    }
                    throw e;
                }
            }
        });
        result.setFuture(returnValue);
        return result;
    }

    public final NotifyingFuture<Void> clearAsync() {
        return this.clearAsync(null, null);
    }

    final NotifyingFuture<Void> clearAsync(final EnumSet<Flag> explicitFlags, final ClassLoader explicitClassLoader) {
        final NotifyingFutureImpl result = new NotifyingFutureImpl();
        Future<Void> returnValue = this.asyncExecutor.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    CacheImpl.this.clear(explicitFlags, explicitClassLoader);
                    try {
                        result.notifyDone(null);
                    }
                    catch (Throwable t) {
                        log.trace("Error when notifying", t);
                    }
                    return null;
                }
                catch (Exception e) {
                    try {
                        result.notifyException((Throwable)e);
                    }
                    catch (Throwable t) {
                        log.trace("Error when notifying", t);
                    }
                    throw e;
                }
            }
        });
        result.setFuture(returnValue);
        return result;
    }

    public final NotifyingFuture<V> putIfAbsentAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        return this.putIfAbsentAsync(key, value, metadata, null, null);
    }

    final NotifyingFuture<V> putIfAbsentAsync(final K key, final V value, final Metadata metadata, final EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        final NotifyingFutureImpl result = new NotifyingFutureImpl();
        final InvocationContext ctx = this.getInvocationContextWithImplicitTransactionForAsyncOps(false, explicitClassLoader, 1);
        Future returnValue = this.asyncExecutor.submit(new Callable<V>(){

            @Override
            public V call() throws Exception {
                try {
                    CacheImpl.this.associateImplicitTransactionWithCurrentThread(ctx);
                    Object retval = CacheImpl.this.putIfAbsentInternal(key, value, metadata, explicitFlags, ctx);
                    try {
                        result.notifyDone(retval);
                    }
                    catch (Throwable t) {
                        log.trace("Error when notifying", t);
                    }
                    return retval;
                }
                catch (Exception e) {
                    try {
                        result.notifyException((Throwable)e);
                    }
                    catch (Throwable t) {
                        log.trace("Error when notifying", t);
                    }
                    throw e;
                }
            }
        });
        result.setFuture(returnValue);
        return result;
    }

    public final NotifyingFuture<V> removeAsync(Object key) {
        return this.removeAsync(key, null, null);
    }

    final NotifyingFuture<V> removeAsync(final Object key, final EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        final NotifyingFutureImpl result = new NotifyingFutureImpl();
        final InvocationContext ctx = this.getInvocationContextWithImplicitTransactionForAsyncOps(false, explicitClassLoader, 1);
        Future returnValue = this.asyncExecutor.submit(new Callable<V>(){

            @Override
            public V call() throws Exception {
                try {
                    CacheImpl.this.associateImplicitTransactionWithCurrentThread(ctx);
                    Object retval = CacheImpl.this.removeInternal(key, explicitFlags, ctx);
                    try {
                        result.notifyDone(retval);
                    }
                    catch (Throwable t) {
                        log.trace("Error when notifying", t);
                    }
                    return retval;
                }
                catch (Exception e) {
                    try {
                        result.notifyException((Throwable)e);
                    }
                    catch (Throwable t) {
                        log.trace("Error when notifying", t);
                    }
                    throw e;
                }
            }
        });
        result.setFuture(returnValue);
        return result;
    }

    public final NotifyingFuture<Boolean> removeAsync(Object key, Object value) {
        return this.removeAsync(key, value, null, null);
    }

    final NotifyingFuture<Boolean> removeAsync(final Object key, final Object value, final EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        final NotifyingFutureImpl result = new NotifyingFutureImpl();
        final InvocationContext ctx = this.getInvocationContextWithImplicitTransactionForAsyncOps(false, explicitClassLoader, 1);
        Future<Boolean> returnValue = this.asyncExecutor.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try {
                    CacheImpl.this.associateImplicitTransactionWithCurrentThread(ctx);
                    Boolean retval = CacheImpl.this.removeInternal(key, value, explicitFlags, ctx);
                    try {
                        result.notifyDone((Object)retval);
                    }
                    catch (Throwable t) {
                        log.trace("Error when notifying", t);
                    }
                    return retval;
                }
                catch (Exception e) {
                    try {
                        result.notifyException((Throwable)e);
                    }
                    catch (Throwable t) {
                        log.trace("Error when notifying", t);
                    }
                    throw e;
                }
            }
        });
        result.setFuture(returnValue);
        return result;
    }

    public final NotifyingFuture<V> replaceAsync(K key, V value, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        return this.replaceAsync(key, value, metadata, null, null);
    }

    final NotifyingFuture<V> replaceAsync(final K key, final V value, final Metadata metadata, final EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        final NotifyingFutureImpl result = new NotifyingFutureImpl();
        final InvocationContext ctx = this.getInvocationContextWithImplicitTransactionForAsyncOps(false, explicitClassLoader, 1);
        Future returnValue = this.asyncExecutor.submit(new Callable<V>(){

            @Override
            public V call() throws Exception {
                try {
                    CacheImpl.this.associateImplicitTransactionWithCurrentThread(ctx);
                    Object retval = CacheImpl.this.replaceInternal(key, value, metadata, explicitFlags, ctx);
                    try {
                        result.notifyDone(retval);
                    }
                    catch (Throwable t) {
                        log.trace("Error when notifying", t);
                    }
                    return retval;
                }
                catch (Exception e) {
                    try {
                        result.notifyException((Throwable)e);
                    }
                    catch (Throwable t) {
                        log.trace("Error when notifying", t);
                    }
                    throw e;
                }
            }
        });
        result.setFuture(returnValue);
        return result;
    }

    public final NotifyingFuture<Boolean> replaceAsync(K key, V oldValue, V newValue, long lifespan, TimeUnit lifespanUnit, long maxIdle, TimeUnit maxIdleUnit) {
        Metadata metadata = new EmbeddedMetadata.Builder().lifespan(lifespan, lifespanUnit).maxIdle(maxIdle, maxIdleUnit).build();
        return this.replaceAsync(key, oldValue, newValue, metadata, null, null);
    }

    final NotifyingFuture<Boolean> replaceAsync(final K key, final V oldValue, final V newValue, final Metadata metadata, final EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        final NotifyingFutureImpl result = new NotifyingFutureImpl();
        final InvocationContext ctx = this.getInvocationContextWithImplicitTransactionForAsyncOps(false, explicitClassLoader, 1);
        Future<Boolean> returnValue = this.asyncExecutor.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                try {
                    CacheImpl.this.associateImplicitTransactionWithCurrentThread(ctx);
                    Boolean retval = CacheImpl.this.replaceInternal(key, oldValue, newValue, metadata, explicitFlags, ctx);
                    try {
                        result.notifyDone((Object)retval);
                    }
                    catch (Throwable t) {
                        log.trace("Error when notifying", t);
                    }
                    return retval;
                }
                catch (Exception e) {
                    try {
                        result.notifyException((Throwable)e);
                    }
                    catch (Throwable t) {
                        log.trace("Error when notifying", t);
                    }
                    throw e;
                }
            }
        });
        result.setFuture(returnValue);
        return result;
    }

    public NotifyingFuture<V> getAsync(K key) {
        return this.getAsync(key, null, null);
    }

    NotifyingFuture<V> getAsync(final K key, EnumSet<Flag> explicitFlags, ClassLoader explicitClassLoader) {
        Object appliedFlags;
        if (this.asyncSkipsThread(explicitFlags, key)) {
            return this.wrapInFuture(this.get(key, explicitFlags, explicitClassLoader));
        }
        if (explicitFlags == null) {
            appliedFlags = null;
        } else {
            appliedFlags = explicitFlags.clone();
            explicitFlags.clear();
        }
        NotifyingFutureImpl result = new NotifyingFutureImpl();
        Callable c = new Callable<V>((EnumSet)appliedFlags, explicitClassLoader, result){
            final /* synthetic */ EnumSet val$appliedFlags;
            final /* synthetic */ ClassLoader val$explicitClassLoader;
            final /* synthetic */ NotifyingFutureImpl val$result;
            {
                this.val$appliedFlags = enumSet;
                this.val$explicitClassLoader = classLoader;
                this.val$result = notifyingFutureImpl;
            }

            @Override
            public V call() throws Exception {
                try {
                    Object retval = CacheImpl.this.get(key, this.val$appliedFlags, this.val$explicitClassLoader);
                    try {
                        this.val$result.notifyDone(retval);
                    }
                    catch (Throwable t) {
                        log.trace("Error when notifying", t);
                    }
                    return retval;
                }
                catch (Exception e) {
                    try {
                        this.val$result.notifyException((Throwable)e);
                    }
                    catch (Throwable t) {
                        log.trace("Error when notifying", t);
                    }
                    throw e;
                }
            }
        };
        result.setFuture(this.asyncExecutor.submit(c));
        return result;
    }

    private boolean asyncSkipsThread(EnumSet<Flag> flags, K key) {
        boolean isSkipLoader = this.isSkipLoader(flags);
        if (!isSkipLoader) {
            return false;
        }
        if (!this.config.clustering().cacheMode().isDistributed()) {
            return true;
        }
        if (flags != null && (flags.contains((Object)Flag.SKIP_REMOTE_LOOKUP) || flags.contains((Object)Flag.CACHE_MODE_LOCAL))) {
            return true;
        }
        return this.distributionManager.getLocality(key).isLocal();
    }

    private boolean isSkipLoader(EnumSet<Flag> flags) {
        boolean hasCacheLoaderConfig = !this.config.persistence().stores().isEmpty();
        return !hasCacheLoaderConfig || flags != null && (flags.contains((Object)Flag.SKIP_CACHE_LOAD) || flags.contains((Object)Flag.SKIP_CACHE_STORE));
    }

    @Override
    public AdvancedCache<K, V> getAdvancedCache() {
        return this;
    }

    @Override
    public RpcManager getRpcManager() {
        return this.rpcManager;
    }

    @Override
    public AdvancedCache<K, V> withFlags(Flag ... flags) {
        if (flags == null || flags.length == 0) {
            return this;
        }
        return new DecoratedCache(this, flags);
    }

    private Transaction getOngoingTransaction() {
        try {
            Transaction transaction = null;
            if (this.transactionManager != null && (transaction = this.transactionManager.getTransaction()) == null && this.config.invocationBatching().enabled()) {
                transaction = this.batchContainer.getBatchTransaction();
            }
            return transaction;
        }
        catch (SystemException e) {
            throw new CacheException("Unable to get transaction", (Throwable)e);
        }
    }

    private Object executeCommandAndCommitIfNeeded(InvocationContext ctx, VisitableCommand command) {
        Object result;
        boolean txInjected = this.isTxInjected(ctx);
        try {
            result = this.invoker.invoke(ctx, command);
        }
        catch (RuntimeException e) {
            if (txInjected) {
                this.tryRollback();
            }
            throw e;
        }
        if (txInjected) {
            this.tryCommit();
        }
        return result;
    }

    private boolean isTxInjected(InvocationContext ctx) {
        return ctx.isInTxScope() && ((TxInvocationContext)ctx).isImplicitTransaction();
    }

    private Transaction tryBegin() {
        if (this.transactionManager == null) {
            return null;
        }
        try {
            this.transactionManager.begin();
            Transaction transaction = this.getOngoingTransaction();
            if (log.isTraceEnabled()) {
                log.tracef("Implicit transaction started! Transaction: %s", transaction);
            }
            return transaction;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CacheException("Unable to begin implicit transaction.", (Throwable)e);
        }
    }

    private void tryRollback() {
        block3: {
            try {
                if (this.transactionManager != null) {
                    this.transactionManager.rollback();
                }
            }
            catch (Throwable t) {
                if (!trace) break block3;
                log.trace("Could not rollback", t);
            }
        }
    }

    private void tryCommit() {
        if (this.transactionManager == null) {
            return;
        }
        if (trace) {
            log.tracef("Committing transaction as it was implicit: %s", this.getOngoingTransaction());
        }
        try {
            this.transactionManager.commit();
        }
        catch (Throwable e) {
            log.couldNotCompleteInjectedTransaction(e);
            throw new CacheException("Could not commit implicit transaction", e);
        }
    }

    @Override
    public ClassLoader getClassLoader() {
        ClassLoader classLoader = this.globalCfg.classLoader();
        return classLoader != null ? classLoader : Thread.currentThread().getContextClassLoader();
    }

    @Override
    public AdvancedCache<K, V> with(ClassLoader classLoader) {
        return new DecoratedCache(this, classLoader);
    }

    @Override
    public V put(K key, V value, Metadata metadata) {
        return this.put(key, value, metadata, null, null);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map, Metadata metadata) {
        Metadata merged = this.applyDefaultMetadata(metadata);
        this.putAll(map, merged, null, null);
    }

    private Metadata applyDefaultMetadata(Metadata metadata) {
        if (metadata == null) {
            return this.defaultMetadata;
        }
        Metadata.Builder builder = metadata.builder();
        return builder != null ? builder.merge(this.defaultMetadata).build() : metadata;
    }

    @Override
    public V replace(K key, V value, Metadata metadata) {
        Metadata merged = this.applyDefaultMetadata(metadata);
        return this.replace(key, value, merged, null, null);
    }

    @Override
    public boolean replace(K key, V oldValue, V value, Metadata metadata) {
        Metadata merged = this.applyDefaultMetadata(metadata);
        return this.replace(key, oldValue, value, merged, null, null);
    }

    @Override
    public V putIfAbsent(K key, V value, Metadata metadata) {
        Metadata merged = this.applyDefaultMetadata(metadata);
        return this.putIfAbsent(key, value, merged, null, null);
    }

    @Override
    public NotifyingFuture<V> putAsync(K key, V value, Metadata metadata) {
        return this.putAsync(key, value, metadata, null, null);
    }

    private void associateImplicitTransactionWithCurrentThread(InvocationContext ctx) throws InvalidTransactionException, SystemException {
        if (this.isTxInjected(ctx)) {
            Transaction transaction = ((TxInvocationContext)ctx).getTransaction();
            if (transaction == null) {
                throw new IllegalStateException("Null transaction not possible!");
            }
            this.transactionManager.resume(transaction);
        }
    }

    private Transaction suspendOngoingTransactionIfExists() {
        Transaction tx = this.getOngoingTransaction();
        if (tx != null) {
            try {
                this.transactionManager.suspend();
            }
            catch (SystemException e) {
                throw new CacheException("Unable to suspend transaction.", (Throwable)e);
            }
        }
        return tx;
    }

    private void resumePreviousOngoingTransaction(Transaction transaction, boolean failSilently, String failMessage) {
        if (transaction != null) {
            try {
                this.transactionManager.resume(transaction);
            }
            catch (Exception e) {
                if (failSilently) {
                    if (log.isDebugEnabled()) {
                        log.debug(failMessage);
                    }
                }
                throw new CacheException(failMessage, (Throwable)e);
            }
        }
    }

    @ManagedAttribute(description="Returns the cache configuration in form of properties", displayName="Cache configuration properties", dataType=DataType.TRAIT, displayType=DisplayType.SUMMARY)
    public Properties getConfigurationAsProperties() {
        return new PropertyFormatter().format(this.config);
    }
}

