/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.report;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.TreeSet;
import org.cpsolver.coursett.Constants;
import org.cpsolver.coursett.model.RoomLocation;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.util.CSVFile;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.studentsct.StudentSectioningModel;
import org.cpsolver.studentsct.extension.StudentQuality;
import org.cpsolver.studentsct.model.AreaClassificationMajor;
import org.cpsolver.studentsct.model.CourseRequest;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Instructor;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.SctAssignment;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Student;
import org.cpsolver.studentsct.model.StudentGroup;
import org.cpsolver.studentsct.report.StudentSectioningReport;

public class AccommodationConflictsTable
implements StudentSectioningReport {
    private StudentSectioningModel iModel = null;
    private StudentQuality iSQ = null;
    private StudentQuality.Type[] iTypes = new StudentQuality.Type[]{StudentQuality.Type.ShortDistance, StudentQuality.Type.AccBackToBack, StudentQuality.Type.AccBreaksBetweenClasses, StudentQuality.Type.AccFreeTimeOverlap};

    public AccommodationConflictsTable(StudentSectioningModel model) {
        this.iModel = model;
        this.iSQ = this.iModel.getStudentQuality();
    }

    public StudentSectioningModel getModel() {
        return this.iModel;
    }

    protected String rooms(SctAssignment section) {
        if (section.getNrRooms() == 0) {
            return "";
        }
        String ret = "";
        for (RoomLocation r : section.getRooms()) {
            ret = ret + (ret.isEmpty() ? "" : ", ") + r.getName();
        }
        return ret;
    }

    protected String curriculum(Student student) {
        String curriculum = "";
        for (AreaClassificationMajor acm : student.getAreaClassificationMajors()) {
            curriculum = curriculum + (curriculum.isEmpty() ? "" : ", ") + acm.toString();
        }
        return curriculum;
    }

    protected String group(Student student) {
        String group = "";
        TreeSet<String> groups = new TreeSet<String>();
        for (StudentGroup studentGroup : student.getGroups()) {
            groups.add(studentGroup.getReference());
        }
        for (String string : groups) {
            group = group + (group.isEmpty() ? "" : ", ") + string;
        }
        return group;
    }

    protected String advisor(Student student) {
        String advisors = "";
        for (Instructor instructor : student.getAdvisors()) {
            advisors = advisors + (advisors.isEmpty() ? "" : ", ") + instructor.getName();
        }
        return advisors;
    }

    public CSVFile createTable(Assignment<Request, Enrollment> assignment, boolean includeLastLikeStudents, boolean includeRealStudents, boolean useAmPm) {
        if (this.iSQ == null) {
            throw new IllegalArgumentException("Student Schedule Quality is not enabled.");
        }
        CSVFile csv = new CSVFile();
        csv.setHeader(new CSVFile.CSVField[]{new CSVFile.CSVField("__Student"), new CSVFile.CSVField("External Id"), new CSVFile.CSVField("Student Name"), new CSVFile.CSVField("Curriculum"), new CSVFile.CSVField("Group"), new CSVFile.CSVField("Advisor"), new CSVFile.CSVField("Type"), new CSVFile.CSVField("Course"), new CSVFile.CSVField("Class"), new CSVFile.CSVField("Meeting Time"), new CSVFile.CSVField("Room"), new CSVFile.CSVField("Conflicting\nCourse"), new CSVFile.CSVField("Conflicting\nClass"), new CSVFile.CSVField("Conflicting\nMeeting Time"), new CSVFile.CSVField("Conflicting\nRoom"), new CSVFile.CSVField("Penalty\nMinutes")});
        ArrayList<StudentQuality.Conflict> confs = new ArrayList<StudentQuality.Conflict>();
        for (Request r1 : this.getModel().variables()) {
            Enrollment e1 = assignment.getValue(r1);
            if (e1 == null || !(r1 instanceof CourseRequest)) continue;
            for (StudentQuality.Type type : this.iTypes) {
                confs.addAll(this.iSQ.conflicts(type, e1));
            }
            for (Request r2 : r1.getStudent().getRequests()) {
                Enrollment e2 = assignment.getValue(r2);
                if (e2 == null || r1.getId() >= r2.getId() || !(r2 instanceof CourseRequest)) continue;
                for (StudentQuality.Type t2 : this.iTypes) {
                    confs.addAll(this.iSQ.conflicts(t2, e1, e2));
                }
            }
        }
        Collections.sort(confs, new Comparator<StudentQuality.Conflict>(){

            @Override
            public int compare(StudentQuality.Conflict c1, StudentQuality.Conflict c2) {
                int cmp = (c1.getStudent().getExternalId() == null ? "" : c1.getStudent().getExternalId()).compareTo(c2.getStudent().getExternalId() == null ? "" : c2.getStudent().getExternalId());
                if (cmp != 0) {
                    return cmp;
                }
                cmp = c1.getStudent().compareTo(c2.getStudent());
                if (cmp != 0) {
                    return cmp;
                }
                if (c1.getType() != c2.getType()) {
                    return Integer.compare(c1.getType().ordinal(), c2.getType().ordinal());
                }
                cmp = c1.getE1().getCourse().getName().toString().compareTo(c2.getE1().getCourse().getName());
                if (cmp != 0) {
                    return cmp;
                }
                return ((Section)c1.getS1()).getName(c1.getE1().getCourse().getId()).compareTo(((Section)c2.getS1()).getName(c2.getE1().getCourse().getId()));
            }
        });
        for (StudentQuality.Conflict conflict : confs) {
            if (conflict.getStudent().isDummy() && !includeLastLikeStudents || !conflict.getStudent().isDummy() && !includeRealStudents) continue;
            if (conflict.getType() == StudentQuality.Type.AccBackToBack) {
                boolean trueConflict = false;
                for (int i = 0; i < Constants.DAY_CODES.length; ++i) {
                    if ((conflict.getS1().getTime().getDayCode() & Constants.DAY_CODES[i]) == 0 || (conflict.getS2().getTime().getDayCode() & Constants.DAY_CODES[i]) == 0) continue;
                    boolean inBetween = false;
                    block17: for (Request request : conflict.getStudent().getRequests()) {
                        Enrollment e = request.getAssignment(assignment);
                        if (e == null) continue;
                        for (SctAssignment s : e.getAssignments()) {
                            if (s.getTime() == null || (s.getTime().getDayCode() & Constants.DAY_CODES[i]) == 0 || !s.getTime().shareWeeks(conflict.getS1().getTime()) || !s.getTime().shareWeeks(conflict.getS2().getTime())) continue;
                            if (conflict.getS1().getTime().getStartSlot() + conflict.getS1().getTime().getLength() <= s.getTime().getStartSlot() && s.getTime().getStartSlot() + s.getTime().getLength() <= conflict.getS2().getTime().getStartSlot()) {
                                inBetween = true;
                                continue block17;
                            }
                            if (conflict.getS2().getTime().getStartSlot() + conflict.getS2().getTime().getLength() > s.getTime().getStartSlot() || s.getTime().getStartSlot() + s.getTime().getLength() > conflict.getS1().getTime().getStartSlot()) continue;
                            inBetween = true;
                            continue block17;
                        }
                    }
                    if (inBetween) continue;
                    trueConflict = true;
                    break;
                }
                if (!trueConflict) continue;
            }
            ArrayList<CSVFile.CSVField> line = new ArrayList<CSVFile.CSVField>();
            line.add(new CSVFile.CSVField(conflict.getStudent().getId()));
            line.add(new CSVFile.CSVField(conflict.getStudent().getExternalId()));
            line.add(new CSVFile.CSVField(conflict.getStudent().getName()));
            line.add(new CSVFile.CSVField(this.curriculum(conflict.getStudent())));
            line.add(new CSVFile.CSVField(this.group(conflict.getStudent())));
            line.add(new CSVFile.CSVField(this.advisor(conflict.getStudent())));
            switch (conflict.getType()) {
                case ShortDistance: {
                    line.add(new CSVFile.CSVField(this.iSQ.getDistanceMetric().getShortDistanceAccommodationReference()));
                    break;
                }
                case AccBackToBack: {
                    line.add(new CSVFile.CSVField(this.iSQ.getStudentQualityContext().getBackToBackAccommodation()));
                    break;
                }
                case AccBreaksBetweenClasses: {
                    line.add(new CSVFile.CSVField(this.iSQ.getStudentQualityContext().getBreakBetweenClassesAccommodation()));
                    break;
                }
                case AccFreeTimeOverlap: {
                    line.add(new CSVFile.CSVField(this.iSQ.getStudentQualityContext().getFreeTimeAccommodation()));
                    break;
                }
                default: {
                    line.add(new CSVFile.CSVField(conflict.getType().getName()));
                }
            }
            line.add(new CSVFile.CSVField(conflict.getE1().getCourse().getName()));
            line.add(new CSVFile.CSVField(conflict.getS1() instanceof Section ? ((Section)conflict.getS1()).getName(conflict.getE1().getCourse().getId()) : ""));
            line.add(new CSVFile.CSVField(conflict.getS1().getTime() == null ? "" : conflict.getS1().getTime().getLongName(useAmPm)));
            line.add(new CSVFile.CSVField(this.rooms(conflict.getS1())));
            line.add(new CSVFile.CSVField(conflict.getE2().isCourseRequest() ? conflict.getE2().getCourse().getName() : "Free Time"));
            line.add(new CSVFile.CSVField(conflict.getS2() instanceof Section ? ((Section)conflict.getS2()).getName(conflict.getE2().getCourse().getId()) : ""));
            line.add(new CSVFile.CSVField(conflict.getS2().getTime() == null ? "" : conflict.getS2().getTime().getLongName(useAmPm)));
            line.add(new CSVFile.CSVField(this.rooms(conflict.getS2())));
            switch (conflict.getType()) {
                case AccFreeTimeOverlap: {
                    line.add(new CSVFile.CSVField(5 * conflict.getPenalty()));
                    break;
                }
                case ShortDistance: {
                    line.add(new CSVFile.CSVField(this.iSQ.getStudentQualityContext().getDistanceInMinutes(((Section)conflict.getS1()).getPlacement(), ((Section)conflict.getS2()).getPlacement())));
                    break;
                }
                case AccBackToBack: 
                case AccBreaksBetweenClasses: {
                    TimeLocation t1 = conflict.getS1().getTime();
                    TimeLocation t2 = conflict.getS2().getTime();
                    if (t1.getStartSlot() + t1.getNrSlotsPerMeeting() <= t2.getStartSlot()) {
                        int dist = t2.getStartSlot() - (t1.getStartSlot() + t1.getNrSlotsPerMeeting());
                        line.add(new CSVFile.CSVField(5 * dist + t1.getBreakTime()));
                        break;
                    }
                    if (t2.getStartSlot() + t2.getNrSlotsPerMeeting() <= t1.getStartSlot()) {
                        int dist = t1.getStartSlot() - (t2.getStartSlot() + t2.getNrSlotsPerMeeting());
                        line.add(new CSVFile.CSVField(5 * dist + t2.getBreakTime()));
                        break;
                    }
                    line.add(new CSVFile.CSVField(null));
                    break;
                }
                default: {
                    line.add(new CSVFile.CSVField(conflict.getPenalty()));
                }
            }
            csv.addLine(line);
        }
        return csv;
    }

    @Override
    public CSVFile create(Assignment<Request, Enrollment> assignment, DataProperties properties) {
        return this.createTable(assignment, properties.getPropertyBoolean("lastlike", false), properties.getPropertyBoolean("real", true), properties.getPropertyBoolean("useAmPm", true));
    }
}

