/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.heuristics.selection;

import java.util.ConcurrentModificationException;
import java.util.Set;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.heuristics.NeighbourSelection;
import org.cpsolver.ifs.heuristics.ValueSelection;
import org.cpsolver.ifs.heuristics.VariableSelection;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.model.SimpleNeighbour;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.Progress;
import org.cpsolver.studentsct.filter.StudentFilter;
import org.cpsolver.studentsct.heuristics.selection.UnassignedRequestSelection;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;

public class StandardSelection
implements NeighbourSelection<Request, Enrollment> {
    private long iIteration = 0L;
    protected ValueSelection<Request, Enrollment> iValueSelection = null;
    protected VariableSelection<Request, Enrollment> iVariableSelection = null;
    protected long iNrIterations = -1L;
    protected boolean iPreferPriorityStudents = true;
    protected long iConflictTimeOut = -7200L;
    protected long iTimeOut = -3600L;
    protected boolean iCanConflict = true;
    protected boolean iCanHigherPriorityConflict = true;

    public StandardSelection(DataProperties properties, VariableSelection<Request, Enrollment> variableSelection, ValueSelection<Request, Enrollment> valueSelection) {
        this.iVariableSelection = variableSelection;
        this.iValueSelection = valueSelection;
        this.iPreferPriorityStudents = properties.getPropertyBoolean("Sectioning.PriorityStudentsFirstSelection.AllIn", true);
        this.iTimeOut = properties.getPropertyLong("Neighbour.StandardTimeOut", -3600L);
        if (this.iTimeOut < 0L) {
            this.iTimeOut = Math.max(0L, properties.getPropertyLong("Termination.TimeOut", -1L) + this.iTimeOut);
        }
        this.iConflictTimeOut = properties.getPropertyLong("Neighbour.StandardConflictTimeOut", -7200L);
        if (this.iConflictTimeOut < 0L) {
            this.iConflictTimeOut = Math.max(0L, properties.getPropertyLong("Termination.TimeOut", -1L) + this.iConflictTimeOut);
        }
        this.iCanConflict = properties.getPropertyBoolean("Neighbour.StandardCanConflict", true);
        this.iCanHigherPriorityConflict = properties.getPropertyBoolean("Neighbour.StandardCanHigherPriorityConflict", true);
    }

    @Override
    public void init(Solver<Request, Enrollment> solver) {
        StudentFilter filter = null;
        if (this.iVariableSelection instanceof UnassignedRequestSelection) {
            filter = ((UnassignedRequestSelection)this.iVariableSelection).getFilter();
        }
        this.init(solver, "Ifs" + (filter == null ? "" : " (" + filter.getName().toLowerCase() + " students)") + "...");
    }

    protected void init(Solver<Request, Enrollment> solver, String name) {
        this.iVariableSelection.init(solver);
        this.iValueSelection.init(solver);
        this.iIteration = 0L;
        this.iNrIterations = solver.getProperties().getPropertyLong("Neighbour.StandardIterations", -1L);
        if (this.iNrIterations < 0L) {
            this.iNrIterations = solver.currentSolution().getModel().nrUnassignedVariables(solver.currentSolution().getAssignment());
        }
        if (this.iTimeOut > 0L && solver.currentSolution().getTime() > (double)this.iTimeOut) {
            this.iNrIterations = 0L;
        }
        this.iCanConflict = solver.getProperties().getPropertyBoolean("Neighbour.StandardCanConflict", true);
        if (this.iCanConflict && this.iConflictTimeOut > 0L && solver.currentSolution().getTime() > (double)this.iConflictTimeOut) {
            this.iCanConflict = false;
        }
        if (this.iNrIterations > 0L) {
            Progress.getInstance(solver.currentSolution().getModel()).setPhase(this.iCanConflict ? name : "No-conf " + name, this.iNrIterations);
        }
    }

    public boolean canUnassign(Enrollment enrollment, Enrollment conflict, Assignment<Request, Enrollment> assignment) {
        float credit;
        if (!this.iCanConflict) {
            return false;
        }
        if (!this.iCanHigherPriorityConflict && conflict.getRequest().getPriority() < enrollment.getRequest().getPriority()) {
            return false;
        }
        if (conflict.getRequest().isMPP() && conflict.equals(conflict.getRequest().getInitialAssignment())) {
            return false;
        }
        if (conflict.getRequest().getStudent().hasMinCredit() && (credit = conflict.getRequest().getStudent().getAssignedCredit(assignment) - conflict.getCredit()) < conflict.getRequest().getStudent().getMinCredit()) {
            return false;
        }
        if (!conflict.getRequest().isAlternative() && conflict.getRequest().getRequestPriority().isHigher(enrollment.getRequest())) {
            return false;
        }
        return !this.iPreferPriorityStudents && !conflict.getRequest().getRequestPriority().isSame(enrollment.getRequest()) || !conflict.getStudent().getPriority().isHigher(enrollment.getStudent());
    }

    @Override
    public Neighbour<Request, Enrollment> selectNeighbour(Solution<Request, Enrollment> solution) {
        if (solution.getModel().unassignedVariables(solution.getAssignment()).isEmpty() || ++this.iIteration >= this.iNrIterations) {
            return null;
        }
        Progress.getInstance(solution.getModel()).incProgress();
        block2: for (int i = 0; i < 10; ++i) {
            try {
                Set<Enrollment> conflicts;
                Enrollment enrollment;
                Request request = this.iVariableSelection.selectVariable(solution);
                if (request == null || (enrollment = this.iValueSelection.selectValue(solution, request)) == null || (conflicts = ((Request)enrollment.variable()).getModel().conflictValues(solution.getAssignment(), enrollment)).contains(enrollment)) continue;
                for (Enrollment conflict : conflicts) {
                    if (this.canUnassign(enrollment, conflict, solution.getAssignment())) continue;
                    continue block2;
                }
                return new SimpleNeighbour<Request, Enrollment>(request, enrollment, conflicts);
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
        }
        return null;
    }
}

