/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.instructor.criteria;

import java.util.Collection;
import java.util.Set;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.criteria.AbstractCriterion;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.instructor.criteria.InstructorSchedulingCriterion;
import org.cpsolver.instructor.model.Instructor;
import org.cpsolver.instructor.model.InstructorSchedulingModel;
import org.cpsolver.instructor.model.TeachingAssignment;
import org.cpsolver.instructor.model.TeachingRequest;

public class SameDays
extends InstructorSchedulingCriterion {
    private double iDiffRoomWeight = 0.8;
    private double iDiffTypeWeight = 0.5;

    public SameDays() {
        this.setValueUpdateType(AbstractCriterion.ValueUpdateType.NoUpdate);
    }

    @Override
    public void configure(DataProperties properties) {
        super.configure(properties);
        this.iDiffRoomWeight = properties.getPropertyDouble("SameDays.DifferentRoomWeight", 1.0);
        this.iDiffTypeWeight = properties.getPropertyDouble("SameDays.DifferentTypeWeight", 0.5);
    }

    @Override
    public double getWeightDefault(DataProperties config) {
        return 1.0;
    }

    public double getDifferentRoomWeight() {
        return this.iDiffRoomWeight;
    }

    public double getDifferentTypeWeight() {
        return this.iDiffTypeWeight;
    }

    @Override
    public double getValue(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, TeachingAssignment value, Set<TeachingAssignment> conflicts) {
        return value.getInstructor().countSameDays(assignment, value, this.iDiffRoomWeight, this.iDiffTypeWeight);
    }

    @Override
    protected double[] computeBounds(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment) {
        double[] bounds = new double[]{0.0, 0.0};
        for (Instructor instructor : ((InstructorSchedulingModel)this.getModel()).getInstructors()) {
            bounds[1] = bounds[1] + (double)Math.abs(instructor.getSameDaysPreference());
        }
        return bounds;
    }

    @Override
    public double[] getBounds(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, Collection<TeachingRequest.Variable> variables) {
        double[] bounds = new double[]{0.0, 0.0};
        for (Instructor instructor : this.getInstructors(assignment, variables)) {
            bounds[1] = bounds[1] + (double)Math.abs(instructor.getSameDaysPreference());
        }
        return bounds;
    }

    @Override
    public double getValue(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, Collection<TeachingRequest.Variable> variables) {
        double value = 0.0;
        for (Instructor instructor : this.getAssignedInstructors(assignment, variables)) {
            value += ((Instructor.Context)instructor.getContext(assignment)).countSameDaysPreference(this.iDiffRoomWeight, this.iDiffTypeWeight);
        }
        return value;
    }

    @Override
    public String getAbbreviation() {
        return "SameDays";
    }
}

