/*
 * Decompiled with CFR 0.152.
 */
package biweekly.util.com.google.ical.iter;

import biweekly.util.com.google.ical.iter.DateValueComparison;
import biweekly.util.com.google.ical.iter.RecurrenceIterator;
import biweekly.util.com.google.ical.values.DateValue;
import java.util.Comparator;

final class HeapElement {
    final boolean inclusion;
    private final RecurrenceIterator it;
    private long comparable;
    private DateValue head;
    static final Comparator<HeapElement> CMP = new Comparator<HeapElement>(){

        @Override
        public int compare(HeapElement a, HeapElement b) {
            long bc;
            long ac = a.comparable();
            return ac < (bc = b.comparable()) ? -1 : (ac == bc ? 0 : 1);
        }
    };

    HeapElement(boolean inclusion, RecurrenceIterator it) {
        this.inclusion = inclusion;
        this.it = it;
    }

    DateValue head() {
        return this.head;
    }

    long comparable() {
        return this.comparable;
    }

    boolean shift() {
        if (!this.it.hasNext()) {
            return false;
        }
        this.head = this.it.next();
        this.comparable = DateValueComparison.comparable(this.head);
        return true;
    }

    void advanceTo(DateValue newStartUtc) {
        this.it.advanceTo(newStartUtc);
    }

    public String toString() {
        return "[" + this.head.toString() + ", " + (this.inclusion ? "inclusion" : "exclusion") + "]";
    }
}

