/*
 * Decompiled with CFR 0.152.
 */
package biweekly.property;

import biweekly.ICalVersion;
import biweekly.ValidationWarning;
import biweekly.component.ICalComponent;
import biweekly.property.ValuedProperty;
import biweekly.util.Frequency;
import biweekly.util.Google2445Utils;
import biweekly.util.ICalDate;
import biweekly.util.Recurrence;
import biweekly.util.com.google.ical.compat.javautil.DateIterator;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public class RecurrenceProperty
extends ValuedProperty<Recurrence> {
    public RecurrenceProperty(Recurrence recur) {
        super(recur);
    }

    public RecurrenceProperty(RecurrenceProperty original) {
        super(original);
    }

    public DateIterator getDateIterator(Date startDate, TimeZone timezone) {
        return this.getDateIterator(new ICalDate(startDate), timezone);
    }

    public DateIterator getDateIterator(ICalDate startDate, TimeZone timezone) {
        Recurrence recur = (Recurrence)this.getValue();
        return recur == null ? new Google2445Utils.EmptyDateIterator() : recur.getDateIterator(startDate, timezone);
    }

    @Override
    protected void validate(List<ICalComponent> components, ICalVersion version, List<ValidationWarning> warnings) {
        super.validate(components, version, warnings);
        if (this.value == null) {
            return;
        }
        if (((Recurrence)this.value).getFrequency() == null) {
            warnings.add(new ValidationWarning(30, new Object[0]));
        }
        if (((Recurrence)this.value).getUntil() != null && ((Recurrence)this.value).getCount() != null) {
            warnings.add(new ValidationWarning(31, new Object[0]));
        }
        switch (version) {
            case V1_0: {
                if (!((Recurrence)this.value).getXRules().isEmpty()) {
                    warnings.add(new ValidationWarning("X-Rules are not supported by vCal."));
                }
                if (!((Recurrence)this.value).getBySetPos().isEmpty()) {
                    warnings.add(new ValidationWarning("BYSETPOS is not supported by vCal."));
                }
                if (((Recurrence)this.value).getFrequency() != Frequency.SECONDLY) break;
                warnings.add(new ValidationWarning(Frequency.SECONDLY.name() + " frequency is not supported by vCal."));
                break;
            }
            case V2_0_DEPRECATED: {
                break;
            }
            case V2_0: {
                if (((Recurrence)this.value).getXRules().isEmpty()) break;
                warnings.add(new ValidationWarning(32, new Object[0]));
            }
        }
    }
}

