/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.scribe.property;

import biweekly.ICalDataType;
import biweekly.ICalVersion;
import biweekly.io.ParseContext;
import biweekly.io.WriteContext;
import biweekly.io.json.JCalValue;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.io.xml.XCalElement;
import biweekly.parameter.ICalParameters;
import biweekly.property.TextProperty;
import biweekly.property.ValuedProperty;
import com.github.mangstadt.vinnie.io.VObjectPropertyValues;

public abstract class TextPropertyScribe<T extends TextProperty>
extends ICalPropertyScribe<T> {
    public TextPropertyScribe(Class<T> clazz, String propertyName) {
        this(clazz, propertyName, ICalDataType.TEXT);
    }

    public TextPropertyScribe(Class<T> clazz, String propertyName, ICalDataType dataType) {
        super(clazz, propertyName, dataType);
    }

    @Override
    protected String _writeText(T property, WriteContext context) {
        String value = (String)((ValuedProperty)property).getValue();
        if (value != null) {
            return VObjectPropertyValues.escape((String)value);
        }
        return "";
    }

    @Override
    protected T _parseText(String value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        value = VObjectPropertyValues.unescape((String)value);
        return this.newInstance(value, context.getVersion());
    }

    @Override
    protected void _writeXml(T property, XCalElement element, WriteContext context) {
        element.append(this.dataType(property, context.getVersion()), (String)((ValuedProperty)property).getValue());
    }

    @Override
    protected T _parseXml(XCalElement element, ICalParameters parameters, ParseContext context) {
        ICalDataType dataType = this.defaultDataType(context.getVersion());
        String value = element.first(dataType);
        if (value != null) {
            return this.newInstance(value, context.getVersion());
        }
        throw TextPropertyScribe.missingXmlElements(dataType);
    }

    @Override
    protected JCalValue _writeJson(T property, WriteContext context) {
        return JCalValue.single(((ValuedProperty)property).getValue());
    }

    @Override
    protected T _parseJson(JCalValue value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        return this.newInstance(value.asSingle(), context.getVersion());
    }

    protected abstract T newInstance(String var1, ICalVersion var2);
}

