/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.scribe.property;

import biweekly.ICalDataType;
import biweekly.ICalVersion;
import biweekly.io.CannotParseException;
import biweekly.io.ParseContext;
import biweekly.io.WriteContext;
import biweekly.io.json.JCalValue;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.io.xml.XCalElement;
import biweekly.parameter.ICalParameters;
import biweekly.property.FreeBusy;
import biweekly.property.ICalProperty;
import biweekly.util.Duration;
import biweekly.util.ICalDate;
import biweekly.util.Period;
import com.github.mangstadt.vinnie.io.VObjectPropertyValues;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public class FreeBusyScribe
extends ICalPropertyScribe<FreeBusy> {
    public FreeBusyScribe() {
        super(FreeBusy.class, "FREEBUSY");
    }

    @Override
    protected ICalDataType _defaultDataType(ICalVersion version) {
        return ICalDataType.PERIOD;
    }

    @Override
    protected String _writeText(FreeBusy property, WriteContext context) {
        List values = property.getValues();
        ArrayList<String> strValues = new ArrayList<String>(values.size());
        for (Period period : values) {
            StringBuilder sb = new StringBuilder();
            ICalDate start = period.getStartDate();
            if (start != null) {
                String dateStr = FreeBusyScribe.date((Date)start, (ICalProperty)property, context).extended(false).write();
                sb.append(dateStr);
            }
            sb.append('/');
            ICalDate end = period.getEndDate();
            if (end != null) {
                String dateStr = FreeBusyScribe.date((Date)end, (ICalProperty)property, context).extended(false).write();
                sb.append(dateStr);
            } else if (period.getDuration() != null) {
                sb.append(period.getDuration());
            }
            strValues.add(sb.toString());
        }
        return VObjectPropertyValues.writeList(strValues);
    }

    @Override
    protected FreeBusy _parseText(String value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        return this.parse(VObjectPropertyValues.parseList((String)value), parameters, context);
    }

    @Override
    protected void _writeXml(FreeBusy property, XCalElement element, WriteContext context) {
        for (Period period : property.getValues()) {
            Duration duration;
            ICalDate end;
            XCalElement periodElement = element.append(ICalDataType.PERIOD);
            ICalDate start = period.getStartDate();
            if (start != null) {
                String dateStr = FreeBusyScribe.date((Date)start, (ICalProperty)property, context).extended(true).write();
                periodElement.append("start", dateStr);
            }
            if ((end = period.getEndDate()) != null) {
                String dateStr = FreeBusyScribe.date((Date)end, (ICalProperty)property, context).extended(true).write();
                periodElement.append("end", dateStr);
            }
            if ((duration = period.getDuration()) == null) continue;
            periodElement.append("duration", duration.toString());
        }
    }

    @Override
    protected FreeBusy _parseXml(XCalElement element, ICalParameters parameters, ParseContext context) {
        List<XCalElement> periodElements = element.children(ICalDataType.PERIOD);
        if (periodElements.isEmpty()) {
            throw FreeBusyScribe.missingXmlElements(ICalDataType.PERIOD);
        }
        FreeBusy property = new FreeBusy();
        for (XCalElement periodElement : periodElements) {
            ICalDate start;
            String startStr = periodElement.first("start");
            if (startStr == null) {
                throw new CannotParseException(9, new Object[0]);
            }
            try {
                start = FreeBusyScribe.date(startStr).parse();
            }
            catch (IllegalArgumentException e) {
                throw new CannotParseException(10, startStr);
            }
            String endStr = periodElement.first("end");
            if (endStr != null) {
                try {
                    ICalDate end = FreeBusyScribe.date(endStr).parse();
                    property.getValues().add(new Period(start, end));
                    context.addDate(start, property, parameters);
                    context.addDate(end, property, parameters);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new CannotParseException(11, endStr);
                }
            }
            String durationStr = periodElement.first("duration");
            if (durationStr != null) {
                try {
                    Duration duration = Duration.parse(durationStr);
                    property.getValues().add(new Period(start, duration));
                    context.addDate(start, property, parameters);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    throw new CannotParseException(12, durationStr);
                }
            }
            throw new CannotParseException(13, new Object[0]);
        }
        return property;
    }

    @Override
    protected JCalValue _writeJson(FreeBusy property, WriteContext context) {
        List values = property.getValues();
        if (values.isEmpty()) {
            return JCalValue.single("");
        }
        ArrayList<String> valuesStr = new ArrayList<String>();
        for (Period period : values) {
            StringBuilder sb = new StringBuilder();
            ICalDate start = period.getStartDate();
            if (start != null) {
                String dateStr = FreeBusyScribe.date((Date)start, (ICalProperty)property, context).extended(true).write();
                sb.append(dateStr);
            }
            sb.append('/');
            ICalDate end = period.getEndDate();
            if (end != null) {
                String dateStr = FreeBusyScribe.date((Date)end, (ICalProperty)property, context).extended(true).write();
                sb.append(dateStr);
            } else if (period.getDuration() != null) {
                sb.append(period.getDuration());
            }
            valuesStr.add(sb.toString());
        }
        return JCalValue.multi(valuesStr);
    }

    @Override
    protected FreeBusy _parseJson(JCalValue value, ICalDataType dataType, ICalParameters parameters, ParseContext context) {
        return this.parse(value.asMulti(), parameters, context);
    }

    private FreeBusy parse(List<String> periods, ICalParameters parameters, ParseContext context) {
        FreeBusy property = new FreeBusy();
        for (String period : periods) {
            ICalDate start;
            int slash = period.indexOf(47);
            if (slash < 0) {
                throw new CannotParseException(13, new Object[0]);
            }
            String startStr = period.substring(0, slash);
            try {
                start = FreeBusyScribe.date(startStr).parse();
            }
            catch (IllegalArgumentException e) {
                throw new CannotParseException(10, startStr);
            }
            String endStr = period.substring(slash + 1);
            try {
                ICalDate end = FreeBusyScribe.date(endStr).parse();
                property.getValues().add(new Period(start, end));
                context.addDate(start, property, parameters);
                context.addDate(end, property, parameters);
            }
            catch (IllegalArgumentException e) {
                try {
                    Duration duration = Duration.parse(endStr);
                    property.getValues().add(new Period(start, duration));
                    context.addDate(start, property, parameters);
                }
                catch (IllegalArgumentException e2) {
                    throw new CannotParseException(14, endStr);
                }
            }
        }
        return property;
    }

    @Override
    public Set<ICalVersion> getSupportedVersions() {
        return EnumSet.of(ICalVersion.V2_0_DEPRECATED, ICalVersion.V2_0);
    }
}

