/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io.scribe.property;

import biweekly.ICalDataType;
import biweekly.ICalVersion;
import biweekly.component.VAlarm;
import biweekly.io.scribe.property.VCalAlarmPropertyScribe;
import biweekly.property.Action;
import biweekly.property.Attendee;
import biweekly.property.EmailAlarm;
import com.github.mangstadt.vinnie.io.VObjectPropertyValues;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class EmailAlarmScribe
extends VCalAlarmPropertyScribe<EmailAlarm> {
    public EmailAlarmScribe() {
        super(EmailAlarm.class, "MALARM");
    }

    @Override
    protected ICalDataType _defaultDataType(ICalVersion version) {
        return ICalDataType.TEXT;
    }

    @Override
    protected List<String> writeData(EmailAlarm property) {
        String email = property.getEmail();
        String note = property.getNote();
        if (email == null && note == null) {
            return Collections.emptyList();
        }
        ArrayList<String> dataValues = new ArrayList<String>(2);
        dataValues.add(email == null ? "" : email);
        dataValues.add(note == null ? "" : note);
        return dataValues;
    }

    @Override
    protected EmailAlarm create(ICalDataType dataType, VObjectPropertyValues.SemiStructuredValueIterator it) {
        String email = it.next();
        String note = it.next();
        EmailAlarm property = new EmailAlarm(email);
        property.setNote(note);
        return property;
    }

    @Override
    protected void toVAlarm(VAlarm valarm, EmailAlarm property) {
        String email = property.getEmail();
        if (email != null) {
            valarm.addAttendee(new Attendee(null, email));
        }
        valarm.setDescription(property.getNote());
    }

    @Override
    protected Action action() {
        return Action.email();
    }
}

