/*
 * Decompiled with CFR 0.152.
 */
package biweekly;

import com.github.mangstadt.vinnie.SyntaxStyle;

public enum ICalVersion {
    V1_0("1.0", SyntaxStyle.OLD),
    V2_0_DEPRECATED("2.0", SyntaxStyle.NEW),
    V2_0("2.0", SyntaxStyle.NEW);

    private final String version;
    private final SyntaxStyle syntaxStyle;

    private ICalVersion(String version, SyntaxStyle syntaxStyle) {
        this.version = version;
        this.syntaxStyle = syntaxStyle;
    }

    public String getVersion() {
        return this.version;
    }

    public SyntaxStyle getSyntaxStyle() {
        return this.syntaxStyle;
    }

    public static ICalVersion get(String version) {
        if (ICalVersion.V1_0.version.equals(version)) {
            return V1_0;
        }
        if (ICalVersion.V2_0.version.equals(version)) {
            return V2_0;
        }
        return null;
    }

    public String toString() {
        if (this == V2_0_DEPRECATED) {
            return this.version + " (obsoleted)";
        }
        return this.version;
    }
}

