/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.webutil;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import javax.servlet.jsp.JspWriter;
import org.unitime.commons.web.htmlgen.TableCell;
import org.unitime.commons.web.htmlgen.TableStream;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.model.ClassDurationType;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.LearningManagementSystemInfo;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.comparators.ClassCourseComparator;
import org.unitime.timetable.model.comparators.InstrOfferingConfigComparator;
import org.unitime.timetable.model.dao.InstrOfferingConfigDAO;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.CachedClassAssignmentProxy;
import org.unitime.timetable.solver.ClassAssignmentProxy;
import org.unitime.timetable.solver.exam.ExamAssignmentProxy;
import org.unitime.timetable.webutil.Navigation;
import org.unitime.timetable.webutil.WebInstructionalOfferingTableBuilder;

public class WebInstrOfferingConfigTableBuilder
extends WebInstructionalOfferingTableBuilder {
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);

    public String buttonsTable(InstrOfferingConfig ioc, SessionContext context) {
        StringBuffer btnTable = new StringBuffer("");
        btnTable.append("<div class='unitime-MainTableHeader'><div class='unitime-HeaderPanel' style='margin-bottom: 0px;'>");
        btnTable.append("<div class='left'><div class='title'>");
        String configName = ioc.getName();
        if (configName == null || configName.trim().length() == 0) {
            configName = ioc.getUniqueId().toString();
        }
        if (ioc.getInstructionalMethod() != null) {
            btnTable.append(MSG.labelConfigurationWithInstructionalMethod(configName, ioc.getInstructionalMethod().getLabel()));
        } else {
            btnTable.append(MSG.labelConfiguration(configName));
        }
        btnTable.append("</div></div>");
        boolean notOffered = ioc.getInstructionalOffering().isNotOffered();
        if (!notOffered) {
            btnTable.append("<div class='right unitime-NoPrint' style='line-height: 29px; vertical-align: bottom; font-size: small;'>");
            btnTable.append("<table border='0' align='right' cellspacing='1' cellpadding='0'><tr>");
            if (context.hasPermission(ioc, Right.InstrOfferingConfigEdit)) {
                btnTable.append("<td>");
                btnTable.append("\t<form method='post' action='instructionalOfferingConfigEdit.action' class='FormWithNoPadding'>");
                btnTable.append("\t\t<input type='hidden' name='form.configId' value='" + ioc.getUniqueId().toString() + "'>");
                btnTable.append("\t\t<input type='submit' name='op' value='" + MSG.actionEditConfiguration() + "' title='" + MSG.titleEditConfiguration() + "' class='gwt-Button'>");
                btnTable.append("\t</form>");
                btnTable.append("</td>");
            }
            if (context.hasPermission(ioc, Right.MultipleClassSetup)) {
                btnTable.append("<td>");
                btnTable.append("\t<form method='post' action='instructionalOfferingModify.action' class='FormWithNoPadding'>");
                btnTable.append("\t\t<input type='hidden' name='uid' value='" + ioc.getUniqueId().toString() + "'>");
                btnTable.append("\t\t<input type='submit' name='op' value='" + MSG.actionClassSetup() + "' title='" + MSG.titleClassSetup() + "' class='gwt-Button'> ");
                btnTable.append("\t</form>");
                btnTable.append("</td>");
            }
            if (ApplicationProperty.LegacyCourseAssignInstructors.isTrue() && context.hasPermission(ioc, Right.AssignInstructors)) {
                btnTable.append("<td>");
                btnTable.append("\t<form method='post' action='classInstructorAssignment.action' class='FormWithNoPadding'>");
                btnTable.append("\t\t<input type='hidden' name='uid' value='" + ioc.getUniqueId().toString() + "'>");
                btnTable.append("\t\t<input type='submit' name='op' value='" + MSG.actionAssignInstructors() + "' title='" + MSG.titleAssignInstructors() + "' class='gwt-Button'> ");
                btnTable.append("\t</form>");
                btnTable.append("</td>");
            }
            if (ApplicationProperty.LegacyCourseAssignInstructors.isFalse() && context.hasPermission(ioc, Right.AssignInstructors)) {
                btnTable.append("<td>");
                btnTable.append("<span id='" + ioc.getUniqueId().toString() + "' name='UniTimeGWT:AssignInstructorsButton' style=\"display: none;\">");
                btnTable.append(ioc.getUniqueId().toString());
                btnTable.append("</span>");
                btnTable.append("</td>");
            }
            btnTable.append("</tr></table>");
            btnTable.append("</div>");
        }
        btnTable.append("</div></div>");
        return btnTable.toString();
    }

    public void htmlTableForInstructionalOfferingConfig(Vector subpartIds, ClassAssignmentProxy classAssignment, ExamAssignmentProxy examAssignment, Long instrOfferingConfigId, SessionContext context, JspWriter outputStream) {
        if (instrOfferingConfigId != null) {
            InstrOfferingConfigDAO iocDao = new InstrOfferingConfigDAO();
            InstrOfferingConfig ioc = (InstrOfferingConfig)iocDao.get(instrOfferingConfigId);
            this.htmlTableForInstructionalOfferingConfig(subpartIds, classAssignment, examAssignment, ioc, context, outputStream);
        }
    }

    private void htmlTableForInstructionalOfferingConfig(Vector subpartIds, ClassAssignmentProxy classAssignment, ExamAssignmentProxy examAssignment, InstrOfferingConfig ioc, SessionContext context, JspWriter outputStream) {
        if (CommonValues.Yes.eq(context.getUser().getProperty(UserProperty.ClassesKeepSort))) {
            this.setClassComparator(new ClassCourseComparator(context.getUser().getProperty("InstructionalOfferingList.sortBy", ClassCourseComparator.getName(ClassCourseComparator.SortBy.NAME)), classAssignment, false));
        }
        if (ioc != null) {
            this.setDisplayDistributionPrefs(false);
            if (this.isShowTimetable()) {
                boolean hasTimetable = false;
                if (context.hasPermission(Right.ClassAssignments) && classAssignment != null) {
                    try {
                        if (classAssignment instanceof CachedClassAssignmentProxy) {
                            Vector<Class_> allClasses = new Vector<Class_>();
                            Iterator<SchedulingSubpart> iterator = ioc.getSchedulingSubparts().iterator();
                            while (!hasTimetable && iterator.hasNext()) {
                                SchedulingSubpart ss = iterator.next();
                                for (Class_ clazz : ss.getClasses()) {
                                    allClasses.add(clazz);
                                }
                            }
                            ((CachedClassAssignmentProxy)classAssignment).setCache(allClasses);
                            hasTimetable = !classAssignment.getAssignmentTable(allClasses).isEmpty();
                        } else {
                            Iterator<SchedulingSubpart> k = ioc.getSchedulingSubparts().iterator();
                            block6: while (!hasTimetable && k.hasNext()) {
                                SchedulingSubpart schedulingSubpart = k.next();
                                for (Class_ clazz : schedulingSubpart.getClasses()) {
                                    if (classAssignment.getAssignment(clazz) == null) continue;
                                    hasTimetable = true;
                                    continue block6;
                                }
                            }
                        }
                    }
                    catch (Exception k) {
                        // empty catch block
                    }
                }
                this.setDisplayTimetable(hasTimetable);
            }
            if (this.getDisplayConfigOpButtons()) {
                try {
                    outputStream.write(this.buttonsTable(ioc, context));
                }
                catch (IOException hasTimetable) {
                    // empty catch block
                }
            }
            ArrayList<String> columnList = new ArrayList<String>();
            columnList.add(LABEL);
            columnList.add(MSG.columnExternalId());
            columnList.add(MSG.columnMinPerWk());
            if (StudentClassEnrollment.sessionHasEnrollments(context.getUser().getCurrentAcademicSessionId())) {
                columnList.add(MSG.columnDemand());
            }
            columnList.add(MSG.columnLimit());
            if (ioc.getInstructionalOffering().getSession().getCurrentSnapshotDate() != null) {
                columnList.add(MSG.columnSnapshotLimit());
            }
            columnList.add(MSG.columnRoomRatio());
            columnList.add(MSG.columnManager());
            columnList.add(MSG.columnDatePattern());
            columnList.add(MSG.columnTimePattern());
            columnList.add(MSG.columnPreferences());
            columnList.add(MSG.columnInstructor());
            columnList.add(MSG.columnTimetable());
            if (LearningManagementSystemInfo.isLmsInfoDefinedForSession(ioc.getSessionId())) {
                columnList.add(MSG.columnLms());
            }
            if (ApplicationProperty.CoursesFundingDepartmentsEnabled.isTrue()) {
                block8: for (SchedulingSubpart schedulingSubpart : ioc.getSchedulingSubparts()) {
                    for (Class_ c : schedulingSubpart.getClasses()) {
                        if (c.getFundingDept() == null) continue;
                        columnList.add(MSG.columnFundingDepartment());
                        break block8;
                    }
                }
            }
            this.setVisibleColumns(columnList);
            boolean hasInstructorAssignments = false;
            block10: for (SchedulingSubpart ss : ioc.getSchedulingSubparts()) {
                if (ss.isInstructorAssignmentNeeded()) {
                    hasInstructorAssignments = true;
                    break;
                }
                for (Class_ c : ss.getClasses()) {
                    if (!c.isInstructorAssignmentNeeded()) continue;
                    hasInstructorAssignments = true;
                    break block10;
                }
            }
            this.setShowInstructorAssignment(hasInstructorAssignments);
            this.setDisplayInstructorPrefs(false);
            ClassDurationType classDurationType = ioc.getEffectiveDurationType();
            TableStream configTable = this.initTable((Writer)outputStream, context.getUser().getCurrentAcademicSessionId(), classDurationType == null ? MSG.columnMinPerWk() : classDurationType.getLabel());
            this.buildConfigRow(subpartIds, classAssignment, examAssignment, configTable, ioc.getInstructionalOffering().getControllingCourseOffering(), ioc, context, !this.getDisplayConfigOpButtons(), true);
            configTable.tableComplete();
        }
    }

    public void htmlConfigTablesForInstructionalOffering(SessionContext context, ClassAssignmentProxy classAssignment, ExamAssignmentProxy examAssignment, Long instructionalOffering, JspWriter outputStream, String backType, String backId) {
        this.setBackType(backType);
        this.setBackId(backId);
        if (CommonValues.Yes.eq(context.getUser().getProperty(UserProperty.ClassesKeepSort))) {
            this.setClassComparator(new ClassCourseComparator(context.getUser().getProperty("InstructionalOfferingList.sortBy", ClassCourseComparator.getName(ClassCourseComparator.SortBy.NAME)), classAssignment, false));
        }
        if (instructionalOffering != null) {
            InstructionalOfferingDAO iDao = new InstructionalOfferingDAO();
            InstructionalOffering io = (InstructionalOffering)iDao.get(instructionalOffering);
            this.setUserSettings(context.getUser());
            Vector subpartIds = new Vector();
            if (io.getInstrOfferingConfigs() != null) {
                TreeSet<InstrOfferingConfig> configs = new TreeSet<InstrOfferingConfig>(new InstrOfferingConfigComparator(io.getControllingCourseOffering().getSubjectArea().getUniqueId()));
                configs.addAll(io.getInstrOfferingConfigs());
                InstrOfferingConfig ioc2 = null;
                int idx = 0;
                for (InstrOfferingConfig ioc2 : configs) {
                    if (idx > 0 && this.getDisplayConfigOpButtons()) {
                        try {
                            outputStream.println("<br>");
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    this.htmlTableForInstructionalOfferingConfig(subpartIds, classAssignment, examAssignment, ioc2, context, outputStream);
                    ++idx;
                }
            }
            Navigation.set(context, Navigation.sSchedulingSubpartLevel, subpartIds);
        }
    }

    @Override
    protected TableCell buildPrefGroupLabel(CourseOffering co, PreferenceGroup prefGroup, int indentSpaces, boolean isEditable, String prevLabel, String icon) {
        TableCell cell = super.buildPrefGroupLabel(co, prefGroup, indentSpaces, isEditable, prevLabel, icon);
        if ("PreferenceGroup".equals(this.getBackType()) && prefGroup.getUniqueId().toString().equals(this.getBackId())) {
            cell.addContent("<A name=\"back\"></A>");
        }
        return cell;
    }

    @Override
    protected TableCell buildMinPerWeek(PreferenceGroup prefGroup, boolean isEditable) {
        TableCell cell = null;
        if (prefGroup instanceof Class_) {
            Class_ aClass = (Class_)prefGroup;
            cell = this.initNormalCell(aClass.getSchedulingSubpart().getMinutesPerWk().toString(), isEditable);
            cell.setAlign("right");
        } else if (prefGroup instanceof SchedulingSubpart) {
            SchedulingSubpart aSchedulingSubpart = (SchedulingSubpart)prefGroup;
            cell = this.initNormalCell(aSchedulingSubpart.getMinutesPerWk().toString(), isEditable);
            cell.setAlign("right");
        } else {
            cell = this.initNormalCell("&nbsp;", isEditable);
        }
        return cell;
    }
}

