/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.webutil;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import javax.servlet.jsp.JspWriter;
import org.unitime.commons.Debug;
import org.unitime.commons.web.htmlgen.TableCell;
import org.unitime.commons.web.htmlgen.TableStream;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.form.ClassAssignmentsReportForm;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.LearningManagementSystemInfo;
import org.unitime.timetable.model.PreferenceGroup;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.StudentClassEnrollment;
import org.unitime.timetable.model.SubjectArea;
import org.unitime.timetable.model.base.BaseSubjectArea;
import org.unitime.timetable.model.comparators.InstructorComparator;
import org.unitime.timetable.security.SessionContext;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.CachedClassAssignmentProxy;
import org.unitime.timetable.solver.ClassAssignmentProxy;
import org.unitime.timetable.solver.exam.ExamAssignmentProxy;
import org.unitime.timetable.solver.ui.AssignmentPreferenceInfo;
import org.unitime.timetable.webutil.Navigation;
import org.unitime.timetable.webutil.WebClassListTableBuilder;

public class WebClassAssignmentReportListTableBuilder
extends WebClassListTableBuilder {
    public WebClassAssignmentReportListTableBuilder() {
        this.disabledColor = "black";
    }

    @Override
    protected String additionalNote() {
        return " " + MSG.classAssignmentsAdditionalNote();
    }

    @Override
    protected TableCell buildDatePatternCell(ClassAssignmentProxy classAssignment, PreferenceGroup prefGroup, boolean isEditable) {
        Assignment a = null;
        AssignmentPreferenceInfo p = null;
        if (this.getDisplayTimetable() && this.isShowTimetable() && classAssignment != null && prefGroup instanceof Class_) {
            try {
                a = classAssignment.getAssignment((Class_)prefGroup);
                p = classAssignment.getAssignmentInfo((Class_)prefGroup);
            }
            catch (Exception e) {
                Debug.error(e);
            }
        }
        DatePattern dp = a != null ? a.getDatePattern() : prefGroup.effectiveDatePattern();
        TableCell cell = null;
        cell = dp == null ? this.initNormalCell("", isEditable) : this.initNormalCell("<div title='" + sDateFormat.format(dp.getStartDate()) + " - " + sDateFormat.format(dp.getEndDate()) + "' " + (p == null ? "" : "style='color:" + PreferenceLevel.int2color(p.getDatePatternPref()) + ";'") + ">" + dp.getName() + "</div>", isEditable);
        cell.setAlign("center");
        return cell;
    }

    public void htmlTableForClasses(SessionContext context, ClassAssignmentProxy classAssignment, ExamAssignmentProxy examAssignment, ClassAssignmentsReportForm form, JspWriter outputStream, String backType, String backId) {
        this.setVisibleColumns(form);
        this.setBackType(backType);
        this.setBackId(backId);
        Collection<Class_> classes = form.getClasses();
        Navigation.set(context, Navigation.sClassLevel, classes);
        if (this.getDisplayTimetable()) {
            boolean hasTimetable = false;
            if (context.hasPermission(Right.ClassAssignments) && classAssignment != null) {
                try {
                    if (classAssignment instanceof CachedClassAssignmentProxy) {
                        ((CachedClassAssignmentProxy)classAssignment).setCache(classes);
                    }
                    for (Object[] objectArray : classes) {
                        Class_ clazz = (Class_)objectArray[0];
                        if (classAssignment.getAssignment(clazz) == null) continue;
                        hasTimetable = true;
                        break;
                    }
                }
                catch (Exception i) {
                    // empty catch block
                }
            }
            this.setDisplayTimetable(hasTimetable);
        }
        this.setUserSettings(context.getUser());
        if (examAssignment != null || Exam.hasTimetable(context.getUser().getCurrentAcademicSessionId())) {
            this.setShowExam(true);
            this.setShowExamTimetable(true);
            this.setShowExamName(false);
        }
        this.setShowInstructor(true);
        if (StudentClassEnrollment.sessionHasEnrollments(context.getUser().getCurrentAcademicSessionId())) {
            this.setShowDemand(true);
        }
        if (LearningManagementSystemInfo.isLmsInfoDefinedForSession(context.getUser().getCurrentAcademicSessionId())) {
            this.setShowLms(true);
        }
        TableStream table = null;
        int ct = 0;
        Iterator<Class_> iterator = classes.iterator();
        BaseSubjectArea subjectArea = null;
        String prevLabel = null;
        while (iterator.hasNext()) {
            Object[] o = (Object[])iterator.next();
            Class_ c = (Class_)o[0];
            CourseOffering co = (CourseOffering)o[1];
            if (subjectArea == null || !subjectArea.getUniqueId().equals(co.getSubjectArea().getUniqueId())) {
                if (table != null) {
                    table.tableComplete();
                    try {
                        outputStream.print("<br>");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                subjectArea = co.getSubjectArea();
                try {
                    outputStream.print(this.labelForTable((SubjectArea)subjectArea));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ct = 0;
                table = this.initTable((Writer)outputStream, context.getUser().getCurrentAcademicSessionId());
            }
            this.buildClassRow(classAssignment, examAssignment, ++ct, table, co, c, 0, context, prevLabel);
            prevLabel = c.getClassLabel(co);
        }
        if (table != null) {
            table.tableComplete();
        }
    }

    @Override
    protected TableCell buildInstructor(PreferenceGroup prefGroup, boolean isEditable) {
        TableCell cell = this.initNormalCell("", isEditable);
        if (prefGroup instanceof Class_) {
            Class_ aClass = (Class_)prefGroup;
            if (aClass.isDisplayInstructor().booleanValue() && !aClass.getClassInstructors().isEmpty()) {
                InstructorComparator ic = new InstructorComparator();
                if (ApplicationProperty.InstructorsDropdownFollowNameFormatting.isTrue()) {
                    ic.setNameFormat(this.getInstructorNameFormat());
                }
                TreeSet<ClassInstructor> sortedInstructors = new TreeSet<ClassInstructor>(ic);
                sortedInstructors.addAll(aClass.getClassInstructors());
                Iterator<ClassInstructor> i = sortedInstructors.iterator();
                while (i.hasNext()) {
                    ClassInstructor ci = i.next();
                    String label = ci.getInstructor().getName(this.getInstructorNameFormat());
                    cell.addContent(label + (i.hasNext() ? "<br>" : ""));
                }
            } else {
                cell.addContent(" &nbsp; ");
            }
            cell.setAlign("left");
        } else {
            cell.addContent(" &nbsp; ");
        }
        return cell;
    }
}

