/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.util;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfPageEventHelper;
import com.lowagie.text.pdf.PdfWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.util.PdfFont;

public class PdfEventHandler
extends PdfPageEventHelper {
    private static final GwtMessages MESSAGES = Localization.create(GwtMessages.class);
    private BaseFont baseFont;
    private float fontSize;
    private Date dateTime = null;
    private Formats.Format<Date> dateFormat = Formats.getDateFormat(Formats.Pattern.DATE_TIME_STAMP);

    public PdfEventHandler() throws DocumentException, IOException {
        Font font = PdfFont.getSmallFont();
        this.setBaseFont(font.getBaseFont());
        this.setFontSize(font.getSize() * 0.8f);
    }

    public static PdfWriter initFooter(Document document, OutputStream outputStream) throws DocumentException, IOException {
        PdfWriter iWriter = PdfWriter.getInstance((Document)document, (OutputStream)outputStream);
        iWriter.setPageEvent((PdfPageEvent)new PdfEventHandler());
        return iWriter;
    }

    public void onEndPage(PdfWriter writer, Document document) {
        if (this.getDateTime() == null) {
            this.setDateTime(new Date());
        }
        PdfContentByte cb = writer.getDirectContent();
        cb.beginText();
        cb.setFontAndSize(this.getBaseFont(), this.getFontSize());
        cb.showTextAligned(0, this.getDateFormat().format(this.getDateTime()), document.left(), 20.0f, 0.0f);
        cb.showTextAligned(2, String.valueOf(document.getPageNumber()), document.right(), 20.0f, 0.0f);
        cb.showTextAligned(1, MESSAGES.pdfCopyright(Constants.getVersion()), (document.left() + document.right()) / 2.0f, 20.0f, 0.0f);
        cb.endText();
    }

    private BaseFont getBaseFont() {
        return this.baseFont;
    }

    private void setBaseFont(BaseFont baseFont) {
        this.baseFont = baseFont;
    }

    private float getFontSize() {
        return this.fontSize;
    }

    private void setFontSize(float fontSize) {
        this.fontSize = fontSize;
    }

    private Date getDateTime() {
        return this.dateTime;
    }

    private void setDateTime(Date dateTime) {
        this.dateTime = dateTime;
    }

    private Formats.Format<Date> getDateFormat() {
        return this.dateFormat;
    }
}

